/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.contract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.InvoiceBiztypeHelper;
import kd.scmc.conm.business.helper.BillImportHelper;
import kd.scmc.conm.business.helper.SupplierHelper;
import kd.scmc.conm.utils.CommonUtils;

public class PurContractPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
UploadListener {
    private static final Log logger = LogFactory.getLog(PurContractPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit invoiceBizTypeEdit;
        BasedataEdit material;
        BasedataEdit provideraddressf7;
        Control provideraddress;
        BasedataEdit contpartiesEdit;
        BasedataEdit supplierLinkmanEdit;
        BasedataEdit invoiceSupplierEdit;
        BasedataEdit ReceiveSupplierEdit;
        BasedataEdit providerSupplierEdit;
        BasedataEdit supplierEdit;
        BasedataEdit entrySettleOrg = (BasedataEdit)this.getView().getControl("entrysettleorg");
        if (entrySettleOrg != null) {
            entrySettleOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplierEdit = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((providerSupplierEdit = (BasedataEdit)this.getView().getControl("providersupplier")) != null) {
            providerSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ReceiveSupplierEdit = (BasedataEdit)this.getView().getControl("receivesupplier")) != null) {
            ReceiveSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invoiceSupplierEdit = (BasedataEdit)this.getView().getControl("invoicesupplier")) != null) {
            invoiceSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplierLinkmanEdit = (BasedataEdit)this.getView().getControl("providerlinkman")) != null) {
            supplierLinkmanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((contpartiesEdit = (BasedataEdit)this.getView().getControl("contparties")) != null) {
            contpartiesEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((provideraddress = this.getView().getControl("provideraddress")) != null) {
            this.addClickListeners(new String[]{"provideraddress"});
        }
        if ((provideraddressf7 = (BasedataEdit)this.getView().getControl("provideraddressf7")) != null) {
            provideraddressf7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{"tbmain"});
        AttachmentPanel signattachment = (AttachmentPanel)this.getView().getControl("signattachment");
        signattachment.addUploadListener((UploadListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit suitOrg = (BasedataEdit)this.getView().getControl("suitorg");
        if (suitOrg != null) {
            suitOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invoiceBizTypeEdit = (BasedataEdit)this.getView().getControl("invoicebiztype")) != null) {
            invoiceBizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isAPI((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        this.cusAndSupSettletype(this.getModel(), "supplier");
        this.changeContParties();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!"org".equals(e.getProperty().getName()) && org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurContractPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (e.getProperty().getName()) {
            case "supplier": {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("purchasehold", "=", (Object)"0").and(new QFilter("bizfunction", "like", (Object)"%1%")));
                Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("type")).ifPresent(type -> Optional.ofNullable(type.getDynamicObject("biztype")).ifPresent(biztype -> Optional.ofNullable(biztype.getString("number")).ifPresent(bizTypeNumber -> {
                    if ("130".equals(bizTypeNumber)) {
                        qFilters.add(new QFilter("enablevmi", "=", (Object)Boolean.TRUE));
                    }
                })));
                showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
                break;
            }
            case "providersupplier": {
                if (this.getModel().getValue("supplier") != null) {
                    QFilter bizfunction1 = new QFilter("bizfunction", "like", (Object)"%4%");
                    QFilter status = new QFilter("status", "=", (Object)"C");
                    QFilter enable = new QFilter("enable", "=", (Object)"1");
                    QFilter customerstatus = new QFilter("supplier_status.number", "=", (Object)"ZCGYS");
                    QFilter filters = status.and(enable).and(bizfunction1).and(customerstatus);
                    showParameter.getListFilterParameter().getQFilters().add(filters);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurContractPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "invoicesupplier": {
                if (this.getModel().getValue("supplier") != null) {
                    QFilter bizfunction = new QFilter("bizfunction", "like", (Object)"%2%");
                    showParameter.getListFilterParameter().getQFilters().add(bizfunction);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurContractPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "receivesupplier": {
                if (this.getModel().getValue("supplier") != null) {
                    QFilter bizfunction = new QFilter("bizfunction", "like", (Object)"%3%");
                    showParameter.getListFilterParameter().getQFilters().add(bizfunction);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurContractPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "providerlinkman": {
                DynamicObject providerSupplier = (DynamicObject)this.getModel().getValue("providersupplier");
                if (providerSupplier != null) {
                    DynamicObjectCollection linkmans = providerSupplier.getDynamicObjectCollection("entry_linkman");
                    List invalid = linkmans.stream().filter(a -> !a.getBoolean("invalid")).map(a -> (Long)a.getPkValue()).collect(Collectors.toList());
                    QFilter qFilter = new QFilter("supplierid", "=", providerSupplier.getPkValue());
                    QFilter ids = new QFilter("id", "in", invalid);
                    showParameter.getListFilterParameter().setFilter(qFilter.and(ids));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurContractPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "partb": {
                showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("partnerrole", "=", (Object)"1")));
                break;
            }
            case "provideraddressf7": {
                DynamicObject supplier = (DynamicObject)this.getModel().getValue("providersupplier");
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurContractPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter qFilter1 = new QFilter("supplierid", "in", (Object)supplier.getPkValue().toString());
                QFilter qFilter2 = new QFilter("invalid", "=", (Object)"0");
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2));
                break;
            }
            case "material": {
                if (this.getModel().getValue("type") != null) {
                    Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("type").getDynamicObject("biztype")).ifPresent(biztype -> {
                        switch (biztype.getString("number")) {
                            case "113": {
                                showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid.serviceattribute.fbasedataid_id", "=", (Object)1194029878949760000L));
                                break;
                            }
                            case "111": {
                                showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid.serviceattribute.fbasedataid_id", "=", (Object)1194030110357899264L));
                                break;
                            }
                            case "130": {
                                showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid.enablevmi", "=", (Object)Boolean.TRUE));
                                break;
                            }
                        }
                    });
                    Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("type")).ifPresent(type -> {
                        switch (type.getString("number")) {
                            case "NCPCG": {
                                showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid.farmproducts", "=", (Object)Boolean.TRUE));
                                break;
                            }
                        }
                    });
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u7c7b\u578b\u3002", (String)"PurContractPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "suitorg": {
                DynamicObject purOrg = (DynamicObject)this.getModel().getValue("org");
                if (purOrg != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurContractPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "invoicebiztype": {
                AppInfo appInfo;
                if (this.getView().getFormShowParameter().getAppId() == null || (appInfo = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId())) == null) break;
                String bizCloudId = appInfo.getCloudId();
                QFilter qFilterCloudId = new QFilter("mulbiz.fbasedataid.id", "=", (Object)bizCloudId);
                showParameter.getListFilterParameter().getQFilters().add(qFilterCloudId);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        switch (itemKey) {
            case "bar_draw": {
                DynamicObject org = (DynamicObject)model.getValue("org");
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurContractPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "material": {
                this.changeMaterial((DynamicObject)newValue, rowIndex);
                break;
            }
            case "supplier": {
                this.changeSupplier(newValue);
                DynamicObject invoicebiztype = (DynamicObject)this.getModel().getValue("invoicebiztype");
                if (invoicebiztype != null || newValue == null) break;
                DynamicObject supplier = (DynamicObject)newValue;
                DynamicObject invoicecategory = supplier.getDynamicObject("invoicecategory");
                Long invoicecategoryId = 0L;
                if (invoicecategory != null) {
                    invoicecategoryId = (Long)invoicecategory.getPkValue();
                }
                if (this.getView().getFormShowParameter().getAppId() != null) {
                    invoicebiztype = InvoiceBiztypeHelper.getInvoiceBizType((Long)invoicecategoryId, (String)this.getView().getFormShowParameter().getAppId());
                }
                if (invoicebiztype == null) break;
                this.getModel().setValue("invoicebiztype", invoicebiztype.getPkValue());
                break;
            }
            case "providersupplier": {
                this.changeProviderSupplier(newValue);
                break;
            }
            case "contparties": {
                this.changeContParties();
                break;
            }
            case "provideraddress": {
                this.getModel().beginInit();
                this.getModel().setValue("provideraddressf7", null);
                this.getModel().endInit();
                break;
            }
            case "provideraddressf7": {
                DynamicObject newAddress = (DynamicObject)newValue;
                if (newAddress == null) break;
                this.getModel().beginInit();
                this.getModel().setValue("provideraddress", (Object)newAddress.getString("detailaddress"));
                this.getView().updateView("provideraddress");
                this.getModel().endInit();
                break;
            }
            case "isprepay": {
                if (newValue == null) break;
                Boolean isprepay = (Boolean)newValue;
                if (isprepay.booleanValue()) {
                    String pretimepoint;
                    DynamicObject type = (DynamicObject)this.getModel().getValue("type");
                    if (type == null || StringUtils.isEmpty((String)(pretimepoint = type.getString("pretimepoint")))) break;
                    this.getModel().setValue("pretimepoint", (Object)pretimepoint, rowIndex);
                    break;
                }
                this.getModel().setValue("pretimepoint", (Object)"", rowIndex);
                break;
            }
            case "type": {
                this.setLedgerBtnControl();
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName;
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        switch (entryName = e.getEntryProp().getName()) {
            case "payentry": {
                DynamicObject type = (DynamicObject)this.getModel().getValue("type");
                if (rowDataEntities == null || rowDataEntities.length <= 0) break;
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    Boolean isprepay = (Boolean)this.getModel().getValue("isprepay", rowIndex);
                    if (isprepay != null && isprepay.booleanValue()) {
                        String pretimepoint;
                        if (type == null || StringUtils.isEmpty((String)(pretimepoint = type.getString("pretimepoint")))) continue;
                        this.getModel().setValue("pretimepoint", (Object)pretimepoint, rowIndex);
                        continue;
                    }
                    this.getModel().setValue("pretimepoint", (Object)"", rowIndex);
                }
                break;
            }
        }
    }

    public void click(EventObject evt) {
        DynamicObject org;
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (key.equals("provideraddress") && (org = (DynamicObject)this.getModel().getValue("org")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurContractPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (c.getKey().equalsIgnoreCase("provideraddress")) {
            BasedataEdit provideraddressf7 = (BasedataEdit)this.getControl("provideraddressf7");
            provideraddressf7.click();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        String key = operate.getOperateKey();
        if ("renew".equals(key)) {
            String billno;
            QFilter filter;
            DynamicObject bill = this.getModel().getDataEntity();
            String formId = bill.getDataEntityType().getName();
            DynamicObject[] renewBills = BusinessDataServiceHelper.load((String)formId, (String)"id,framenum,billno,biztimebegin,biztimeend", (QFilter[])(filter = new QFilter("framenum", "in", (Object)(billno = bill.getString("billno"))).and(new QFilter("isrenew", "=", (Object)Boolean.TRUE))).toArray());
            if (renewBills != null && renewBills.length > 0) {
                DynamicObject renewBill = renewBills[0];
                String renewBillNo = renewBill.getString("billno");
                String tip = String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u6709\u7eed\u7b7e\u5408\u540c\u201c%1$s\u201d\uff0c\u65e0\u6cd5\u518d\u6b21\u7eed\u7b7e\u3002", (String)"PurContractPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]), renewBillNo);
                this.getView().showTipNotification(tip);
                args.setCancel(true);
            }
        } else if ("payaccordsetting".equals(key)) {
            DynamicObject bill = this.getModel().getDataEntity();
            Object pkValue = bill.getPkValue();
            boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
            boolean dataChanged = this.getModel().getDataChanged();
            if (pkValue == null || pkValue.equals(0L) || !isFromDataBase || dataChanged) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u6216\u5237\u65b0\u5355\u636e\u3002", (String)"PurContractPlugin_12", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!"true".equals(option.getVariableValue("payaccordsetting", ""))) {
                boolean isOverPay = (Boolean)this.getModel().getValue("isallowoverpay");
                String billNo = (String)this.getModel().getValue("billno");
                String msg = isOverPay ? String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u662f\u201d\u66f4\u6539\u4e3a\u201c\u5426\u201d\uff0c\u4e25\u683c\u63a7\u5236\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurContractPlugin_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]), billNo) : String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u5426\u201d\u66f4\u6539\u4e3a\u201c\u662f\u201d\uff0c\u5141\u8bb8\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurContractPlugin_11", (String)"scmc-conm-formplugin", (Object[])new Object[0]), billNo);
                ConfirmCallBackListener listener = new ConfirmCallBackListener("payaccordsetting", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.setLedgerBtnControl();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "ledger": {
                this.showQuotaPushOrderForm();
                break;
            }
            case "payaccordsetting": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
        this.setLedgerBtnControl();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String key;
        switch (key = event.getCallBackId()) {
            case "payaccordsetting": {
                if (!event.getResult().equals((Object)MessageBoxResult.Yes)) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("payaccordsetting", "true");
                this.getView().invokeOperation("payaccordsetting", option);
            }
        }
    }

    private void showQuotaPushOrderForm() {
        IDataModel model = this.getModel();
        Long ledgerId = (Long)model.getValue("ledgerid");
        if (ledgerId == null || ledgerId == 0L) {
            String tip = String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u65e0\u5408\u540c\u53f0\u8d26\u5355\u636e\u3002", (String)"PurContractPlugin_9", (String)"scmc-conm-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showTipNotification(tip);
        } else {
            BillShowParameter quotaPushOrderForm = new BillShowParameter();
            quotaPushOrderForm.setFormId("er_contractbill");
            quotaPushOrderForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            quotaPushOrderForm.setPkId((Object)ledgerId);
            this.getView().showForm((FormShowParameter)quotaPushOrderForm);
        }
    }

    private void setLedgerBtnControl() {
        DynamicObject type = (DynamicObject)this.getModel().getValue("type");
        if (type != null && type.getBoolean("costexpense")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ledger"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ledger"});
        }
    }

    private void changeMaterial(DynamicObject material, int rowIndex) {
        IDataModel model = this.getModel();
        if (material == null) {
            model.setValue("unit", null, rowIndex);
            model.setValue("deliveraddress", null, rowIndex);
            return;
        }
        DynamicObject salesunit = material.getDynamicObject("purchaseunit");
        model.setValue("unit", salesunit == null ? null : salesunit.getPkValue(), rowIndex);
        model.setValue("deliveraddress", null, rowIndex);
        if (material.getDynamicObject("masterid.taxrate") == null) {
            Optional.ofNullable(this.getModel().getValue("supplier")).flatMap(supplier -> Optional.ofNullable(((DynamicObject)supplier).getDynamicObject("taxrate"))).ifPresent(supplierTaxRate -> this.getModel().setValue("taxrateid", supplierTaxRate.getPkValue(), rowIndex));
        }
    }

    private void cusAndSupSettletype(IDataModel bill, String roleType) {
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isdefault.and(isenable);
        DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{filter});
        if (bill.getValue("settletype") == null) {
            DynamicObject role = (DynamicObject)bill.getValue(roleType);
            if (role != null) {
                DynamicObject settlementtypeid = role.getDynamicObject("settlementtypeid");
                if (settlementtypeid == null) {
                    bill.setValue("settletype", defaultSettlementType == null ? null : defaultSettlementType.getPkValue());
                } else {
                    bill.setValue("settletype", settlementtypeid.getPkValue());
                }
            } else {
                bill.setValue("settletype", defaultSettlementType == null ? null : defaultSettlementType.getPkValue());
            }
        }
    }

    private void changeProviderSupplier(Object newValue) {
        if (newValue == null) {
            IDataModel bill = this.getModel();
            bill.setValue("providerlinkman", null);
            bill.setValue("provideraddress", null);
        } else if (newValue instanceof DynamicObject) {
            DynamicObject providerSupplier = (DynamicObject)newValue;
            String providerAddress = null;
            DynamicObjectCollection linkmans = null;
            if (providerSupplier != null) {
                providerAddress = SupplierHelper.getAddress((DynamicObject)providerSupplier);
                linkmans = providerSupplier.getDynamicObjectCollection("entry_linkman");
            }
            Long supplierLinkmanId = null;
            if (linkmans != null) {
                for (DynamicObject linkman : linkmans) {
                    boolean isDefault = linkman.getBoolean("isdefault_linkman");
                    boolean invalid = linkman.getBoolean("invalid");
                    if (isDefault && !invalid) {
                        supplierLinkmanId = (Long)linkman.getPkValue();
                        break;
                    }
                    if (supplierLinkmanId != null || invalid) continue;
                    supplierLinkmanId = (Long)linkman.getPkValue();
                }
            }
            IDataModel bill = this.getModel();
            bill.setValue("providerlinkman", supplierLinkmanId);
            bill.setValue("provideraddress", (Object)providerAddress);
        }
    }

    private void changeSupplier(Object newValue) {
        if (newValue == null) {
            IDataModel bill = this.getModel();
            bill.setValue("providersupplier", null);
            bill.setValue("invoicesupplier", null);
            bill.setValue("receivesupplier", null);
            bill.setValue("party2nd", null);
            bill.setValue("contactperson2nd", null);
            bill.setValue("phone2nd", null);
            return;
        }
        if (newValue instanceof DynamicObject) {
            DynamicObject supplier = (DynamicObject)newValue;
            DynamicObject settlementCy = null;
            DynamicObject settlementType = null;
            if (supplier != null) {
                settlementCy = supplier.getDynamicObject("settlementcyid");
                settlementType = supplier.getDynamicObject("settlementtypeid");
            }
            IDataModel bill = this.getModel();
            bill.setValue("providersupplier", (Object)this.getSupplierValue(supplier, "deliversupplierid"));
            bill.setValue("invoicesupplier", (Object)this.getSupplierValue(supplier, "invoicesupplierid"));
            bill.setValue("receivesupplier", (Object)this.getSupplierValue(supplier, "receivingsupplierid"));
            bill.setValue("party2nd", (Object)supplier.getLocaleString("name"));
            bill.setValue("contactperson2nd", (Object)supplier.getLocaleString("linkman").toString());
            bill.setValue("phone2nd", supplier.get("bizpartner_phone"));
            if (settlementType != null) {
                QFilter isenable;
                Long settlementTypeId = (Long)settlementType.getPkValue();
                QFilter id = new QFilter("id", "=", (Object)settlementTypeId);
                DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{id.and(isenable = new QFilter("enable", "=", (Object)"1"))});
                if (object == null) {
                    this.getSettleTypeDefault(bill);
                } else {
                    bill.setValue("settletype", settlementType.getPkValue());
                }
            } else if (settlementType == null) {
                this.getSettleTypeDefault(bill);
            }
            if (!Boolean.parseBoolean(this.getPageCache().get("isdraw"))) {
                if (settlementCy != null) {
                    bill.setValue("settlecurrency", settlementCy.getPkValue());
                } else {
                    DynamicObject currency = (DynamicObject)bill.getValue("currency");
                    bill.setValue("settlecurrency", currency == null ? null : currency.getPkValue());
                }
            }
        }
    }

    private void changeContParties() {
        IDataModel model = this.getModel();
        DynamicObject contParties = (DynamicObject)model.getValue("contparties");
        if (contParties != null) {
            model.setValue("party1st", (Object)contParties.getLocaleString("name"));
            model.setValue("contactperson1st", (Object)contParties.getString("contacts"));
            model.setValue("phone1st", contParties.get("phone"));
        } else {
            model.setValue("party1st", null);
            model.setValue("contactperson1st", null);
            model.setValue("phone1st", null);
        }
    }

    private Long getSupplierValue(DynamicObject supplier, String otherSupplier) {
        if (supplier == null) {
            return null;
        }
        DynamicObject other = SupplierHelper.getSupplierOriginal((DynamicObject)supplier, (String)otherSupplier);
        return other == null ? null : (Long)other.getPkValue();
    }

    private void getSettleTypeDefault(IDataModel bill) {
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isdefault.and(isenable);
        DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{filter});
        if (defaultSettlementType != null) {
            bill.setValue("settletype", defaultSettlementType.getPkValue());
        } else {
            bill.setValue("settletype", null);
        }
    }
}

