/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.contract;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.conm.business.helper.BillImportHelper;
import kd.scmc.conm.business.helper.BotpHelper;
import kd.scmc.conm.business.helper.CustomerHelper;
import kd.scmc.conm.business.pojo.ReturnResultInfo;
import kd.scmc.conm.enums.EnableStatusEnum;
import kd.scmc.conm.enums.MaterialConfigPropertiesEnum;
import kd.scmc.conm.utils.CommonUtils;

public class SalContractPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(SalContractPlugin.class);
    public static final String SELCONFIG = "selconfig";
    public static final String PREINVOICING = "preinvoicing";

    public void registerListener(EventObject e) {
        Toolbar tbmainentry;
        BasedataEdit configuredcode;
        BasedataEdit material;
        BasedataEdit receiveaddressf7;
        Control receiveaddress;
        BasedataEdit contpartiesEdit;
        BasedataEdit linkMan;
        BasedataEdit customerEdit;
        BasedataEdit reclinkmanEdit;
        BasedataEdit recentrysettleorg;
        BasedataEdit entrySettleOrg = (BasedataEdit)this.getView().getControl("entrysettleorg");
        if (entrySettleOrg != null) {
            entrySettleOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((recentrysettleorg = (BasedataEdit)this.getView().getControl("recentrysettleorg")) != null) {
            recentrysettleorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((reclinkmanEdit = (BasedataEdit)this.getView().getControl("reclinkman")) != null) {
            reclinkmanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((customerEdit = (BasedataEdit)this.getView().getControl("customer")) != null) {
            customerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit recCustomer = (BasedataEdit)this.getView().getControl("reccustomer");
        BasedataEdit settleCustmer = (BasedataEdit)this.getView().getControl("settlecustomer");
        BasedataEdit payCustomer = (BasedataEdit)this.getView().getControl("payingcustomer");
        if (recCustomer != null) {
            recCustomer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (settleCustmer != null) {
            settleCustmer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (payCustomer != null) {
            payCustomer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((linkMan = (BasedataEdit)this.getControl("linkman")) != null) {
            linkMan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((contpartiesEdit = (BasedataEdit)this.getView().getControl("contparties")) != null) {
            contpartiesEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((receiveaddress = this.getControl("receiveaddress")) != null) {
            this.addClickListeners(new String[]{"receiveaddress"});
        }
        if ((receiveaddressf7 = (BasedataEdit)this.getControl("receiveaddressf7")) != null) {
            receiveaddressf7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit suitOrg = (BasedataEdit)this.getView().getControl("suitorg");
        if (suitOrg != null) {
            suitOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((configuredcode = (BasedataEdit)this.getControl("configuredcode")) != null) {
            configuredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tbmainentry = (Toolbar)this.getView().getControl("tbmainentry")) != null) {
            tbmainentry.addItemClickListener((ItemClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isAPI((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        this.cusAndSupSettletype(this.getModel(), "customer");
        this.changeContParties();
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey = e.getItemKey();
        IDataModel model = this.getModel();
        switch (itemKey) {
            case "bar_draw": {
                DynamicObject org = (DynamicObject)model.getValue("org");
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalContractPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "selconfig": {
                if (e.isCancel()) break;
                AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
                int focusEntryRow = billentry.getEntryState().getFocusRow();
                if (focusEntryRow == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7269\u6599\u5206\u5f55\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"SalContractPlugin_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                int[] selectrows = ((EntryGrid)billentry).getSelectRows();
                if (selectrows != null && selectrows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7269\u6599\u5206\u5f55\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"SalContractPlugin_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", focusEntryRow);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"SalContractPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (MaterialConfigPropertiesEnum.CONFIG.getValue().equals(material.getDynamicObject("masterid").getString("configproperties"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u914d\u7f6e\u5c5e\u6027\u4e3a\u201c\u914d\u7f6e\u4ef6\u201d\u7684\u7269\u6599\uff0c\u518d\u8fdb\u884c\u9009\u914d\u3002", (String)"SalContractPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        String itemKey;
        super.itemClick(e);
        switch (itemKey = e.getItemKey()) {
            case "selconfig": {
                this.showProductConfigForm();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String name = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!"org".equals(name) && org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalContractPlugin_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (name) {
            case "recentrysettleorg": {
                HashSet<Long> array2 = new HashSet<Long>();
                DynamicObject org2 = (DynamicObject)this.getModel().getValue("org");
                array2.add(this.getCompanyByOrg(org2, Boolean.FALSE, Boolean.TRUE));
                DynamicObject entryInvOrg2 = (DynamicObject)this.getModel().getValue("entryinvorg", 0);
                array2.add(this.getCompanyByOrg(entryInvOrg2, Boolean.FALSE, Boolean.TRUE));
                if (array2.size() == 0) break;
                QFilter settleOrgFilter2 = new QFilter("id", "in", array2);
                showParameter.getListFilterParameter().setFilter(settleOrgFilter2);
                break;
            }
            case "suitorg": {
                DynamicObject salOrg = (DynamicObject)this.getModel().getValue("org");
                if (salOrg != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalContractPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "reclinkman": {
                if (this.getModel().getValue("reccustomer") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u5ba2\u6237\u3002", (String)"SalContractPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject recCustomer = (DynamicObject)this.getModel().getValue("reccustomer");
                if (recCustomer != null) {
                    DynamicObjectCollection linkmans = recCustomer.getDynamicObjectCollection("entry_linkman");
                    List invalid = linkmans.stream().filter(a -> !a.getBoolean("invalid")).map(a -> (Long)a.getPkValue()).collect(Collectors.toList());
                    QFilter qFilter = new QFilter("customerid", "=", recCustomer.getPkValue());
                    QFilter ids = new QFilter("id", "in", invalid);
                    showParameter.getListFilterParameter().setFilter(qFilter.and(ids));
                    break;
                }
                showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("customerid", "=", (Object)0)));
                break;
            }
            case "customer": {
                QFilter blockedorder = new QFilter("blockedorder", "=", (Object)"0");
                QFilter bizfunction = new QFilter("bizfunction", "like", (Object)"%1%");
                showParameter.getListFilterParameter().getQFilters().add(blockedorder.and(bizfunction));
                break;
            }
            case "reccustomer": {
                if (this.getModel().getValue("customer") != null) {
                    QFilter bizfunction1 = new QFilter("bizfunction", "like", (Object)"%4%");
                    QFilter status = new QFilter("status", "=", (Object)"C");
                    QFilter enable = new QFilter("enable", "=", (Object)"1");
                    QFilter customerstatus = new QFilter("customerstatus.number", "=", (Object)"ZSKH");
                    QFilter filters = status.and(enable).and(bizfunction1).and(customerstatus);
                    showParameter.getListFilterParameter().getQFilters().add(filters);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"SalContractPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "settlecustomer": {
                if (this.getModel().getValue("customer") != null) {
                    QFilter filter = new QFilter("bizfunction", "like", (Object)"%2%");
                    showParameter.getListFilterParameter().getQFilters().add(filter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"SalContractPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "payingcustomer": {
                if (this.getModel().getValue("customer") != null) {
                    QFilter filter = new QFilter("bizfunction", "like", (Object)"%3%");
                    showParameter.getListFilterParameter().getQFilters().add(filter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u5ba2\u6237\u3002", (String)"SalContractPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "partb": {
                showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("partnerrole", "=", (Object)"2")));
                break;
            }
            case "receiveaddressf7": {
                DynamicObject customer = (DynamicObject)this.getModel().getValue("reccustomer");
                if (customer == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u5ba2\u6237\u3002", (String)"SalContractPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter qFilter1 = new QFilter("customerid", "in", (Object)customer.getPkValue().toString());
                QFilter qFilter2 = new QFilter("invalid", "=", (Object)"0");
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2));
                break;
            }
            case "material": {
                if (this.getModel().getValue("type") != null) {
                    Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("type").getDynamicObject("biztype")).ifPresent(biztype -> {
                        if ("212".equals(biztype.getString("number"))) {
                            showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid.serviceattribute.fbasedataid_id", "=", (Object)1194029708862343168L));
                        }
                    });
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u7c7b\u578b\u3002", (String)"SalContractPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "configuredcode": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                if (material == null || material.getDynamicObject("masterid") == null) break;
                QFilter qFilter = new QFilter("material", "=", material.getDynamicObject("masterid").getPkValue());
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "material": {
                this.changeMaterial((DynamicObject)newValue, rowIndex);
                break;
            }
            case "customer": {
                this.customerChanged((DynamicObject)newValue);
                break;
            }
            case "reccustomer": {
                this.setValueIfExists("reclinkman", newValue == null ? null : () -> CustomerHelper.getLinkman((DynamicObject)((DynamicObject)newValue)));
                this.setValueIfExists("receiveaddress", newValue == null ? null : () -> CustomerHelper.getAddress((DynamicObject)((DynamicObject)newValue)));
                break;
            }
            case "contparties": {
                this.changeContParties();
                break;
            }
            case "receiveaddress": {
                this.getModel().beginInit();
                this.getModel().setValue("receiveaddressf7", null);
                this.getModel().endInit();
                break;
            }
            case "receiveaddressf7": {
                DynamicObject newAddress = (DynamicObject)newValue;
                if (newAddress == null) break;
                this.getModel().beginInit();
                this.getModel().setValue("receiveaddress", (Object)newAddress.getString("detailaddress"));
                this.getView().updateView("receiveaddress");
                this.getModel().endInit();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        DynamicObject org;
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (key.equals("receiveaddress") && (org = (DynamicObject)this.getModel().getValue("org")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalContractPlugin_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (c.getKey().equalsIgnoreCase("receiveaddress")) {
            BasedataEdit receiveaddressf7 = (BasedataEdit)this.getControl("receiveaddressf7");
            receiveaddressf7.click();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "matchamount": {
                DynamicObject billEntry = this.getModel().getEntryRowEntity("payentry", 0);
                if (billEntry != null && billEntry.getDynamicObject("recentrysettleorg") != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6536\u6b3e\u8ba1\u5212\u5206\u5f55\u884c\u7684\u7ed3\u7b97\u7ec4\u7ec7\uff0c\u518d\u5339\u914d\u9884\u6536\u6b3e\u3002", (String)"SalContractPlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "renew": {
                DynamicObject bill = this.getModel().getDataEntity();
                String formId = bill.getDataEntityType().getName();
                String billno = bill.getString("billno");
                QFilter filter = new QFilter("framenum", "in", (Object)billno).and(new QFilter("isrenew", "=", (Object)Boolean.TRUE));
                DynamicObject[] renewBills = BusinessDataServiceHelper.load((String)formId, (String)"id,framenum,billno,biztimebegin,biztimeend", (QFilter[])filter.toArray());
                if (renewBills == null || renewBills.length <= 0) break;
                DynamicObject renewBill = renewBills[0];
                String renewBillNo = renewBill.getString("billno");
                String tip = String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u6709\u7eed\u7b7e\u5408\u540c\u201c%1$s\u201d\uff0c\u65e0\u6cd5\u518d\u6b21\u7eed\u7b7e\u3002", (String)"SalContractPlugin_5", (String)"scmc-conm-formplugin", (Object[])new Object[0]), renewBillNo);
                this.getView().showTipNotification(tip);
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        AbstractOperate operate = (AbstractOperate)e.getSource();
        OperationResult opRes = e.getOperationResult();
        switch (operateKey) {
            case "matchamount": {
                DynamicObjectCollection recEntrys;
                DynamicObject settlecurrency;
                FormShowParameter param = new FormShowParameter();
                param.setFormId("conm_recmatch");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setCustomParam("wftypenumber", (Object)"HXLB_HTYSKPP_Recplanentry");
                param.setCustomParam("billno", this.getModel().getValue("billno"));
                DynamicObject customer = (DynamicObject)this.getModel().getValue("payingcustomer");
                if (customer != null) {
                    param.setCustomParam("customer", (Object)customer.getString("name"));
                }
                if ((settlecurrency = (DynamicObject)this.getModel().getValue("settlecurrency")) != null) {
                    param.setCustomParam("settlecurrency", (Object)settlecurrency.getString("name"));
                }
                if ((recEntrys = this.getModel().getEntryEntity("payentry")) != null && recEntrys.size() > 0 && ((DynamicObject)recEntrys.get(0)).getDynamicObject("recentrysettleorg") != null) {
                    param.setCustomParam("recentrysettleorg", (Object)((DynamicObject)recEntrys.get(0)).getDynamicObject("recentrysettleorg").getString("name"));
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date bizTime = (Date)this.getModel().getValue("biztime");
                if (bizTime != null) {
                    String formatDate = simpleDateFormat.format(bizTime);
                    param.setCustomParam("biztime", (Object)formatDate);
                }
                this.getView().showForm(param);
                break;
            }
            case "matchrecord": {
                ListShowParameter recordParam = new ListShowParameter();
                recordParam.setBillFormId("conm_scmatch");
                recordParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                recordParam.setCustomParam("billno", this.getModel().getValue("billno"));
                this.getView().showForm((FormShowParameter)recordParam);
                break;
            }
            case "preinvoicing": {
                String preParam;
                if (opRes == null || !opRes.isSuccess() || kd.bos.util.StringUtils.isEmpty((String)(preParam = operate.getOption().getVariableValue("PreOriginalParam", "")))) break;
                if ("onlytax".equals(preParam)) {
                    ArrayList<Long> srcBillIdList = new ArrayList<Long>(16);
                    for (Object pkID : opRes.getSuccessPkIds()) {
                        srcBillIdList.add((Long)pkID);
                    }
                    try {
                        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"AutoGenerateOriginalService", (String)"getOriginalIds", (Object[])new Object[]{srcBillIdList, "conm_salcontract"});
                        if (result == null) break;
                        if (Boolean.TRUE.equals(result.get("success"))) {
                            Set originalIdSet = (Set)result.get("originalIds");
                            this.showPreInvoicingTargetBillForm("sim_original_bill", originalIdSet);
                            break;
                        }
                        String errMsg = result.get("errMsg").toString();
                        this.getView().showTipNotification(errMsg);
                    }
                    catch (KDException ke1) {
                        String ke1Msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)ke1));
                        log.info("\u8c03\u7528 \u5e94\u6536 AutoGenerateOriginalService\u63a5\u53e3\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a" + ke1Msg);
                        this.getView().showErrorNotification(ke1Msg);
                    }
                    catch (Exception ex1) {
                        String ex1Msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex1);
                        log.error("\u8c03\u7528 \u5e94\u6536 AutoGenerateOriginalService\u63a5\u53e3\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a", (Object)ex1Msg);
                        this.getView().showErrorNotification(ex1Msg);
                    }
                    break;
                }
                if (!"allamount".equals(preParam)) break;
                String ruleId = "880193402522621952";
                Long billID = (Long)this.getModel().getValue("id");
                DynamicObject bill = this.getModel().getDataEntity();
                DynamicObjectCollection matEntrys1 = this.getModel().getEntryEntity("billentry");
                HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(matEntrys1.size());
                for (DynamicObject row : matEntrys1) {
                    sourceIdMap.put((Long)row.getPkValue(), billID);
                }
                ReturnResultInfo rrInfo = BotpHelper.botpGenerateTargetBill(sourceIdMap, (String)ruleId, (String)"conm_salcontract", (String)"billentry", (String)"ar_finarbill", (String)"save", null, (boolean)true);
                if (rrInfo.isSuccess() && rrInfo.getSuccessList() != null) {
                    List finarBillList = rrInfo.getSuccessList();
                    HashSet<Long> finarBillIdSet = new HashSet<Long>(finarBillList.size());
                    for (Object tb : finarBillList) {
                        if (tb instanceof Long) {
                            finarBillIdSet.add((Long)tb);
                            continue;
                        }
                        if (tb instanceof String) {
                            if (!StringUtils.isNotEmpty((CharSequence)((String)tb))) continue;
                            finarBillIdSet.add(Long.valueOf((String)tb));
                            continue;
                        }
                        if (!(tb instanceof DynamicObject)) continue;
                        finarBillIdSet.add((Long)((DynamicObject)tb).getPkValue());
                    }
                    this.showPreInvoicingTargetBillForm("ar_finarbill", finarBillIdSet);
                    break;
                }
                String errMsg = "";
                if (StringUtils.isNotBlank((CharSequence)rrInfo.getMessage())) {
                    log.info("\u9500\u552e\u5408\u540c\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + rrInfo.getMessage());
                    errMsg = rrInfo.getMessage();
                } else if (StringUtils.isNotBlank((CharSequence)rrInfo.getDetailMessage())) {
                    log.info("\u9500\u552e\u5408\u540c\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + rrInfo.getDetailMessage());
                    errMsg = rrInfo.getDetailMessage();
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9500\u552e\u5408\u540c\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%1$s\u3002", (String)"SalContractPlugin_9", (String)"scmc-conm-formplugin", (Object[])new Object[0]), errMsg));
                break;
            }
        }
    }

    private void showPreInvoicingTargetBillForm(String targetEntityKey, Set<Long> targetBillIdSet) {
        if (targetBillIdSet != null && targetBillIdSet.size() > 1) {
            ListShowParameter targetBillListParam = new ListShowParameter();
            targetBillListParam.setBillFormId(targetEntityKey);
            targetBillListParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            targetBillListParam.getCustomParams().put("preoriginal", Boolean.TRUE);
            targetBillListParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", targetBillIdSet));
            this.getView().showForm((FormShowParameter)targetBillListParam);
        } else if (targetBillIdSet != null && targetBillIdSet.size() == 1) {
            Long targetBillId = 0L;
            Iterator<Long> iterator = targetBillIdSet.iterator();
            while (iterator.hasNext()) {
                Long tid;
                targetBillId = tid = iterator.next();
            }
            BillShowParameter targetBillEditParam = new BillShowParameter();
            targetBillEditParam.setFormId(targetEntityKey);
            targetBillEditParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            targetBillEditParam.setPkId((Object)targetBillId);
            this.getView().showForm((FormShowParameter)targetBillEditParam);
        }
    }

    private void changeMaterial(DynamicObject material, int rowIndex) {
        DynamicObject salesunit;
        IDataModel model = this.getModel();
        model.setValue("configuredcode", null, rowIndex);
        if (material == null) {
            model.setValue("unit", null, rowIndex);
            model.setValue("deliveraddress", null, rowIndex);
            model.setValue("productline", null, rowIndex);
            return;
        }
        if (material.getDynamicObject("masterid") != null) {
            DynamicObject productLine = material.getDynamicObject("masterid").getDynamicObject("productline");
            if (productLine != null) {
                model.setValue("productline", productLine.getPkValue(), rowIndex);
            } else {
                model.setValue("productline", null, rowIndex);
            }
        }
        model.setValue("unit", (salesunit = material.getDynamicObject("salesunit")) == null ? null : salesunit.getPkValue(), rowIndex);
        model.setValue("deliveraddress", null, rowIndex);
        if (material.getDynamicObject("masterid.taxrate") == null) {
            Optional.ofNullable(this.getModel().getValue("customer")).flatMap(customer -> Optional.ofNullable(((DynamicObject)customer).getDynamicObject("taxrate"))).ifPresent(customerTaxRate -> this.getModel().setValue("taxrateid", customerTaxRate.getPkValue(), rowIndex));
        }
    }

    private void changeContParties() {
        IDataModel model = this.getModel();
        DynamicObject contParties = (DynamicObject)model.getValue("contparties");
        if (contParties != null) {
            model.setValue("party2nd", (Object)contParties.getLocaleString("name"));
            model.setValue("contactperson2nd", contParties.get("contacts"));
            model.setValue("phone2nd", contParties.get("phone"));
        } else {
            model.setValue("party2nd", null);
            model.setValue("contactperson2nd", null);
            model.setValue("phone2nd", null);
        }
    }

    private void customerChanged(DynamicObject customer) {
        if (customer == null) {
            return;
        }
        IDataModel model = this.getModel();
        Long customerValue = this.getCustomerValue(customer, "delivercustomerid");
        this.setValueIfExists("reccustomer", () -> customerValue);
        if (customerValue != null) {
            DynamicObject recCustomer = BusinessDataServiceHelper.loadSingleFromCache((Object)customerValue, (String)"bd_customer");
            this.setValueIfExists("reclinkman", () -> CustomerHelper.getLinkman((DynamicObject)recCustomer));
            this.setValueIfExists("receiveaddress", () -> CustomerHelper.getAddress((DynamicObject)recCustomer));
        }
        this.setValueIfExists("payingcustomer", () -> this.getCustomerValue(customer, "paymentcustomerid"));
        this.setValueIfExists("settlecustomer", () -> this.getCustomerValue(customer, "invoicecustomerid"));
        model.setValue("party1st", (Object)customer.getLocaleString("name"));
        model.setValue("contactperson1st", (Object)customer.getString("linkman"));
        model.setValue("phone1st", customer.get("bizpartner_phone"));
        DynamicObject settlementType = customer.getDynamicObject("settlementtypeid");
        if (settlementType != null) {
            Long settlementTypeId = (Long)settlementType.getPkValue();
            QFilter isenable = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            QFilter id = new QFilter("id", "=", (Object)settlementTypeId);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{id.and(isenable)});
            if (object == null) {
                this.getSettleTypeDefault(model);
            } else {
                model.setValue("settletype", settlementType.getPkValue());
            }
        } else {
            this.getSettleTypeDefault(model);
        }
        if (customer.getDynamicObject("settlementcyid") != null) {
            this.setValueIfExists("settlecurrency", () -> BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getDynamicObject("settlementcyid").getPkValue(), (String)"bd_currency", (String)"id, number, name, amtprecision,priceprecision,sign,isshowsign"));
        } else {
            this.setValueIfExists("settlecurrency", () -> model.getValue("currency"));
        }
    }

    private void getSettleTypeDefault(IDataModel bill) {
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isdefault.and(isenable);
        DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id,", (QFilter[])new QFilter[]{filter});
        if (defaultSettlementType != null) {
            bill.setValue("settletype", defaultSettlementType.getPkValue());
        } else {
            bill.setValue("settletype", null);
        }
    }

    private void setValueIfExists(String property, ValueHandle handle) {
        if (handle == null) {
            this.getModel().setValue(property, null);
        } else if (handle.getValue() != null && handle.getValue() instanceof DynamicObject) {
            this.getModel().setValue(property, ((DynamicObject)handle.getValue()).getPkValue());
        } else {
            this.getModel().setValue(property, handle.getValue());
        }
    }

    private void cusAndSupSettletype(IDataModel bill, String roleType) {
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isdefault.and(isenable);
        DynamicObject defaultSettlementType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{filter});
        if (bill.getValue("settletype") == null) {
            DynamicObject role = (DynamicObject)bill.getValue(roleType);
            if (role != null) {
                DynamicObject settlementtypeid = role.getDynamicObject("settlementtypeid");
                if (settlementtypeid == null) {
                    bill.setValue("settletype", defaultSettlementType == null ? null : defaultSettlementType.getPkValue());
                } else {
                    bill.setValue("settletype", settlementtypeid.getPkValue());
                }
            } else {
                bill.setValue("settletype", defaultSettlementType == null ? null : defaultSettlementType.getPkValue());
            }
        }
    }

    private Long getCompanyByOrg(DynamicObject org, Boolean isBizUnit, Boolean isSerrchUpward) {
        if (org == null || org.getPkValue() == null) {
            return null;
        }
        String key = "" + org.getPkValue() + isBizUnit + isSerrchUpward;
        String companyOrgStr = this.getPageCache().get(key);
        if (kd.bos.util.StringUtils.isEmpty((String)companyOrgStr)) {
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()), (Boolean)isBizUnit, (Boolean)isSerrchUpward);
            if (map == null) {
                return null;
            }
            Long companyOrgId = (Long)map.get("id");
            this.getPageCache().put(key, companyOrgId.toString());
            return companyOrgId;
        }
        return Long.valueOf(companyOrgStr);
    }

    private Long getCustomerValue(DynamicObject customer, String otherCustomer) {
        DynamicObject othCustomer = CustomerHelper.getCustomerOriginal((DynamicObject)customer, (String)otherCustomer);
        return othCustomer == null ? null : (Long)othCustomer.getPkValue();
    }

    private void showProductConfigForm() {
        AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
        int focusEntryRow = billentry.getEntryState().getFocusRow();
        if (focusEntryRow == -1) {
            return;
        }
        IDataModel model = this.getModel();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pdm_productconfig");
        param.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("780");
        param.getOpenStyle().setInlineStyleCss(style);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        DynamicObject materialsalinfo = (DynamicObject)model.getValue("material", focusEntryRow);
        DynamicObject material = materialsalinfo != null ? materialsalinfo.getDynamicObject("masterid") : null;
        String materialid = material == null ? "" : String.valueOf(material.getPkValue());
        DynamicObject invOrg = (DynamicObject)model.getValue("entryinvorg", focusEntryRow);
        String orgid = invOrg == null ? "" : String.valueOf(invOrg.getPkValue());
        Object datetime = model.getValue("biztime");
        Object deliverydatetime = model.getValue("deliverydate", focusEntryRow);
        DynamicObject configuredcode = (DynamicObject)model.getValue("configuredcode", focusEntryRow);
        long configcodeid = configuredcode == null ? 0L : (Long)configuredcode.getPkValue();
        customParams.put("org", orgid);
        customParams.put("material", materialid);
        customParams.put("datetime", datetime);
        customParams.put("deliverdatetime", deliverydatetime);
        customParams.put("configcode", configcodeid);
        customParams.put("issale", "2");
        param.setCustomParams(customParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELCONFIG));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() != null && SELCONFIG.equals(actionId)) {
            HashMap returnData = (HashMap)e.getReturnData();
            Long configCode = (Long)returnData.get("configCodeBack");
            AbstractGrid billentry = (AbstractGrid)this.getControl("billentry");
            int focusEntryRow = billentry.getEntryState().getFocusRow();
            this.getModel().setValue("configuredcode", (Object)configCode, focusEntryRow);
        }
    }

    public static interface ValueHandle {
        public Object getValue();
    }
}

