/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.tpl;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.conm.business.service.cooperate.impl.CooperateServiceExecutor;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateResponse;
import kd.scmc.conm.enums.BizCancelStatusEnum;
import kd.scmc.conm.enums.BizReviewStatusEnum;
import kd.scmc.conm.enums.BizSignStatusEnum;
import kd.scmc.conm.enums.StatusEnum;

public class ElecSignTplPlugin
extends AbstractBillPlugIn
implements UploadListener {
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("signattachment");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.elecSignBtnControl();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "revoke": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String entity = dataEntity.getDataEntityType().getName();
                Object pkValue = dataEntity.getPkValue();
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entity);
                String signstatus = bill.getString("signstatus");
                if ("B".equalsIgnoreCase(signstatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5df2\u7b7e\u7ae0\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"ElecSignTplPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                FormOperate operate = (FormOperate)args.getSource();
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("revoke", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u64a4\u9500\u201d\u64cd\u4f5c\u5c06\u6e05\u9664\u7b7e\u7ae0\u4fe1\u606f\uff0c\u662f\u5426\u64a4\u9500\uff1f", (String)"ElecSignTplPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        OperationResult result = args.getOperationResult();
        if (result == null) {
            return;
        }
        boolean success1 = result.isSuccess();
        boolean success2 = result.getValidateResult().isSuccess();
        DynamicObject bill = this.getModel().getDataEntity(true);
        if (success1 && success2) {
            switch (key) {
                case "uploadcontract": {
                    this.afterUpload(bill);
                    break;
                }
                case "revoke": {
                    this.afterRevoke(bill);
                    break;
                }
            }
            this.elecSignBtnControl();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("revoke") && evt.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("revoke", operateOption);
        }
    }

    private void elecSignBtnControl() {
        Boolean isElecSign = (Boolean)this.getModel().getValue("iselecsignature");
        String signstatus = (String)this.getModel().getValue("signstatus");
        String billstatus = (String)this.getModel().getValue("billstatus");
        String reviewstatus = (String)this.getModel().getValue("reviewstatus");
        String cancelstatus = (String)this.getModel().getValue("cancelstatus");
        if (isElecSign.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_signconfirm"});
            if (StatusEnum.SAVE.getValue().equalsIgnoreCase(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_bizprocess"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_preview"});
            } else if (StatusEnum.SUBMIT.getValue().equalsIgnoreCase(billstatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_bizprocess"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_preview"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_bizprocess"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_preview"});
            }
            if (BizSignStatusEnum.UNSIGN.getValue().equalsIgnoreCase(signstatus) && (BizReviewStatusEnum.INACTIVE.getValue().equalsIgnoreCase(reviewstatus) || BizReviewStatusEnum.PASS.getValue().equalsIgnoreCase(reviewstatus)) && BizCancelStatusEnum.UNCANCEL.getValue().equalsIgnoreCase(cancelstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_upload"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_upload"});
            }
            if (BizSignStatusEnum.PARTBSIGN.getValue().equalsIgnoreCase(signstatus) || BizSignStatusEnum.UPLOADFINISH.getValue().equalsIgnoreCase(signstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_part1stsign"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_part1stsign"});
            }
            if (BizSignStatusEnum.PARTASIGN.getValue().equalsIgnoreCase(signstatus) || BizSignStatusEnum.UPLOADFINISH.getValue().equalsIgnoreCase(signstatus)) {
                String name = this.getModel().getDataEntityType().getName();
                HashSet<String> orgIds = new HashSet<String>();
                Object orgId = this.getModel().getDataEntity().get("org.id");
                String orgIdStr = String.valueOf(orgId);
                orgIds.add(orgIdStr);
                Map enableSupMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"scc", (String)"ISCCBillService", (String)"getSCCSrm", (Object[])new Object[]{orgIds});
                boolean sccSysParam = "true".equals(enableSupMap.get(orgIdStr));
                if (("conm_purcontract".equals(name) || "conm_purendagrt".equals(name) || "conm_pursupagrt".equals(name)) && this.getModel().getDataEntity().getBoolean("supplier.issuppcolla") && sccSysParam) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_part2stsign"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bar_part2stsign"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_part2stsign"});
            }
            if (BizSignStatusEnum.PARTASIGN.getValue().equalsIgnoreCase(signstatus) || BizSignStatusEnum.PARTBSIGN.getValue().equalsIgnoreCase(signstatus) || BizSignStatusEnum.UPLOADFINISH.getValue().equalsIgnoreCase(signstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_revoke"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revoke"});
            }
            if (StatusEnum.SAVE.getValue().equalsIgnoreCase(billstatus)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"signattachment"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"signattachment"});
            }
        } else {
            if (BizSignStatusEnum.INACTIVE.getValue().equalsIgnoreCase(signstatus) || BizSignStatusEnum.UNSIGN.getValue().equalsIgnoreCase(signstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_preview"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_preview"});
            }
            if (BizSignStatusEnum.INACTIVE.getValue().equalsIgnoreCase(signstatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_signconfirm"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_signconfirm"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_upload"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_part1stsign"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_part2stsign"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revoke"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"signattachment"});
        }
    }

    private void afterUpload(DynamicObject bill) {
        bill.set("signstatus", (Object)"F");
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{bill});
        String name = this.getModel().getDataEntityType().getName();
        CooperateResponse response = CooperateServiceExecutor.sync(Collections.singletonList(bill), (String)name, (String)"sign-upload", (Long)RequestContext.get().getCurrUserId(), (Date)new Date());
        if (response != null && !response.isSuccess().booleanValue()) {
            throw new KDBizException(response.getMsg());
        }
        this.getView().updateView("signstatus");
    }

    private void afterRevoke(DynamicObject bill) {
        bill.set("signstatus", (Object)"A");
        bill.set("signdate", null);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{bill});
        String name = this.getModel().getDataEntityType().getName();
        CooperateResponse response = CooperateServiceExecutor.sync(Collections.singletonList(bill), (String)name, (String)"sign-revoke", (Long)RequestContext.get().getCurrUserId(), (Date)new Date());
        if (response != null && !response.isSuccess().booleanValue()) {
            throw new KDBizException(response.getMsg());
        }
        this.getView().updateView();
    }
}

