/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.tpl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupFilterHelper;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.business.helper.BillImportHelper;
import kd.scmc.conm.business.helper.OperatorGroupHelper;
import kd.scmc.conm.enums.EnableStatusEnum;
import kd.scmc.conm.utils.CommonUtils;

public class SalOperatorGrpPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(SalOperatorGrpPlugin.class);
    private static final String GRPTYPE_XSZ = "XSZ";
    private static final String OPERATORGRPID = "operatorgrpid";

    public void registerListener(EventObject e) {
        BasedataEdit deptEdit;
        BasedataEdit operatorEdit;
        super.registerListener(e);
        BasedataEdit operatorGroupEdit = (BasedataEdit)this.getView().getControl("operatorgroup");
        if (operatorGroupEdit != null) {
            operatorGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operatorEdit = (BasedataEdit)this.getView().getControl("operator")) != null) {
            operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deptEdit = (BasedataEdit)this.getView().getControl("dept")) != null) {
            deptEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object value = this.getModel().getValue("operator");
        this.getView().setEnable(Boolean.valueOf(value != null), new String[]{"operatorgroup"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isAPI((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter[] filters = new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)org.getPkValue())), new QFilter("operatorgrouptype", "=", (Object)GRPTYPE_XSZ), new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()), new QFilter("entryentity.operator.id", "=", (Object)UserServiceHelper.getCurrentUserId()), new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE)};
        DynamicObject query = QueryServiceHelper.queryOne((String)"bd_operatorgroup", (String)"id, entryentity.id", (QFilter[])filters);
        if (query != null) {
            model.setValue("operatorgroup", query.get("id"));
            model.setValue("operator", query.get("entryentity.id"));
            Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
            model.setValue("dept", (Object)deptId);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String name = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        switch (name) {
            case "operator": {
                QFilter invalidFilter = new QFilter("invalid", "=", (Object)Character.valueOf('0'));
                try {
                    Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)"conm_salcontract", (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
                    if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                        QFilter qFilter1 = OperatorGroupFilterHelper.getOperatorGroupByUserForAll((long)UserServiceHelper.getCurrentUserId(), (DynamicObject)org, (String)GRPTYPE_XSZ);
                        ArrayList<QFilter> list = new ArrayList<QFilter>();
                        list.add(qFilter1.and(invalidFilter));
                        showParameter.getListFilterParameter().setQFilters(list);
                        break;
                    }
                    QFilter qFilter1 = new QFilter(OPERATORGRPID, "in", (Object)OperatorGroupHelper.getOperatorGroupByOrg((long)((Long)org.getPkValue()), (String)GRPTYPE_XSZ));
                    ArrayList<QFilter> list = new ArrayList<QFilter>();
                    list.add(qFilter1.and(invalidFilter));
                    showParameter.getListFilterParameter().setQFilters(list);
                }
                catch (Exception ee) {
                    showParameter.getListFilterParameter().setFilter(new QFilter("opergrptype", "=", (Object)GRPTYPE_XSZ).and(invalidFilter));
                    LOGGER.error(ee.getMessage());
                }
                break;
            }
            case "dept": {
                DynamicObject user;
                List deptIDs = OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)((Long)org.getPkValue()), (boolean)true);
                DynamicObject operator2 = (DynamicObject)this.getModel().getValue("operator");
                if (operator2 != null && (user = operator2.getDynamicObject("operatorid")) != null) {
                    Long userID = (Long)user.getPkValue();
                    Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    deptIDs.add(deptID);
                }
                QFilter qFilter = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (Objects.equals("operator", propName)) {
            Long userID;
            DynamicObject operator = (DynamicObject)newValue;
            if (operator == null) {
                this.getModel().setValue("dept", null);
                this.getModel().setValue("operatorgroup", null);
                return;
            }
            Long deptID = null;
            this.getModel().setValue("operatorgroup", (Object)operator.getLong(OPERATORGRPID));
            Long l = userID = operator.get("operatorid") != null ? (Long)((DynamicObject)operator.get("operatorid")).getPkValue() : null;
            if (userID != null) {
                deptID = UserServiceHelper.getUserMainOrgId((long)userID);
            }
            this.getModel().setValue("dept", (Object)deptID);
        }
    }
}

