/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.contract;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.mpscmm.msbd.business.helper.OperateLogHelper;
import kd.mpscmm.msbd.common.enums.ChangeStatusEnum;
import kd.scmc.conm.enums.BizValidStatusEnum;

public class PmContractPayAccordSettingOp
extends AbstractOperationServicePlugIn {
    private static final String OP_KEY = "payaccordsetting";
    private static final String CACHE_RESULTKEY = "payaccordsettingresult";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isallowoverpay");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("changestatus");
        e.getFieldKeys().add("validstatus");
        e.getFieldKeys().add("payentry");
        e.getFieldKeys().add("isprepay");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                if (dataEntities == null || dataEntities.length < 1) {
                    return;
                }
                BillEntityType billEntityType = (BillEntityType)dataEntities[0].getDataEntity().getDynamicObjectType();
                String appId = billEntityType.getAppId();
                Long userId = RequestContext.get().getCurrUserId();
                String name = billEntityType.getName();
                Date now = TimeServiceHelper.now();
                String opDisPlayName = PmContractPayAccordSettingOp.this.getOpName(name, PmContractPayAccordSettingOp.OP_KEY);
                ArrayList<AppLogInfo> logList = new ArrayList<AppLogInfo>(10);
                for (ExtendedDataEntity extBill : dataEntities) {
                    DynamicObject org;
                    DynamicObject bill = extBill.getDataEntity();
                    boolean isAllowOverPay = bill.getBoolean("isallowoverpay");
                    if (!isAllowOverPay || (org = bill.getDynamicObject("org")) == null) continue;
                    Long orgId = (Long)org.getPkValue();
                    DynamicObject conmType = bill.getDynamicObject("type");
                    if (conmType == null) continue;
                    String excutecontrol = conmType.getString("excutecontrol");
                    String billNo = bill.getString("billno");
                    if ("M&N&P".equals(excutecontrol)) continue;
                    this.addErrorMessage(extBill, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b.\u5408\u540c\u63a7\u5236\u4e0d\u662f\u603b\u91d1\u989d\u3001\u6570\u91cf\u3001\u5355\u4ef7\uff0c\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5e94\u4e3a\u662f\uff0c\u66f4\u6539\u5931\u8d25\u3002", (String)"PmContractPayAccordSettingOp_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]));
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s \u7684\u91c7\u8d2d\u5408\u540c\u5408\u540c\u7c7b\u578b.\u5408\u540c\u63a7\u5236\u4e0d\u662f\u603b\u91d1\u989d\u3001\u6570\u91cf\u3001\u5355\u4ef7\uff0c\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5e94\u4e3a\u662f\uff0c\u66f4\u6539\u5931\u8d25\u3002", (String)"PmContractPayAccordSettingOp_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billNo);
                    logList.add(OperateLogHelper.buildAppLogInfo((Long)userId, (String)appId, (String)name, (Long)orgId, (Date)now, (String)opDisPlayName, (String)msg));
                }
                if (!logList.isEmpty()) {
                    OperateLogHelper.saveAppLog(logList);
                }
            }
        });
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if (this.dataEntities == null || this.dataEntities.length == 0) {
                    return;
                }
                HashSet<Long> ids = new HashSet<Long>(10);
                for (ExtendedDataEntity extendedData : this.dataEntities) {
                    DynamicObject bill;
                    if (extendedData == null || (bill = extendedData.getDataEntity()) == null) continue;
                    ids.add((Long)bill.getPkValue());
                }
                String name = this.dataEntities[0].getDataEntity().getDynamicObjectType().getName();
                if (ids.isEmpty()) {
                    return;
                }
                DynamicObjectCollection changingConmIdCol = QueryServiceHelper.query((String)name, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("changestatus", "=", (Object)ChangeStatusEnum.CHANGING.getValue())});
                if (changingConmIdCol == null || changingConmIdCol.isEmpty()) {
                    return;
                }
                ArrayList changingConmIds = new ArrayList(ids.size());
                changingConmIdCol.forEach(id -> changingConmIds.add(id.getLong("id")));
                for (ExtendedDataEntity extendedData : this.dataEntities) {
                    DynamicObject bill;
                    if (extendedData == null || (bill = extendedData.getDataEntity()) == null) continue;
                    ids.add((Long)bill.getPkValue());
                    if (!changingConmIds.contains(bill.getPkValue())) continue;
                    this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u66f4\u72b6\u6001\u4e0d\u7b49\u4e8e\u53d8\u66f4\u4e2d\u7684\u6570\u636e\u3002", (String)"PmContractPayAccordSettingOp_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || !OP_KEY.equals(operationKey) || dataEntities.length == 0) {
            return;
        }
        String name = dataEntities[0].getDynamicObjectType().getName();
        Boolean isOverPayResult = null;
        HashSet<Long> ids = new HashSet<Long>(10);
        for (DynamicObject bill : dataEntities) {
            Object pkValue = bill.getPkValue();
            ids.add((Long)pkValue);
            Object isOverPay = bill.get("isallowoverpay");
            if (isOverPayResult != null || isOverPay == null) continue;
            isOverPayResult = (Boolean)isOverPay == false;
        }
        if (isOverPayResult == null || ids.isEmpty()) {
            return;
        }
        this.getOption().setVariableValue(CACHE_RESULTKEY, String.valueOf(isOverPayResult));
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObject[] billFromDB = BusinessDataServiceHelper.load((String)name, (String)"id,isallowoverpay", (QFilter[])new QFilter[]{idFilter});
        if (billFromDB == null || billFromDB.length == 0) {
            return;
        }
        for (DynamicObject bill : billFromDB) {
            bill.set("isallowoverpay", (Object)isOverPayResult);
        }
        SaveServiceHelper.save((DynamicObject[])billFromDB);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || !OP_KEY.equals(operationKey) || dataEntities.length == 0) {
            return;
        }
        String payaccordsettingresult = this.getOption().getVariableValue(CACHE_RESULTKEY);
        if (StringUtils.isBlank((CharSequence)payaccordsettingresult)) {
            return;
        }
        boolean isOverPayResult = Boolean.parseBoolean(payaccordsettingresult);
        this.writeOperateLog(dataEntities, this.getOperationResult(), isOverPayResult);
        this.sendEventMsg(dataEntities, this.getOperationResult(), isOverPayResult);
    }

    private void sendEventMsg(DynamicObject[] dataEntities, OperationResult operationResult, boolean isOverPayResult) {
        List successPkIds;
        List list = successPkIds = operationResult.getSuccessPkIds() == null ? new ArrayList(10) : operationResult.getSuccessPkIds();
        if (successPkIds.isEmpty()) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            String billStatus = bill.getString("billstatus");
            String validStatus = bill.getString("validstatus");
            DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("payentry");
            if (payEntrys == null || payEntrys.isEmpty() || !"C".equals(billStatus) || !BizValidStatusEnum.VALID.getValue().equals(validStatus)) {
                successPkIds.remove(bill.getPkValue());
                continue;
            }
            boolean hasPrePay = false;
            for (DynamicObject payRow : payEntrys) {
                if (!payRow.getBoolean("isprepay")) continue;
                hasPrePay = true;
                break;
            }
            if (hasPrePay) continue;
            successPkIds.remove(bill.getPkValue());
        }
        if (successPkIds.isEmpty()) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("entityno", this.billEntityType.getName());
        param.put("billids", SerializationUtils.toJsonString(successPkIds));
        param.put("isallowoverpay", String.valueOf(isOverPayResult));
        EventServiceHelper.triggerEventSubscribe((String)"IsAllowOverPayChangeEvent", (String)SerializationUtils.toJsonString(param));
    }

    private void writeOperateLog(DynamicObject[] dataEntities, OperationResult operationResult, boolean isOverPayResult) {
        String appId = this.billEntityType.getAppId();
        Long userId = RequestContext.get().getCurrUserId();
        String name = this.billEntityType.getName();
        Date now = TimeServiceHelper.now();
        String opDisPlayName = this.getOpName(name, OP_KEY);
        ArrayList<AppLogInfo> logList = new ArrayList<AppLogInfo>(10);
        List successPkIds = operationResult.getSuccessPkIds();
        for (DynamicObject bill : dataEntities) {
            Long pkValue = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            Long orgId = (Long)org.getPkValue();
            String msg = "";
            if (successPkIds != null && successPkIds.contains(pkValue)) {
                msg = isOverPayResult ? String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c\u6309\u5c65\u7ea6\u652f\u4ed8\u7531\u201c\u5426\u201d\u66f4\u6539\u4e3a\u201c\u662f\u201d\u3002", (String)"PmContractPayAccordSettingOp_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billNo) : String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c\u6309\u5c65\u7ea6\u652f\u4ed8\u7531\u201c\u662f\u201d\u66f4\u6539\u4e3a\u201c\u5426\u201d\u3002", (String)"PmContractPayAccordSettingOp_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billNo);
            }
            logList.add(OperateLogHelper.buildAppLogInfo((Long)userId, (String)appId, (String)name, (Long)orgId, (Date)now, (String)opDisPlayName, (String)msg));
        }
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        if (errorInfos != null && !errorInfos.isEmpty()) {
            HashMap<Object, DynamicObject> dataPkMap = new HashMap<Object, DynamicObject>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                Object pkValue = dataEntity.getPkValue();
                if (successPkIds.contains(pkValue)) continue;
                dataPkMap.put(pkValue, dataEntity);
            }
            for (IOperateInfo errorInfo : errorInfos) {
                DynamicObject billObj;
                if (!(errorInfo instanceof OperateErrorInfo) || errorInfo.getPkValue() == null || (billObj = (DynamicObject)dataPkMap.get(errorInfo.getPkValue())) == null) continue;
                DynamicObject org = billObj.getDynamicObject("org");
                Long orgId = org == null ? Long.valueOf("0") : (Long)org.getPkValue();
                logList.add(OperateLogHelper.buildAppLogInfo((Long)userId, (String)appId, (String)name, (Long)orgId, (Date)now, (String)opDisPlayName, (String)errorInfo.getMessage()));
            }
        }
        OperateLogHelper.saveAppLog(logList);
    }

    private String getOpName(String entityName, String operationKey) {
        String operationName = "";
        Map dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityName, (String)operationKey);
        if (dataEntityOperate != null) {
            Map opName = (Map)dataEntityOperate.get("name");
            if (opName != null) {
                operationName = opName.containsKey(ResManager.getLanguage()) ? (String)opName.get(ResManager.getLanguage()) : (String)opName.get("zh_CN");
            }
            return operationName;
        }
        return operationName;
    }
}

