/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.contract;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.opvalidate.validator.ConfiguredCodeValidator;
import kd.scmc.conm.business.helper.CustomerHelper;
import kd.scmc.conm.validation.contract.ContractSubmitValidator;
import kd.scmc.conm.validation.contract.SalContractBlockedValidator;
import kd.scmc.conm.validation.tpl.ContractSuitOrgValidator;

public class SmContractSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("reccustomer");
        e.getFieldKeys().add("reclinkman");
        e.getFieldKeys().add("receiveaddress");
        e.getFieldKeys().add("settlecustomer");
        e.getFieldKeys().add("payingcustomer");
        e.getFieldKeys().add("suitscope");
        e.getFieldKeys().add("suitorg");
        e.getFieldKeys().add("biztimebegin");
        e.getFieldKeys().add("biztimeend");
        e.getFieldKeys().add("framename");
        e.getFieldKeys().add("framenum");
        e.getFieldKeys().add("frameversion");
        e.getFieldKeys().add("isrenew");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("configuredcode");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SalContractBlockedValidator());
        e.addValidator((AbstractValidator)new ContractSuitOrgValidator());
        e.addValidator((AbstractValidator)new ContractSubmitValidator());
        HashMap<String, Boolean> ccValidation = new HashMap<String, Boolean>(1);
        ccValidation.put("ischeckmustinput", Boolean.FALSE);
        ConfiguredCodeValidator ccValidator = new ConfiguredCodeValidator();
        ccValidator.setValidation(ccValidation);
        e.addValidator((AbstractValidator)ccValidator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObject customer = bill.getDynamicObject("customer");
            DynamicObject recCustomer = bill.getDynamicObject("reccustomer");
            DynamicObject settleCustomer = bill.getDynamicObject("settlecustomer");
            DynamicObject payingCustomer = bill.getDynamicObject("payingcustomer");
            if (recCustomer == null) {
                bill.set("reccustomer", (Object)customer);
                bill.set("reclinkman", (Object)CustomerHelper.getLinkmanObject((DynamicObject)customer));
                bill.set("receiveaddress", (Object)CustomerHelper.getAddress((DynamicObject)customer));
            }
            if (settleCustomer == null) {
                bill.set("settlecustomer", (Object)customer);
            }
            if (payingCustomer != null) continue;
            bill.set("payingcustomer", (Object)customer);
        }
    }
}

