/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.contract;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.conm.business.helper.XContractHelper;
import kd.scmc.conm.enums.ChangeTypeEnum;

public class XPurContractBizValidOp
extends AbstractOperationServicePlugIn {
    private static final String BIZVALID = "bizvalid";
    private static final Log logger = LogFactory.getLog(XPurContractBizValidOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sourcebillentity");
        e.getFieldKeys().add("totalallamount");
        e.getFieldKeys().add("billentrychangetype");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("billentrysrcid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        String srcBillEntity = null;
        for (DynamicObject bill : bills) {
            String sourceBillEntity = bill.getString("sourcebillentity");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (StringUtils.isBlank(srcBillEntity) && StringUtils.isNotBlank((CharSequence)sourceBillEntity)) {
                srcBillEntity = sourceBillEntity;
            }
            if (sourceBillId == null || sourceBillId == 0L) continue;
            srcBillIds.add(sourceBillId);
        }
        if (!srcBillIds.isEmpty() && StringUtils.isNotBlank(srcBillEntity)) {
            Map<Long, BigDecimal> conmPrePayAmountSum = this.getConmPrePayAmountSum(srcBillIds, srcBillEntity);
            conmPrePayAmountSum.entrySet().forEach(entry -> this.getOption().setVariableValue(XPurContractBizValidOp.getBillPayMountKey((Long)entry.getKey()), ((BigDecimal)entry.getValue()).toString()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (BIZVALID.equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills = e.getDataEntities();
            if (bills == null || bills.length == 0) {
                return;
            }
            DynamicObject bill = bills[0];
            bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
            String sourceBillEntity = bill.getString("sourcebillentity");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (sourceBillId == null || sourceBillEntity == null) {
                return;
            }
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillEntity);
            if (CommonUtils.isNull((Object)srcBill)) {
                return;
            }
            DynamicObjectCollection billEntry = srcBill.getDynamicObjectCollection("billentry");
            Boolean rowCancel = XContractHelper.isRowCancel((String)bill.getDynamicObjectType().getName());
            if (rowCancel != null && rowCancel.booleanValue()) {
                DynamicObjectCollection xBillEntry = bill.getDynamicObjectCollection("billentry");
                String[] enableEntryPropertys = ChangeModelHelper.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType(), (String)"billentry");
                block0: for (DynamicObject xRow : xBillEntry) {
                    String entryChangeType = xRow.getString("billentrychangetype");
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) continue;
                    for (DynamicObject row : billEntry) {
                        if (row.getLong("id") != xRow.getLong("billentrysrcid")) continue;
                        for (String entryProperty : enableEntryPropertys) {
                            row.set(entryProperty, xRow.get(entryProperty));
                        }
                        continue block0;
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBill});
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (!BIZVALID.equals(e.getOperationKey()) || CommonUtils.isNull((Object)e.getDataEntities())) {
            return;
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        String srcEntity = null;
        for (DynamicObject bill : e.getDataEntities()) {
            String sourceBillEntity = bill.getString("sourcebillentity");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (StringUtils.isBlank(srcEntity) && StringUtils.isNotBlank((CharSequence)sourceBillEntity)) {
                srcEntity = sourceBillEntity;
            }
            if (sourceBillId == null || sourceBillId == 0L) continue;
            srcBillIds.add(sourceBillId);
        }
        this.compareAndExcuteEvent(srcBillIds, srcEntity, this.getOption());
    }

    private void compareAndExcuteEvent(HashSet<Long> srcBillIds, String entityNo, OperateOption operateOption) {
        if (srcBillIds == null || srcBillIds.isEmpty()) {
            return;
        }
        Map<Long, BigDecimal> srcBeforeChangeAmountMap = this.getSrcBeforeChangePrePayAmount(operateOption);
        QFilter isPrePay = new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE);
        QFilter payTime = new QFilter("payentry.pretimepoint", "in", (Object)new String[]{"A", " "});
        QFilter idFilter = new QFilter("id", "in", srcBillIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNo, (String)"id,isallowoverpay,payentry.payamount as payamount", (QFilter[])new QFilter[]{isPrePay, payTime, idFilter}, null);
        DataSet billPayAmountSumDataSet = dataSet.groupBy(new String[]{"id", "isallowoverpay"}).sum("payamount").finish();
        HashMap<Long, BigDecimal> afterChangePayAmountSum = new HashMap<Long, BigDecimal>(10);
        HashSet<Long> isallowoverpayIds = new HashSet<Long>(10);
        for (Row row : billPayAmountSumDataSet) {
            Long id = row.getLong("id");
            Boolean isallowoverpay = row.getBoolean("isallowoverpay");
            if (isallowoverpay != null && isallowoverpay.booleanValue()) {
                isallowoverpayIds.add(id);
            }
            BigDecimal sumPayamount = row.getBigDecimal("payamount") == null ? BigDecimal.ZERO : row.getBigDecimal("payamount");
            afterChangePayAmountSum.put(id, sumPayamount);
        }
        if (!isallowoverpayIds.isEmpty()) {
            for (Long id : isallowoverpayIds) {
                srcBeforeChangeAmountMap.remove(id);
                afterChangePayAmountSum.remove(id);
            }
            if (srcBeforeChangeAmountMap.isEmpty() && afterChangePayAmountSum.isEmpty()) {
                return;
            }
        }
        HashSet<Long> prePayChangedSrcBillIds = new HashSet<Long>(10);
        prePayChangedSrcBillIds.addAll(this.getPrePayChanged(srcBeforeChangeAmountMap, afterChangePayAmountSum));
        prePayChangedSrcBillIds.addAll(this.getPrePayChanged(afterChangePayAmountSum, srcBeforeChangeAmountMap));
        if (prePayChangedSrcBillIds.isEmpty()) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("entityno", entityNo);
        param.put("billids", SerializationUtils.toJsonString(prePayChangedSrcBillIds));
        EventServiceHelper.triggerEventSubscribe((String)"PrePayAmountChangeEvent", (String)SerializationUtils.toJsonString(param));
    }

    private HashSet<Long> getPrePayChanged(Map<Long, BigDecimal> srcBeforeChangeAmountMap, Map<Long, BigDecimal> afterChangePayAmountSum) {
        HashSet<Long> result = new HashSet<Long>(10);
        for (Map.Entry<Long, BigDecimal> entry : srcBeforeChangeAmountMap.entrySet()) {
            BigDecimal afterAmount;
            BigDecimal srcBeforeAmount;
            Long srcBillId = entry.getKey();
            BigDecimal bigDecimal = srcBeforeAmount = entry.getValue() == null ? BigDecimal.ZERO : entry.getValue();
            if (srcBillId == null || srcBeforeAmount.compareTo(afterAmount = afterChangePayAmountSum.get(srcBillId) == null ? BigDecimal.ZERO : afterChangePayAmountSum.get(srcBillId)) == 0) continue;
            result.add(srcBillId);
        }
        return result;
    }

    private Map<Long, BigDecimal> getSrcBeforeChangePrePayAmount(OperateOption operateOption) {
        Map variables = operateOption.getVariables();
        HashMap<Long, BigDecimal> srcBillIdAndAmount = new HashMap<Long, BigDecimal>(10);
        if (variables == null || variables.isEmpty()) {
            return srcBillIdAndAmount;
        }
        for (Map.Entry entry : variables.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null || key.indexOf("sumprepayamount") == -1) continue;
            srcBillIdAndAmount.put(Long.parseLong(key.substring(0, key.indexOf("sumprepayamount"))), new BigDecimal((String)entry.getValue()));
        }
        return srcBillIdAndAmount;
    }

    private Map<Long, BigDecimal> getConmPrePayAmountSum(Set<Long> billids, String srcEntity) {
        QFilter isPrePay = new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE);
        QFilter payTime = new QFilter("payentry.pretimepoint", "in", (Object)new String[]{"A", " "});
        QFilter idFilter = new QFilter("id", "in", billids);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)srcEntity, (String)"id,payentry.payamount as payamount", (QFilter[])new QFilter[]{isPrePay, payTime, idFilter}, null);
        DataSet billPayAmountSumDataSet = dataSet.groupBy(new String[]{"id"}).sum("payamount").finish();
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(10);
        for (Row row : billPayAmountSumDataSet) {
            Long id = row.getLong("id");
            BigDecimal sumPayamount = row.getBigDecimal("payamount") == null ? BigDecimal.ZERO : row.getBigDecimal("payamount");
            result.put(id, sumPayamount);
        }
        return result;
    }

    private static String getBillPayMountKey(Long billId) {
        return billId + "sumprepayamount";
    }
}

