/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.InteTimeZone;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.conm.business.helper.TaskHelper;

public class EndAgreementValidTask
extends AbstractTask {
    private Log log = LogFactory.getLog(EndAgreementValidTask.class);

    public void execute(RequestContext context, Map<String, Object> parm) throws KDException {
        Map<String, String> entityMap = this.getBillEntityId();
        entityMap.forEach((entityName, opKey) -> {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)entityName, (String)String.join((CharSequence)",", TaskHelper.selectFields()), (QFilter[])this.getQFilter());
            if (null == bills || bills.length == 0) {
                this.log.info(entityName + " no exist bills.");
                return;
            }
            TaskHelper.execOpAndSendErrorMsg((String)entityName, (String)opKey, Arrays.asList(bills));
        });
    }

    protected Map<String, String> getBillEntityId() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("conm_purendagrt", "bizvalid");
        map.put("conm_salendagrt", "bizvalid");
        return map;
    }

    protected QFilter[] getQFilter() {
        InteTimeZone zone = TimeServiceHelper.getUserTimeZone();
        LocalDate localDate = zone == null ? LocalDate.now() : LocalDate.now(zone.getTimeZone().toZoneId());
        LocalDateTime maxLocalDateTime = LocalDateTime.of(localDate, LocalTime.MAX.withNano(999));
        QFilter qfilter2 = new QFilter("biztimeend", "<=", (Object)maxLocalDateTime);
        List filters = TaskHelper.getValidQFilter();
        filters.add(qfilter2);
        return filters.toArray(new QFilter[filters.size()]);
    }

    @Deprecated
    protected String getSelectFields() {
        return String.join((CharSequence)",", TaskHelper.selectFields());
    }
}

