/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.tpl;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.conm.business.helper.TaskHelper;
import kd.scmc.conm.enums.BizCloseStatusEnum;
import kd.scmc.conm.validation.tpl.BizRowCloseStatusValidator;

public class BizRowCloseOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(BizRowCloseOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("rowclosestatus");
        e.getFieldKeys().add("validstatus");
        e.getFieldKeys().add("closestatus");
        e.getFieldKeys().add("changestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BizRowCloseStatusValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.endOperationTransaction(e);
        ArrayList<Object> billCloseIds = new ArrayList<Object>();
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection col = bill.getDynamicObjectCollection("billentry");
            if (col == null || col.size() == 0) continue;
            int falg = 0;
            for (DynamicObject dymRow : col) {
                String rowCloseStatus = dymRow.getString("rowclosestatus");
                if (!BizCloseStatusEnum.CLOSE.getValue().equals(rowCloseStatus)) continue;
                ++falg;
            }
            if (falg != col.size()) continue;
            billCloseIds.add(bill.getPkValue());
        }
        LOG.info(String.format(ResManager.loadKDString((String)"\u7b26\u5408\u6574\u5355\u5173\u95ed\u6761\u4ef6\u7684\u5355\u636eIDs : %s\u3002", (String)"BizRowCloseOp_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billCloseIds));
        if (billCloseIds.size() > 0) {
            OperationResult opRes = TaskHelper.executeOpIgnoreTip((String)"bizclose", (String)this.billEntityType.getName(), (Object[])billCloseIds.toArray());
            LOG.info(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c\uff1a%s\u3002", (String)"BizRowCloseOp_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), opRes));
            if (opRes.getAllErrorInfo().size() > 0 || opRes.getAllErrorOrValidateInfo().size() > 0) {
                LOG.info(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6574\u5355\u5173\u95ed\u64cd\u4f5c\u5931\u8d25 : ErrorInfo , %1$s <------> validateInfo , %2$s", (String)"BizRowCloseOp_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), opRes.getAllErrorInfo(), opRes.getAllErrorOrValidateInfo()));
                this.getOperationResult().setSuccess(false);
                this.getOperationResult().getAllErrorInfo().addAll(opRes.getAllErrorInfo());
                this.getOperationResult().getAllErrorOrValidateInfo().addAll(opRes.getAllErrorOrValidateInfo());
                this.getOperationResult().setMessage(String.format(ResManager.loadKDString((String)"%s\u68c0\u6d4b\u5230\u7684\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u201c\u5df2\u751f\u6548\u201d\u3001\u201c\u672a\u5173\u95ed\u201d\u3001\u975e\u201c\u53d8\u66f4\u4e2d\u201d\u7684\u6709\u6548\u6570\u636e\u624d\u80fd\u8fdb\u884c\u6574\u5355\u5173\u95ed\u64cd\u4f5c\u3002", (String)"BizRowCloseOp_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), opRes.getMessage()));
            }
        }
    }
}

