/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.tpl;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.conm.business.helper.TaskHelper;
import kd.scmc.conm.enums.BizRowTerminateStatusEnum;
import kd.scmc.conm.validation.tpl.BizRowTerminateStatusValidator;

public class BizRowTerminateOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(BizRowTerminateOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("rowterminatestatus");
        e.getFieldKeys().add("validstatus");
        e.getFieldKeys().add("terminatestatus");
        e.getFieldKeys().add("changestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BizRowTerminateStatusValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.endOperationTransaction(e);
        ArrayList<Object> billTerminateIds = new ArrayList<Object>();
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection col = bill.getDynamicObjectCollection("billentry");
            if (col == null || col.size() == 0) continue;
            int falg = 0;
            for (DynamicObject dymRow : col) {
                String rowCloseStatus = dymRow.getString("rowterminatestatus");
                if (!BizRowTerminateStatusEnum.TERMINATE.getValue().equals(rowCloseStatus)) continue;
                ++falg;
            }
            if (falg != col.size()) continue;
            billTerminateIds.add(bill.getPkValue());
        }
        LOG.info(String.format(ResManager.loadKDString((String)"\u7b26\u5408\u6574\u5355\u7ec8\u6b62\u6761\u4ef6\u7684\u5355\u636eIDs : %s\u3002", (String)"BizRowTerminateOp_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billTerminateIds));
        if (billTerminateIds.size() > 0) {
            OperationResult opRes = TaskHelper.executeOpIgnoreTip((String)"bizterminate", (String)this.billEntityType.getName(), (Object[])billTerminateIds.toArray());
            LOG.info(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c\uff1a%s\u3002", (String)"BizRowTerminateOp_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), opRes));
            if (opRes.getAllErrorInfo().size() > 0 || opRes.getAllErrorOrValidateInfo().size() > 0) {
                LOG.info(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6574\u5355\u7ec8\u6b62\u64cd\u4f5c\u5931\u8d25 : ErrorInfo , %1$s  validateInfo , %2$s\u3002", (String)"BizRowTerminateOp_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), opRes.getAllErrorInfo(), opRes.getAllErrorOrValidateInfo()));
                this.getOperationResult().setSuccess(false);
                this.getOperationResult().getAllErrorInfo().addAll(opRes.getAllErrorInfo());
                this.getOperationResult().getAllErrorOrValidateInfo().addAll(opRes.getAllErrorOrValidateInfo());
                this.getOperationResult().setMessage(String.format(ResManager.loadKDString((String)"%s\u68c0\u6d4b\u5230\u7684\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u201c\u5df2\u751f\u6548\u201d\u3001\u201c\u672a\u7ec8\u6b62\u201d\u3001\u975e\u201c\u53d8\u66f4\u4e2d\u201d\u7684\u6709\u6548\u6570\u636e\u624d\u80fd\u8fdb\u884c\u6574\u5355\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"BizRowTerminateOp_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), opRes.getMessage()));
            }
        }
    }
}

