/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.tpl;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.opvalidate.validator.IsPresentValidator;
import kd.scmc.conm.enums.ExChangeTypeEnum;
import kd.scmc.conm.validation.tpl.MaterialValidator;

public class ContractMatTplSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("materialmasterid");
        e.getFieldKeys().add("materialversion");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("exchangetype");
        e.getFieldKeys().add("materialname");
        e.getFieldKeys().add("billentrychangetype");
        e.getFieldKeys().add("discountamount");
        e.getFieldKeys().add("amountandtax");
        e.getFieldKeys().add("ispresent");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MaterialValidator());
        ArrayList<String> billName = new ArrayList<String>();
        billName.add("conm_purcontract");
        billName.add("conm_salcontract");
        billName.add("conm_xpurcontract");
        billName.add("conm_xsalcontract");
        String dateEnTityName = this.billEntityType.getName();
        if (!StringUtils.isEmpty((CharSequence)dateEnTityName) && billName != null && billName.contains(dateEnTityName) && this.isSupportDiscount()) {
            e.addValidator((AbstractValidator)new IsPresentValidator());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        if ("submit".equals(key) || "copublish".equals(key)) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = e.getDataEntities()) {
                String exchangeType = bill.getString("exchangetype");
                if (!kd.bos.util.StringUtils.isEmpty((String)exchangeType)) continue;
                bill.set("exchangetype", (Object)ExChangeTypeEnum.DIRECTRATE.getValue());
            }
        }
    }

    private boolean isSupportDiscount() {
        QFilter paramFilter = new QFilter("number", "=", (Object)"DISCOUNT001");
        DynamicObject discountParam = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_scmcapplevelparam", (QFilter[])new QFilter[]{paramFilter});
        return discountParam == null || !"0".equals(discountParam.getString("enable"));
    }
}

