/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.tpl;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.conm.business.custom.ext.bizextplugin.XContractSynContractStatusImpl;
import kd.scmc.conm.business.helper.AttachmentsHelper;
import kd.scmc.conm.business.helper.RowNumHelper;
import kd.scmc.conm.enums.ChangeTypeEnum;
import kd.sdk.scmc.conm.extpoint.IXContractPlugin;

public class XBizValidOp
extends AbstractOperationServicePlugIn {
    private static final String BIZVALID = "bizvalid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("billentrychangetype");
        e.getFieldKeys().add("lineno");
        e.getFieldKeys().add("sourcebillentity");
        e.getFieldKeys().add("billentrysrcid");
        e.getFieldKeys().add("orderbaseqty");
        e.getFieldKeys().add("baseqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (BIZVALID.equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            XContractSynContractStatusImpl impl;
            PluginProxy pluginProxy;
            List results;
            DynamicObject[] srcBills;
            DynamicObject[] xbills = e.getDataEntities();
            HashSet<Long> srcBillIds = new HashSet<Long>(16);
            String sourceBillEntity = null;
            for (DynamicObject xbill : xbills) {
                srcBillIds.add(xbill.getLong("sourcebillid"));
                sourceBillEntity = xbill.getString("sourcebillentity");
            }
            if (StringUtils.isNotEmpty(sourceBillEntity) && !srcBillIds.isEmpty() && (srcBills = BusinessDataServiceHelper.load((Object[])srcBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType(sourceBillEntity))) != null && srcBills.length > 0 && (results = (pluginProxy = PluginProxy.create((Object)(impl = new XContractSynContractStatusImpl()), IXContractPlugin.class, (String)"SCMC_CONM_XCONTRACT_ACTIVE_SYNCSTATUS", null)).callReplaceIfPresent(p -> p.activeSynContractStatus(srcBills, xbills))) != null && results.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])srcBills);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] entities = e.getDataEntities();
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        String tableName = "";
        String signAttachKey = "signattachment";
        String attachmentKey = "attachmentpanel";
        for (DynamicObject entity : entities) {
            tableName = entity.getDataEntityType().getName();
            String tarFormId = "";
            if ("conm_xpurcontract".equals(tableName)) {
                tarFormId = "conm_purcontract";
            } else if ("conm_xsalcontract".equals(tableName)) {
                tarFormId = "conm_salcontract";
            }
            if (StringUtils.isNotEmpty((String)tarFormId)) {
                AttachmentsHelper.copyAttachments((String)tableName, (Object)entity.getPkValue(), (String)signAttachKey, (String)tarFormId, (Object)entity.getLong("sourcebillid"), (String)signAttachKey);
                AttachmentsHelper.copyAttachments((String)tableName, (Object)entity.getPkValue(), (String)attachmentKey, (String)tarFormId, (Object)entity.getLong("sourcebillid"), (String)attachmentKey);
            }
            Boolean isAddNewRow = Boolean.FALSE;
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
            for (DynamicObject row : entry) {
                if (!ChangeTypeEnum.ADDNEW.getValue().equals(row.getString("billentrychangetype"))) continue;
                isAddNewRow = Boolean.TRUE;
                break;
            }
            if (!isAddNewRow.booleanValue()) continue;
            srcBillIds.add(entity.getLong("sourcebillid"));
        }
        if (srcBillIds.size() == 0) {
            return;
        }
        if (tableName == null) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", srcBillIds);
        DynamicObject[] srcEntities = null;
        if ("conm_xpurcontract".equals(tableName)) {
            srcEntities = BusinessDataServiceHelper.load((String)"conm_purcontract", (String)"lineno", (QFilter[])new QFilter[]{qFilter});
        } else if ("conm_xsalcontract".equals(tableName)) {
            srcEntities = BusinessDataServiceHelper.load((String)"conm_salcontract", (String)"lineno", (QFilter[])new QFilter[]{qFilter});
        }
        if (srcEntities != null) {
            RowNumHelper.generateRowNum(srcEntities, (Boolean)Boolean.FALSE);
            SaveServiceHelper.update((DynamicObject[])srcEntities);
        }
    }
}

