/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ContractFilingValidator
extends AbstractValidator {
    public void validate() {
        switch (this.getOperateKey()) {
            case "save": 
            case "submit": {
                HashSet<Long> bills = new HashSet<Long>();
                HashSet<Long> pks = new HashSet<Long>();
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    long srcbillid = bill.getLong("srcbillid");
                    long pkValue = (Long)bill.getPkValue();
                    if (srcbillid != 0L) {
                        bills.add(srcbillid);
                    } else if ("save".equals(this.getOperateKey())) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5f52\u6863\u7684\u5355\u636e\u3002", (String)"ContractFilingValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                        return;
                    }
                    pks.add(pkValue);
                }
                QFilter id = new QFilter("srcbillid", "in", bills);
                QFilter pk = new QFilter("id", "not in", pks);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"conm_filingapply", (String)"id,srcbillid", (QFilter[])new QFilter[]{id.and(pk)});
                bills.clear();
                query.forEach(q -> bills.add(q.getLong("srcbillid")));
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    long srcbillid = bill.getLong("srcbillid");
                    if (!bills.contains(srcbillid)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u8be5\u5408\u540c\u5df2\u5b58\u5728\u5f52\u6863\u7533\u8bf7\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u7533\u8bf7\u3002", (String)"ContractFilingValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
                break;
            }
        }
    }
}

