/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ContractSubmitValidator
extends AbstractValidator {
    public void validate() {
        DynamicObjectCollection srcContracts;
        HashSet<String> billNoSet = new HashSet<String>();
        String entityName = null;
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject bill = extend.getDataEntity();
            entityName = bill.getDataEntityType().getName();
            if (!"conm_purcontract".equals(entityName) && !"conm_salcontract".equals(entityName)) continue;
            boolean isRenew = bill.getBoolean("isrenew");
            String frameNum = bill.getString("framenum");
            if (!isRenew) continue;
            billNoSet.add(frameNum);
        }
        if (StringUtils.isNotEmpty(entityName) && (srcContracts = QueryServiceHelper.query((String)entityName, (String)"id,billno,biztimebegin,biztimeend", (QFilter[])new QFilter("billno", "in", billNoSet).toArray())) != null && srcContracts.size() > 0) {
            HashMap map = new HashMap();
            for (DynamicObject srcContract : srcContracts) {
                HashMap<String, Date> dateMap = new HashMap<String, Date>();
                dateMap.put("srcbiztimebegin", srcContract.getDate("biztimebegin"));
                dateMap.put("srcbiztimeend", srcContract.getDate("biztimeend"));
                map.put(srcContract.getString("billno"), dateMap);
            }
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObject bill = extend.getDataEntity();
                Date bizTimeBegin = bill.getDate("biztimebegin");
                Date bizTimeEnd = bill.getDate("biztimeend");
                Map dateMap = (Map)map.get(bill.getString("framenum"));
                if (dateMap == null) continue;
                Date srcBizTimeBegin = (Date)dateMap.get("srcbiztimebegin");
                Date srcBizTimeEnd = (Date)dateMap.get("srcbiztimeend");
                if (bizTimeBegin == null || bizTimeEnd == null || srcBizTimeBegin == null || srcBizTimeEnd == null || bizTimeBegin.compareTo(srcBizTimeEnd) > 0) continue;
                String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u7eed\u7b7e\u5408\u540c\u7684\u8d77\u59cb\u65e5\u671f\uff0c\u4f7f\u5176\u665a\u4e8e\u539f\u5408\u540c\u7684\u622a\u6b62\u65e5\u671f\u3002", (String)"ContractRenewValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
                this.addMessage(extend, tip, ErrorLevel.Error);
            }
        }
    }
}

