/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.conm.business.helper.CustomerHelper;

public class CustomerValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("customer");
        preparePropertys.add("payingcustomer");
        preparePropertys.add("settlecustomer");
        preparePropertys.add("reccustomer");
        preparePropertys.add("reclinkman");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject recLinkman;
            DynamicObject recCustomer;
            DynamicObject settleCustomer;
            DynamicObject payCustomer;
            DynamicObject bill = extend.getDataEntity();
            DynamicObject customer = bill.getDynamicObject("customer");
            if (customer != null && (!CustomerHelper.checkBizFunction((DynamicObject)customer, (String)"1") || CustomerHelper.isBlockedorder((DynamicObject)customer))) {
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%1$s\u201d\u5df2\u9500\u552e\u51bb\u7ed3\u6216\u4e0d\u662f\u5177\u6709\u9500\u552e\u804c\u80fd\u7684\u5ba2\u6237\u3002", (String)"CustomerValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), customer.getString("number")), ErrorLevel.Error);
            }
            if ((payCustomer = bill.getDynamicObject("payingcustomer")) != null && !CustomerHelper.checkBizFunction((DynamicObject)payCustomer, (String)"3")) {
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u662f\u5177\u6709\u4ed8\u6b3e\u804c\u80fd\u7684\u5ba2\u6237\u3002", (String)"CustomerValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), payCustomer.getString("number")), ErrorLevel.Error);
            }
            if ((settleCustomer = bill.getDynamicObject("settlecustomer")) != null && !CustomerHelper.checkBizFunction((DynamicObject)settleCustomer, (String)"2")) {
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u5177\u6709\u7ed3\u7b97\u804c\u80fd\u3002", (String)"CustomerValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), settleCustomer.getString("number")), ErrorLevel.Error);
            }
            if ((recCustomer = bill.getDynamicObject("reccustomer")) == null) continue;
            if (!CustomerHelper.checkBizFunction((DynamicObject)recCustomer, (String)"4")) {
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u6536\u8d27\u5ba2\u6237\u201c%1$s\u201d\u4e0d\u662f\u5177\u6709\u6536\u8d27\u804c\u80fd\u7684\u5ba2\u6237\u3002", (String)"CustomerValidator_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]), recCustomer.getString("number")), ErrorLevel.Error);
            }
            if ((recLinkman = bill.getDynamicObject("reclinkman")) == null || CustomerHelper.getAllLinkMans((DynamicObject)recCustomer).contains(recLinkman.getPkValue())) continue;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u6536\u8d27\u8054\u7cfb\u4eba\u201c%1$s\u201d\u4e0d\u662f\u5f53\u524d\u6536\u8d27\u5ba2\u6237\u7684\u6709\u6548\u8054\u7cfb\u4eba\u3002", (String)"CustomerValidator_5", (String)"scmc-conm-opplugin", (Object[])new Object[0]), recLinkman.getString("contactperson")), ErrorLevel.Error);
        }
    }
}

