/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class PurContractOrgValidator
extends AbstractValidator {
    public static String PARA_ISCHECKREQORG = "ischeckreqorg";
    public static String PARA_ISCHECKRECORG = "ischeckrecorg";
    public static String PARA_ISCHECKSETTLEORG = "ischecksettleorg";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("entryreqorg");
        preparePropertys.add("entrysettleorg");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        HashMap<String, List<Long>> cacheMap = new HashMap<String, List<Long>>(8);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject settleOrg;
                DynamicObject recOrg;
                String cacheKey;
                DynamicObject reqOrg;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKREQORG)) && (reqOrg = entry.getDynamicObject("entryreqorg")) != null) {
                    cacheKey = String.valueOf(org.getPkValue()) + "entryreqorg";
                    List reqOrgIds = new ArrayList(8);
                    if (PurContractOrgValidator.isCache(cacheMap, cacheKey)) {
                        reqOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        reqOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"", (String)"02", (String)"fromorg");
                        cacheMap.put(cacheKey, reqOrgIds);
                    }
                    if (reqOrgIds != null && reqOrgIds.size() > 0 && !reqOrgIds.contains(reqOrg.getPkValue())) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u53ef\u7528\u7684\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"PurContractOrgValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), i + 1, reqOrg.getString("number")), ErrorLevel.Error);
                    }
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKRECORG)) && (recOrg = entry.getDynamicObject("entryinvorg")) != null) {
                    cacheKey = String.valueOf(recOrg.getPkValue()) + "entryinvorg";
                    List recOrgIds = new ArrayList(8);
                    if (PurContractOrgValidator.isCache(cacheMap, cacheKey)) {
                        recOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        recOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"02", (String)"05", (String)"toorg");
                        cacheMap.put(cacheKey, recOrgIds);
                    }
                    if (recOrgIds != null && recOrgIds.size() > 0 && !recOrgIds.contains(recOrg.getPkValue())) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u53ef\u7528\u7684\u6536\u8d27\u7ec4\u7ec7\u3002", (String)"PurContractOrgValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), i + 1, recOrg.getString("number")), ErrorLevel.Error);
                    }
                }
                if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKSETTLEORG)) || (settleOrg = entry.getDynamicObject("entrysettleorg")) == null) continue;
                cacheKey = String.valueOf(settleOrg.getPkValue()) + "entrysettleorg";
                List settleOrgIds = new ArrayList(8);
                if (PurContractOrgValidator.isCache(cacheMap, cacheKey)) {
                    settleOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                } else {
                    settleOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"02", (String)"10", (String)"toorg");
                    cacheMap.put(cacheKey, settleOrgIds);
                }
                if (settleOrgIds == null || settleOrgIds.size() <= 0 || settleOrgIds.contains(settleOrg.getPkValue())) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u53ef\u7528\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"PurContractOrgValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), i + 1, settleOrg.getString("number")), ErrorLevel.Error);
            }
        }
    }

    private static boolean isCache(Map<String, List<Long>> map, String key) {
        return map.containsKey(key);
    }
}

