/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PurContractSouceControlValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject supplier = bill.getDynamicObject("supplier");
            Date biztimebegin = bill.getDate("biztimebegin");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (org == null || supplier == null || biztimebegin == null || entrys == null || entrys.isEmpty()) continue;
            Long orgId = (Long)org.getPkValue();
            Long supplierId = (Long)supplier.getPkValue();
            ArrayList<Long> materialIds = new ArrayList<Long>(entrys.size());
            ArrayList<Long> materialGroupIds = new ArrayList<Long>(entrys.size());
            for (DynamicObject entry : entrys) {
                DynamicObject master;
                DynamicObject material = entry.getDynamicObject("material");
                String entryChangeType = entry.getString("billentrychangetype");
                if ("C".equals(entryChangeType) || material == null || !material.getBoolean("isapprovedsupplier") || (master = material.getDynamicObject("masterid")) == null) continue;
                materialIds.add((Long)master.getPkValue());
                DynamicObject group = master.getDynamicObject("group");
                if (group == null) continue;
                materialGroupIds.add((Long)group.getPkValue());
            }
            if (materialIds.isEmpty()) continue;
            QFilter q1 = new QFilter("status", "=", (Object)"C");
            QFilter q2 = new QFilter("enable", "=", (Object)"1");
            QFilter q3 = new QFilter("org", "=", (Object)orgId);
            QFilter q4 = new QFilter("supplier", "=", (Object)supplierId);
            QFilter q5 = new QFilter("entryentity.effectdate", "<=", (Object)biztimebegin);
            QFilter q6 = new QFilter("entryentity.expirydate", ">=", (Object)biztimebegin);
            QFilter q7 = null;
            QFilter q71 = new QFilter("entryentity.type", "=", (Object)"A");
            QFilter q72 = new QFilter("entryentity.material.masterid", "in", materialIds);
            QFilter q8 = new QFilter("entryentity.frozenstatus", "=", (Object)"A");
            if (materialGroupIds.isEmpty()) {
                q7 = q71.and(q72);
            } else {
                QFilter q73 = new QFilter("entryentity.type", "=", (Object)"B");
                QFilter q74 = new QFilter("entryentity.materialsort", "in", materialGroupIds);
                q7 = q71.and(q72).or(q73.and(q74));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"pm_sourcelist", (String)"id,org,supplier,status,enable,entryentity.type type,entryentity.material.masterid material,entryentity.materialsort materialsort,entryentity.effectdate,entryentity.expirydate", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7, q8});
            ArrayList<Long> materials = null;
            ArrayList<Long> materialsorts = null;
            if (query != null && !query.isEmpty()) {
                int size = query.size();
                materials = new ArrayList<Long>(size);
                materialsorts = new ArrayList<Long>(size);
                for (DynamicObject dyn : query) {
                    Long id;
                    String type = dyn.getString("type");
                    if ("A".equals(type)) {
                        id = dyn.getLong("material");
                        if (id == null) continue;
                        materials.add(id);
                        continue;
                    }
                    if (!"B".equals(type) || (id = Long.valueOf(dyn.getLong("materialsort"))) == null) continue;
                    materialsorts.add(id);
                }
            }
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject entry = (DynamicObject)entrys.get(j);
                DynamicObject material = entry.getDynamicObject("material");
                String entryChangeType = entry.getString("billentrychangetype");
                if ("C".equals(entryChangeType) || material == null || !material.getBoolean("isapprovedsupplier")) continue;
                DynamicObject master = material.getDynamicObject("masterid");
                if (master != null) {
                    Object masterPkValue = master.getPkValue();
                    if (materials != null && materials.contains(masterPkValue)) continue;
                    DynamicObject group = master.getDynamicObject("group");
                    if (group != null) {
                        Object pkValue2 = group.getPkValue();
                        if (materialsorts != null && materialsorts.contains(pkValue2)) continue;
                    }
                }
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u7269\u6599\u660e\u7ec6\u201d\u4e0d\u6ee1\u8db3\u201c\u8d27\u6e90\u63a7\u5236\u201d\u3002", (String)"PurContractSouceControlValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), j + 1), ErrorLevel.Error);
            }
        }
    }
}

