/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.OperatorHelper;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MetadataUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.enums.BizConfirmStatusEnum;
import kd.scmc.conm.enums.StatusEnum;

public class PurContractValidator
extends AbstractValidator {
    public static String PARA_ISCHECKBILLHEAD = "ischeckbillhead";
    public static String PARA_ISCHECKMATERIAL = "ischeckmaterial";
    public static String PARA_ISCHECKSTATUS = "ischeckstatus";
    public static String PARA_ISCHECKUSERANDDEPT = "ischeckuseranddept";
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("supplier");
        preparePropertys.add("type");
        preparePropertys.add("partc");
        preparePropertys.add("invoicebiztype");
        preparePropertys.add("billstatus");
        preparePropertys.add("validstatus");
        preparePropertys.add("confirmstatus");
        preparePropertys.add("operator");
        preparePropertys.add("dept");
        preparePropertys.add("operatorgroup");
        preparePropertys.add("material");
        preparePropertys.add("ecostcenter");
        preparePropertys.add("entrysettleorg");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        Set<Object> invoiceBizTypeIdSet = this.getInvoiceBizTypeIdSet();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billentry;
            DynamicObject entrysettleorg;
            DynamicObjectCollection billentrys;
            DynamicObject operator;
            DynamicObject type;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null || (type = bill.getDynamicObject("type")) == null) continue;
            String billStatus = bill.getString("billstatus");
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKBILLHEAD))) {
                DynamicObject invoiceBizType;
                DynamicObject supplier = bill.getDynamicObject("supplier");
                Boolean operMatControl = (Boolean)AppParameterHelper.getAppParameterByFormId((String)"scc_purchase", (Long)((Long)org.getPkValue()), (String)"sccsrm");
                if (bill.getBoolean("iscollaconsult") && supplier != null && (!supplier.getBoolean("issuppcolla") || Boolean.FALSE.equals(operMatControl))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u5c5e\u6027\u201c\u542f\u7528\u91c7\u8d2d\u534f\u540c\u201d\u672a\u5f00\u542f\uff0c\u6216\u201c\u542f\u7528\u5408\u540c\u534f\u540c\u201d\u53c2\u6570\u672a\u5f00\u542f\uff0c\u4e0d\u6ee1\u8db3\u78cb\u5546\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"PurContractValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if ((invoiceBizType = bill.getDynamicObject("invoicebiztype")) != null) {
                    Long invoiceBizTypeId = (Long)invoiceBizType.getPkValue();
                    if (invoiceBizTypeIdSet != null && !invoiceBizTypeIdSet.contains(invoiceBizTypeId)) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u4f9b\u5e94\u94fe\u4e91\u53ef\u7528\u7684\u53d1\u7968\u7c7b\u522b\u3002", (String)"PurContractValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), invoiceBizType.get("number")), ErrorLevel.Error);
                    }
                }
            }
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKSTATUS))) {
                String validstatus = bill.getString("validstatus");
                String confirmstatus = bill.getString("confirmstatus");
                if (("B".equals(validstatus) || "C".equals(validstatus)) && !CommonUtils.isNull((Object)confirmstatus) && (confirmstatus.equals(BizConfirmStatusEnum.UNCONFIRM.getValue()) || confirmstatus.equals(BizConfirmStatusEnum.CONSULT.getValue()) || confirmstatus.equals(BizConfirmStatusEnum.REJECT.getValue()))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u751f\u6548\u72b6\u6001\u4e3a\u5df2\u751f\u6548\u6216\u5df2\u5931\u6548\u65f6\uff0c\u786e\u8ba4\u72b6\u6001\u4e0d\u80fd\u4e3a\u5f85\u786e\u8ba4\u3001\u78cb\u5546\u4e2d\u3001\u5df2\u62d2\u7edd\u3002", (String)"PurContractValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if (bill.get("iscollaconsult") != null && bill.getBoolean("iscollaconsult") && !StatusEnum.SAVE.getValue().equals(billStatus)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u201c\u534f\u540c\u78cb\u5546\u201d\u540e\uff0c\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u6682\u5b58\u201d\u3002", (String)"PurContractValidator_5", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKUSERANDDEPT)) && (operator = bill.getDynamicObject("operator")) != null) {
                DynamicObject operatorUser = operator.getDynamicObject("operatorid");
                Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)"conm_purcontract", (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
                if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                    DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
                    if (operatorGroup != null) {
                        if (!MetadataUtils.checkProperty((DynamicObject)operatorGroup, (String)"entryentity")) {
                            operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)operatorGroup.getPkValue(), (String)"bd_operatorgroup");
                        }
                        DynamicObjectCollection operatorEntrys = operatorGroup.getDynamicObjectCollection("entryentity");
                        ArrayList<Object> operators = new ArrayList<Object>(operatorEntrys.size());
                        for (DynamicObject entry : operatorEntrys) {
                            DynamicObject entryOperator = entry.getDynamicObject("operator");
                            if (entry.getBoolean("invalid") || entryOperator == null) continue;
                            operators.add(entryOperator.getPkValue());
                        }
                        if (operatorUser != null && !operators.contains(operatorUser.getPkValue())) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5728\u7684\u91c7\u8d2d\u7ec4\u5185\u6709\u6548\u7684\u91c7\u8d2d\u5458\u3002", (String)"PurContractValidator_7", (String)"scmc-conm-opplugin", (Object[])new Object[0]), operator.getString("operatornumber")), ErrorLevel.Error);
                        }
                    }
                } else {
                    List operatorByOrgAndUser;
                    Long operatorgrpId = operator.getLong("operatorgrpid");
                    if (operatorgrpId != null && operatorUser != null && CommonUtils.isNull((Object)(operatorByOrgAndUser = OperatorHelper.getOperatorByOrgAndUser((Long)((Long)org.getPkValue()), (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue(), (Long)((Long)operatorUser.getPkValue()))))) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u8303\u56f4\u5185\u6709\u6548\u7684\u91c7\u8d2d\u5458\u3002", (String)"PurContractValidator_8", (String)"scmc-conm-opplugin", (Object[])new Object[0]), operator.getString("operatornumber")), ErrorLevel.Error);
                    }
                }
            }
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKMATERIAL))) {
                DynamicObjectCollection billentrys2 = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : billentrys2) {
                    DynamicObject material;
                    DynamicObject materialpurchase = entry.getDynamicObject("material");
                    if (materialpurchase == null || (material = materialpurchase.getDynamicObject("masterid")) == null) continue;
                    String materialNumber = material.getString("number");
                    if (!(MetadataUtils.checkProperty((DynamicObject)material, (String)"enablevmi") && MetadataUtils.checkProperty((DynamicObject)material, (String)"enableasset") && MetadataUtils.checkProperty((DynamicObject)material, (String)"farmproducts") && MetadataUtils.checkProperty((DynamicObject)material, (String)"serviceattribute"))) {
                        QFilter[] materialqFilters = new QFilter[]{new QFilter("number", "=", (Object)materialNumber)};
                        material = this.getCacheDynamicObject("material", "bd_material", "id,enablevmi,status,enable,serviceattribute,enableasset,farmproducts", materialqFilters, material);
                    }
                    if (type == null || material == null) continue;
                    DynamicObject bizType = type.getDynamicObject("biztype");
                    if (bizType != null) {
                        if (!MetadataUtils.checkProperty((DynamicObject)bizType, (String)"domain")) {
                            QFilter[] bizqFilters = new QFilter[]{new QFilter("masterid", "=", bizType.getPkValue())};
                            bizType = this.getCacheDynamicObject("biztype", "bd_biztype", "id,status,enable,domain", bizqFilters, bizType);
                        }
                        if (bizType != null) {
                            DynamicObjectCollection materialServiceattribute;
                            if ("6".equals(bizType.getString("domain")) && !material.getBoolean("enablevmi")) {
                                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u4e0d\u662f\u53efVMI\u7269\u6599\u3002", (String)"PurContractValidator_10", (String)"scmc-conm-opplugin", (Object[])new Object[0]), materialNumber), ErrorLevel.Error);
                            }
                            if ((materialServiceattribute = material.getDynamicObjectCollection("serviceattribute")) != null) {
                                Boolean enableasset;
                                List ids = materialServiceattribute.stream().map(dym -> dym.get("fbasedataid_id")).collect(Collectors.toList());
                                if (bizType.getString("number").equals("111") && !(enableasset = Boolean.valueOf(material.getBoolean("enableasset"))).booleanValue() && !ids.contains(1194030110357899264L)) {
                                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%1$s\u201d\u4e0d\u662f\u8d44\u4ea7\u7c7b\u578b\u6216\u53ef\u8d44\u4ea7\u7269\u6599\u3002", (String)"PurContractValidator_11", (String)"scmc-conm-opplugin", (Object[])new Object[0]), materialNumber), ErrorLevel.Error);
                                }
                                if (bizType.getString("number").equals("113") && !ids.contains(1194029878949760000L)) {
                                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%1$s\u201d\u4e0d\u662f\u8d39\u7528\u7c7b\u578b\u7269\u6599\u3002", (String)"PurContractValidator_12", (String)"scmc-conm-opplugin", (Object[])new Object[0]), materialNumber), ErrorLevel.Error);
                                }
                            }
                        }
                    }
                    if (!"NCPCG".equals(type.getString("number")) || material.getBoolean("farmproducts")) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%1$s\u201d\u4e0d\u662f\u519c\u4ea7\u54c1\u7269\u6599\u3002", (String)"PurContractValidator_14", (String)"scmc-conm-opplugin", (Object[])new Object[0]), materialNumber), ErrorLevel.Error);
                }
            }
            if (StringUtils.isEmpty((String)billStatus) || StatusEnum.SAVE.getValue().equals(billStatus) || !type.getBoolean("costexpense")) continue;
            DynamicObjectCollection payentrys = bill.getDynamicObjectCollection("payentry");
            if (payentrys != null && payentrys.size() == 0) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e2d\u5f00\u542f\u8d39\u7528\u62a5\u9500\uff0c\u8bf7\u7ef4\u62a4\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"PurContractValidator_16", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]), ErrorLevel.Error);
            }
            if ((billentrys = bill.getDynamicObjectCollection("billentry")) == null || billentrys.isEmpty() || (entrysettleorg = (billentry = (DynamicObject)billentrys.get(0)).getDynamicObject("entrysettleorg")) != null) continue;
            String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7269\u6599\u660e\u7ec6\u7b2c1\u884c\u5f55\u5165\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"PurContractValidator_17", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
            this.addMessage(dataEntity, tip, ErrorLevel.Error);
        }
    }

    private Set<Object> getInvoiceBizTypeIdSet() {
        if (this.getValidateContext() == null || this.getValidateContext().getBillEntityType() == null) {
            return null;
        }
        HashSet<Long> invoiceBizTypeSet = new HashSet<Long>(10);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject invoiceBizType = bill.getDynamicObject("invoicebiztype");
            if (invoiceBizType == null) continue;
            invoiceBizTypeSet.add((Long)invoiceBizType.getPkValue());
        }
        String appId = this.getValidateContext().getBillEntityType().getAppId();
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        Set<Object> invoiceBizTypeIdSet = null;
        if (appInfo != null) {
            String bizCloudId = appInfo.getCloudId();
            QFilter qFilterNmuber = new QFilter("mulbiz.fbasedataid.id", "=", (Object)bizCloudId);
            QFilter qFilterPkValue = new QFilter("id", "in", invoiceBizTypeSet);
            Map invoiceBizTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"id", (QFilter[])new QFilter[]{qFilterNmuber.and(qFilterPkValue)});
            invoiceBizTypeIdSet = invoiceBizTypes == null ? new HashSet() : invoiceBizTypes.keySet();
        }
        return invoiceBizTypeIdSet;
    }

    private DynamicObject getCacheDynamicObject(String propName, String entityName, String selectProperties, QFilter[] qFilters, DynamicObject dyn) {
        if (dyn == null) {
            DynamicObject value = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters);
            if (value != null) {
                this.tempCache.put(propName + "_" + value.getPkValue(), value);
            }
            return value;
        }
        DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + dyn.getPkValue());
        if (value == null && (value = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters)) != null) {
            this.tempCache.put(propName + "_" + value.getPkValue(), value);
        }
        return value;
    }
}

