/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class SalContractOrgValidator
extends AbstractValidator {
    public static String PARA_ISCHECKENTRYINVORG = "ischeckentryinvorg";
    public static String PARA_ISCHECKSETTLEORG = "ischecksettleorg";
    public static String PARA_ISCHECKSETTLEORGPAY = "ischecksettleorgpay";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("billentry");
        preparePropertys.add("entrysettleorg");
        preparePropertys.add("entryinvorg");
        preparePropertys.add("payentry");
        preparePropertys.add("recentrysettleorg");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        HashMap<String, List<Long>> cacheMap = new HashMap<String, List<Long>>(8);
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObjectCollection payEntrys;
            DynamicObject bill = extend.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                return;
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys != null && entrys.size() > 0) {
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject settleOrg;
                    String cacheKey;
                    DynamicObject entryinvorg;
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKENTRYINVORG)) && (entryinvorg = entry.getDynamicObject("entryinvorg")) != null) {
                        cacheKey = String.valueOf(entryinvorg.getPkValue()) + "entryinvorg";
                        List entryinOrgIds = new ArrayList(8);
                        if (SalContractOrgValidator.isCache(cacheMap, cacheKey)) {
                            entryinOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                        } else {
                            entryinOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"03", (String)"05", (String)"toorg");
                            cacheMap.put(cacheKey, entryinOrgIds);
                        }
                        if (entryinOrgIds != null && entryinOrgIds.size() > 0 && !entryinOrgIds.contains(entryinvorg.getPkValue())) {
                            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u53d1\u8d27\u7ec4\u7ec7\u3002", (String)"SalContractOrgValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), i + 1, entryinvorg.getString("number")), ErrorLevel.Error);
                        }
                    }
                    if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKSETTLEORG)) || (settleOrg = entry.getDynamicObject("entrysettleorg")) == null) continue;
                    cacheKey = String.valueOf(settleOrg.getPkValue()) + "entrysettleorg";
                    List settleOrgIds = new ArrayList(8);
                    if (SalContractOrgValidator.isCache(cacheMap, cacheKey)) {
                        settleOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        settleOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"03", (String)"10", (String)"toorg");
                        cacheMap.put(cacheKey, settleOrgIds);
                    }
                    if (settleOrgIds == null || settleOrgIds.size() <= 0 || settleOrgIds.contains(settleOrg.getPkValue())) continue;
                    this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"SalContractOrgValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), i + 1, settleOrg.getString("number")), ErrorLevel.Error);
                }
            }
            if ((payEntrys = bill.getDynamicObjectCollection("payentry")) == null || payEntrys.size() <= 0) continue;
            for (int i = 0; i < payEntrys.size(); ++i) {
                DynamicObject recentrysettleorg;
                DynamicObject payEntry = (DynamicObject)payEntrys.get(i);
                if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKSETTLEORGPAY)) || (recentrysettleorg = payEntry.getDynamicObject("recentrysettleorg")) == null) continue;
                String cacheKey = String.valueOf(recentrysettleorg.getPkValue()) + "recentrysettleorg";
                List settleOrgIds = new ArrayList(8);
                if (SalContractOrgValidator.isCache(cacheMap, cacheKey)) {
                    settleOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                } else {
                    settleOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"03", (String)"10", (String)"toorg");
                    cacheMap.put(cacheKey, settleOrgIds);
                }
                if (settleOrgIds == null || settleOrgIds.size() <= 0 || settleOrgIds.contains(recentrysettleorg.getPkValue())) continue;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\uff0c\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u53ef\u7528\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"SalContractOrgValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), i + 1, recentrysettleorg.getString("number")), ErrorLevel.Error);
            }
        }
    }

    private static boolean isCache(Map<String, List<Long>> map, String key) {
        return map.containsKey(key);
    }
}

