/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MetadataUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.business.helper.OperatorGroupHelper;

public class SalContractValidator
extends AbstractValidator {
    public static String PARA_ISCHECKMATERIAL = "ischeckmaterial";
    public static String PARA_ISCHECKOPERATOR = "ischeckoperator";
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("type");
        preparePropertys.add("operator");
        preparePropertys.add("operatorgroup");
        preparePropertys.add("material");
        preparePropertys.add("productline");
        preparePropertys.add("configuredcode");
        preparePropertys.add("deliverydate");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject operator;
            DynamicObject type;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null || (type = bill.getDynamicObject("type")) == null) continue;
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKOPERATOR)) && (operator = bill.getDynamicObject("operator")) != null) {
                ArrayList operatorByOrgAndUser;
                DynamicObject operatorUser = operator.getDynamicObject("operatorid");
                Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)"conm_salcontract", (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
                if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                    DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
                    if (operatorGroup != null) {
                        DynamicObjectCollection operatorEntrys = operatorGroup.getDynamicObjectCollection("entryentity");
                        ArrayList<Object> operators = new ArrayList<Object>(operatorEntrys.size());
                        for (DynamicObject entry : operatorEntrys) {
                            DynamicObject entryOperator = entry.getDynamicObject("operator");
                            if (entry.getBoolean("invalid") || entryOperator == null) continue;
                            operators.add(entryOperator.getPkValue());
                        }
                        if (operatorUser != null && !operators.contains(operatorUser.getPkValue())) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5728\u7684\u9500\u552e\u7ec4\u5185\u6709\u6548\u7684\u9500\u552e\u5458\u3002", (String)"SalContractValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), operator.getString("operatornumber")), ErrorLevel.Error);
                        }
                    }
                } else if (operatorUser != null && CommonUtils.isNull((Object)(operatorByOrgAndUser = OperatorGroupHelper.getOperatorGroupByUser((long)((Long)org.getPkValue()), (long)((Long)operatorUser.getPkValue()), (String)OperatorGrpTypeEnum.SALEGRP.getValue())))) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u8303\u56f4\u5185\u6709\u6548\u7684\u9500\u552e\u5458\u3002", (String)"SalContractValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), operator.getString("operatornumber")), ErrorLevel.Error);
                }
            }
            if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKMATERIAL))) continue;
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentrys) {
                DynamicObject configuredcode;
                String configproperties;
                DynamicObjectCollection materialServiceattribute;
                DynamicObject bizType;
                DynamicObject material;
                DynamicObject materialsalchase = entry.getDynamicObject("material");
                if (materialsalchase == null || (material = materialsalchase.getDynamicObject("masterid")) == null) continue;
                String materialNumber = material.getString("number");
                if (!MetadataUtils.checkProperty((DynamicObject)material, (String)"serviceattribute")) {
                    QFilter[] materialqFilters = new QFilter[]{new QFilter("number", "=", (Object)materialNumber)};
                    material = this.getCacheDynamicObject("material", "bd_material", "id,serviceattribute", materialqFilters, material);
                }
                if (type != null && material != null && (bizType = type.getDynamicObject("biztype")) != null && (materialServiceattribute = material.getDynamicObjectCollection("serviceattribute")) != null) {
                    List ids = materialServiceattribute.stream().map(dym -> dym.get("fbasedataid_id")).collect(Collectors.toList());
                    if (bizType.getString("number").equals("212") && !ids.contains(691917066026067968L)) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u670d\u52a1\u201d\u65f6\uff0c\u7269\u6599\u7684\u4e1a\u52a1\u5c5e\u6027\u5fc5\u987b\u4e5f\u662f\u670d\u52a1\u3002", (String)"SalContractValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), materialNumber), ErrorLevel.Error);
                    }
                }
                if (material == null || !"B".equals(bill.getString("billstatus")) && !"C".equals(bill.getString("billstatus")) || StringUtils.isEmpty((CharSequence)(configproperties = material.getString("configproperties"))) || !"2".equals(configproperties) || (configuredcode = entry.getDynamicObject("configuredcode")) != null) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u914d\u7f6e\u5c5e\u6027\u4e3a\u914d\u7f6e\u4ef6\uff0c\u8bf7\u5f55\u5165\u914d\u7f6e\u53f7\u3002", (String)"SalContractValidator_7", (String)"scmc-conm-opplugin", (Object[])new Object[0]), material.getString("number")), ErrorLevel.Error);
            }
        }
    }

    private DynamicObject getCacheDynamicObject(String propName, String entityName, String selectProperties, QFilter[] qFilters, DynamicObject dyn) {
        if (dyn == null) {
            DynamicObject value = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters);
            if (value != null) {
                this.tempCache.put(propName + "_" + value.getPkValue(), value);
            }
            return value;
        }
        DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + dyn.getPkValue());
        if (value == null && (value = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters)) != null) {
            this.tempCache.put(propName + "_" + value.getPkValue(), value);
        }
        return value;
    }
}

