/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;

public class SmContractPreInvoicingValidator
extends AbstractValidator {
    public static Log logger = LogFactory.getLog(SmContractPreInvoicingValidator.class);

    public void validate() {
        if (this.dataEntities != null) {
            if (this.dataEntities.length > 1) {
                String singlePreTip = String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u5f20\u5355\u636e\u9884\u5f00\u7968\u64cd\u4f5c\u3002", (String)"SmContractPreInvoicingValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
                this.addMessage(this.dataEntities[0], singlePreTip, ErrorLevel.Error);
                return;
            }
            for (ExtendedDataEntity extend : this.dataEntities) {
                this.checkAndGetPreOriginalParam(extend);
            }
        }
    }

    private void checkAndGetPreOriginalParam(ExtendedDataEntity extend) {
        block13: {
            DynamicObject bill = extend.getDataEntity();
            DynamicObjectCollection matEntrys = bill.getDynamicObjectCollection("billentry");
            String noParamTip = String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u7269\u6599\u660e\u7ec6\u884c\u7684\u7ed3\u7b97\u7ec4\u7ec7\u65e0\u6cd5\u83b7\u53d6\u9884\u5f00\u7968\u65b9\u5f0f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u8d22\u52a1\u4eba\u5458\u786e\u8ba4\u7ed3\u7b97\u7ec4\u7ec7\u7684\u9884\u5f00\u7968\u65b9\u5f0f\u540e\u518d\u8bd5\u3002", (String)"SmContractPreInvoicingValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
            if (matEntrys == null) {
                this.addMessage(extend, noParamTip, ErrorLevel.Error);
                return;
            }
            if (matEntrys.size() > 2000) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u9884\u5f00\u7968\u65f6\uff0c\u7269\u6599\u660e\u7ec6\u884c\u4e0d\u5141\u8bb8\u8d85\u8fc72000\u884c\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"SmContractPreInvoicingValidator_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            ArrayList<Long> orgIdList = new ArrayList<Long>(16);
            for (DynamicObject row : matEntrys) {
                DynamicObject settleOrg;
                if (row == null || row.getDynamicObject("entrysettleorg") == null || (settleOrg = row.getDynamicObject("entrysettleorg")) == null || orgIdList.contains(settleOrg.getLong("id"))) continue;
                orgIdList.add(settleOrg.getLong("id"));
            }
            if (orgIdList.size() > 0) {
                try {
                    Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"PreOriginalParamService", (String)"getPreOriginalParam", (Object[])new Object[]{orgIdList});
                    if (paramMap == null || paramMap.size() <= 0) {
                        this.addMessage(extend, noParamTip, ErrorLevel.Error);
                        break block13;
                    }
                    if (paramMap.containsValue("noprestyle")) {
                        String containsNotPreInvoiceTip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u884c\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u65e0\u9884\u5f00\u7968\u65b9\u5f0f\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u4eba\u5458\u3002", (String)"SmContractPreInvoicingValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
                        this.addMessage(extend, containsNotPreInvoiceTip, ErrorLevel.Error);
                        break block13;
                    }
                    if (paramMap.containsValue("onlytax") && paramMap.containsValue("allamount")) {
                        String paramNotSameTip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u884c\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u7684\u9884\u5f00\u7968\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u4eba\u5458\u786e\u8ba4\u3002", (String)"SmContractPreInvoicingValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
                        this.addMessage(extend, paramNotSameTip, ErrorLevel.Error);
                        break block13;
                    }
                    if (paramMap.containsValue("onlytax") && !paramMap.containsValue("allamount")) {
                        this.getOption().setVariableValue("PreOriginalParam", "onlytax");
                        break block13;
                    }
                    if (!paramMap.containsValue("onlytax") && paramMap.containsValue("allamount")) {
                        this.getOption().setVariableValue("PreOriginalParam", "allamount");
                        break block13;
                    }
                    this.addMessage(extend, noParamTip, ErrorLevel.Error);
                }
                catch (KDException ke) {
                    String kdExcMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)ke));
                    logger.info("\u8c03\u7528 \u5e94\u6536 PreOriginalParamService\u63a5\u53e3\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a" + kdExcMsg);
                    this.addMessage(extend, kdExcMsg, ErrorLevel.Error);
                }
                catch (Exception e) {
                    String excMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    logger.error("\u8c03\u7528 \u5e94\u6536 PreOriginalParamService\u63a5\u53e3\u83b7\u53d6\u53c2\u6570\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a", (Object)excMsg);
                    this.addMessage(extend, excMsg, ErrorLevel.Error);
                }
            } else {
                this.addMessage(extend, noParamTip, ErrorLevel.Error);
            }
        }
    }
}

