/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MetadataUtils;

public class SupplierValidator
extends AbstractValidator {
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("supplier");
        preparePropertys.add("providersupplier");
        preparePropertys.add("invoicesupplier");
        preparePropertys.add("receivesupplier");
        preparePropertys.add("linkman");
        preparePropertys.add("providerlinkman");
        preparePropertys.add("type");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Set<Long> ids;
            DynamicObject provideLinkMan;
            QFilter[] bizqFilters;
            DynamicObject bizType;
            DynamicObject type;
            DynamicObject org;
            DynamicObject bill = dataEntity.getDataEntity();
            if (bill == null || (org = bill.getDynamicObject("org")) == null) continue;
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (supplier == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SupplierValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            DynamicObject providersupplier = bill.getDynamicObject("providersupplier");
            DynamicObject invoicesupplier = bill.getDynamicObject("invoicesupplier");
            DynamicObject receivesupplier = bill.getDynamicObject("receivesupplier");
            if (supplier != null) {
                this.validSupplier(dataEntity, "supplier", org, supplier, "PURCHASE");
                this.validBizFunction(dataEntity, supplier, "PURCHASE");
            }
            if (providersupplier != null) {
                this.validSupplier(dataEntity, "providersupplier", org, providersupplier, "DELIVER");
                this.validBizFunction(dataEntity, providersupplier, "DELIVER");
            }
            if (invoicesupplier != null) {
                this.validSupplier(dataEntity, "invoicesupplier", org, invoicesupplier, "INVOICE");
                this.validBizFunction(dataEntity, invoicesupplier, "INVOICE");
            }
            if (receivesupplier != null) {
                this.validSupplier(dataEntity, "receivesupplier", org, receivesupplier, "RECEIVE");
                this.validBizFunction(dataEntity, receivesupplier, "RECEIVE");
            }
            if (!MetadataUtils.checkProperty((DynamicObject)supplier, (String)"enablevmi")) {
                supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,enablevmi");
            }
            if ((type = bill.getDynamicObject("type")) != null && (bizType = type.getDynamicObject("biztype")) != null && (bizType = this.getCacheDynamicObject("biztype", "bd_biztype", "id,status,enable,domain", bizqFilters = new QFilter[]{new QFilter("masterid", "=", bizType.getPkValue())}, bizType)) != null && "6".equals(bizType.getString("domain")) && !supplier.getBoolean("enablevmi")) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1$s\u201d\u4e0d\u662f\u53efVMI\u4f9b\u5e94\u5546\u3002", (String)"SupplierValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), supplier.getString("number")), ErrorLevel.Error);
            }
            if ((provideLinkMan = bill.getDynamicObject("providerlinkman")) == null || providersupplier == null || (ids = SupplierValidator.getAllLinkMans(providersupplier)).contains(provideLinkMan.getPkValue())) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u8054\u7cfb\u4eba\u201c%1$s\u201d\u4e0d\u662f\u5f53\u524d\u4f9b\u8d27\u4f9b\u5e94\u5546\u201c%2$s\u201d\u7684\u6709\u6548\u8054\u7cfb\u4eba\u3002", (String)"SupplierValidator_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]), provideLinkMan.getString("contactperson"), providersupplier.getString("number")), ErrorLevel.Error);
        }
    }

    private void validSupplier(ExtendedDataEntity data, String proName, DynamicObject org, DynamicObject otherSupplier, String function) {
        QFilter[] qFilters;
        DynamicObject dbSupplier;
        if (org == null || otherSupplier == null) {
            return;
        }
        String supplierPrefix = "";
        switch (function) {
            case "PURCHASE": {
                supplierPrefix = ResManager.loadKDString((String)"\u8ba2\u8d27", (String)"SupplierValidator_10", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                break;
            }
            case "INVOICE": {
                supplierPrefix = ResManager.loadKDString((String)"\u7ed3\u7b97", (String)"SupplierValidator_5", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                break;
            }
            case "RECEIVE": {
                supplierPrefix = ResManager.loadKDString((String)"\u6536\u6b3e", (String)"SupplierValidator_6", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                break;
            }
            case "DELIVER": {
                supplierPrefix = ResManager.loadKDString((String)"\u4f9b\u8d27", (String)"SupplierValidator_7", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                break;
            }
        }
        QFilter supplierOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_supplierOrgFilter");
        if (supplierOrgFilter == null) {
            supplierOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_supplierOrgFilter", supplierOrgFilter);
        }
        if ((dbSupplier = this.getCacheDynamicObject(proName, "bd_supplier", "id,bizfunction,", qFilters = new QFilter[]{new QFilter("id", "=", otherSupplier.getPkValue()), supplierOrgFilter}, otherSupplier)) == null) {
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u91c7\u8d2d\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"SupplierValidator_8", (String)"scmc-conm-opplugin", (Object[])new Object[0]), supplierPrefix, org.getString("number")), ErrorLevel.Error);
        }
    }

    private void validBizFunction(ExtendedDataEntity data, DynamicObject supplier, String function) {
        if (supplier == null) {
            return;
        }
        if (!MetadataUtils.checkProperty((DynamicObject)supplier, (String)"bizfunction") || !MetadataUtils.checkProperty((DynamicObject)supplier, (String)"purchasehold")) {
            supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,bizfunction,purchasehold");
        }
        String supplierPrefix = "";
        Boolean result = Boolean.TRUE;
        switch (function) {
            case "PURCHASE": {
                String purFunction = supplier.getString("bizfunction");
                if (!StringUtils.isEmpty((String)purFunction) && purFunction.contains("1") && !supplier.getBoolean("purchasehold")) break;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%s\u201d\u65e0\u91c7\u8d2d\u804c\u80fd\u6216\u91c7\u8d2d\u5df2\u51bb\u7ed3\u3002", (String)"SupplierValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), supplier.getString("number")), ErrorLevel.Error);
                break;
            }
            case "INVOICE": {
                String invFunction = supplier.getString("bizfunction");
                if (!StringUtils.isEmpty((String)invFunction) && invFunction.contains("2")) break;
                supplierPrefix = ResManager.loadKDString((String)"\u7ed3\u7b97", (String)"SupplierValidator_5", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                result = Boolean.FALSE;
                break;
            }
            case "RECEIVE": {
                String recFunction = supplier.getString("bizfunction");
                if (!StringUtils.isEmpty((String)recFunction) && recFunction.contains("3")) break;
                supplierPrefix = ResManager.loadKDString((String)"\u6536\u6b3e", (String)"SupplierValidator_6", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                result = Boolean.FALSE;
                break;
            }
            case "DELIVER": {
                String delFunction = supplier.getString("bizfunction");
                if (!StringUtils.isEmpty((String)delFunction) && delFunction.contains("4")) break;
                supplierPrefix = ResManager.loadKDString((String)"\u4f9b\u8d27", (String)"SupplierValidator_7", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                result = Boolean.FALSE;
                break;
            }
        }
        if (!result.booleanValue()) {
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%1$s\u201d\u4e0d\u662f\u5177\u6709\u201c%2$s\u201d\u804c\u80fd\u7684\u4f9b\u5e94\u5546\u3002", (String)"SupplierValidator_9", (String)"scmc-conm-opplugin", (Object[])new Object[0]), supplier.getString("number"), supplierPrefix), ErrorLevel.Error);
        }
    }

    private DynamicObject getCacheDynamicObject(String propName, String entityName, String selectProperties, QFilter[] qFilters, DynamicObject dyn) {
        if (dyn == null) {
            DynamicObject value = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters);
            if (value != null) {
                this.tempCache.put(propName + "_" + value.getPkValue(), value);
            }
            return value;
        }
        DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + dyn.getPkValue());
        if (value == null && (value = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters)) != null) {
            this.tempCache.put(propName + "_" + value.getPkValue(), value);
        }
        return value;
    }

    private static Set<Long> getAllLinkMans(DynamicObject supplier) {
        HashSet<Long> ids = new HashSet<Long>(8);
        if (supplier == null) {
            return ids;
        }
        if (!MetadataUtils.checkProperty((DynamicObject)supplier, (String)"entry_linkman")) {
            supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier");
        }
        DynamicObjectCollection linkmans = supplier.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject linkman : linkmans) {
            boolean invalid = linkman.getBoolean("invalid");
            if (invalid) continue;
            ids.add((Long)linkman.getPkValue());
        }
        return ids;
    }
}

