/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.XContractHelper;
import kd.scmc.conm.enums.ChangeTypeEnum;
import kd.scmc.conm.enums.ExcuteControlEnum;

public class XContractSubmitValidator
extends AbstractValidator {
    public void validate() {
        DynamicObjectCollection downContracts;
        String tip;
        String formatDate;
        Map dateMap;
        Date bizTimeEnd;
        Date bizTimeBegin;
        DynamicObject bill;
        DynamicObjectCollection srcContracts;
        HashSet<String> srcBillNoSet = new HashSet<String>();
        HashSet<String> curBillNoSet = new HashSet<String>();
        String srcEntityName = null;
        String curEntityName = null;
        for (ExtendedDataEntity data : this.dataEntities) {
            Boolean rowCancel;
            DynamicObject contType;
            DynamicObject bill2 = data.getDataEntity();
            srcEntityName = bill2.getDataEntityType().getName();
            curEntityName = bill2.getDataEntityType().getName();
            if ("conm_xpurcontract".equals(srcEntityName) || "conm_xsalcontract".equals(srcEntityName)) {
                boolean isRenew = bill2.getBoolean("isrenew");
                String string = bill2.getString("framenum");
                if (isRenew) {
                    srcBillNoSet.add(string);
                }
                curBillNoSet.add(bill2.getString("billno"));
            }
            if ((contType = bill2.getDynamicObject("type")) != null) {
                String string = contType.getString("excutecontrol");
                String conmprop = bill2.getString("conmprop");
                if (conmprop != null && "A".equals(conmprop) && !ExcuteControlEnum.AMOUNT_QTY.getValue().equals(string) && !ExcuteControlEnum.AMOUNT_PRICE.getValue().equals(string) && !ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(string) && !ExcuteControlEnum.QTY.getValue().equals(string) && !ExcuteControlEnum.PRICE.getValue().equals(string)) continue;
            }
            DynamicObjectCollection dynamicObjectCollection = bill2.getDynamicObjectCollection("billentry");
            boolean isAllCancel = true;
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject billEntry = (DynamicObject)dynamicObjectCollection.get(i);
                if (ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("billentrychangetype"))) continue;
                isAllCancel = false;
                break;
            }
            if ((rowCancel = XContractHelper.isRowCancel((String)bill2.getDataEntityType().getName())) != null && rowCancel.booleanValue() && isAllCancel && "conm_xpurcontract".equals(srcEntityName) || !isAllCancel) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u4e0d\u5141\u8bb8\u5168\u90e8\u53d6\u6d88\u3002", (String)"XContractSubmitValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
        String downEntityName = "";
        if ("conm_xpurcontract".equals(curEntityName)) {
            downEntityName = "conm_purcontract";
        }
        if ("conm_xsalcontract".equals(curEntityName)) {
            downEntityName = "conm_salcontract";
        }
        if (StringUtils.isNotEmpty((String)downEntityName) && srcBillNoSet.size() > 0 && (srcContracts = QueryServiceHelper.query((String)downEntityName, (String)"id,billno,biztimebegin,biztimeend", (QFilter[])new QFilter("billno", "in", srcBillNoSet).toArray())) != null && srcContracts.size() > 0) {
            HashMap map = new HashMap();
            for (DynamicObject srcContract : srcContracts) {
                HashMap<String, Object> dateMap2 = new HashMap<String, Object>();
                dateMap2.put("srcbiztimebegin", srcContract.getDate("biztimebegin"));
                dateMap2.put("srcbiztimeend", srcContract.getDate("biztimeend"));
                dateMap2.put("srcbillno", srcContract.getString("billno"));
                map.put(srcContract.getString("billno"), dateMap2);
            }
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                bill = extendedDataEntity.getDataEntity();
                bizTimeBegin = bill.getDate("biztimebegin");
                bizTimeEnd = bill.getDate("biztimeend");
                dateMap = (Map)map.get(bill.getString("framenum"));
                if (dateMap == null) continue;
                Date srcBizTimeBegin = (Date)dateMap.get("srcbiztimebegin");
                Date srcBizTimeEnd = (Date)dateMap.get("srcbiztimeend");
                String srcBillNo = (String)dateMap.get("srcbillno");
                if (bizTimeBegin == null || bizTimeEnd == null || srcBizTimeBegin == null || srcBizTimeEnd == null || bizTimeBegin.compareTo(srcBizTimeEnd) > 0) continue;
                formatDate = this.formatDate(srcBizTimeEnd);
                tip = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u539f\u5408\u540c\u7531\u201c%1$s\u201d\u7eed\u7b7e\u751f\u6210\uff0c\u53d8\u66f4\u540e\u7684\u8d77\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u201c%2$s\u201d\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"XContractRenewValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), srcBillNo, formatDate);
                this.addMessage(extendedDataEntity, tip, ErrorLevel.Error);
            }
        }
        if (StringUtils.isNotEmpty((String)downEntityName) && curBillNoSet.size() > 0 && (downContracts = QueryServiceHelper.query((String)downEntityName, (String)"id,billno,framenum,biztimebegin,biztimeend", (QFilter[])new QFilter("framenum", "in", curBillNoSet).and(new QFilter("isrenew", "=", (Object)Boolean.TRUE)).toArray())) != null && downContracts.size() > 0) {
            HashMap map = new HashMap();
            for (DynamicObject downContract : downContracts) {
                HashMap<String, Object> dateMap3 = new HashMap<String, Object>();
                dateMap3.put("downbiztimebegin", downContract.getDate("biztimebegin"));
                dateMap3.put("downbiztimeend", downContract.getDate("biztimeend"));
                dateMap3.put("downbillno", downContract.getString("billno"));
                map.put(downContract.getString("framenum"), dateMap3);
            }
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                bill = extendedDataEntity.getDataEntity();
                bizTimeBegin = bill.getDate("biztimebegin");
                bizTimeEnd = bill.getDate("biztimeend");
                dateMap = (Map)map.get(bill.getString("billno"));
                if (dateMap == null) continue;
                Date downBizTimeBegin = (Date)dateMap.get("downbiztimebegin");
                Date downBizTimeEnd = (Date)dateMap.get("downbiztimeend");
                String downBillNo = (String)dateMap.get("downbillno");
                if (bizTimeBegin == null || bizTimeEnd == null || downBizTimeBegin == null || downBizTimeEnd == null || downBizTimeBegin.compareTo(bizTimeEnd) > 0) continue;
                formatDate = this.formatDate(downBizTimeBegin);
                tip = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u539f\u5408\u540c\u4e0b\u6e38\u5b58\u5728\u7eed\u7b7e\u5408\u540c\u201c%1$s\u201d\uff0c\u8bf7\u786e\u4fdd\u53d8\u66f4\u540e\u7684\u622a\u6b62\u65e5\u671f\u65e9\u4e8e\u201c%2$s\u201d\u3002", (String)"XContractRenewValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), downBillNo, formatDate);
                this.addMessage(extendedDataEntity, tip, ErrorLevel.Error);
            }
        }
    }

    private String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }
}

