/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.conm.business.helper.XContractHelper;
import kd.scmc.conm.enums.ChangeTypeEnum;
import kd.scmc.conm.enums.ExcuteControlEnum;

public class XPurContractSubmitValidator
extends AbstractValidator {
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            this.checkEntryQty(extend);
            this.checkEntryAmount(extend);
        }
        this.cancelEntrys();
        this.checkEntryAndAmount();
    }

    private Map<Long, Object> getSrcBillEntryMap(DynamicObject xBill) {
        HashMap<Long, Object> srcBillEntryMap = new HashMap<Long, Object>(16);
        if (xBill == null) {
            return srcBillEntryMap;
        }
        HashSet<Long> srcBillEntryIds = new HashSet<Long>(16);
        String sourcebillentity = xBill.getString("sourcebillentity");
        DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < xBillEntry.size(); ++i) {
            int seq = i + 1;
            DynamicObject entry = (DynamicObject)xBillEntry.get(i);
            if (entry == null) continue;
            BigDecimal qty = entry.getBigDecimal("qty");
            String changeType = entry.getString("billentrychangetype");
            if (qty == null || qty.compareTo(ZERO) != 0 || !ChangeTypeEnum.UPDATE.getValue().equals(changeType)) continue;
            srcBillEntryIds.add(entry.getLong("billentrysrcid"));
        }
        if (srcBillEntryIds != null && !srcBillEntryIds.isEmpty()) {
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)sourcebillentity, (String)"id,billentry.id as entryid,billentry.qty as qty", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", srcBillEntryIds)}, null);){
                while (queryDataSet != null && queryDataSet.hasNext()) {
                    Row bill = queryDataSet.next();
                    Long entryid = bill.getLong("entryid");
                    BigDecimal qty = bill.getBigDecimal("qty");
                    srcBillEntryMap.put(entryid, qty);
                }
            }
        }
        return srcBillEntryMap;
    }

    private void checkEntryAndAmount() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            Boolean rowCancel;
            DynamicObject xBill = extend.getDataEntity();
            if (xBill == null || xBill.getDataEntityType() == null || !(rowCancel = XContractHelper.isRowCancel((String)xBill.getDataEntityType().getName())).booleanValue()) continue;
            Map<Long, Object> srcBillEntryMap = this.getSrcBillEntryMap(xBill);
            if (srcBillEntryMap == null || srcBillEntryMap.isEmpty()) {
                return;
            }
            DynamicObject type = xBill.getDynamicObject("type");
            if (type == null) continue;
            String contCtrl = type.getString("excutecontrol");
            Boolean isentrysumamt = xBill.getBoolean("isentrysumamt");
            DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("billentry");
            if (xBillEntry == null) continue;
            BigDecimal qty = ZERO;
            boolean flag = false;
            for (int i = 0; i < xBillEntry.size(); ++i) {
                BigDecimal srcQty;
                Long billentrysrcid;
                int seq = i + 1;
                DynamicObject entry = (DynamicObject)xBillEntry.get(i);
                if (entry == null) continue;
                qty = entry.getBigDecimal("qty");
                String changeType = entry.getString("billentrychangetype");
                if (changeType != null && ChangeTypeEnum.UPDATE.getValue().equals(changeType) && qty != null && qty.compareTo(ZERO) == 0 && (billentrysrcid = Long.valueOf(entry.getLong("billentrysrcid"))) != null && srcBillEntryMap.get(billentrysrcid) != null && (srcQty = (BigDecimal)srcBillEntryMap.get(billentrysrcid)) != null && srcQty.compareTo(ZERO) > 0 && (ExcuteControlEnum.QTY.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl))) {
                    flag = true;
                    String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c:\u6570\u91cf\u3002", (String)"XPurContractSubmitValidator_6", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                    this.addMessage(extend, String.format(msg, seq), ErrorLevel.Error);
                }
                if (isentrysumamt != null && !isentrysumamt.booleanValue()) {
                    flag = true;
                }
                if (changeType == null || !ChangeTypeEnum.ADDNEW.getValue().equals(changeType) || qty == null || qty.compareTo(ZERO) != 0 || !ExcuteControlEnum.QTY.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl)) continue;
                flag = true;
                String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c:\u6570\u91cf\u3002", (String)"XPurContractSubmitValidator_6", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                this.addMessage(extend, String.format(msg, seq), ErrorLevel.Error);
            }
            BigDecimal totalallamount = xBill.getBigDecimal("totalallamount");
            if (!flag || !ExcuteControlEnum.AMOUNT.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_PRICE.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl) || totalallamount.compareTo(ZERO) != 0) continue;
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u3002", (String)"XPurContractSubmitValidator_7", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
            this.addMessage(extend, msg, ErrorLevel.Error);
        }
    }

    private void cancelEntrys() {
        block0: for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject type;
            DynamicObject bill = extend.getDataEntity();
            if (bill == null || (type = bill.getDynamicObject("type")) == null || !type.getBoolean("costexpense")) continue;
            DynamicObjectCollection payentrys = bill.getDynamicObjectCollection("payentry");
            boolean isAllCancel = true;
            if (payentrys != null) {
                for (DynamicObject entry : payentrys) {
                    if (ChangeTypeEnum.CANCEL.getValue().equals(entry.getString("payentrychangetype"))) continue;
                    isAllCancel = false;
                    break;
                }
                if (isAllCancel && payentrys.size() > 0) {
                    String tip = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u4e0d\u5141\u8bb8\u5168\u90e8\u53d6\u6d88\u3002", (String)"XPurContractSubmitValidator_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
                    this.addMessage(extend, tip, ErrorLevel.Error);
                }
            }
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < billentrys.size(); ++i) {
                DynamicObject entrysettleorg;
                DynamicObject billentry = (DynamicObject)billentrys.get(i);
                if (billentry == null) continue;
                String entryChange = billentry.getString("billentrychangetype");
                if (ChangeTypeEnum.CANCEL.getValue().equals(entryChange) || (entrysettleorg = billentry.getDynamicObject("entrysettleorg")) != null) continue;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u5f55\u5165\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"XPurContractSubmitValidator_5", (String)"scmc-conm-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                continue block0;
            }
        }
    }

    private void checkEntryQty(ExtendedDataEntity extend) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("billentry");
        DynamicObject contType = extend.getDataEntity().getDynamicObject("type");
        String contexecute = contType != null ? contType.getString("excutecontrol") : ExcuteControlEnum.NOCONTROL.getValue();
        for (int i = 0; i < entrys.size(); ++i) {
            int row;
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
            BigDecimal associatedBaseQty = billEntry.getBigDecimal("joinorderbaseqty");
            BigDecimal joinPayableBaseQty = billEntry.getBigDecimal("joinpayablebaseqty");
            BigDecimal orderBaseQty = billEntry.getBigDecimal("orderbaseqty");
            if (ChangeTypeEnum.UPDATE.getValue().equals(billEntry.getString("billentrychangetype")) && (ExcuteControlEnum.QTY.getValue().equals(contexecute) || ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contexecute) || ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contexecute))) {
                if (baseQty.compareTo(associatedBaseQty) >= 0 && baseQty.compareTo(joinPayableBaseQty) >= 0 && baseQty.compareTo(orderBaseQty) >= 0) continue;
                row = i + 1;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5408\u540c\u7684\u201c\u5173\u8054\u8ba2\u8d27\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u5e94\u4ed8\u6570\u91cf\u201d\u6216\u201c\u5df2\u8ba2\u8d27\u6570\u91cf\u201d\u3002", (String)"XPurContractSubmitValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                continue;
            }
            if (!ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("billentrychangetype")) || associatedBaseQty.compareTo(BigDecimal.ZERO) <= 0 && joinPayableBaseQty.compareTo(BigDecimal.ZERO) <= 0 && orderBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            row = i + 1;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u7684\u201c\u5173\u8054\u8ba2\u8d27\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u5e94\u4ed8\u6570\u91cf\u201d\u6216\u201c\u5df2\u8ba2\u8d27\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPurContractSubmitValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
        }
    }

    private void checkEntryAmount(ExtendedDataEntity extend) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("payentry");
        DynamicObject contType = extend.getDataEntity().getDynamicObject("type");
        String contexecute = contType != null ? contType.getString("excutecontrol") : ExcuteControlEnum.NOCONTROL.getValue();
        for (int i = 0; i < entrys.size(); ++i) {
            int row;
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            BigDecimal payAmount = billEntry.getBigDecimal("payamount");
            BigDecimal joinPayAmount = billEntry.getBigDecimal("joinpayamount");
            if (ChangeTypeEnum.UPDATE.getValue().equals(billEntry.getString("payentrychangetype")) && (ExcuteControlEnum.QTY.getValue().equals(contexecute) || ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contexecute) || ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contexecute))) {
                if (payAmount.compareTo(joinPayAmount) >= 0) continue;
                row = i + 1;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u884c\u53d8\u66f4\u540e\u7684\u201c\u4ed8\u6b3e\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u201d\u3002", (String)"XPurContractSubmitValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                continue;
            }
            if (!ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("payentrychangetype")) || joinPayAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            row = i + 1;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u884c\u7684\u201c\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPurContractSubmitValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
        }
    }
}

