/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.conm.enums.ChangeTypeEnum;

public class XSalContractSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            this.checkEntryQty(extend);
            this.checkEntryAmount(extend);
        }
    }

    private void checkEntryQty(ExtendedDataEntity extend) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            int row;
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
            BigDecimal associatedBaseQty = billEntry.getBigDecimal("joinorderbaseqty");
            BigDecimal arJoinBaseQty = billEntry.getBigDecimal("arjoinbaseqty");
            BigDecimal orderBaseQty = billEntry.getBigDecimal("orderbaseqty");
            if (ChangeTypeEnum.UPDATE.getValue().equals(billEntry.getString("billentrychangetype"))) {
                if (baseQty.compareTo(associatedBaseQty) >= 0 && baseQty.compareTo(arJoinBaseQty) >= 0) continue;
                row = i + 1;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5408\u540c\u7684\u201c\u5173\u8054\u8ba2\u8d27\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u5e94\u6536\u6570\u91cf\u201d\u3002", (String)"XSalContractSubmitValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
                continue;
            }
            if (!ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("billentrychangetype")) || associatedBaseQty.compareTo(BigDecimal.ZERO) <= 0 && arJoinBaseQty.compareTo(BigDecimal.ZERO) <= 0 && orderBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            row = i + 1;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u7684\u201c\u5173\u8054\u8ba2\u8d27\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u5e94\u6536\u6570\u91cf\u201d\u6216\u201c\u5df2\u8ba2\u8d27\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XSalContractSubmitValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
        }
    }

    private void checkEntryAmount(ExtendedDataEntity extend) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("payentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            BigDecimal payAmount = billEntry.getBigDecimal("payamount");
            BigDecimal joinPayAmount = billEntry.getBigDecimal("joinpayamount");
            if (!ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("payentrychangetype")) || joinPayAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            int row = i + 1;
            this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%s\u884c\u7684\u201c\u5173\u8054\u6536\u6b3e\u91d1\u989d\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XSalContractSubmitValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
        }
    }
}

