/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.tpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.conm.enums.BizReviewStatusEnum;
import kd.scmc.conm.enums.BizSignStatusEnum;
import kd.scmc.conm.enums.ExcuteControlEnum;
import kd.scmc.conm.enums.FilingStatusEnum;
import kd.scmc.conm.enums.StatusEnum;

public class BillContractValidator
extends AbstractValidator {
    private Map<String, Object> tempCache = new HashMap<String, Object>();
    public static String PARA_ISCHECKBILLHEAD = "ischeckbillhead";
    public static String PARA_ISCHECKSTATUS = "ischeckstatus";
    public static String PARA_ISCHECKMATERIAL = "ischeckmaterial";
    public static String PARA_ISCHECKTERM = "ischeckterm";
    public static String PARA_ISCHECKPAYENTRY = "ischeckpayentry";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>(16);
        }
        preparePropertys.add("org");
        preparePropertys.add("type");
        preparePropertys.add("billtype");
        preparePropertys.add("category");
        preparePropertys.add("template");
        preparePropertys.add("bizmode");
        preparePropertys.add("suitscope");
        preparePropertys.add("templateversion");
        preparePropertys.add("biztimeend");
        preparePropertys.add("biztime");
        preparePropertys.add("biztimebegin");
        preparePropertys.add("contparties");
        preparePropertys.add("suitentry");
        preparePropertys.add("suitorg");
        preparePropertys.add("billstatus");
        preparePropertys.add("validstatus");
        preparePropertys.add("signstatus");
        preparePropertys.add("reviewstatus");
        preparePropertys.add("filingstatus");
        preparePropertys.add("taxrateid");
        preparePropertys.add("qty");
        preparePropertys.add("price");
        preparePropertys.add("priceandtax");
        preparePropertys.add("project");
        preparePropertys.add("totalallamount");
        preparePropertys.add("term");
        preparePropertys.add("payentry");
        preparePropertys.add("timeunit");
        preparePropertys.add("payname");
        preparePropertys.add("entrynum");
        preparePropertys.add("partc");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject type;
            DynamicObject org;
            DynamicObject bill = dataEntity.getDataEntity();
            if (bill == null) continue;
            String billName = "";
            if ("conm_purcontract".equals(bill.getDataEntityType().getName())) {
                billName = ResManager.loadKDString((String)"\u91c7\u8d2d", (String)"BillContractValidator_26", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
            }
            if ("conm_salcontract".equals(bill.getDataEntityType().getName())) {
                billName = ResManager.loadKDString((String)"\u9500\u552e", (String)"BillContractValidator_27", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
            }
            if ((org = bill.getDynamicObject("org")) == null || (type = bill.getDynamicObject("type")) == null) continue;
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKBILLHEAD))) {
                QFilter[] qFilters;
                DynamicObject contpartiesDyn;
                DynamicObject contparties;
                String suitscope;
                DynamicObject template;
                QFilter[] typeqFilters;
                List typeIDs;
                String formId = bill.getDataEntityType().getName();
                DynamicObject billType = bill.getDynamicObject("billtype");
                if (billType != null) {
                    QFilter[] qFilters2 = new QFilter[]{new QFilter("masterid", "=", billType.get("masterid"))};
                    DynamicObject dbBillType = this.getCacheDynamicObject("billtype", "bos_billtype", "number,billformid", qFilters2, billType);
                    if (dbBillType == null || dbBillType.getDynamicObject("billformid") != null && !dbBillType.getDynamicObject("billformid").getString("number").equals(formId)) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u662f%2$s\u5408\u540c\u53ef\u7528\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"BillContractValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billType.getString("number"), billName), ErrorLevel.Error);
                    }
                } else {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillContractValidator_28", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                DynamicObject category = bill.getDynamicObject("category");
                if (!(category == null || (typeIDs = this.getDynamicObjectIDs("conm_type", "number,id", typeqFilters = new QFilter[]{new QFilter("contcategory", "=", category.getPkValue()), new QFilter("enable", "=", (Object)"1")})) != null && typeIDs.contains(type.getPkValue()))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u4e0e\u5408\u540c\u79cd\u7c7b\u4e0d\u5339\u914d\u3002", (String)"BillContractValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if ((template = bill.getDynamicObject("template")) != null) {
                    DynamicObject contentity;
                    QFilter[] templateFilters = new QFilter[]{new QFilter("contype", "=", type.getPkValue())};
                    List templateIDs = this.getDynamicObjectIDs("conm_template", "number,id", templateFilters);
                    if (templateIDs == null || !templateIDs.contains(template.getPkValue())) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u6a21\u7248\u672a\u5728\u5408\u540c\u7c7b\u578b\u5173\u8054\u7684\u5408\u540c\u6a21\u7248\u8303\u56f4\u5185\u3002", (String)"BillContractValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    if ((contentity = template.getDynamicObject("contentity")) != null && !contentity.getString("number").equals(bill.getDataEntityType().getName())) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u7248\u9002\u7528\u5355\u636e\u4e0d\u662f%1$s\u5408\u540c\u3002", (String)"BillContractValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billName), ErrorLevel.Error);
                    }
                    DynamicObjectCollection attachmententrys = template.getDynamicObjectCollection("attachmententry");
                    ArrayList<String> entryNumList = new ArrayList<String>();
                    for (DynamicObject attachmententry : attachmententrys) {
                        entryNumList.add(attachmententry.getString("version"));
                    }
                    DynamicObject templateversion = bill.getDynamicObject("templateversion");
                    if (templateversion != null && !entryNumList.contains(templateversion.getString("version"))) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u7248\u7248\u672c\u4e0d\u5728\u5408\u540c\u6a21\u7248\u7684\u7248\u672c\u8303\u56f4\u5185\u3002", (String)"BillContractValidator_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                }
                ArrayList<String> dataList = new ArrayList<String>(3);
                dataList.add("A");
                dataList.add("B");
                dataList.add("C");
                String bizMode = bill.getString("bizmode");
                if (!dataList.contains(bizMode)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u5f0f\u201c%1$s\u201d\u4e0d\u662f\u6709\u6548\u7684\u4e1a\u52a1\u6a21\u5f0f\u503c\u3002", (String)"BillContractValidator_5", (String)"scmc-conm-opplugin", (Object[])new Object[0]), bizMode), ErrorLevel.Error);
                }
                if (!"".equals(suitscope = bill.getString("suitscope")) && !dataList.contains(suitscope)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u201c%1$s\u201d\u4e0d\u5728\u6709\u6548\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u5185\u3002", (String)"BillContractValidator_6", (String)"scmc-conm-opplugin", (Object[])new Object[0]), suitscope), ErrorLevel.Error);
                }
                Date biztimeend = bill.getDate("biztimeend");
                Date biztime = bill.getDate("biztime");
                Date biztimebegin = bill.getDate("biztimebegin");
                if (biztime != null && biztimeend != null && biztimebegin != null) {
                    if (biztimeend.compareTo(biztimebegin) < 0) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u59cb\u65e5\u671f\u3002", (String)"BillContractValidator_7", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    if (biztimeend.compareTo(biztime) < 0) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u7b7e\u8ba2\u65e5\u671f\u3002", (String)"BillContractValidator_8", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                }
                if ((contparties = bill.getDynamicObject("contparties")) != null && (contpartiesDyn = this.getCacheDynamicObject("contparties", "conm_contparties", "number", qFilters = new QFilter[]{new QFilter("masterid", "=", contparties.getPkValue()), new QFilter("org", "=", org.getPkValue())}, contparties)) == null) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u4e3b\u4f53\u201c%1$s\u201d\u4e0d\u5728%2$s\u7ec4\u7ec7\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BillContractValidator_9", (String)"scmc-conm-opplugin", (Object[])new Object[0]), contparties.getString("number"), billName), ErrorLevel.Error);
                }
                DynamicObjectCollection suitentrys = bill.getDynamicObjectCollection("suitentry");
                if ((StatusEnum.SUBMIT.getValue().equals(bill.getString("billstatus")) || StatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) && suitentrys.size() == 0 && "B".equals(bill.getString("suitscope"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e3a\u6307\u5b9a\u7ec4\u7ec7\u65f6\uff0c\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u5206\u5f55\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"BillContractValidator_29", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if (suitentrys.size() > 0) {
                    QFilter qFilter = null;
                    if ("conm_purcontract".equals(bill.getDataEntityType().getName())) {
                        qFilter = new QFilter("fispurchase", "=", (Object)Boolean.TRUE);
                    }
                    if ("conm_salcontract".equals(bill.getDataEntityType().getName())) {
                        qFilter = new QFilter("fissale", "=", (Object)Boolean.TRUE);
                    }
                    Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), qFilter});
                    for (DynamicObject suitentry : suitentrys) {
                        DynamicObject suitOrg = suitentry.getDynamicObject("suitorg");
                        if (suitOrg == null || orgs != null && orgs.containsKey(suitOrg.getPkValue())) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5177\u5907%2$s\u804c\u80fd\u3002", (String)"BillContractValidator_10", (String)"scmc-conm-opplugin", (Object[])new Object[0]), suitOrg.getString("number"), billName), ErrorLevel.Error);
                    }
                }
            }
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKSTATUS))) {
                String billStatus = bill.getString("billstatus");
                String validstatus = bill.getString("validstatus");
                String reviewstatus = bill.getString("reviewstatus");
                String signstatus = bill.getString("signstatus");
                String filingstatus = bill.getString("filingstatus");
                if ("B".equals(validstatus) || "C".equals(validstatus)) {
                    if (!"C".equals(billStatus)) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u751f\u6548\u72b6\u6001\u4e3a\u201c\u5df2\u751f\u6548\u201d\u6216\u201c\u5df2\u5931\u6548\u201d\u65f6\uff0c\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"BillContractValidator_11", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    if (!CommonUtils.isNull((Object)reviewstatus) && (reviewstatus.equals(BizReviewStatusEnum.UNREVIEW.getValue()) || reviewstatus.equals(BizReviewStatusEnum.INREVIEW.getValue()) || reviewstatus.equals(BizReviewStatusEnum.NOPASS.getValue()))) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u751f\u6548\u72b6\u6001\u4e3a\u5df2\u751f\u6548\u6216\u5df2\u5931\u6548\u65f6\uff0c\u8bc4\u5ba1\u72b6\u6001\u4e0d\u80fd\u4e3a\u672a\u8bc4\u5ba1\u3001\u8bc4\u5ba1\u4e2d\u3001\u4e0d\u901a\u8fc7\u3002", (String)"BillContractValidator_12", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    if (!CommonUtils.isNull((Object)signstatus) && (signstatus.equals(BizSignStatusEnum.UNSIGN.getValue()) || signstatus.equals(BizSignStatusEnum.UPLOADFINISH.getValue()) || signstatus.equals(BizSignStatusEnum.PARTASIGN.getValue()) || signstatus.equals(BizSignStatusEnum.PARTBSIGN.getValue()))) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u751f\u6548\u72b6\u6001\u4e3a\u201c\u5df2\u751f\u6548\u201d\u6216\u201c\u5df2\u5931\u6548\u201d\u65f6\uff0c\u7b7e\u7ae0\u72b6\u6001\u4e0d\u80fd\u4e3a\u201c\u672a\u7b7e\u7ae0\u201d\u3001\u201c\u4e0a\u4f20\u5b8c\u6210\u201d\u3001\u201c\u7532\u65b9\u5df2\u7b7e\u201d\u3001\u201c\u4e59\u65b9\u5df2\u7b7e\u201d\u3002", (String)"BillContractValidator_13", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                }
                if (type.getBoolean("activereview") && BizReviewStatusEnum.INACTIVE.getValue().equals(reviewstatus)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u542f\u7528\u201c\u5408\u540c\u8bc4\u5ba1\u201d\u540e\uff0c\u8bc4\u5ba1\u72b6\u6001\u4e0d\u80fd\u4e3a\u201c\u672a\u542f\u7528\u201d\u3002", (String)"BillContractValidator_14", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if (type.getBoolean("activesign") && BizSignStatusEnum.INACTIVE.getValue().equals(signstatus)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u542f\u7528\u7b7e\u7ae0\u540e\uff0c\u7b7e\u7ae0\u72b6\u6001\u4e0d\u80fd\u4e3a\u201c\u672a\u542f\u7528\u201d\u3002", (String)"BillContractValidator_15", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if (type.getBoolean("activearchive") && FilingStatusEnum.INACTIVE.getValue().equals(filingstatus)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u542f\u7528\u201c\u5f52\u6863\u201d\u540e\uff0c\u5f52\u6863\u72b6\u6001\u4e0d\u80fd\u4e3a\u201c\u672a\u542f\u7528\u201d\u3002", (String)"BillContractValidator_16", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if ("A".equals(validstatus) && type.getBoolean("activesign") && !bill.getBoolean("iselecsignature") && (signstatus.equals(BizSignStatusEnum.UPLOADFINISH.getValue()) || signstatus.equals(BizSignStatusEnum.PARTASIGN.getValue()) || signstatus.equals(BizSignStatusEnum.PARTBSIGN.getValue()) || signstatus.equals(BizSignStatusEnum.INACTIVE.getValue()))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001\u4e3a\u201c\u672a\u751f\u6548\u201d\uff0c\u5408\u540c\u7c7b\u578b\u7684\u542f\u7528\u7b7e\u7ae0\u4e3a\u201c\u662f\u201d\uff0c\u662f\u5426\u7535\u5b50\u7b7e\u7ae0\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u7b7e\u7ae0\u72b6\u6001\u4e0d\u80fd\u4e3a\u201c\u4e0a\u4f20\u5b8c\u6210\u201d\u3001\u201c\u7532\u65b9\u5df2\u7b7e\u201d\u3001\u201c\u4e59\u65b9\u5df2\u7b7e\u201d\u3001\u201c\u672a\u542f\u7528\u201d\u3002", (String)"BillContractValidator_38", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKMATERIAL))) {
                DynamicObjectCollection entrys;
                String conmprop;
                String contCtrl = type.getString("excutecontrol");
                if ((StatusEnum.SUBMIT.getValue().equals(bill.getString("billstatus")) || StatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) && ((conmprop = bill.getString("conmprop")) == null || !"A".equals(conmprop) || ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_PRICE.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl) || ExcuteControlEnum.QTY.getValue().equals(contCtrl) || ExcuteControlEnum.PRICE.getValue().equals(contCtrl)) && (entrys = bill.getDynamicObjectCollection("billentry")).size() == 0) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u3002", (String)"BillContractValidator_37", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
                QFilter taxrateidFilter = this.getQFilter(org, "taxrateid", "bd_taxrate");
                List taxrateIDs = this.getDynamicObjectIDs("bd_taxrate", "id,number,activedate,expdate", new QFilter[]{taxrateidFilter});
                for (DynamicObject entry : billentrys) {
                    DynamicObject taxrateid = entry.getDynamicObject("taxrateid");
                    Date bizTime = bill.getDate("biztime");
                    if (taxrateid != null && bizTime != null) {
                        Date activedate = taxrateid.getDate("activedate");
                        Date expdate = taxrateid.getDate("expdate");
                        if (taxrateIDs == null || !taxrateIDs.contains(taxrateid.getPkValue()) || activedate != null && activedate.compareTo(bizTime) > 0 || expdate != null && expdate.compareTo(bizTime) < 0) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u7387\u7f16\u7801\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9%2$s\u7ec4\u7ec7\u7f16\u7801\u201c%3$s\u201d\u4f7f\u7528\u6216\u7b7e\u8ba2\u65e5\u671f\u672a\u5728\u5176\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"BillContractValidator_17", (String)"scmc-conm-opplugin", (Object[])new Object[0]), taxrateid.getString("number"), billName, org.getString("number")), ErrorLevel.Error);
                        }
                    }
                    BigDecimal qty = entry.getBigDecimal("qty");
                    BigDecimal price = entry.getBigDecimal("price");
                    BigDecimal priceandtax = entry.getBigDecimal("priceandtax");
                    if ((ExcuteControlEnum.QTY.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl)) && qty != null && BigDecimal.ZERO.compareTo(qty) == 0) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u63a7\u5236\u65b9\u5f0f\u5305\u542b\u201c\u6570\u91cf\u201d\u63a7\u5236\u65f6\uff0c\u6570\u91cf\u5b57\u6bb5\u5fc5\u987b\u586b\u5199\u3002", (String)"BillContractValidator_19", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]), ErrorLevel.Error);
                    }
                    if ((ExcuteControlEnum.PRICE.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_PRICE.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl)) && bill.getBoolean("istax") && priceandtax != null && priceandtax.compareTo(BigDecimal.ZERO) == 0) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u63a7\u5236\u65b9\u5f0f\u5305\u542b\u201c\u5355\u4ef7\u201d\u63a7\u5236\u65f6\uff0c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u586b\u5199\u3002", (String)"BillContractValidator_20", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]), ErrorLevel.Error);
                    }
                    if (!ExcuteControlEnum.PRICE.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_PRICE.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl) || bill.getBoolean("istax") || price == null || price.compareTo(BigDecimal.ZERO) != 0) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u63a7\u5236\u65b9\u5f0f\u5305\u542b\u201c\u5355\u4ef7\u201d\u63a7\u5236\u65f6\uff0c\u5355\u4ef7\u5fc5\u987b\u586b\u5199\u3002", (String)"BillContractValidator_21", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]), ErrorLevel.Error);
                }
                BigDecimal totalallamount = bill.getBigDecimal("totalallamount");
                if ((ExcuteControlEnum.AMOUNT.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_PRICE.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl) || ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl)) && totalallamount != null && totalallamount.compareTo(BigDecimal.ZERO) == 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b\u63a7\u5236\u65b9\u5f0f\u5305\u542b\u201c\u603b\u91d1\u989d\u201d\u63a7\u5236\u65f6\uff0c\u4ef7\u7a0e\u5408\u8ba1\u5fc5\u987b\u586b\u5199\u3002", (String)"BillContractValidator_22", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]), ErrorLevel.Error);
                }
            }
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKTERM))) {
                DynamicObjectCollection termentrys = bill.getDynamicObjectCollection("termentry");
                QFilter ctrlstrategy = new QFilter("ctrlstrategy", "=", (Object)"5");
                QFilter qFilter = new QFilter("org", "=", org.getPkValue()).or(ctrlstrategy);
                List termIDs = this.getDynamicObjectIDs("conm_term", "id,status,enable", new QFilter[]{qFilter});
                for (DynamicObject termentry : termentrys) {
                    DynamicObject term = termentry.getDynamicObject("term");
                    if (term == null || termIDs != null && termIDs.contains(term.getPkValue())) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u6761\u6b3e\u201c%1$s\u201d\u4e0d\u5728%2$s\u7ec4\u7ec7\u7ba1\u63a7\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BillContractValidator_23", (String)"scmc-conm-opplugin", (Object[])new Object[0]), term.getString("number"), billName), ErrorLevel.Error);
                }
            }
            if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKPAYENTRY))) continue;
            DynamicObjectCollection payentrys = bill.getDynamicObjectCollection("payentry");
            ArrayList<String> dataList = new ArrayList<String>(3);
            dataList.add("A");
            dataList.add("B");
            dataList.add("C");
            QFilter assistantDataFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_577354375991666688_qFilter");
            if (assistantDataFilter == null) {
                assistantDataFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)577354375991666688L, (Long)((Long)org.getPkValue()));
                this.tempCache.put(org.getPkValue() + "_577354375991666688_qFilter", assistantDataFilter);
            }
            List payNameIDs = this.getDynamicObjectIDs("bos_assistantdata_detail", "id,number,enable,name,group,ctrlstrategy", new QFilter[]{assistantDataFilter, new QFilter("enable", "=", (Object)"1"), new QFilter("group", "=", (Object)577354375991666688L)});
            for (DynamicObject payentry : payentrys) {
                DynamicObject payName;
                String timeunit = payentry.getString("timeunit");
                if (!dataList.contains(timeunit)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u5355\u4f4d\u201c%1$s\u201d\u4e3a\u65e0\u6548\u9009\u9879\u503c\u3002", (String)"BillContractValidator_24", (String)"scmc-conm-opplugin", (Object[])new Object[0]), timeunit), ErrorLevel.Error);
                }
                if ((payName = payentry.getDynamicObject("payname")) == null || payNameIDs != null && payNameIDs.contains(payName.getPkValue())) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6b3e\u9879\u540d\u79f0\u201c%1$s\u201d\u4e0d\u5728%2$s\u7ec4\u7ec7\u6743\u9650\u8303\u56f4\u5185\uff0c\u6216\u5904\u4e8e\u975e\u53ef\u7528\u72b6\u6001\u3002", (String)"BillContractValidator_25", (String)"scmc-conm-opplugin", (Object[])new Object[0]), payName.getString("number"), billName), ErrorLevel.Error);
            }
        }
    }

    private DynamicObject getCacheDynamicObject(String propName, String entityName, String selectProperties, QFilter[] qFilters, DynamicObject dyn) {
        if (dyn == null) {
            DynamicObject value = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters);
            if (value != null) {
                this.tempCache.put(propName + "_" + value.getPkValue(), value);
            }
            return value;
        }
        DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + dyn.getPkValue());
        if (value == null && (value = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters)) != null) {
            this.tempCache.put(propName + "_" + value.getPkValue(), value);
        }
        return value;
    }

    private QFilter getQFilter(DynamicObject org, String proName, String entityName) {
        QFilter qFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_" + proName + "qFilter");
        if (qFilter == null) {
            qFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_" + proName + "qFilter", qFilter);
        }
        return qFilter;
    }

    private List getDynamicObjectIDs(String entityName, String selectProperties, QFilter[] qFilters) {
        Map types = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])qFilters, null);
        ArrayList<Object> typeID = new ArrayList<Object>();
        if (types != null && types.size() > 0) {
            for (DynamicObject dyn : types.values()) {
                if (dyn == null) continue;
                typeID.add(dyn.getPkValue());
            }
        }
        return typeID;
    }
}

