/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.tpl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.CurrencyHelper;
import kd.mpscmm.msbd.common.enums.ExchangeTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class BillFinanceValidator
extends AbstractValidator {
    private static String PARA_ORGFUNCTION = "orgfunction";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>(32);
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String BILLNO = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billno");
        preparePropertys.add(BILLNO);
        preparePropertys.add("org");
        preparePropertys.add("currency");
        preparePropertys.add("settlecurrency");
        preparePropertys.add("exratetable");
        preparePropertys.add("exchangerate");
        preparePropertys.add("exratedate");
        preparePropertys.add("exchangetype");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String BILLNO = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"billno");
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Map exRateMap;
            String tipMsg;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject currency = bill.getDynamicObject("currency");
            DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
            DynamicObject exRateTable = bill.getDynamicObject("exratetable");
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            Date exRateTime = bill.getDate("exratedate");
            String exchangeType = bill.getString("exchangetype");
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
            if (currency != null && !currency.getPkValue().equals(map.get("baseCurrencyID"))) {
                tipMsg = "";
                if ("pur".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ORGFUNCTION))) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u3002", (String)"BillFinanceValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), currency.getString("name"));
                } else if ("sal".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ORGFUNCTION))) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u201c%1$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u3002", (String)"BillFinanceValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), currency.getString("name"));
                } else if ((org = BusinessDataServiceHelper.loadSingleFromCache((Object)org.getPkValue(), (String)"bos_org", (String)"id,fispurchase,fissale")) != null && org.getBoolean("fispurchase")) {
                    tipMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u3002", (String)"BillFinanceValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), bill.get(BILLNO), currency.getString("name"));
                } else if (org != null && org.getBoolean("fissale")) {
                    tipMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0d\u662f\u9500\u552e\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u3002", (String)"BillFinanceValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), bill.get(BILLNO), currency.getString("name"));
                }
                this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
            }
            if (currency != null && exRateTable != null && exchangeType != null && settleCurrency != null && !exchangeType.equals((exRateMap = CurrencyHelper.getExChangeRateMap((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)exRateTime)).get("exchangetype"))) {
                String exchangeTypeName = "";
                if (StringUtils.isNotEmpty((String)exchangeType) && "0".equals(exchangeType)) {
                    exchangeTypeName = ExchangeTypeEnum.getName((String)exchangeType);
                }
                if (StringUtils.isNotEmpty((String)exchangeType) && "1".equals(exchangeType)) {
                    exchangeTypeName = ExchangeTypeEnum.getName((String)exchangeType);
                }
                String tipMsg2 = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u6362\u7b97\u65b9\u5f0f\u201c%2$s\u201d\u4e0e\u7cfb\u7edf\u5f53\u524d\u8bbe\u7f6e\u4e0d\u4e00\u81f4\u3002", (String)"BillFinanceValidator_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]), bill.get(BILLNO), exchangeTypeName);
                this.addMessage(dataEntity, tipMsg2, ErrorLevel.Error);
            }
            if (currency == null || settleCurrency == null || !currency.getPkValue().equals(settleCurrency.getPkValue()) || exchangeRate == null || exchangeRate.compareTo(BigDecimal.ONE) == 0) continue;
            tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u5e01\u201d\u4e0e\u201c\u672c\u4f4d\u5e01\u201d\u76f8\u540c\uff0c\u6c47\u7387\u5fc5\u987b\u4e3a1\u3002", (String)"BillFinanceValidator_5", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
            this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
        }
    }
}

