/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.tpl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.conm.business.helper.AppParameterHelper;

public class ContractGrpIsolateValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkGrpIsolate(entity);
        }
    }

    private void checkGrpIsolate(ExtendedDataEntity entity) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)bill.getDataEntityType().getName(), (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
        if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            DynamicObject operator = bill.getDynamicObject("operator");
            LocaleString orgName = entity.getDataEntity().getDynamicObjectType().getProperty("org").getDisplayName();
            if (operator == null) {
                LocaleString operatorName = entity.getDataEntity().getDynamicObjectType().getProperty("operator").getDisplayName();
                String tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d%1$s\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u586b\u5199%2$s\u3002", (String)"ContractGrpIsolateValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), orgName, operatorName);
                this.addMessage(entity, tip, ErrorLevel.Error);
            }
        }
    }
}

