/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.DefaultEcServiceIdempotentPropHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.DateUtils;
import kd.scmc.conm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.conm.business.service.writeback.PurWriteServiceExecutor;
import kd.scmc.conm.mservice.api.PurConmService;

public class PurConmServiceImpl
extends BaseECService
implements PurConmService,
IdempotentService {
    private static final TrackLogService trackLog = new TrackLogService(PurConmServiceImpl.class, "conm");
    private static final Log log = LogFactory.getLog(PurConmServiceImpl.class);

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentPropHelper.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        trackLog.startInfo(JSON.toJSONString((Object)param));
        CommonDtxResponse response = new CommonDtxResponse();
        response.put((Object)"success", (Object)Boolean.TRUE);
        if (param instanceof CommonParam) {
            CommonParam commonParam = (CommonParam)param;
            String wbSalContAr = (String)commonParam.get((Object)"method");
            List mapList = (List)commonParam.get((Object)"list");
            if (StringUtils.isNotEmpty((String)wbSalContAr)) {
                switch (wbSalContAr) {
                    case "wbPurContAp": {
                        this.wbPurContAp(mapList);
                        break;
                    }
                    case "wbPurContAmount": {
                        this.wbPurContAmount(mapList);
                    }
                }
            }
        }
        trackLog.endInfo(JSON.toJSONString((Object)response));
        return response;
    }

    @Deprecated
    public boolean WbPrePaidAmount(List<Map<String, Object>> list) {
        log.info("(\u9884)\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212.\u5df2\u4ed8\u6b3e\u91d1\u989d\u548c\u5355\u5934.\u5df2\u9884\u4ed8\u91d1\u989d\u63a5\u53e3 \u5165\u53c2\uff1a" + JSON.toJSONString(list));
        BigDecimal ZERO = BigDecimal.ZERO;
        if (list == null || list.size() <= 0) {
            log.error("(\u9884)\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        Set ids = list.stream().map(a -> a.get("sourcepk")).collect(Collectors.toSet());
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"conm_purcontract").getDynamicObjectType());
        if (loads == null || loads.length == 0) {
            log.error("(\u9884)\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e2d\u7684\u91c7\u8d2d\u5408\u540cID(sourcepk)\u4e0d\u5b58\u5728:-->" + JSON.toJSONString(ids));
            return false;
        }
        block0: for (Map<String, Object> map : list) {
            Long mainBillId = (Long)map.get("sourcepk");
            if (mainBillId == null || mainBillId.compareTo(0L) == 0) continue;
            for (DynamicObject load : loads) {
                DynamicObjectCollection payEntrys;
                boolean isSuccess;
                BigDecimal oldPaidAmount;
                if (!mainBillId.equals(load.getPkValue())) continue;
                String operate = (String)map.get("operate");
                if ("refund".equals(operate)) {
                    DynamicObjectCollection payEntrys2;
                    BigDecimal refundAmount = (BigDecimal)map.get("refundamt");
                    if (refundAmount == null || refundAmount.compareTo(ZERO) == 0) continue;
                    Long currencypk = (Long)map.get("currencypk");
                    DynamicObject settlecurrency = load.getDynamicObject("settlecurrency");
                    if (settlecurrency == null || currencypk == null || refundAmount.compareTo(BigDecimal.ZERO) == 0) {
                        log.error("\u91d1\u989d\u6362\u7b97\u5931\u8d25\uff01");
                        return false;
                    }
                    if ((long)Long.compare((Long)settlecurrency.getPkValue(), currencypk) != 0L) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u65f6\uff0c\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"PurConmServiceImpl_0", (String)"scmc-conm-mservice", (Object[])new Object[0]));
                    }
                    oldPaidAmount = load.getBigDecimal("paidpreallamount");
                    if (oldPaidAmount == null) {
                        oldPaidAmount = ZERO;
                    }
                    if ((payEntrys2 = load.getDynamicObjectCollection("payentry")) == null || payEntrys2.size() < 1) continue;
                    for (int j = payEntrys2.size() - 1; j >= 0; --j) {
                        BigDecimal oldEntryJoinAmount;
                        DynamicObject payEntry = (DynamicObject)payEntrys2.get(j);
                        boolean isPrePay = payEntry.getBoolean("isprepay");
                        if (!isPrePay) continue;
                        BigDecimal oldEntryAmount = (BigDecimal)payEntry.get("paidamount");
                        if (oldEntryAmount == null) {
                            oldEntryAmount = ZERO;
                        }
                        if ((oldEntryJoinAmount = (BigDecimal)payEntry.get("joinpayamount")) == null) {
                            oldEntryJoinAmount = ZERO;
                        }
                        if (oldEntryAmount.subtract(refundAmount).compareTo(ZERO) >= 0) {
                            payEntry.set("paidamount", (Object)oldEntryAmount.subtract(refundAmount));
                            payEntry.set("joinpayamount", (Object)oldEntryJoinAmount.subtract(refundAmount));
                            load.set("paidpreallamount", (Object)oldPaidAmount.subtract(refundAmount));
                            continue block0;
                        }
                        refundAmount = refundAmount.subtract(oldEntryAmount);
                        payEntry.set("paidamount", (Object)ZERO);
                        payEntry.set("joinpayamount", (Object)oldEntryJoinAmount.subtract(oldEntryAmount));
                        load.set("paidpreallamount", (Object)oldPaidAmount.subtract(oldEntryAmount));
                    }
                    continue block0;
                }
                Long mainBillEntryId = (Long)map.get("sourceentrypk");
                BigDecimal paidAmount = (BigDecimal)map.get("amount");
                if (mainBillEntryId == null || paidAmount == null || paidAmount != null && paidAmount.compareTo(ZERO) == 0 || !(isSuccess = ((Boolean)map.get("issuccess")).booleanValue()) && paidAmount.compareTo(ZERO) > 0) continue;
                Long currencypk = (Long)map.get("currencypk");
                DynamicObject settlecurrency = load.getDynamicObject("settlecurrency");
                if (settlecurrency == null || currencypk == null || paidAmount.compareTo(BigDecimal.ZERO) == 0) {
                    log.error("\u91d1\u989d\u6362\u7b97\u5931\u8d25\uff01");
                    continue;
                }
                if ((long)Long.compare((Long)settlecurrency.getPkValue(), currencypk) != 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u65f6\uff0c\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"PurConmServiceImpl_0", (String)"scmc-conm-mservice", (Object[])new Object[0]));
                }
                oldPaidAmount = load.getBigDecimal("paidpreallamount");
                if (oldPaidAmount == null) {
                    oldPaidAmount = ZERO;
                }
                if ((payEntrys = load.getDynamicObjectCollection("payentry")) == null || payEntrys.size() < 1) continue;
                for (DynamicObject payEntry : payEntrys) {
                    Object pkValue = payEntry.getPkValue();
                    if (pkValue == null || mainBillEntryId == null || !mainBillEntryId.equals(pkValue)) continue;
                    BigDecimal oldEntryAmount = (BigDecimal)payEntry.get("paidamount");
                    if (oldEntryAmount == null) {
                        oldEntryAmount = ZERO;
                    }
                    payEntry.set("paidamount", (Object)oldEntryAmount.add(paidAmount));
                    load.set("paidpreallamount", (Object)oldPaidAmount.add(paidAmount));
                    continue block0;
                }
                continue block0;
            }
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])loads);
        log.info("(\u9884)\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u6210\u529f\u7684\u6709:-->" + JSON.toJSONString(Arrays.stream(save).map(a -> ((DynamicObject)a).getString("billno")).collect(Collectors.toList())));
        return true;
    }

    @Deprecated
    public boolean WbPaidAmount(List<Map<String, Object>> list) {
        log.info("\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u5355\u5934.\u5df2\u4ed8\u91d1\u989d\u63a5\u53e3,\u5165\u53c2\uff1a" + JSON.toJSONString(list));
        if (list == null || list.size() <= 0) {
            log.error("\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        Set ids = list.stream().map(a -> a.get("mainbillid")).collect(Collectors.toSet());
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"conm_purcontract").getDynamicObjectType());
        if (loads == null || loads.length == 0) {
            log.error("\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e2d\u7684\u91c7\u8d2d\u5408\u540cID(mainbillid)\u4e0d\u5b58\u5728:-->" + JSON.toJSONString(ids));
            return false;
        }
        block0: for (Map<String, Object> map : list) {
            Long mainBillId = (Long)map.get("mainbillid");
            for (DynamicObject load : loads) {
                BigDecimal paidAmount;
                if (mainBillId == null || !mainBillId.equals(load.getPkValue()) || (paidAmount = (BigDecimal)map.get("paidamount")) == null || paidAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal oldPaidAmount = load.getBigDecimal("paidallamount");
                if (oldPaidAmount == null) {
                    oldPaidAmount = BigDecimal.ZERO;
                }
                Long currencypk = (Long)map.get("currencyid");
                DynamicObject settlecurrency = load.getDynamicObject("settlecurrency");
                if (settlecurrency == null || currencypk == null) {
                    log.error("\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540cid=" + mainBillId + "\u91d1\u989d\u6362\u7b97\u5931\u8d25\uff01");
                    return false;
                }
                if ((long)Long.compare((Long)settlecurrency.getPkValue(), currencypk) != 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u65f6\uff0c\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"PurConmServiceImpl_0", (String)"scmc-conm-mservice", (Object[])new Object[0]));
                }
                load.set("paidallamount", (Object)oldPaidAmount.add(paidAmount));
                continue block0;
            }
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])loads);
        log.info("\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u6210\u529f\u7684\u6709:-->" + JSON.toJSONString(Arrays.stream(save).map(a -> ((DynamicObject)a).getString("billno")).collect(Collectors.toList())));
        return true;
    }

    @Deprecated
    public boolean WbJoinAmount(List<Map<String, Object>> list) {
        log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u4e0a\u7684\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u63a5\u53e3,\u5165\u53c2\uff1a" + JSON.toJSONString(list));
        if (list == null || list.size() <= 0) {
            log.error("\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u4e0a\u7684\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u63a5\u53e3,\u5165\u53c2\u4e3a\u7a7a");
            return false;
        }
        Set ids = list.stream().map(a -> a.get("mainbillid")).collect(Collectors.toSet());
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"conm_purcontract").getDynamicObjectType());
        if (loads == null || loads.length == 0) {
            log.error("\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e2d\u7684\u91c7\u8d2d\u5408\u540cID(mainbillid)\u4e0d\u5b58\u5728:-->" + JSON.toJSONString(ids));
            return false;
        }
        block0: for (Map<String, Object> map : list) {
            Long mainBillId = (Long)map.get("mainbillid");
            for (DynamicObject load : loads) {
                if (mainBillId == null || !mainBillId.equals(load.getPkValue())) continue;
                Long mainBillEntryId = (Long)map.get("mainbillentryid");
                BigDecimal joinAmount = (BigDecimal)map.get("joinamount");
                Long currencypk = (Long)map.get("currencyid");
                if (mainBillId == null || mainBillEntryId == null || joinAmount == null || joinAmount.compareTo(BigDecimal.ZERO) == 0) continue block0;
                DynamicObjectCollection payEntrys = load.getDynamicObjectCollection("payentry");
                for (DynamicObject payEntry : payEntrys) {
                    if (((Long)payEntry.getPkValue()).longValue() != mainBillEntryId.longValue()) continue;
                    BigDecimal oldEntryAmount = (BigDecimal)payEntry.get("joinpayamount");
                    if (oldEntryAmount == null) {
                        oldEntryAmount = BigDecimal.ZERO;
                    }
                    DynamicObject settlecurrency = load.getDynamicObject("settlecurrency");
                    DynamicObject exratetable = load.getDynamicObject("exratetable");
                    Date biztime = load.getDate("biztime");
                    if (settlecurrency == null || exratetable == null || currencypk == null || joinAmount.compareTo(BigDecimal.ZERO) == 0) {
                        log.error("\u91d1\u989d\u6362\u7b97\u5931\u8d25\uff01");
                        return false;
                    }
                    if ((long)Long.compare((Long)settlecurrency.getPkValue(), currencypk) != 0L) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u65f6\uff0c\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"PurConmServiceImpl_0", (String)"scmc-conm-mservice", (Object[])new Object[0]));
                    }
                    payEntry.set("joinpayamount", (Object)oldEntryAmount.add(joinAmount));
                    continue block0;
                }
                continue block0;
            }
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])loads);
        log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u6210\u529f\u7684\u6709:-->" + JSON.toJSONString(Arrays.stream(save).map(a -> ((DynamicObject)a).getString("billno")).collect(Collectors.toList())));
        return true;
    }

    @Deprecated
    public boolean WbJoinPayableQty(List<Map<String, Object>> list) {
        log.info("\u5e94\u4ed8\u5355\u6838\u9500\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u4e0a\u7684\u5e94\u4ed8\u6570\u91cf\u63a5\u53e3,\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString(list));
        if (list == null || list.size() <= 0) {
            log.error("\u5e94\u4ed8\u5355\u6838\u9500\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u4e0a\u7684\u5e94\u4ed8\u6570\u91cf\u63a5\u53e3,\u5165\u53c2\u4e3a\u7a7a");
            return false;
        }
        Set ids = list.stream().map(a -> a.get("mainbillid")).collect(Collectors.toSet());
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"conm_purcontract").getDynamicObjectType());
        for (Map<String, Object> map : list) {
            Long mainBillId = (Long)map.get("mainbillid");
            block1: for (DynamicObject load : loads) {
                Long mainBillEntryId = (Long)map.get("mainbillentryid");
                BigDecimal qty = (BigDecimal)map.get("qty");
                Object pkValue = load.getPkValue();
                if (mainBillId == null || mainBillEntryId == null || qty == null || pkValue == null || mainBillId.compareTo((Long)pkValue) != 0) continue;
                DynamicObjectCollection entrys = load.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    if (((Long)entry.getPkValue()).longValue() != mainBillEntryId.longValue()) continue;
                    BigDecimal oldEntryPayableQty = entry.getBigDecimal("payablepriceqty");
                    entry.set("payablepriceqty", (Object)qty.add(oldEntryPayableQty));
                    continue block1;
                }
            }
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])loads);
        log.info("\u8d22\u52a1\u5e94\u4ed8\u5355\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u6210\u529f\u7684\u6709:-->" + JSON.toJSONString(Arrays.stream(save).map(a -> ((DynamicObject)a).getString("billno")).collect(Collectors.toList())));
        return true;
    }

    public void wbPurContAp(List<Map<String, Object>> list) {
        trackLog.startInfo(JSON.toJSONString(list));
        if (list != null && list.size() > 0) {
            ArrayList<Map<String, Object>> contractInfo = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> mainBillInfo = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> orderBillInfo = new ArrayList<Map<String, Object>>();
            HashMap<Long, DynamicObject> contractMap = new HashMap<Long, DynamicObject>();
            String orderEntity = "pm_purorderbill";
            String defaultContractEntity = "conm_purcontract";
            for (Map<String, Object> map : list) {
                Long contractId = (Long)map.get("conbillid");
                Long contractEntryId = (Long)map.get("conbillentryid");
                if (contractId != null && contractEntryId != null && 0L != contractId && 0L != contractEntryId) {
                    contractInfo.add(map);
                    continue;
                }
                String mainEnityType = (String)map.get("apMainBillEntity");
                if (defaultContractEntity.equalsIgnoreCase(mainEnityType)) {
                    mainBillInfo.add(map);
                    continue;
                }
                if (!orderEntity.equalsIgnoreCase(mainEnityType)) continue;
                orderBillInfo.add(map);
            }
            this.dealWithContractInfo(contractInfo, contractMap);
            this.dealWithMainBillInfo(mainBillInfo, contractMap);
            this.dealWithOrderBillInfo(orderBillInfo, contractMap);
            if (!contractMap.isEmpty()) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(contractMap.size());
                for (DynamicObject entry : contractMap.values()) {
                    Object[] obj = new Object[]{entry.getBigDecimal("billentry.payablepriceqty"), entry.getBigDecimal("billentry.payablebaseqty"), entry.getBigDecimal("billentry.payableamount"), entry.getLong("billentry.id")};
                    paramList.add(obj);
                    this.excessWarning(entry);
                }
                String string = "update t_conm_purcontractentry_r set fpayablepriceqty = ?,fpayablebaseqty = ? ,fpayableamount = ? where fentryid = ?";
                trackLog.info("prepare to update contract data,sql=" + string + ",param=" + JSON.toJSONString(paramList));
                if (paramList.size() > 0) {
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)string, paramList);
                    }
                    catch (Exception e) {
                        trackLog.error(e.getMessage());
                        throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u91c7\u8d2d\u5408\u540c\u65f6\uff0c\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25\u3002", (String)"PurConmServiceImpl_3", (String)"scmc-conm-mservice", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void wbPurContAmount(List<Map<String, Object>> list) {
        if (list != null && list.size() > 0) {
            PurWriteServiceExecutor serviceExecutor = new PurWriteServiceExecutor();
            serviceExecutor.execute(list);
        }
    }

    private void dealWithOrderBillInfo(List<Map<String, Object>> orderBillInfo, Map<Long, DynamicObject> contractMap) {
        trackLog.info("deal main bill is order scene:" + JSON.toJSONString(orderBillInfo));
        String orderEntity = "pm_purorderbill";
        HashSet<Long> orderEntryIds = new HashSet<Long>(orderBillInfo.size());
        for (Map<String, Object> orderInfo : orderBillInfo) {
            Long orderEntryId = (Long)orderInfo.get("poentryid");
            orderEntryIds.add(orderEntryId);
        }
        if (orderEntryIds.size() > 0) {
            HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>();
            DynamicObjectCollection orderBillEntry = QueryServiceHelper.query((String)orderEntity, (String)"billentry.id,billentry.conbillentity,billentry.conbillid,billentry.conbillentryid,billentry.srcbillentity,billentry.srcbillid,billentry.srcbillentryid", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", orderEntryIds)});
            for (DynamicObject entry : orderBillEntry) {
                orderEntryMap.put(entry.getLong("billentry.id"), entry);
            }
            String contractEntity = "conm_purcontract";
            ArrayList<Map<String, Object>> contractInfos = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> orderInfo : orderBillInfo) {
                Long orderEntryId = (Long)orderInfo.get("poentryid");
                DynamicObject orderEntry = (DynamicObject)orderEntryMap.get(orderEntryId);
                if (orderEntry == null) continue;
                String conbillentity = orderEntry.getString("billentry.conbillentity");
                Long conbillid = orderEntry.getLong("billentry.conbillid");
                Long conbillentryid = orderEntry.getLong("billentry.conbillentryid");
                if (StringUtils.isNotEmpty((String)conbillentity) && conbillid != null && Long.compare(conbillid, 0L) != 0 && conbillentryid != null && Long.compare(conbillentryid, 0L) != 0) {
                    orderInfo.put("conbillid", conbillid);
                    orderInfo.put("conbillentryid", conbillentryid);
                    contractInfos.add(orderInfo);
                    trackLog.info("write back with order's contrct information where contractId is " + conbillid + " and contract entryid is " + conbillentryid);
                    continue;
                }
                String srcbillentity = orderEntry.getString("billentry.srcbillentity");
                Long srcbillid = orderEntry.getLong("billentry.srcbillid");
                Long srcbillentryid = orderEntry.getLong("billentry.srcbillentryid");
                if (!StringUtils.isNotEmpty((String)srcbillentity) || !contractEntity.equalsIgnoreCase(srcbillentity) || srcbillid == null || Long.compare(srcbillid, 0L) == 0 || srcbillentryid == null || Long.compare(srcbillentryid, 0L) == 0) continue;
                orderInfo.put("conbillid", srcbillid);
                orderInfo.put("conbillentryid", srcbillentryid);
                contractInfos.add(orderInfo);
                trackLog.info("write back with order's source bill ,where order's source bill type is contract and source bill's id is " + srcbillid + " and source bill's entryId is" + srcbillentryid);
            }
            this.dealWithContractInfo(contractInfos, contractMap);
        }
    }

    private void dealWithMainBillInfo(List<Map<String, Object>> mainBillInfo, Map<Long, DynamicObject> contractMap) {
        trackLog.info("write back where main bill type is contract: " + JSON.toJSONString(mainBillInfo));
        if (mainBillInfo != null && mainBillInfo.size() > 0) {
            for (Map<String, Object> info : mainBillInfo) {
                Long contractId = (Long)info.get("poid");
                Long contractEntryId = (Long)info.get("poentryid");
                info.put("conbillid", contractId);
                info.put("conbillentryid", contractEntryId);
                trackLog.info("write back where mian bill type is contract and main bill'id is " + contractId + " and main bill entry'id is " + contractEntryId);
            }
            this.dealWithContractInfo(mainBillInfo, contractMap);
        }
    }

    private void dealWithContractInfo(List<Map<String, Object>> contractInfo, Map<Long, DynamicObject> contractMap) {
        if (contractInfo != null && contractInfo.size() > 0) {
            DynamicObjectCollection billentry;
            String contractEntity = "conm_purcontract";
            HashSet<Long> contractEntryIds = new HashSet<Long>();
            Set<Long> ids = contractMap.keySet();
            for (Map<String, Object> map : contractInfo) {
                Long conbillentryid = (Long)map.get("conbillentryid");
                trackLog.info("prepare to write back's contract entry ids is " + conbillentryid);
                if (ids.contains(conbillentryid)) continue;
                contractEntryIds.add(conbillentryid);
            }
            if (contractEntryIds.size() > 0 && (billentry = QueryServiceHelper.query((String)contractEntity, (String)"supplier,billentry.id,billentry.material.masterid,billentry.unit,billentry.baseunit,billentry.entrysettleorg,billentry.payablepriceqty,billentry.payablebaseqty,billentry.payableamount,billentry.baseqty,billentry.amountandtax", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", contractEntryIds)})) != null) {
                for (DynamicObject entry : billentry) {
                    if (contractMap.containsKey(entry.getPkValue())) continue;
                    contractMap.put(entry.getLong("billentry.id"), entry);
                }
            }
            int size = contractMap.size();
            HashSet<Long> hashSet = new HashSet<Long>(size);
            HashSet<Long> unitIds = new HashSet<Long>(size);
            for (DynamicObject entry : contractMap.values()) {
                hashSet.add(entry.getLong("billentry.material.masterid"));
                unitIds.add(entry.getLong("billentry.unit"));
                unitIds.add(entry.getLong("billentry.baseunit"));
            }
            QFilter materialFilter = new QFilter("id", "in", hashSet);
            QFilter unitFilter = new QFilter("id", "in", unitIds);
            Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])materialFilter.toArray(), null);
            Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id, precision, precisionaccount", (QFilter[])unitFilter.toArray(), null);
            for (Map<String, Object> verifyInfo : contractInfo) {
                Long contractEntryId = (Long)verifyInfo.get("conbillentryid");
                Long apsettleorgid = (Long)verifyInfo.get("apsettleorgid");
                BigDecimal baseqty = (BigDecimal)verifyInfo.get("baseqty");
                BigDecimal amount = (BigDecimal)verifyInfo.get("amount");
                DynamicObject entry = contractMap.get(contractEntryId);
                trackLog.warn("contract entry id equals " + contractEntryId + "is " + (entry == null ? "not exist" : "exist"));
                if (entry == null) continue;
                Long entryId = entry.getLong("billentry.id");
                Long entrysettleorg = entry.getLong("billentry.entrysettleorg");
                Long supplier = entry.getLong("supplier");
                if (contractEntryId.compareTo(entryId) != 0 || apsettleorgid.compareTo(entrysettleorg) != 0) continue;
                BigDecimal payablepriceqty = entry.getBigDecimal("billentry.payablepriceqty");
                BigDecimal payablebaseqty = entry.getBigDecimal("billentry.payablebaseqty");
                BigDecimal payableamount = entry.getBigDecimal("billentry.payableamount");
                Long material = entry.getLong("billentry.material.masterid");
                Long baseunit = entry.getLong("billentry.baseunit");
                Long unit = entry.getLong("billentry.unit");
                DynamicObject materialObj = (DynamicObject)materialMap.get(material);
                DynamicObject unitObj = (DynamicObject)unitMap.get(unit);
                DynamicObject baseUnitObj = (DynamicObject)unitMap.get(baseunit);
                BigDecimal verifyQty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)baseUnitObj, (BigDecimal)payablebaseqty.add(baseqty), (DynamicObject)unitObj);
                trackLog.info("before update database snopshot is { billentryid=" + entryId + ",payablepriceqty=" + payablepriceqty.toPlainString() + ",payablebaseqty=" + payablebaseqty.toPlainString() + ",payableamount=" + payableamount.toPlainString() + " }");
                entry.set("billentry.payablepriceqty", (Object)verifyQty);
                entry.set("billentry.payablebaseqty", (Object)payablebaseqty.add(baseqty));
                entry.set("billentry.payableamount", (Object)payableamount.add(amount));
                trackLog.info("after update database snopshot is { billentryid=" + entryId + ",payablepriceqty=" + entry.getBigDecimal("billentry.payablepriceqty").toPlainString() + ",payablebaseqty=" + entry.getBigDecimal("billentry.payablebaseqty").toPlainString() + ",payableamount=" + entry.getBigDecimal("billentry.payableamount").toPlainString() + " }");
            }
        }
    }

    private void excessWarning(DynamicObject entry) {
        BigDecimal payableBaseQty = entry.getBigDecimal("billentry.payablebaseqty");
        BigDecimal payableAmount = entry.getBigDecimal("billentry.payableamount");
        BigDecimal amountAndTax = entry.getBigDecimal("billentry.amountandtax");
        BigDecimal baseQty = entry.getBigDecimal("billentry.baseqty");
        Long entryId = entry.getLong("billentry.id");
        if (payableBaseQty.compareTo(baseQty) > 0) {
            trackLog.warn("contractEntryId:" + entryId + ",payableBaseQty[" + payableBaseQty.toPlainString() + "] is greater than baseQty[" + baseQty.toPlainString() + "]");
        }
        if (payableBaseQty.compareTo(BigDecimal.ZERO) < 0) {
            trackLog.warn("contractEntryId:" + entryId + ",payableBaseQty[" + payableBaseQty.toPlainString() + "] is less than zero");
        }
        if (payableAmount.compareTo(amountAndTax) > 0) {
            trackLog.warn("contractEntryId:" + entryId + ",payableAmount[" + payableAmount.toPlainString() + "] is greater than amountAndTax[" + amountAndTax.toPlainString() + "]");
        }
        if (payableAmount.compareTo(BigDecimal.ZERO) < 0) {
            trackLog.warn("contractEntryId:" + entryId + ",payableAmount[" + payableAmount.toPlainString() + "] is less than zero");
        }
    }

    public List<Map<String, Object>> queryOverPayParamAndAmount(Map<Long, Set<Long>> conmidAndEntryIdMap) {
        QFilter conmidFilter;
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        log.info("\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u5165\u53c2\u4e3a\uff1a" + conmidAndEntryIdMap);
        if (CommonUtils.isNull(conmidAndEntryIdMap)) {
            return result;
        }
        ArrayList<Long> hasNoEntryIdConmIds = new ArrayList<Long>(10);
        HashMap<Long, Set<Long>> hasEntryIdAndConmIdMap = new HashMap<Long, Set<Long>>(10);
        for (Map.Entry<Long, Set<Long>> entry : conmidAndEntryIdMap.entrySet()) {
            Long conmId = entry.getKey();
            if (conmId == null || conmId.compareTo(0L) == 0) continue;
            Set<Long> conmEntryIds = entry.getValue();
            if (conmEntryIds == null || conmEntryIds.isEmpty()) {
                hasNoEntryIdConmIds.add(conmId);
                continue;
            }
            hasEntryIdAndConmIdMap.put(conmId, conmEntryIds);
        }
        conmidAndEntryIdMap = null;
        log.info("\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u65e0\u5206\u5f55id\u4e3a\uff1a" + hasNoEntryIdConmIds);
        log.info("\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u6709\u5206\u5f55id\u4e3a\uff1a" + hasEntryIdAndConmIdMap);
        if ((hasNoEntryIdConmIds == null || hasNoEntryIdConmIds.isEmpty()) && (hasEntryIdAndConmIdMap == null || hasEntryIdAndConmIdMap.isEmpty())) {
            return result;
        }
        DataSet dataSet = null;
        if (hasNoEntryIdConmIds != null && !hasNoEntryIdConmIds.isEmpty()) {
            conmidFilter = new QFilter("id", "in", hasNoEntryIdConmIds);
            dataSet = this.queryConmDataSet(conmidFilter, null);
        }
        if (hasEntryIdAndConmIdMap != null && !hasEntryIdAndConmIdMap.isEmpty()) {
            conmidFilter = new QFilter("id", "in", hasEntryIdAndConmIdMap.keySet());
            DataSet hasEntryIdDataSet = this.queryConmDataSet(conmidFilter, this.getHasEntryIdFilter(hasEntryIdAndConmIdMap));
            dataSet = dataSet != null ? dataSet.union(hasEntryIdDataSet).orderBy(new String[]{"id"}) : hasEntryIdDataSet;
        }
        result = this.addConmInfo(result, dataSet);
        return result;
    }

    private QFilter getHasEntryIdFilter(Map<Long, Set<Long>> hasEntryIdAndConmIdMap) {
        QFilter filter = null;
        if (hasEntryIdAndConmIdMap != null && !hasEntryIdAndConmIdMap.isEmpty()) {
            HashSet<Long> entryIds = new HashSet<Long>(10);
            for (Map.Entry<Long, Set<Long>> entry : hasEntryIdAndConmIdMap.entrySet()) {
                Set<Long> value;
                if (entry == null || (value = entry.getValue()) == null || value.isEmpty()) continue;
                entryIds.addAll(value);
            }
            filter = new QFilter("billentry.id", "in", entryIds);
        }
        return filter;
    }

    private List<Map<String, Object>> addConmInfo(List<Map<String, Object>> result, DataSet dataSet) {
        HashMap billInfos = new HashMap(10);
        for (Row row : dataSet) {
            Long poEntryId;
            Long id = row.getLong("id");
            Boolean isAllowOverPay = row.getBoolean("isallowoverpay") == null ? Boolean.TRUE : row.getBoolean("isallowoverpay");
            Long settleCurrency = row.getLong("settlecurrency");
            Long invoicesupplier = row.getLong("invoicesupplier");
            String billno = row.getString("billno");
            Date createtime = row.getDate("createtime");
            BigDecimal sumPrePayAmount = row.getBigDecimal("sumprepayamount") == null ? BigDecimal.ZERO : row.getBigDecimal("sumprepayamount");
            HashMap<String, Object> billInfo = (HashMap<String, Object>)billInfos.get(id);
            if (billInfo == null) {
                billInfo = new HashMap<String, Object>(10);
                billInfo.put("billid", id);
                billInfo.put("isallowoverpay", isAllowOverPay);
                billInfo.put("settlecurrency", settleCurrency);
                billInfo.put("invoicesupplier", invoicesupplier);
                billInfo.put("sumprepayamount", sumPrePayAmount);
                billInfo.put("billno", billno);
                billInfo.put("createtime", createtime);
                billInfo.put("entryinfo", new ArrayList(10));
            }
            if ((poEntryId = row.getLong("entryid")) == null || poEntryId.compareTo(0L) == 0) {
                billInfos.put(id, billInfo);
                continue;
            }
            List entryinfoList = (List)billInfo.get("entryinfo");
            HashMap<String, Number> rowInfoMap = new HashMap<String, Number>(10);
            BigDecimal entryAmount = row.getBigDecimal("amount");
            rowInfoMap.put("entryid", poEntryId);
            rowInfoMap.put("settleorg", row.getLong("settleorg"));
            rowInfoMap.put("amount", entryAmount);
            rowInfoMap.put("amountandtax", row.getBigDecimal("amountandtax"));
            rowInfoMap.put("baseqty", row.getBigDecimal("baseqty"));
            rowInfoMap.put("seq", row.getInteger("seq"));
            entryinfoList.add(rowInfoMap);
            billInfos.put(id, billInfo);
        }
        if (billInfos == null || billInfos.isEmpty()) {
            return result;
        }
        result.addAll(billInfos.values());
        return result;
    }

    private DataSet queryConmDataSet(QFilter conmidFilter, QFilter conmEntryIdFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(conmidFilter);
        if (conmEntryIdFilter != null) {
            filters.add(conmEntryIdFilter);
        }
        DataSet poHeadDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"id,isallowoverpay,invoicesupplier,settlecurrency,billno,createtime", (QFilter[])new QFilter[]{conmidFilter}, null);
        QFilter isPrePayFilter = new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE);
        QFilter pretimepointFilter = new QFilter("payentry.pretimepoint", "in", (Object)new String[]{"A", " "});
        DataSet poPayPlanDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"id,payentry.payamount as prepayamount", (QFilter[])new QFilter[]{conmidFilter, isPrePayFilter, pretimepointFilter}, null);
        poPayPlanDataSet = poPayPlanDataSet.groupBy(new String[]{"id"}).sum("prepayamount").finish().select(new String[]{"id", "prepayamount as sumprepayamount"});
        DataSet headAndPrePayAmountDataSet = poHeadDataSet.leftJoin(poPayPlanDataSet).on("id", "id").select(new String[]{"id", "isallowoverpay", "invoicesupplier", "settlecurrency", "billno", "createtime"}, new String[]{"sumprepayamount"}).finish();
        DataSet billEntryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"id,billentry.entrysettleorg as settleorg,billentry.amount as amount,billentry.amountandtax as amountandtax,billentry.baseqty as baseqty,billentry.id as entryid,billentry.seq as seq", (QFilter[])filters.toArray(new QFilter[0]), (String)"id");
        DataSet dataSet = headAndPrePayAmountDataSet.fullJoin(billEntryDataSet).on("id", "id").select(new String[]{"id", "sumprepayamount", "isallowoverpay", "invoicesupplier", "settlecurrency", "billno", "createtime"}, new String[]{"entryid", "baseqty", "amountandtax", "amount", "settleorg", "seq"}).finish();
        dataSet = dataSet.orderBy(new String[]{"id"});
        return dataSet;
    }

    public Map<Long, String> payBillOverPayValService(List<Map<String, Object>> params) {
        HashMap<Long, String> result = new HashMap<Long, String>(10);
        if (params == null || params.isEmpty()) {
            return null;
        }
        List<Map<String, Object>> payBills = this.getValidPayBills(params);
        if (payBills.isEmpty()) {
            return null;
        }
        HashMap<Long, Set<Long>> queryPoIds = new HashMap<Long, Set<Long>>(10);
        Map<String, POBillInfo> poInfoMap = this.getPOBillInfo(payBills, queryPoIds);
        HashMap<Long, Set<Long>> queryConmIds = new HashMap<Long, Set<Long>>(10);
        Map<Long, ConmBillInfo> conmInfoMap = this.getConmBillInfo(payBills, queryConmIds);
        payBills = null;
        if (!queryPoIds.isEmpty()) {
            List queryPoInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{queryPoIds});
            poInfoMap = this.addPoInfo(poInfoMap, queryPoInfo, conmInfoMap);
        }
        if (!conmInfoMap.isEmpty()) {
            QFilter conidFilter = new QFilter("id", "in", conmInfoMap.keySet());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"id,settlecurrency,createtime,isallowoverpay,billno,billentry.amountandtax,receivesupplier", (QFilter[])new QFilter[]{conidFilter}, null);){
                DataSet select = dataSet.groupBy(new String[]{"id", "settlecurrency", "createtime", "isallowoverpay", "billno", "receivesupplier"}).sum("billentry.amountandtax").finish().select("id,settlecurrency,createtime,isallowoverpay,billno,billentry.amountandtax,receivesupplier");
                conmInfoMap = this.addConmInfo(conmInfoMap, select);
            }
        }
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return result;
        }
        this.filterByPoAndConmRelation(poInfoMap, conmInfoMap);
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return result;
        }
        this.addConmCurrentAmount(poInfoMap, conmInfoMap);
        this.filterByIsOverPayFlag(poInfoMap, conmInfoMap);
        this.addPaidAmount(poInfoMap, conmInfoMap);
        HashMap<Long, Long> supplierMasterIdMap = new HashMap<Long, Long>(10);
        HashMap<Long, Integer> currencyPrecisionMap = new HashMap<Long, Integer>(10);
        this.addSupplierMasterIdAndCurrencyPrecision(poInfoMap, conmInfoMap, supplierMasterIdMap, currencyPrecisionMap);
        result.putAll(this.validPO(poInfoMap, conmInfoMap, supplierMasterIdMap, currencyPrecisionMap));
        Map<Long, String> errorMsg = this.validConm(conmInfoMap, supplierMasterIdMap, currencyPrecisionMap);
        if (!errorMsg.isEmpty()) {
            errorMsg.keySet().forEach(payBillId -> {
                if (!result.containsKey(payBillId)) {
                    result.put((Long)payBillId, (String)errorMsg.get(payBillId));
                }
            });
        }
        return result;
    }

    private void addConmCurrentAmount(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        if (conmInfoMap.isEmpty() || poInfoMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, POBillInfo> poInfoEntry : poInfoMap.entrySet()) {
            Set<Long> poIds;
            ConmBillInfo conmBillInfo;
            POBillInfo poInfo = poInfoEntry.getValue();
            Long conmId = poInfo.getConmId();
            if (conmId == null || (conmBillInfo = conmInfoMap.get(conmId)) == null || (poIds = conmBillInfo.getPoIds()) == null || poIds.isEmpty() || !poIds.contains(poInfo.getCoreBillId())) continue;
            BigDecimal poCurrentAmount = poInfo.getCurrentAmount() == null ? BigDecimal.ZERO : poInfo.getCurrentAmount();
            BigDecimal conmCurrentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
            conmBillInfo.setCurrentAmount(poCurrentAmount.add(conmCurrentAmount));
        }
    }

    private void addSupplierMasterIdAndCurrencyPrecision(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return;
        }
        HashSet supplierIds = new HashSet(10);
        HashSet currencyIds = new HashSet(10);
        poInfoMap.values().forEach(coreBillInfo -> {
            supplierIds.add(coreBillInfo.getCoreBillReceiveSupplierId());
            currencyIds.add(coreBillInfo.getCoreBillSettleCurrency());
        });
        conmInfoMap.values().forEach(conmBillInfo -> {
            supplierIds.add(conmBillInfo.getConmReceiveSupplierId());
            currencyIds.add(conmBillInfo.getConmSettleCurrencyId());
        });
        Map supplierDB = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        Map currencyDB = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        if (supplierDB != null && !supplierDB.isEmpty()) {
            supplierDB.values().forEach(supplier -> supplierMasterIdMap.put(supplier.getLong("id"), supplier.getLong("masterid")));
        }
        if (currencyDB != null && !currencyDB.isEmpty()) {
            currencyDB.values().forEach(currency -> currencyPrecisionMap.put(currency.getLong("id"), currency.getInt("amtprecision")));
        }
    }

    private void filterByPoAndConmRelation(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return;
        }
        HashMap<Long, HashSet<Long>> conmIdAndPoIdsMap = new HashMap<Long, HashSet<Long>>(10);
        HashSet<Long> poIds = new HashSet<Long>(10);
        poInfoMap.values().forEach(poInfo -> poIds.add(poInfo.getCoreBillId()));
        if (!conmInfoMap.isEmpty()) {
            Set<Long> conmIds = conmInfoMap.keySet();
            DynamicObjectCollection purOrderEntrys = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("billentry.conbillid", "in", conmIds)});
            for (DynamicObject dynamicObject : purOrderEntrys) {
                poIds.add(dynamicObject.getLong("id"));
                Long conmBillId = dynamicObject.getLong("billentry.conbillid");
                if (conmBillId == null || conmBillId == 0L) continue;
                HashSet<Long> conmToOrderIds = (HashSet<Long>)conmIdAndPoIdsMap.get(conmBillId);
                if (conmToOrderIds == null) {
                    conmToOrderIds = new HashSet<Long>(16);
                    conmToOrderIds.add(dynamicObject.getLong("id"));
                    conmIdAndPoIdsMap.put(conmBillId, conmToOrderIds);
                    continue;
                }
                conmToOrderIds.add(dynamicObject.getLong("id"));
            }
            purOrderEntrys.clear();
        }
        HashMap<Long, HashSet<Long>> orderIdToConmIdsMap = new HashMap<Long, HashSet<Long>>(16);
        if (!poIds.isEmpty()) {
            DynamicObjectCollection purOrderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", poIds)});
            for (DynamicObject dynamicObject : purOrderBills) {
                Long orderId = dynamicObject.getLong("id");
                Long conmBillId = dynamicObject.getLong("billentry.conbillid");
                if (conmBillId == null || conmBillId == 0L) continue;
                Set<Long> conmIdSet = (Set)orderIdToConmIdsMap.get(orderId);
                if (conmIdSet == null) {
                    conmIdSet = new HashSet<Long>(16);
                    conmIdSet.add(conmBillId);
                    orderIdToConmIdsMap.put(orderId, (HashSet<Long>)conmIdSet);
                    continue;
                }
                conmIdSet.add(conmBillId);
            }
            purOrderBills.clear();
        }
        HashSet hadMultiConmsOrderId = new HashSet(16);
        if (!orderIdToConmIdsMap.isEmpty()) {
            for (Map.Entry entry : orderIdToConmIdsMap.entrySet()) {
                Set conIdSet;
                Long poId = (Long)entry.getKey();
                if (poId == null || poId == 0L || (conIdSet = (Set)entry.getValue()) == null || conIdSet.size() <= 1) continue;
                hadMultiConmsOrderId.add(entry.getKey());
            }
        }
        Iterator iterator = conmIdAndPoIdsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Set oneConmPoIds = (Set)entry.getValue();
            Long conmId = (Long)entry.getKey();
            if (oneConmPoIds == null || oneConmPoIds.isEmpty()) continue;
            for (Long orderId : hadMultiConmsOrderId) {
                if (!oneConmPoIds.contains(orderId)) continue;
                conmInfoMap.remove(conmId);
                iterator.remove();
            }
        }
        HashSet hashSet = new HashSet(10);
        conmIdAndPoIdsMap.values().forEach(poids -> ids.addAll(poids));
        Set allConmIds = conmIdAndPoIdsMap.keySet();
        Iterator<Map.Entry<String, POBillInfo>> poIt = poInfoMap.entrySet().iterator();
        while (poIt.hasNext()) {
            POBillInfo poBillInfo = poIt.next().getValue();
            if (poBillInfo == null) {
                poIt.remove();
                continue;
            }
            if (poBillInfo.getCoreBillSettleOrgId() != null && poBillInfo.getCoreBillReceiveSupplierId() != null && (hashSet.isEmpty() || hashSet.contains(poBillInfo.getCoreBillId()))) continue;
            poIt.remove();
        }
        Iterator<Map.Entry<Long, ConmBillInfo>> conmIt = conmInfoMap.entrySet().iterator();
        while (conmIt.hasNext()) {
            ConmBillInfo conmBillInfo = conmIt.next().getValue();
            if (conmBillInfo == null) {
                conmIt.remove();
                continue;
            }
            if (conmBillInfo.getConmReceiveSupplierId() != null && (allConmIds.isEmpty() || allConmIds.contains(conmBillInfo.getConmId()))) continue;
            conmIt.remove();
        }
        for (Map.Entry entry : conmIdAndPoIdsMap.entrySet()) {
            Long conmBillId = (Long)entry.getKey();
            Set poIdSet = (Set)entry.getValue();
            ConmBillInfo conmBillInfo = conmInfoMap.get(conmBillId);
            if (conmBillInfo != null) {
                conmBillInfo.setPoIds(poIdSet);
            }
            for (Map.Entry<String, POBillInfo> poBillInfoEntry : poInfoMap.entrySet()) {
                POBillInfo poBillInfo = poBillInfoEntry.getValue();
                if (poBillInfo == null) continue;
                Long poId = poBillInfo.getCoreBillId();
                if (poIdSet == null || !poIdSet.contains(poId)) continue;
                poBillInfo.setConmId(conmBillId);
            }
        }
    }

    private Map<Long, String> validConm(Map<Long, ConmBillInfo> conmInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashMap<Long, String> errorMsg = new HashMap<Long, String>(10);
        if (conmInfoMap.isEmpty()) {
            return errorMsg;
        }
        Iterator<Map.Entry<Long, ConmBillInfo>> iterator = conmInfoMap.entrySet().iterator();
        HashMap<Long, ConmBillInfo> checkTolerance = new HashMap<Long, ConmBillInfo>(10);
        while (iterator.hasNext()) {
            BigDecimal paidAmount;
            Map.Entry<Long, ConmBillInfo> next = iterator.next();
            ConmBillInfo conmBillInfo = next.getValue();
            Long conmId = next.getKey();
            Long conmReceiveSupplierId = conmBillInfo.getConmReceiveSupplierId();
            Long payBillPayeeId = conmBillInfo.getPayBillPayeeId();
            if (conmReceiveSupplierId == null || payBillPayeeId == null || conmReceiveSupplierId.compareTo(payBillPayeeId) != 0) continue;
            BigDecimal currentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
            BigDecimal conmAmount = conmBillInfo.getConmAmount() == null ? BigDecimal.ZERO : conmBillInfo.getConmAmount();
            BigDecimal bigDecimal = paidAmount = conmBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : conmBillInfo.getPaidAmount();
            if (conmAmount.compareTo(currentAmount.add(paidAmount)) >= 0) {
                conmBillInfo.setSuccess(Boolean.TRUE);
                continue;
            }
            checkTolerance.put(next.getKey(), conmBillInfo);
        }
        if (checkTolerance.isEmpty()) {
            return errorMsg;
        }
        Set<Long> overToleranceIds = this.conmProcessTolerance(checkTolerance, supplierMasterIdMap, currencyPrecisionMap);
        if (!overToleranceIds.isEmpty()) {
            for (Long overToleranceId : overToleranceIds) {
                ConmBillInfo conmBillInfo = (ConmBillInfo)checkTolerance.get(overToleranceId);
                errorMsg.put(conmBillInfo.getPayBillId(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff0c\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u91c7\u8d2d\u5408\u540c%2$s\u7684\u4ef7\u7a0e\u5408\u8ba1\uff0c\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurConmServiceImpl_4", (String)"scmc-conm-mservice", (Object[])new Object[0]), conmBillInfo.getPayBillNo(), conmBillInfo.getConmBillNo()));
            }
        }
        return errorMsg;
    }

    private Set<Long> conmProcessTolerance(Map<Long, ConmBillInfo> checkTolerance, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashSet<Long> overToleranceId = new HashSet<Long>(16);
        ArrayList params = new ArrayList(16);
        for (Map.Entry<Long, ConmBillInfo> next : checkTolerance.entrySet()) {
            ConmBillInfo conmBillInfo = next.getValue();
            Long conmId = next.getKey();
            Long conmReceiveSupplierId = conmBillInfo.getConmReceiveSupplierId();
            BigDecimal paidAmount = conmBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : conmBillInfo.getPaidAmount();
            BigDecimal currentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
            BigDecimal coreTotalAllAmount = conmBillInfo.getConmAmount() == null ? BigDecimal.ZERO : conmBillInfo.getConmAmount();
            Long conmSettleCurrency = conmBillInfo.getConmSettleCurrencyId() == null ? Long.valueOf(0L) : conmBillInfo.getConmSettleCurrencyId();
            Integer currencyPrecision = currencyPrecisionMap.get(conmBillInfo.getConmSettleCurrencyId()) == null ? Integer.valueOf(10) : currencyPrecisionMap.get(conmBillInfo.getConmSettleCurrencyId());
            HashMap<String, Number> param = new HashMap<String, Number>(10);
            param.put("pk", conmId);
            param.put("bd_supplier", supplierMasterIdMap.get(conmReceiveSupplierId));
            param.put("controlvalue", paidAmount.add(currentAmount));
            param.put("contrastvalue", coreTotalAllAmount);
            param.put("bd_currency", conmSettleCurrency);
            param.put("precision", currencyPrecision);
            params.add(param);
        }
        if (!params.isEmpty()) {
            Map results = null;
            results = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ToleranceMatchService", (String)"getAllResult", (Object[])new Object[]{"cas_paybill", "conm_purcontract", "e_payableamt", "totalallamount", params});
            List overpks = (List)results.get("overpks");
            List failtomatchIds = (List)results.get("failtomatch");
            if (overpks != null && !overpks.isEmpty()) {
                overToleranceId.addAll(overpks);
            }
            if (failtomatchIds != null && !failtomatchIds.isEmpty()) {
                for (Long conmIdfailToMatch : failtomatchIds) {
                    BigDecimal conmTotalAllAmount;
                    ConmBillInfo conmBillInfo = checkTolerance.get(conmIdfailToMatch);
                    BigDecimal paidAmount = conmBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : conmBillInfo.getPaidAmount();
                    BigDecimal currentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
                    BigDecimal bigDecimal = conmTotalAllAmount = conmBillInfo.getConmAmount() == null ? BigDecimal.ZERO : conmBillInfo.getConmAmount();
                    if (paidAmount.add(currentAmount).compareTo(conmTotalAllAmount) <= 0) continue;
                    overToleranceId.add(conmIdfailToMatch);
                }
            }
        }
        return overToleranceId;
    }

    private Map<Long, String> validPO(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashMap<Long, String> errorMsg = new HashMap<Long, String>(10);
        if (poInfoMap.isEmpty()) {
            return errorMsg;
        }
        Iterator<Map.Entry<String, POBillInfo>> iterator = poInfoMap.entrySet().iterator();
        HashMap<String, POBillInfo> checkTolerance = new HashMap<String, POBillInfo>(10);
        while (iterator.hasNext()) {
            BigDecimal currentPaidAmount;
            Map.Entry<String, POBillInfo> next = iterator.next();
            POBillInfo poBillInfo = next.getValue();
            BigDecimal paidAmount = poBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : poBillInfo.getPaidAmount();
            BigDecimal currentAmount = poBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : poBillInfo.getCurrentAmount();
            BigDecimal coreTotalAllAmount = poBillInfo.getCoreTotalAllAmount() == null ? BigDecimal.ZERO : poBillInfo.getCoreTotalAllAmount();
            if (coreTotalAllAmount.compareTo(currentPaidAmount = paidAmount.add(currentAmount)) >= 0) {
                poBillInfo.setSuccess(Boolean.TRUE);
                continue;
            }
            checkTolerance.put(next.getKey(), poBillInfo);
        }
        if (checkTolerance.isEmpty()) {
            return errorMsg;
        }
        Set<String> overToleranceId = this.processTolerance(checkTolerance, supplierMasterIdMap, currencyPrecisionMap);
        if (!overToleranceId.isEmpty()) {
            for (Map.Entry<String, POBillInfo> poBillInfoEntry : poInfoMap.entrySet()) {
                if (poBillInfoEntry == null) continue;
                String demKey = poBillInfoEntry.getKey();
                POBillInfo poBillInfo = poBillInfoEntry.getValue();
                if (overToleranceId.contains(demKey)) {
                    poBillInfo.setSuccess(Boolean.FALSE);
                    errorMsg.put(poBillInfo.getPayBillId(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff0c\u6309\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u91c7\u8d2d\u8ba2\u5355%2$s\u7684\u4ef7\u7a0e\u5408\u8ba1\uff0c\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurConmServiceImpl_5", (String)"scmc-conm-mservice", (Object[])new Object[0]), poBillInfo.getPayBillNo(), poBillInfo.getCoreBillNo()));
                    continue;
                }
                poBillInfo.setSuccess(Boolean.TRUE);
            }
        }
        return errorMsg;
    }

    private void filterByIsOverPayFlag(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, POBillInfo>> poIt = poInfoMap.entrySet().iterator();
        while (poIt.hasNext()) {
            POBillInfo poBillInfo = poIt.next().getValue();
            Boolean coreBillIsAllowOverPay = poBillInfo.getCoreBillIsAllowOverPay();
            if (!coreBillIsAllowOverPay.booleanValue()) continue;
            poIt.remove();
        }
        Iterator<Map.Entry<Long, ConmBillInfo>> conmIt = conmInfoMap.entrySet().iterator();
        while (conmIt.hasNext()) {
            ConmBillInfo conmBillInfo = conmIt.next().getValue();
            if (!conmBillInfo.getConmIsAllowOverPay().booleanValue()) continue;
            conmIt.remove();
        }
    }

    private void addPaidAmount(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return;
        }
        Map<String, Long> allConmDemKeyAndConmId = this.getAllConmDemKey(conmInfoMap);
        List<QFilter> filters = this.getQueryPayBillFilter(poInfoMap, conmInfoMap);
        try (DataSet payBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_paybill", (String)String.join((CharSequence)",", this.getQueryPayBillField()), (QFilter[])filters.toArray(new QFilter[0]), null);){
            DataSet sumPaidAmount = payBillDataSet.groupBy(new String[]{"corebillid", "settleorg", "payee"}).sum("e_payableamt-e_refundamt", "paidamount").finish().select("corebillid,settleorg,payee,paidamount");
            for (Row row : sumPaidAmount) {
                ConmBillInfo conmBillInfo;
                String conmValidDemKey;
                Long conmId;
                POBillInfo poBillInfo;
                Long coreBillId = row.getLong("corebillid");
                Long settleOrgId = row.getLong("settleorg");
                Long payee = row.getLong("payee");
                BigDecimal payBillPaidamount = row.getBigDecimal("paidamount") == null ? BigDecimal.ZERO : row.getBigDecimal("paidamount");
                String validDemKey = this.getValidDemKey(settleOrgId, coreBillId, payee);
                if (validDemKey != null && (poBillInfo = poInfoMap.get(validDemKey)) != null) {
                    BigDecimal paidAmount = poBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : poBillInfo.getPaidAmount();
                    poBillInfo.setPaidAmount(paidAmount.add(payBillPaidamount));
                }
                if ((conmId = allConmDemKeyAndConmId.get(conmValidDemKey = this.getConmValidDemKey(coreBillId, payee))) == null || (conmBillInfo = conmInfoMap.get(conmId)) == null) continue;
                BigDecimal conmPaidAmount = conmBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : conmBillInfo.getPaidAmount();
                conmBillInfo.setPaidAmount(conmPaidAmount.add(payBillPaidamount));
            }
        }
    }

    private Map<String, Long> getAllConmDemKey(Map<Long, ConmBillInfo> conmInfoMap) {
        if (conmInfoMap.isEmpty()) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> conmDemKey = new HashMap<String, Long>(conmInfoMap.size());
        for (ConmBillInfo conmBillInfo : conmInfoMap.values()) {
            Long conmId = conmBillInfo.getConmId();
            Long conmReceiveSupplierId = conmBillInfo.getConmReceiveSupplierId();
            conmDemKey.put(this.getConmValidDemKey(conmId, conmReceiveSupplierId), conmId);
            Set<Long> poIds = conmBillInfo.getPoIds();
            if (poIds == null || poIds.isEmpty()) continue;
            for (Long poId : poIds) {
                conmDemKey.put(this.getConmValidDemKey(poId, conmReceiveSupplierId), conmId);
            }
        }
        return conmDemKey;
    }

    private List<QFilter> getQueryPayBillFilter(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        Date earliestTime = this.getEarliestCreateTime(poInfoMap, conmInfoMap);
        HashSet<Long> allCoreBillIds = new HashSet<Long>(10);
        HashSet<Long> allReciSupplierIds = new HashSet<Long>(10);
        for (Map.Entry<String, POBillInfo> entry : poInfoMap.entrySet()) {
            POBillInfo poBillInfo = entry.getValue();
            allCoreBillIds.add(poBillInfo.getCoreBillId());
            allReciSupplierIds.add(poBillInfo.getCoreBillReceiveSupplierId());
        }
        for (ConmBillInfo conmBillInfo : conmInfoMap.values()) {
            allCoreBillIds.add(conmBillInfo.getConmId());
            Set<Long> poIds = conmBillInfo.getPoIds();
            if (poIds != null && !poIds.isEmpty()) {
                allCoreBillIds.addAll(poIds);
            }
            Long conmBillReceiveSupplierId = conmBillInfo.getConmReceiveSupplierId();
            allReciSupplierIds.add(conmBillInfo.getConmReceiveSupplierId());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("entry.e_corebillid", "in", allCoreBillIds));
        filters.add(new QFilter("billstatus", "not in", (Object)new String[]{"F", "G", "H", "A"}));
        if (earliestTime != null) {
            filters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getStartOfDay((Date)earliestTime)));
        }
        filters.add(new QFilter("payee", "in", allReciSupplierIds));
        return filters;
    }

    private Map<Long, ConmBillInfo> addConmInfo(Map<Long, ConmBillInfo> conmInfoMap, DataSet dataSet) {
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            ConmBillInfo conmBillInfo = conmInfoMap.get(id);
            if (conmBillInfo == null) continue;
            conmBillInfo.setConmBillNo(row.getString("billno"));
            conmBillInfo.setConmId(id);
            conmBillInfo.setConmAmount(row.getBigDecimal("billentry.amountandtax"));
            conmBillInfo.setConmCreateTime(row.getDate("createtime"));
            conmBillInfo.setConmIsAllowOverPay(row.getBoolean("isallowoverpay"));
            conmBillInfo.setConmSettleCurrencyId(row.getLong("settlecurrency"));
            conmBillInfo.setConmReceiveSupplierId(row.getLong("receivesupplier"));
        }
        return conmInfoMap;
    }

    private Map<String, POBillInfo> addPoInfo(Map<String, POBillInfo> poInfoMap, List<Map<String, Object>> queryPoInfo, Map<Long, ConmBillInfo> conmBillInfoMap) {
        for (Map<String, Object> poInfo : queryPoInfo) {
            Long poId = (Long)poInfo.get("billid");
            Boolean isallowoverpay = (Boolean)poInfo.get("isallowoverpay");
            Long settleCurrency = (Long)poInfo.get("settlecurrency");
            Long poReceivesupplier = poInfo.get("receivesupplier") == null ? Long.valueOf(0L) : (Long)poInfo.get("receivesupplier");
            Date createtime = (Date)poInfo.get("createtime");
            String coreBillNo = (String)poInfo.get("billno");
            List entryinfoList = (List)poInfo.get("entryinfo");
            if (entryinfoList == null || entryinfoList.isEmpty()) continue;
            for (Map poEntryInfo : entryinfoList) {
                Object conbillid;
                Long settleOrg = poEntryInfo.get("settleorg") == null ? Long.valueOf(0L) : (Long)poEntryInfo.get("settleorg");
                String validDemKey = this.getValidDemKey(settleOrg, poId, poReceivesupplier);
                BigDecimal amountandtax = poEntryInfo.get("amountandtax") == null ? BigDecimal.ZERO : (BigDecimal)poEntryInfo.get("amountandtax");
                POBillInfo poBillInfo = poInfoMap.get(validDemKey);
                if (poBillInfo != null) {
                    BigDecimal coreTotalAllAmount = poBillInfo.getCoreTotalAllAmount() == null ? BigDecimal.ZERO : poBillInfo.getCoreTotalAllAmount();
                    poBillInfo.setCoreTotalAllAmount(coreTotalAllAmount.add(amountandtax));
                    if (poBillInfo.getCoreBillNo() == null) {
                        poBillInfo.setCoreBillNo(coreBillNo);
                    }
                    if (poBillInfo.getCoreBillCreateTime() == null) {
                        poBillInfo.setCoreBillCreateTime(createtime);
                    }
                    if (poBillInfo.getCoreBillSettleCurrency() == null) {
                        poBillInfo.setCoreBillSettleCurrency(settleCurrency);
                    }
                    if (poBillInfo.getCoreBillReceiveSupplierId() == null) {
                        poBillInfo.setCoreBillReceiveSupplierId(poReceivesupplier);
                    }
                    if (poBillInfo.getCoreBillSettleOrgId() == null) {
                        poBillInfo.setCoreBillSettleOrgId(settleOrg);
                    }
                    if (poBillInfo.getCoreBillIsAllowOverPay() == null) {
                        poBillInfo.setCoreBillIsAllowOverPay(isallowoverpay);
                    }
                }
                if ((conbillid = poEntryInfo.get("conbillid")) == null) continue;
                ConmBillInfo conmBillInfo = new ConmBillInfo(poBillInfo.getPayBillId(), poBillInfo.getPayBillNo());
                conmBillInfoMap.put((Long)conbillid, conmBillInfo);
                conmBillInfo.setPayBillPayeeId(poBillInfo.getPayBillPayeeId());
            }
        }
        return poInfoMap;
    }

    private Map<Long, ConmBillInfo> getConmBillInfo(List<Map<String, Object>> payBills, Map<Long, Set<Long>> queryConmIds) {
        HashMap<Long, ConmBillInfo> conmInfoMap = new HashMap<Long, ConmBillInfo>(10);
        for (Map<String, Object> payBill : payBills) {
            if (payBill == null) continue;
            Long payBillId = (Long)payBill.get("id");
            String payBillNo = (String)payBill.get("billno");
            Long payee = (Long)payBill.get("payee");
            List payBillEntry = (List)payBill.get("entry");
            if (payBillEntry == null || payBillEntry.isEmpty()) continue;
            for (Map payBillRow : payBillEntry) {
                String coreBillEntity = (String)payBillRow.get("e_corebilltype");
                if (coreBillEntity == null || !"conm_purcontract".equals(coreBillEntity)) continue;
                Long coreBillId = (Long)payBillRow.get("e_corebillid");
                BigDecimal payableAmt = (BigDecimal)payBillRow.get("e_payableamt");
                BigDecimal refundAmt = (BigDecimal)payBillRow.get("e_refundamt");
                Long settleOrgId = 0L;
                Object settleorg = payBillRow.get("settleorg");
                if (settleorg != null) {
                    Long l = settleOrgId = settleorg instanceof DynamicObject ? (Long)((DynamicObject)settleorg).getPkValue() : (Long)settleorg;
                }
                if (coreBillId == 0L || payableAmt == null || refundAmt == null || settleOrgId == 0L) continue;
                String conmvalidDemKey = this.getConmValidDemKey(coreBillId, payee);
                ConmBillInfo conmBillInfo = (ConmBillInfo)conmInfoMap.get(coreBillId);
                if (conmBillInfo == null) {
                    conmBillInfo = new ConmBillInfo(payBillId, payBillNo);
                }
                BigDecimal currentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
                conmBillInfo.setCurrentAmount(currentAmount.add(payableAmt.subtract(refundAmt)));
                if (conmBillInfo.getPayBillPayeeId() == null) {
                    conmBillInfo.setPayBillPayeeId(payee);
                }
                if (conmBillInfo.getPayBillSettleOrgId() == null) {
                    conmBillInfo.setPayBillSettleOrgId(settleOrgId);
                }
                conmInfoMap.put(coreBillId, conmBillInfo);
                queryConmIds.put(coreBillId, new HashSet(1));
            }
        }
        return conmInfoMap;
    }

    private Map<String, POBillInfo> getPOBillInfo(List<Map<String, Object>> payBills, Map<Long, Set<Long>> queryPoIds) {
        HashMap<String, POBillInfo> coreBillDemAndPayAmountMap = new HashMap<String, POBillInfo>(10);
        for (Map<String, Object> payBill : payBills) {
            if (payBill == null) continue;
            Long payBillId = (Long)payBill.get("id");
            String payBillNo = (String)payBill.get("billno");
            Long payee = (Long)payBill.get("payee");
            List payBillEntry = (List)payBill.get("entry");
            if (payBillEntry == null || payBillEntry.isEmpty()) continue;
            for (Map payBillRow : payBillEntry) {
                String coreBillEntity = (String)payBillRow.get("e_corebilltype");
                if (coreBillEntity == null || !"pm_purorderbill".equals(coreBillEntity)) continue;
                Long coreBillId = (Long)payBillRow.get("e_corebillid");
                BigDecimal payableAmt = (BigDecimal)payBillRow.get("e_payableamt");
                BigDecimal refundAmt = (BigDecimal)payBillRow.get("e_refundamt");
                Long settleOrgId = 0L;
                Object settleorg = payBillRow.get("settleorg");
                if (settleorg != null) {
                    Long l = settleOrgId = settleorg instanceof DynamicObject ? (Long)((DynamicObject)settleorg).getPkValue() : (Long)settleorg;
                }
                if (coreBillId == 0L || payableAmt == null || refundAmt == null || settleOrgId == 0L) continue;
                String validDemKey = this.getValidDemKey(settleOrgId, coreBillId, payee);
                POBillInfo coreBillInfo = (POBillInfo)coreBillDemAndPayAmountMap.get(validDemKey);
                if (coreBillInfo == null) {
                    coreBillInfo = new POBillInfo(payBillId, payBillNo);
                }
                BigDecimal currentAmount = coreBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCurrentAmount();
                coreBillInfo.setCurrentAmount(currentAmount.add(payableAmt.subtract(refundAmt)));
                if (coreBillInfo.getPayBillId() == null) {
                    coreBillInfo.setPayBillId(payBillId);
                }
                if (coreBillInfo.getPayBillNo() == null) {
                    coreBillInfo.setPayBillNo(payBillNo);
                }
                if (coreBillInfo.getCoreBillId() == null) {
                    coreBillInfo.setCoreBillId(coreBillId);
                }
                if (coreBillInfo.getPayBillNo() == null) {
                    coreBillInfo.setPayBillNo(payBillNo);
                }
                if (coreBillInfo.getPayBillPayeeId() == null) {
                    coreBillInfo.setPayBillPayeeId(payee);
                }
                if (coreBillInfo.getPayBillSettleOrgId() == null) {
                    coreBillInfo.setPayBillSettleOrgId(settleOrgId);
                }
                coreBillDemAndPayAmountMap.put(validDemKey, coreBillInfo);
                queryPoIds.put(coreBillId, new HashSet(1));
            }
        }
        return coreBillDemAndPayAmountMap;
    }

    private Map<String, BigDecimal> queryPayBillPaidAMount(Set<Long> coreBillIds, Date earliestCreateTime, Set<Long> receiveSupplierId) {
        HashMap<String, BigDecimal> coreBillDemKeyPaidAmount = new HashMap<String, BigDecimal>(10);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("entry.e_corebillid", "in", coreBillIds));
        filters.add(new QFilter("billstatus", "not in", (Object)new String[]{"F", "G", "H", "A"}));
        if (earliestCreateTime != null) {
            filters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getStartOfDay((Date)earliestCreateTime)));
        }
        filters.add(new QFilter("payee", "in", receiveSupplierId));
        List<String> queryFields = this.getQueryPayBillField();
        String selectStr = String.join((CharSequence)",", queryFields);
        try (DataSet payBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_paybill", (String)selectStr, (QFilter[])filters.toArray(new QFilter[0]), null);){
            DataSet sumPaidAmount = payBillDataSet.groupBy(new String[]{"corebillid", "settleorg", "payee"}).sum("e_payableamt-e_refundamt", "paidamount").finish().select("corebillid,settleorg,payee,paidamount");
            for (Row row : sumPaidAmount) {
                Long coreBillId = row.getLong("corebillid");
                Long settleOrgId = row.getLong("settleorg");
                Long payee = row.getLong("payee");
                BigDecimal paidamount = row.getBigDecimal("paidamount");
                coreBillDemKeyPaidAmount.put(this.getValidDemKey(settleOrgId, coreBillId, payee), paidamount);
            }
        }
        return coreBillDemKeyPaidAmount;
    }

    private Date getEarliestCreateTime(Map<String, POBillInfo> poBillInfoMap, Map<Long, ConmBillInfo> conmBillInfoMap) {
        Date earliestCreateTime = null;
        for (POBillInfo coreBillInfo : poBillInfoMap.values()) {
            Long coreBillId = coreBillInfo.getCoreBillId();
            Long conmId = coreBillInfo.getConmId();
            Date coreBillCreateTime = coreBillInfo.getCoreBillCreateTime();
            if (coreBillCreateTime == null) continue;
            if (earliestCreateTime == null) {
                earliestCreateTime = coreBillCreateTime;
            }
            if (!coreBillCreateTime.before(earliestCreateTime)) continue;
            earliestCreateTime = coreBillCreateTime;
        }
        for (ConmBillInfo conmBillInfo : conmBillInfoMap.values()) {
            Date conmCreateTime = conmBillInfo.getConmCreateTime();
            if (conmCreateTime == null || earliestCreateTime == null || !conmCreateTime.before(earliestCreateTime)) continue;
            earliestCreateTime = conmCreateTime;
        }
        return earliestCreateTime;
    }

    private Set<String> processTolerance(Map<String, POBillInfo> poBillInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashSet<String> overToleranceId = new HashSet<String>(16);
        ArrayList params = new ArrayList(16);
        for (Map.Entry<String, POBillInfo> next : poBillInfoMap.entrySet()) {
            POBillInfo coreBillInfo = next.getValue();
            String key = next.getKey();
            BigDecimal paidAmount = coreBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : coreBillInfo.getPaidAmount();
            BigDecimal currentAmount = coreBillInfo.getCurrentAmount();
            BigDecimal coreTotalAllAmount = coreBillInfo.getCoreTotalAllAmount();
            HashMap<String, Object> param = new HashMap<String, Object>(10);
            param.put("pk", key);
            param.put("bd_supplier", supplierMasterIdMap.get(coreBillInfo.getCoreBillReceiveSupplierId()));
            param.put("controlvalue", paidAmount.add(currentAmount));
            param.put("contrastvalue", coreTotalAllAmount);
            param.put("bd_currency", coreBillInfo.getCoreBillSettleCurrency());
            param.put("precision", currencyPrecisionMap.get(coreBillInfo.getCoreBillSettleCurrency()));
            param.put("bos_org", coreBillInfo.getCoreBillSettleOrgId());
            params.add(param);
        }
        if (!params.isEmpty()) {
            Map results = null;
            results = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ToleranceMatchService", (String)"getAllResult", (Object[])new Object[]{"cas_paybill", "pm_purorderbill", "e_payableamt", "totalallamount", params});
            List overpks = (List)results.get("overpks");
            List failtomatch = (List)results.get("failtomatch");
            if (overpks != null && !overpks.isEmpty()) {
                overToleranceId.addAll(overpks);
            }
            if (failtomatch != null && !failtomatch.isEmpty()) {
                for (String failMatch : failtomatch) {
                    BigDecimal coreTotalAllAmount;
                    POBillInfo coreBillInfo = poBillInfoMap.get(failMatch);
                    BigDecimal paidAmount = coreBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : coreBillInfo.getPaidAmount();
                    BigDecimal currentAmount = coreBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCurrentAmount();
                    BigDecimal bigDecimal = coreTotalAllAmount = coreBillInfo.getCoreTotalAllAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCoreTotalAllAmount();
                    if (paidAmount.add(currentAmount).compareTo(coreTotalAllAmount) <= 0) continue;
                    overToleranceId.add(failMatch);
                }
            }
        }
        return overToleranceId;
    }

    private List<String> getQueryPayBillField() {
        ArrayList<String> keys = new ArrayList<String>(10);
        keys.add("entry.e_corebillid as corebillid");
        keys.add("entry.settleorg as settleorg");
        keys.add("entry.e_payableamt as e_payableamt");
        keys.add("entry.e_refundamt as e_refundamt");
        keys.add("payee");
        return keys;
    }

    private List<Map<String, Object>> getValidPayBills(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> payBills = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> param : params) {
            Long payee;
            if (param == null || param.isEmpty() || (payee = (Long)param.get("payee")) == null || payee == 0L) continue;
            boolean hasCoreBillInfo = false;
            List payBillEntry = (List)param.get("entry");
            if (payBillEntry == null || payBillEntry.isEmpty()) continue;
            for (Map payBillRow : payBillEntry) {
                Long coreBillId;
                String coreBillEntity = (String)payBillRow.get("e_corebilltype");
                if (coreBillEntity == null || !"pm_purorderbill".equals(coreBillEntity) && !"conm_purcontract".equals(coreBillEntity) || (coreBillId = (Long)payBillRow.get("e_corebillid")) == null || coreBillId == 0L) continue;
                hasCoreBillInfo = true;
                break;
            }
            if (!hasCoreBillInfo) continue;
            payBills.add(param);
        }
        return payBills;
    }

    private String getValidDemKey(Long settleOrgId, Long billId, Long recSupplierId) {
        if (settleOrgId == null || billId == null || recSupplierId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(settleOrgId).append('_').append(billId).append('_').append(recSupplierId);
        return sb.toString();
    }

    private String getConmValidDemKey(Long billId, Long recSupplierId) {
        if (billId == null || recSupplierId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(billId).append('_').append(recSupplierId);
        return sb.toString();
    }

    static class ConmBillInfo {
        private Boolean isSuccess;
        private String payBillNo;
        private Long payBillId;
        private BigDecimal currentAmount;
        private BigDecimal paidAmount;
        private Long payBillSettleOrgId;
        private Long payBillPayeeId;
        private Date conmCreateTime;
        private Boolean conmIsAllowOverPay;
        private BigDecimal conmAmount;
        private Long conmId;
        private String conmBillNo;
        private Long conmReceiveSupplierId;
        private Long conmSettleCurrencyId;
        private Set<Long> poIds;

        public ConmBillInfo(Long payBillId, String payBillNo) {
            this.payBillNo = payBillNo;
            this.payBillId = payBillId;
        }

        public Set<Long> getPoIds() {
            return this.poIds;
        }

        public String getConmBillNo() {
            return this.conmBillNo;
        }

        public Long getConmSettleCurrencyId() {
            return this.conmSettleCurrencyId;
        }

        public void setConmSettleCurrencyId(Long conmSettleCurrencyId) {
            this.conmSettleCurrencyId = conmSettleCurrencyId;
        }

        public void setConmBillNo(String conmBillNo) {
            this.conmBillNo = conmBillNo;
        }

        public void setPoIds(Set<Long> poIds) {
            this.poIds = poIds;
        }

        public Boolean getSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(Boolean success) {
            this.isSuccess = success;
        }

        public String getPayBillNo() {
            return this.payBillNo;
        }

        public void setPayBillNo(String payBillNo) {
            this.payBillNo = payBillNo;
        }

        public Long getPayBillId() {
            return this.payBillId;
        }

        public void setPayBillId(Long payBillId) {
            this.payBillId = payBillId;
        }

        public BigDecimal getCurrentAmount() {
            return this.currentAmount;
        }

        public void setCurrentAmount(BigDecimal currentAmount) {
            this.currentAmount = currentAmount;
        }

        public BigDecimal getPaidAmount() {
            return this.paidAmount;
        }

        public void setPaidAmount(BigDecimal paidAmount) {
            this.paidAmount = paidAmount;
        }

        public Long getPayBillSettleOrgId() {
            return this.payBillSettleOrgId;
        }

        public void setPayBillSettleOrgId(Long payBillSettleOrgId) {
            this.payBillSettleOrgId = payBillSettleOrgId;
        }

        public Long getPayBillPayeeId() {
            return this.payBillPayeeId;
        }

        public void setPayBillPayeeId(Long payBillPayeeId) {
            this.payBillPayeeId = payBillPayeeId;
        }

        public Date getConmCreateTime() {
            return this.conmCreateTime;
        }

        public void setConmCreateTime(Date conmCreateTime) {
            this.conmCreateTime = conmCreateTime;
        }

        public Boolean getConmIsAllowOverPay() {
            return this.conmIsAllowOverPay;
        }

        public void setConmIsAllowOverPay(Boolean conmIsAllowOverPay) {
            this.conmIsAllowOverPay = conmIsAllowOverPay;
        }

        public BigDecimal getConmAmount() {
            return this.conmAmount;
        }

        public void setConmAmount(BigDecimal conmAmount) {
            this.conmAmount = conmAmount;
        }

        public Long getConmId() {
            return this.conmId;
        }

        public void setConmId(Long conmId) {
            this.conmId = conmId;
        }

        public Long getConmReceiveSupplierId() {
            return this.conmReceiveSupplierId;
        }

        public void setConmReceiveSupplierId(Long conmReceiveSupplierId) {
            this.conmReceiveSupplierId = conmReceiveSupplierId;
        }
    }

    static class POBillInfo {
        private Boolean isSuccess;
        private String payBillNo;
        private Long payBillId;
        private BigDecimal currentAmount;
        private BigDecimal paidAmount;
        private Long payBillSettleOrgId;
        private Long payBillPayeeId;
        private Long coreBillId;
        private Long coreBillSettleOrgId;
        private Long coreBillReceiveSupplierId;
        private String coreBillNo;
        private Long coreBillSettleCurrency;
        private BigDecimal coreTotalAllAmount;
        private Date coreBillCreateTime;
        private Boolean coreBillIsAllowOverPay;
        private Long conmId;

        public POBillInfo(Long payBillId, String payBillNo) {
            this.payBillId = payBillId;
            this.payBillNo = payBillNo;
        }

        public Long getPayBillSettleOrgId() {
            return this.payBillSettleOrgId;
        }

        public void setPayBillSettleOrgId(Long payBillSettleOrgId) {
            this.payBillSettleOrgId = payBillSettleOrgId;
        }

        public Long getPayBillPayeeId() {
            return this.payBillPayeeId;
        }

        public void setPayBillPayeeId(Long payBillPayeeId) {
            this.payBillPayeeId = payBillPayeeId;
        }

        public Boolean getSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(Boolean success) {
            this.isSuccess = success;
        }

        public Long getPayBillId() {
            return this.payBillId;
        }

        public Long getCoreBillSettleCurrency() {
            return this.coreBillSettleCurrency;
        }

        public void setCoreBillSettleCurrency(Long coreBillSettleCurrency) {
            this.coreBillSettleCurrency = coreBillSettleCurrency;
        }

        public Date getCoreBillCreateTime() {
            return this.coreBillCreateTime;
        }

        public void setCoreBillCreateTime(Date coreBillCreateTime) {
            this.coreBillCreateTime = coreBillCreateTime;
        }

        public void setPayBillId(Long payBillId) {
            this.payBillId = payBillId;
        }

        public Long getCoreBillReceiveSupplierId() {
            return this.coreBillReceiveSupplierId;
        }

        public void setCoreBillReceiveSupplierId(Long coreBillReceiveSupplierId) {
            this.coreBillReceiveSupplierId = coreBillReceiveSupplierId;
        }

        public String getPayBillNo() {
            return this.payBillNo;
        }

        public Boolean getCoreBillIsAllowOverPay() {
            return this.coreBillIsAllowOverPay;
        }

        public void setCoreBillIsAllowOverPay(Boolean coreBillIsAllowOverPay) {
            this.coreBillIsAllowOverPay = coreBillIsAllowOverPay;
        }

        public void setPayBillNo(String payBillNo) {
            this.payBillNo = payBillNo;
        }

        public BigDecimal getCurrentAmount() {
            return this.currentAmount;
        }

        public void setCurrentAmount(BigDecimal currentAmount) {
            this.currentAmount = currentAmount;
        }

        public BigDecimal getPaidAmount() {
            return this.paidAmount;
        }

        public void setPaidAmount(BigDecimal paidAmount) {
            this.paidAmount = paidAmount;
        }

        public Long getCoreBillId() {
            return this.coreBillId;
        }

        public void setCoreBillId(Long coreBillId) {
            this.coreBillId = coreBillId;
        }

        public String getCoreBillNo() {
            return this.coreBillNo;
        }

        public void setCoreBillNo(String coreBillNo) {
            this.coreBillNo = coreBillNo;
        }

        public BigDecimal getCoreTotalAllAmount() {
            return this.coreTotalAllAmount;
        }

        public void setCoreTotalAllAmount(BigDecimal coreTotalAllAmount) {
            this.coreTotalAllAmount = coreTotalAllAmount;
        }

        public Long getCoreBillSettleOrgId() {
            return this.coreBillSettleOrgId;
        }

        public void setCoreBillSettleOrgId(Long coreBillSettleOrgId) {
            this.coreBillSettleOrgId = coreBillSettleOrgId;
        }

        public Long getConmId() {
            return this.conmId;
        }

        public void setConmId(Long conmId) {
            this.conmId = conmId;
        }
    }
}

