/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.DefaultEcServiceIdempotentPropHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.scmc.conm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.conm.business.service.writeback.SalWriteServiceExecutor;
import kd.scmc.conm.mservice.api.SalConmService;

public class SalConmServiceImpl
extends BaseECService
implements SalConmService,
IdempotentService {
    private static final Log log = LogFactory.getLog(SalConmServiceImpl.class);
    private static final TrackLogService trackLog = new TrackLogService(SalConmServiceImpl.class, "conm");

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentPropHelper.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        trackLog.startInfo(JSON.toJSONString((Object)param));
        CommonDtxResponse response = new CommonDtxResponse();
        response.put((Object)"success", (Object)Boolean.TRUE);
        if (param instanceof CommonParam) {
            CommonParam commonParam = (CommonParam)param;
            String wbSalContAr = (String)commonParam.get((Object)"method");
            List mapList = (List)commonParam.get((Object)"list");
            if (StringUtils.isNotEmpty((String)wbSalContAr)) {
                switch (wbSalContAr) {
                    case "wbSalContAr": {
                        this.wbSalContAr(mapList);
                        break;
                    }
                    case "wbSalContAmount": {
                        this.wbSalContAmount(mapList);
                    }
                }
            }
        }
        trackLog.endInfo(JSON.toJSONString((Object)response));
        return response;
    }

    @Deprecated
    public boolean WbPreRecAmount(List<Map<String, Object>> list) {
        log.info("(\u9884)\u6536\u6b3e\u5355\u53cd\u5199\u6536\u6b3e\u8ba1\u5212\u5b9e\u6536\u91d1\u989d,\u5355\u5934\u7d2f\u8ba1\u9884\u6536\u91d1\u989d,\u5165\u53c2\uff1a" + JSON.toJSONString(list));
        if (list == null || list.size() <= 0) {
            log.error("(\u9884)\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        Set ids = list.stream().map(a -> a.get("sourcepk")).collect(Collectors.toSet());
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"conm_salcontract").getDynamicObjectType());
        if (loads == null || loads.length == 0) {
            log.error("(\u9884)\u6536\u6b3e\u5355\u53cd\u5199\u6536\u6b3e\u8ba1\u5212\u9500\u552e\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e2d\u7684\u9500\u552e\u5408\u540cID(sourcepk)\u4e0d\u5b58\u5728:-->" + JSON.toJSONString(ids));
            return false;
        }
        for (Map<String, Object> map : list) {
            Long mainBillId = (Long)map.get("sourcepk");
            Long entryId = (Long)map.get("sourceentrypk");
            BigDecimal paidAmount = (BigDecimal)map.get("amount");
            if (mainBillId == null || mainBillId == 0L || entryId == 0L || paidAmount == null) {
                return false;
            }
            block1: for (DynamicObject load : loads) {
                if (mainBillId.compareTo((Long)load.getPkValue()) != 0) continue;
                Long currencypk = (Long)map.get("currencyid");
                DynamicObject settlecurrency = load.getDynamicObject("settlecurrency");
                DynamicObject exchangerate = load.getDynamicObject("exchangerate");
                if (settlecurrency == null || exchangerate == null || currencypk == null || paidAmount.compareTo(BigDecimal.ZERO) == 0) {
                    log.error("\u91d1\u989d\u6362\u7b97\u5931\u8d25\uff01");
                    return false;
                }
                if ((long)Long.compare((Long)settlecurrency.getPkValue(), currencypk) != 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u9500\u552e\u5408\u540c\u65f6\uff0c\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"SalConmServiceImpl_0", (String)"scmc-conm-mservice", (Object[])new Object[0]));
                }
                DynamicObjectCollection planDy = load.getDynamicObjectCollection("payentry");
                for (DynamicObject row : planDy) {
                    if (row.getLong("id") != entryId.longValue()) continue;
                    BigDecimal amount = row.getBigDecimal("paidamount");
                    row.set("paidamount", (Object)amount.add(paidAmount));
                    load.set("prereceiptamount", (Object)load.getBigDecimal("prereceiptamount").add(paidAmount));
                    continue block1;
                }
            }
            Object[] objectArray = SaveServiceHelper.save((DynamicObject[])loads);
        }
        return true;
    }

    @Deprecated
    public boolean WbRecAmount(List<Map<String, Object>> list) {
        log.info("\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u5408\u540c\u5355\u5934\u4e0a\u7684\u5df2\u6536\u91d1\u989d\u63a5\u53e3,\u5165\u53c2\uff1a" + JSON.toJSONString(list));
        if (list == null || list.size() <= 0) {
            log.error("\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        Set ids = list.stream().map(a -> a.get("mainbillid")).collect(Collectors.toSet());
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"conm_salcontract").getDynamicObjectType());
        if (loads == null || loads.length == 0) {
            log.error("\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u5408\u540c\u63a5\u53e3\u53c2\u6570\u4e2d\u7684\u5408\u540cID(mainbillid)\u4e0d\u5b58\u5728:-->" + JSON.toJSONString(ids));
            return false;
        }
        for (Map<String, Object> map : list) {
            Long mainBillId = (Long)map.get("mainbillid");
            BigDecimal paidAmount = (BigDecimal)map.get("paidamount");
            Long currencypk = (Long)map.get("currencyid");
            if (mainBillId == null || paidAmount == null) {
                log.error("\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u5408\u540c ,mainbillid\u6216paidamount\u4e3a\u7a7a");
                return false;
            }
            for (DynamicObject load : loads) {
                if (mainBillId.compareTo((Long)load.getPkValue()) != 0) continue;
                DynamicObject settlecurrency = load.getDynamicObject("settlecurrency");
                DynamicObject exratetable = load.getDynamicObject("exratetable");
                if (settlecurrency == null || exratetable == null || currencypk == null) {
                    log.error("\u91d1\u989d\u6362\u7b97\u5931\u8d25\uff01");
                    return false;
                }
                if ((long)Long.compare((Long)settlecurrency.getPkValue(), currencypk) != 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u9500\u552e\u5408\u540c\u65f6\uff0c\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"SalConmServiceImpl_0", (String)"scmc-conm-mservice", (Object[])new Object[0]));
                }
                BigDecimal oldPaidAmount = load.getBigDecimal("receiptallamount");
                if (oldPaidAmount == null) {
                    oldPaidAmount = BigDecimal.ZERO;
                }
                load.set("receiptallamount", (Object)oldPaidAmount.add(paidAmount));
            }
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])loads);
        log.info("\u6536\u6b3e\u5355\u53cd\u5199\u9500\u552e\u5408\u540c\u6210\u529f\u7684\u6709:-->" + JSON.toJSONString(Arrays.stream(save).map(a -> ((DynamicObject)a).getString("billno")).collect(Collectors.toList())));
        return true;
    }

    public void wbSalContAr(List<Map<String, Object>> list) {
        trackLog.startInfo(JSON.toJSONString(list));
        if (list != null && list.size() > 0) {
            ArrayList<Map<String, Object>> contractInfo = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> mainBillInfo = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> orderBillInfo = new ArrayList<Map<String, Object>>();
            HashMap<Long, DynamicObject> contractMap = new HashMap<Long, DynamicObject>();
            String orderEntity = "sm_salorder";
            String defaultContractEntity = "conm_salcontract";
            for (Map<String, Object> map : list) {
                Long contractId = (Long)map.get("conbillid");
                Long contractEntryId = (Long)map.get("conbillentryid");
                if (contractId != null && contractEntryId != null && 0L != contractId && 0L != contractEntryId) {
                    contractInfo.add(map);
                    continue;
                }
                String mainEnityType = (String)map.get("arMainBillEntity");
                if (defaultContractEntity.equalsIgnoreCase(mainEnityType)) {
                    mainBillInfo.add(map);
                    continue;
                }
                if (!orderEntity.equalsIgnoreCase(mainEnityType)) continue;
                orderBillInfo.add(map);
            }
            this.dealWithContractInfo(contractInfo, contractMap);
            this.dealWithMainBillInfo(mainBillInfo, contractMap);
            this.dealWithOrderBillInfo(orderBillInfo, contractMap);
            if (!contractMap.isEmpty()) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(contractMap.size());
                for (DynamicObject entry : contractMap.values()) {
                    Object[] obj = new Object[]{entry.getBigDecimal("billentry.joinpriceqty"), entry.getBigDecimal("billentry.joinpricebaseqty"), entry.getBigDecimal("billentry.aramount"), entry.getLong("billentry.id")};
                    paramList.add(obj);
                    this.excessWarning(entry);
                }
                String string = "update t_conm_salcontractentry_r set fjoinpriceqty = ?,fjoinpricebaseqty = ? ,faramount = ? where fentryid = ?";
                trackLog.info("prepare to update contract data,sql=" + string + ",param=" + JSON.toJSONString(paramList));
                if (paramList.size() > 0) {
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)string, paramList);
                    }
                    catch (Exception e) {
                        trackLog.error(e.getMessage());
                        throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u9500\u552e\u5408\u540c\u65f6\uff0c\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25\u3002", (String)"SalConmServiceImpl_3", (String)"scmc-conm-mservice", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void wbSalContAmount(List<Map<String, Object>> list) {
        if (list != null && list.size() > 0) {
            new SalWriteServiceExecutor().execute(list);
        }
    }

    private void dealWithOrderBillInfo(List<Map<String, Object>> orderBillInfo, Map<Long, DynamicObject> contractMap) {
        trackLog.info("deal main bill is order scene:" + JSON.toJSONString(orderBillInfo));
        String orderEntity = "sm_salorder";
        HashSet<Long> orderEntryIds = new HashSet<Long>(orderBillInfo.size());
        for (Map<String, Object> orderInfo : orderBillInfo) {
            Long orderEntryId = (Long)orderInfo.get("soentryid");
            orderEntryIds.add(orderEntryId);
        }
        if (orderEntryIds.size() > 0) {
            HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>();
            DynamicObjectCollection orderBillEntry = QueryServiceHelper.query((String)orderEntity, (String)"billentry.id,billentry.conbillentity,billentry.conbillid,billentry.conbillentryid,billentry.srcbillentity,billentry.srcbillid,billentry.srcbillentryid", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", orderEntryIds)});
            for (DynamicObject entry : orderBillEntry) {
                orderEntryMap.put(entry.getLong("billentry.id"), entry);
            }
            String contractEntity = "conm_salcontract";
            ArrayList<Map<String, Object>> contractInfos = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> orderInfo : orderBillInfo) {
                Long contractEntryId = (Long)orderInfo.get("soentryid");
                DynamicObject orderEntry = (DynamicObject)orderEntryMap.get(contractEntryId);
                if (orderEntry == null) continue;
                String conbillentity = orderEntry.getString("billentry.conbillentity");
                Long conbillid = orderEntry.getLong("billentry.conbillid");
                Long conbillentryid = orderEntry.getLong("billentry.conbillentryid");
                if (StringUtils.isNotEmpty((String)conbillentity) && conbillid != null && Long.compare(conbillid, 0L) != 0 && conbillentryid != null && Long.compare(conbillentryid, 0L) != 0) {
                    orderInfo.put("conbillid", conbillid);
                    orderInfo.put("conbillentryid", conbillentryid);
                    contractInfos.add(orderInfo);
                    trackLog.info("write back with order's contrct information where contractId is " + conbillid + " and contract entryid is " + conbillentryid);
                    continue;
                }
                String srcbillentity = orderEntry.getString("billentry.srcbillentity");
                Long srcbillid = orderEntry.getLong("billentry.srcbillid");
                Long srcbillentryid = orderEntry.getLong("billentry.srcbillentryid");
                if (!StringUtils.isNotEmpty((String)srcbillentity) || !contractEntity.equalsIgnoreCase(srcbillentity) || srcbillid == null || Long.compare(srcbillid, 0L) == 0 || srcbillentryid == null || Long.compare(srcbillentryid, 0L) == 0) continue;
                orderInfo.put("conbillid", srcbillid);
                orderInfo.put("conbillentryid", srcbillentryid);
                contractInfos.add(orderInfo);
                trackLog.info("write back with order's source bill ,where order's source bill type is contract and source bill's id is " + srcbillid + " and source bill's entryId is" + srcbillentryid);
            }
            this.dealWithContractInfo(contractInfos, contractMap);
        }
    }

    private void dealWithMainBillInfo(List<Map<String, Object>> mainBillInfo, Map<Long, DynamicObject> contractMap) {
        trackLog.info("write back where main bill type is contract: " + JSON.toJSONString(mainBillInfo));
        if (mainBillInfo != null && mainBillInfo.size() > 0) {
            for (Map<String, Object> info : mainBillInfo) {
                Long contractId = (Long)info.get("soid");
                Long contractEntryId = (Long)info.get("soentryid");
                info.put("conbillid", contractId);
                info.put("conbillentryid", contractEntryId);
                trackLog.info("write back where mian bill type is contract and main bill'id is " + contractId + " and main bill entry'id is " + contractEntryId);
            }
            this.dealWithContractInfo(mainBillInfo, contractMap);
        }
    }

    private void dealWithContractInfo(List<Map<String, Object>> contractInfo, Map<Long, DynamicObject> contractMap) {
        if (contractInfo != null && contractInfo.size() > 0) {
            DynamicObjectCollection billentry;
            String contractEntity = "conm_salcontract";
            HashSet<Long> contractEntryIds = new HashSet<Long>();
            Set<Long> ids = contractMap.keySet();
            for (Map<String, Object> map : contractInfo) {
                Long conbillentryid = (Long)map.get("conbillentryid");
                trackLog.info("prepare to write back's contract entry ids is " + conbillentryid);
                if (ids.contains(conbillentryid)) continue;
                contractEntryIds.add(conbillentryid);
            }
            if (contractEntryIds.size() > 0 && (billentry = QueryServiceHelper.query((String)contractEntity, (String)"customer,billentry.id,billentry.material.masterid,billentry.unit,billentry.baseunit,billentry.entrysettleorg,billentry.joinpriceqty,billentry.joinpricebaseqty,billentry.aramount,billentry.baseqty,billentry.amountandtax", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", contractEntryIds)})) != null) {
                for (DynamicObject entry : billentry) {
                    if (contractMap.containsKey(entry.getPkValue())) continue;
                    contractMap.put(entry.getLong("billentry.id"), entry);
                }
            }
            int size = contractMap.size();
            HashSet<Long> hashSet = new HashSet<Long>(size);
            HashSet<Long> unitIds = new HashSet<Long>(size);
            for (DynamicObject entry : contractMap.values()) {
                hashSet.add(entry.getLong("billentry.material.masterid"));
                unitIds.add(entry.getLong("billentry.unit"));
                unitIds.add(entry.getLong("billentry.baseunit"));
            }
            QFilter materialFilter = new QFilter("id", "in", hashSet);
            QFilter unitFilter = new QFilter("id", "in", unitIds);
            Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])materialFilter.toArray(), null);
            Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id, precision, precisionaccount", (QFilter[])unitFilter.toArray(), null);
            for (Map<String, Object> verifyInfo : contractInfo) {
                Long contractEntryId = (Long)verifyInfo.get("conbillentryid");
                Long arsettleorgid = (Long)verifyInfo.get("arsettleorgid");
                BigDecimal baseqty = (BigDecimal)verifyInfo.get("baseqty");
                BigDecimal amount = (BigDecimal)verifyInfo.get("amount");
                DynamicObject entry = contractMap.get(contractEntryId);
                trackLog.warn("contract entry id equals " + contractEntryId + " is " + (entry == null ? "not exist" : "exist"));
                if (entry == null) continue;
                Long entryId = entry.getLong("billentry.id");
                Long entrysettleorg = entry.getLong("billentry.entrysettleorg");
                if (contractEntryId.compareTo(entryId) != 0 || arsettleorgid.compareTo(entrysettleorg) != 0) continue;
                BigDecimal joinpriceqty = entry.getBigDecimal("billentry.joinpriceqty");
                BigDecimal joinpricebaseqty = entry.getBigDecimal("billentry.joinpricebaseqty");
                BigDecimal aramount = entry.getBigDecimal("billentry.aramount");
                Long material = entry.getLong("billentry.material.masterid");
                Long baseunit = entry.getLong("billentry.baseunit");
                Long unit = entry.getLong("billentry.unit");
                DynamicObject materialObj = (DynamicObject)materialMap.get(material);
                DynamicObject unitObj = (DynamicObject)unitMap.get(unit);
                DynamicObject baseUnitObj = (DynamicObject)unitMap.get(baseunit);
                BigDecimal verifyQty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)baseUnitObj, (BigDecimal)joinpricebaseqty.add(baseqty), (DynamicObject)unitObj);
                trackLog.info("before update database snopshot is { billentryid=" + entryId + ",joinpriceqty=" + joinpriceqty.toPlainString() + ",joinpricebaseqty=" + joinpricebaseqty.toPlainString() + ",aramount=" + aramount.toPlainString() + " }");
                entry.set("billentry.joinpriceqty", (Object)verifyQty);
                entry.set("billentry.joinpricebaseqty", (Object)joinpricebaseqty.add(baseqty));
                entry.set("billentry.aramount", (Object)aramount.add(amount));
                trackLog.info("after update database snopshot is { billentryid=" + entryId + ",joinpriceqty=" + entry.getBigDecimal("billentry.joinpriceqty").toPlainString() + ",joinpricebaseqty=" + entry.getBigDecimal("billentry.joinpricebaseqty").toPlainString() + ",aramount=" + entry.getBigDecimal("billentry.aramount").toPlainString() + " }");
            }
        }
    }

    private void excessWarning(DynamicObject entry) {
        BigDecimal joinPriceBaseQty = entry.getBigDecimal("billentry.joinpricebaseqty");
        BigDecimal arAmount = entry.getBigDecimal("billentry.aramount");
        BigDecimal amountAndTax = entry.getBigDecimal("billentry.amountandtax");
        BigDecimal baseQty = entry.getBigDecimal("billentry.baseqty");
        Long entryId = entry.getLong("billentry.id");
        if (joinPriceBaseQty.compareTo(baseQty) > 0) {
            trackLog.warn("contractEntryId:" + entryId + ",joinPriceBaseQty[" + joinPriceBaseQty.toPlainString() + "] is greater than baseQty[" + baseQty.toPlainString() + "]");
        }
        if (joinPriceBaseQty.compareTo(BigDecimal.ZERO) < 0) {
            trackLog.warn("contractEntryId:" + entryId + ",joinPriceBaseQty[" + joinPriceBaseQty.toPlainString() + "] is less than zero");
        }
        if (arAmount.compareTo(amountAndTax) > 0) {
            trackLog.warn("contractEntryId:" + entryId + ",arAmount[" + arAmount.toPlainString() + "] is greater than amountAndTax[" + amountAndTax.toPlainString() + "]");
        }
        if (arAmount.compareTo(BigDecimal.ZERO) < 0) {
            trackLog.warn("contractEntryId:" + entryId + ",arAmount[" + arAmount.toPlainString() + "] is less than zero");
        }
    }
}

