/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice.blockchain;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BlockChainConmPreinsdataImpl {
    private static final DBRoute blockChainRoute = new DBRoute("sys.bc");
    private static final DBRoute eventDbRoute = new DBRoute("wfs");
    private static final Log log = LogFactory.getLog(BlockChainConmPreinsdataImpl.class);

    public void BlockChainDataPreins() throws IOException {
        ArrayList<String> blockChainList = new ArrayList<String>(8);
        blockChainList.add("resources/blockchain/kd_1.5.110_conm_preinsert_data_bea_mapping.sql");
        blockChainList.add("resources/blockchain/kd_1.5.110_conm_preinsert_data_bea_task.sql");
        blockChainList.add("resources/blockchain/kd_1.5.110_conm_preinsert_data_bea_task_mapping.sql");
        Boolean isUpdate = QueryServiceHelper.exists((String)"bea_mapping", (Object)1239803265994986496L);
        if (!isUpdate.booleanValue()) {
            this.insertDB(blockChainList, blockChainRoute);
        }
        ArrayList<String> eventList = new ArrayList<String>(8);
        eventList.add("resources/blockchain/kd_1.5.110_conm_preinsert_data_evt_event.sql");
        eventList.add("resources/blockchain/kd_1.5.110_conm_preinsert_data_evt_subscription.sql");
        isUpdate = QueryServiceHelper.exists((String)"evt_event", (Object)1244036086179590144L);
        if (!isUpdate.booleanValue()) {
            this.insertDB(eventList, eventDbRoute);
        }
    }

    private void insertDB(List<String> pathList, DBRoute dbRoute) throws IOException {
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                for (String path : pathList) {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    if (classLoader == null) continue;
                    InputStream inputStream = classLoader.getResourceAsStream(path);
                    Throwable throwable = null;
                    try {
                        if (inputStream == null) continue;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        Throwable throwable2 = null;
                        try {
                            String str;
                            while ((str = bufferedReader.readLine()) != null) {
                                if (StringUtils.isBlank((String)str)) continue;
                                this.execute(dbRoute, str);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (bufferedReader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            bufferedReader.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
            catch (Throwable e) {
                h.markRollback();
                log.error("preinsdata failed! " + e);
                throw e;
            }
        }
    }

    private void execute(DBRoute dbRoute, String str) {
        DB.execute((DBRoute)dbRoute, (String)str);
    }
}

