/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PurConAttachCountUpgradePlugin
implements IUpgradeService {
    private static final int PAGE_SIZE = 2000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c\u9644\u4ef6\u6570\u5df2\u5347\u7ea7\u5b8c\u6210\u3002", (String)"PurConAttachCountUpgradePlugin_0", (String)"scmc-conm-mservice", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        DBRoute purdbRoute = new DBRoute("scm");
        DBRoute basedataRoute = new DBRoute("basedata");
        try {
            String sqlAll = "select fid from t_conm_purcontract";
            DataSet totalData = DB.queryDataSet((String)"PurConAttachCountUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)purdbRoute, (String)sqlAll, (Object[])null);
            DataSet mainSet = totalData.select("cast(fid as String) fid");
            String sql1 = "select finterid,count(finterid) count from t_bas_attachment where fbilltype = 'conm_purcontract' group by finterid";
            DataSet basAttach = DB.queryDataSet((String)"PurConAttachCountUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)basedataRoute, (String)sql1, null);
            DataSet tempDataset = mainSet.join(basAttach, JoinType.LEFT).on("fid", "finterid").select(new String[]{"fid", "count"}).finish();
            String sql2 = "select fid, count(fid)  collacount from t_conm_purcontractaentry  group by fid";
            DataSet collaAttach = DB.queryDataSet((String)"PurConAttachCountUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)purdbRoute, (String)sql2, null);
            collaAttach = collaAttach.select(new String[]{"cast(fid as String) fid", "collacount"});
            DataSet rows = tempDataset.join(collaAttach, JoinType.LEFT).on("fid", "fid").select(new String[]{"fid", "count", "collacount"}).finish();
            HashMap countMap = new HashMap();
            ArrayList idList = new ArrayList(16);
            rows.forEach(rowx -> {
                if (rowx.getString("fid") != null) {
                    if (rowx.getInteger("count") != null) {
                        idList.add(rowx.getString("fid"));
                        countMap.put(rowx.getString("fid"), rowx.getInteger("count"));
                    }
                    if (rowx.getInteger("collacount") != null) {
                        idList.add(rowx.getString("fid"));
                        countMap.put(rowx.getString("fid"), rowx.getInteger("collacount"));
                    }
                    if (rowx.getInteger("count") != null && rowx.getInteger("collacount") != null) {
                        idList.add(rowx.getString("fid"));
                        countMap.put(rowx.getString("fid"), rowx.getInteger("count") + rowx.getInteger("collacount"));
                    }
                    if (rowx.getInteger("count") == null && rowx.getInteger("collacount") == null) {
                        idList.add(rowx.getString("fid"));
                        countMap.put(rowx.getString("fid"), 0);
                    }
                }
            });
            int count = idList.size();
            int totalPages = count / 2000;
            if (count % 2000 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List subIdList = (pageIndex + 1) * 2000 > idList.size() ? idList.subList(pageIndex * 2000, idList.size()) : idList.subList(pageIndex * 2000, (pageIndex + 1) * 2000);
                if (subIdList.isEmpty()) continue;
                ArrayList<Object[]> parms = new ArrayList<Object[]>(subIdList.size());
                for (String fid : subIdList) {
                    Object[] parm = new Object[]{countMap.get(fid), Long.parseLong(fid)};
                    parms.add(parm);
                }
                this.updateData(purdbRoute, parms);
            }
        }
        catch (Exception e) {
            pProcessInfo.append(e.getMessage());
            return false;
        }
        return true;
    }

    private void updateData(DBRoute dbRoute, List<Object[]> parms) {
        DB.executeBatch((DBRoute)dbRoute, (String)"update t_conm_purcontract set fattchmentcount = ? where fid = ?", parms);
    }
}

