/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;

public class PurContractAllOrderAmountUpGrade
implements IUpgradeService {
    private Log logger = LogFactory.getLog(PurContractAllOrderAmountUpGrade.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.logger.info("syn UpGrade PurContract AllOrderAmount");
        if (StringUtils.isEmpty((CharSequence)sqlFileName)) {
            DataSet contract = DB.queryDataSet((String)"conm_allorderamount_update_1", (DBRoute)new DBRoute("scm"), (String)"select f.fid as id,f.fsettlecurrencyid as settlecurrency, f.fexchangerate as exchangerate from t_conm_purcontract_f f inner join t_conm_purcontract t on f.fid= t.fid where t.fvalidstatus = 'B' and (f.forderallamount =0 or f.forderallamount is null)");
            DataSet order = DB.queryDataSet((String)"conm_allorderamount_update_2", (DBRoute)new DBRoute("scm"), (String)"select p.fbillno as billno, p.fid as pid , p.fsettlecurrencyid as psettlecurrency ,p.fexchangerate as pexchangerate ,r.fsrcbillid as srcbillid ,e.famountandtax as amountandtax from t_pm_purorderbill p inner join t_pm_purorderbillentry e on p.fid = e.fid inner join t_pm_purorderbillentry_r r on r.fentryid = e.fentryid where r.fsrcbillentity = 'conm_purcontract' and p.fbillstatus = 'C'");
            DataSet contract_order = contract.join(order, JoinType.INNER).on("id", "srcbillid").select(new String[]{"id", "settlecurrency", "exchangerate"}, new String[]{"pid", "amountandtax", "psettlecurrency", "pexchangerate"}).finish();
            DataSet sameCurrency_contract_order = contract_order.copy().filter("settlecurrency = psettlecurrency").groupBy(new String[]{"id"}).sum("amountandtax").finish();
            DataSet diffCurrency_contract_order = contract_order.filter("settlecurrency != psettlecurrency").groupBy(new String[]{"id", "exchangerate", "pid", "pexchangerate"}).sum("amountandtax").finish();
            diffCurrency_contract_order = diffCurrency_contract_order.select(new String[]{"id", "case when exchangerate !=0 then amountandtax*pexchangerate/exchangerate else amountandtax*pexchangerate end amountandtax"}).groupBy(new String[]{"id"}).sum("amountandtax").finish();
            DataSet finallyData = sameCurrency_contract_order.union(diffCurrency_contract_order).groupBy(new String[]{"id"}).sum("amountandtax").finish();
            this.updateData(finallyData);
        } else {
            DataSet contract = DB.queryDataSet((String)"conm_allorderamount_update_3", (DBRoute)new DBRoute("scm"), (String)"select f.fid as id from t_conm_purcontract_f f inner join t_conm_purcontract t on f.fid= t.fid where t.fvalidstatus = 'B' and (f.forderallamount =0 or f.forderallamount is null)");
            DataSet order = DB.queryDataSet((String)"conm_allorderamount_update_4", (DBRoute)new DBRoute("scm"), (String)"select p.fid as pid ,r.fsrcbillid as srcbillid ,e.famountandtax as amountandtax from t_pm_purorderbill p inner join t_pm_purorderbillentry e on p.fid = e.fid inner join t_pm_purorderbillentry_r r on r.fentryid = e.fentryid where r.fsrcbillentity = 'conm_purcontract' and p.fbillstatus = 'C'");
            DataSet contract_order = contract.join(order, JoinType.INNER).on("id", "srcbillid").select(new String[]{"id"}, new String[]{"amountandtax"}).finish();
            DataSet finallyData = contract_order.groupBy(new String[]{"id"}).sum("amountandtax").finish();
            this.updateData(finallyData);
        }
        return result;
    }

    private void updateData(DataSet data) {
        int batchNum = 5000;
        ArrayList<Object[]> param = new ArrayList<Object[]>(batchNum);
        ArrayList threadTask = new ArrayList();
        while (data.hasNext()) {
            Row row = data.next();
            BigDecimal bigDecimal = row.getBigDecimal("amountandtax");
            Long id = row.getLong("id");
            if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
            Object[] obj = new Object[]{bigDecimal, id};
            param.add(obj);
            if (param.size() < batchNum && data.hasNext()) continue;
            ArrayList<Object[]> tempList = new ArrayList<Object[]>();
            tempList.addAll(param);
            threadTask.add(tempList);
            param.clear();
        }
        for (List list : threadTask) {
            this.submit(list);
        }
    }

    private void submit(final List<Object[]> datas) {
        ThreadPools.executeOnce((String)"conm_threadpools", (Runnable)new Runnable(){

            @Override
            public void run() {
                String sql = "update t_conm_purcontract_f set forderallamount = ? where fid = ?";
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, (List)datas);
            }
        });
    }
}

