/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.conm.business.helper.CurrencyHelper;
import kd.scmc.conm.enums.DiscountTypeEnum;
import kd.scmc.conm.enums.ExChangeTypeEnum;

public class AmountHelper {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;

    @Deprecated
    public static void setExChangeRate(IDataModel model, String fieldName, Object newValue) {
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        DynamicObject exRateTable = (DynamicObject)model.getValue("exratetable");
        Date bizTime = (Date)model.getValue("exratedate");
        String exchangeType = (String)model.getValue("exchangetype");
        switch (fieldName) {
            case "currency": {
                currency = (DynamicObject)newValue;
                break;
            }
            case "settlecurrency": {
                settleCurrency = (DynamicObject)newValue;
                break;
            }
            case "exratetable": {
                exRateTable = (DynamicObject)newValue;
                break;
            }
            case "exratedate": {
                bizTime = (Date)newValue;
                break;
            }
        }
        if (settleCurrency == null || exRateTable == null || bizTime == null) {
            model.setValue("exchangerate", null);
        }
        if (currency != null && settleCurrency != null && exRateTable != null && bizTime != null) {
            if (exchangeType != null) {
                model.setValue("exchangerate", (Object)CurrencyHelper.getExRate((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), bizTime, exchangeType));
            } else {
                Map<String, Object> exchangeRateMap = CurrencyHelper.getExchangeRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), bizTime);
                if (exchangeRateMap != null && exchangeRateMap.size() > 0) {
                    BigDecimal exrateRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
                    Boolean quoteType = (Boolean)exchangeRateMap.get("quoteType");
                    exchangeType = quoteType != null && quoteType == false ? ExChangeTypeEnum.DIRECTRATE.getValue() : ExChangeTypeEnum.INDIRECTRATE.getValue();
                    model.setValue("exchangerate", (Object)exrateRate);
                    model.setValue("exchangetype", (Object)exchangeType);
                }
            }
        }
    }

    public static void setAmount(IDataModel model, int rowIndex) {
        AmountHelper.setAmount(model, rowIndex, Boolean.FALSE);
    }

    public static void setAmount(IDataModel model, int rowIndex, Boolean isCalDiscountRate) {
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        BigDecimal hundred = new BigDecimal(100);
        taxRate = taxRate != null ? taxRate.divide(hundred) : ZERO;
        Boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal taxAmout = ZERO;
        BigDecimal amount = ZERO;
        int precision = 10;
        DynamicObject currency = (DynamicObject)model.getValue("settlecurrency");
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
            discountRate = BigDecimal.ZERO;
            discountAmount = (BigDecimal)model.getValue("discountamount", rowIndex);
        }
        if (isTax.booleanValue() && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
            price = priceAndTax.divide(ONE.add(taxRate), 10, 4);
            if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                if (discountRate != null) {
                    discountRate = discountRate.divide(hundred);
                }
                if (discountRate != null && priceAndTax != null) {
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(precision, RoundingMode.HALF_UP);
                    amountAndTax = BigDecimal.ONE.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(precision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(precision, RoundingMode.HALF_UP);
                }
            } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                discountAmount = qty.multiply(discountRate).setScale(precision, RoundingMode.HALF_UP);
                if (priceAndTax != null) {
                    amountAndTax = priceAndTax.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(precision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(precision, RoundingMode.HALF_UP);
                }
            } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                if (discountAmount == null) {
                    discountAmount = BigDecimal.ZERO;
                }
                discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                if (priceAndTax != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                    discountRate = discountAmount.divide(qty, 10, 4);
                    amountAndTax = qty.multiply(priceAndTax).setScale(precision, 4);
                    amountAndTax = amountAndTax.subtract(discountAmount);
                    model.beginInit();
                    model.setValue("discountrate", (Object)discountRate, rowIndex);
                    model.endInit();
                }
            } else {
                amountAndTax = qty.multiply(priceAndTax).setScale(precision, RoundingMode.HALF_UP);
            }
            taxAmout = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(precision, RoundingMode.HALF_UP);
            amount = amountAndTax.subtract(taxAmout).setScale(precision, RoundingMode.HALF_UP);
            model.beginInit();
            model.setValue("price", (Object)price, rowIndex);
            model.endInit();
        } else if (!isTax.booleanValue() && price != null && price.compareTo(ZERO) != 0) {
            priceAndTax = price.multiply(ONE.add(taxRate));
            if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                if (discountRate != null) {
                    discountRate = discountRate.divide(hundred);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(precision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).multiply(ONE.subtract(discountRate)).setScale(precision, RoundingMode.HALF_UP);
                }
            } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate)).setScale(precision, RoundingMode.HALF_UP);
                amount = qty.multiply(price.subtract(discountRate)).setScale(precision, RoundingMode.HALF_UP);
            } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                if (discountAmount == null) {
                    discountAmount = BigDecimal.ZERO;
                }
                discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                if (price != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                    discountRate = discountAmount.divide(qty, 10, 4).divide(ONE.add(taxRate), 10, 4);
                    amount = qty.multiply(price.subtract(discountRate)).setScale(precision, 4);
                    model.beginInit();
                    model.setValue("discountrate", (Object)discountRate, rowIndex);
                    model.endInit();
                }
            } else {
                amount = qty.multiply(price).setScale(precision, RoundingMode.HALF_UP);
            }
            taxAmout = amount.multiply(taxRate).setScale(precision, RoundingMode.HALF_UP);
            amountAndTax = amount.add(taxAmout).setScale(precision, RoundingMode.HALF_UP);
            model.beginInit();
            model.setValue("priceandtax", (Object)priceAndTax, rowIndex);
            model.endInit();
        } else {
            priceAndTax = ZERO;
            price = ZERO;
            model.beginInit();
            model.setValue("priceandtax", (Object)priceAndTax, rowIndex);
            model.setValue("price", (Object)price, rowIndex);
            model.endInit();
        }
        model.beginInit();
        model.setValue("discountamount", (Object)discountAmount, rowIndex);
        model.endInit();
        model.setValue("amountandtax", (Object)amountAndTax, rowIndex);
        model.setValue("taxamount", (Object)taxAmout, rowIndex);
        model.setValue("amount", (Object)amount, rowIndex);
        DynamicObject currencyObj = (DynamicObject)model.getValue("currency");
        int currencyPrecision = 10;
        if (currencyObj != null) {
            currencyPrecision = currencyObj.getInt("amtprecision");
        }
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        String exchangeType = (String)model.getValue("exchangetype");
        BigDecimal curTaxAmout = ZERO;
        BigDecimal curAmountAndTax = ZERO;
        BigDecimal curAmount = ZERO;
        if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0) {
            curTaxAmout = AmountHelper.getCurAmountByRate(taxAmout, exChangeRate, currencyPrecision, exchangeType);
            if (isTax.booleanValue()) {
                curAmountAndTax = AmountHelper.getCurAmountByRate(amountAndTax, exChangeRate, currencyPrecision, exchangeType);
                curAmount = curAmountAndTax.subtract(curTaxAmout);
            } else {
                curAmount = AmountHelper.getCurAmountByRate(amount, exChangeRate, currencyPrecision, exchangeType);
                curAmountAndTax = curAmount.add(curTaxAmout);
            }
        }
        model.setValue("curamountandtax", (Object)curAmountAndTax, rowIndex);
        model.setValue("curtaxamount", (Object)curTaxAmout, rowIndex);
        model.setValue("curamount", (Object)curAmount, rowIndex);
    }

    public static Map<String, BigDecimal> getAmount(DynamicObject bill, DynamicObject entryRow) {
        if (entryRow == null || bill == null) {
            return null;
        }
        BigDecimal qty = entryRow.getBigDecimal("qty");
        BigDecimal price = entryRow.getBigDecimal("price");
        BigDecimal priceAndTax = entryRow.getBigDecimal("priceandtax");
        BigDecimal taxRate = entryRow.getBigDecimal("taxrate");
        String discountType = entryRow.getString("discounttype");
        BigDecimal discountRate = entryRow.getBigDecimal("discountrate");
        boolean isTax = bill.getBoolean("istax");
        Map<String, Object> res4P = CurrencyHelper.get4P(bill);
        DynamicObject settleCurrency = (DynamicObject)res4P.get("settlecurrency");
        int settlePrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        int settlePricePrecision = 10;
        BigDecimal ZERO = BigDecimal.ZERO;
        BigDecimal ONE = BigDecimal.ONE;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal bigDecimal = taxRate = taxRate == null ? ZERO : taxRate.divide(hundred).setScale(10, 4);
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (discountRate == null || StringUtils.isEmpty((String)discountType) || discountType.equals("NULL") || discountRate.compareTo(ZERO) == 0) {
                if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                    price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP);
                    taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = amountAndTax.subtract(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if (price != null && price.compareTo(ZERO) != 0) {
                    priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).setScale(settlePrecision, RoundingMode.HALF_UP);
                    taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
            } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                if ("A".equals(discountType)) {
                    discountRate = discountRate.divide(hundred).setScale(10, 4);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = BigDecimal.ONE.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if ("B".equals(discountType) || "C".equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = priceAndTax.compareTo(discountRate) == 0 ? qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            } else if (price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
                if ("A".equals(discountType)) {
                    discountRate = discountRate.divide(hundred, 10, 4);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).setScale(settlePrecision, RoundingMode.HALF_UP).multiply(ONE.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if ("B".equals(discountType) || "C".equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            }
        }
        BigDecimal exChangeRate = (BigDecimal)res4P.get("exchangerate");
        DynamicObject currency = (DynamicObject)res4P.get("currency");
        String exchangeType = (String)res4P.get("exchangetype");
        BigDecimal curAmount = BigDecimal.ZERO;
        BigDecimal curTaxAmount = BigDecimal.ZERO;
        BigDecimal curAmountAndTax = BigDecimal.ZERO;
        int currencyPrecision = 10;
        if (currency != null) {
            currencyPrecision = currency.getInt("amtprecision");
        }
        if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0) {
            curTaxAmount = AmountHelper.getCurAmountByRate(taxAmount, exChangeRate, currencyPrecision, exchangeType);
            if (isTax) {
                curAmountAndTax = AmountHelper.getCurAmountByRate(amountAndTax, exChangeRate, currencyPrecision, exchangeType);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = AmountHelper.getCurAmountByRate(amount, exChangeRate, currencyPrecision, exchangeType);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
        }
        map.put("curamount", curAmount);
        map.put("curtaxamount", curTaxAmount);
        map.put("curamountandtax", curAmountAndTax);
        map.put("price", price);
        map.put("priceandtax", priceAndTax);
        map.put("discountamount", discountAmount);
        map.put("amount", amount);
        map.put("taxamount", taxAmount);
        map.put("amountandtax", amountAndTax);
        return map;
    }

    public static Map<String, BigDecimal> getHeadAmount(DynamicObject bill, int[] rowIndexs, BigDecimal sign) {
        BigDecimal totalTaxAmount = bill.getBigDecimal("totaltaxamount");
        BigDecimal totalAmount = bill.getBigDecimal("totalamount");
        BigDecimal totalAllAmount = bill.getBigDecimal("totalallamount");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int seq : rowIndexs) {
            DynamicObject row = (DynamicObject)entrys.get(seq);
            BigDecimal taxAmount = row.getBigDecimal("taxamount");
            BigDecimal amount = row.getBigDecimal("amount");
            BigDecimal amountAndTax = row.getBigDecimal("amountandtax");
            totalTaxAmount = totalTaxAmount.subtract(taxAmount.multiply(sign));
            totalAmount = totalAmount.subtract(amount.multiply(sign));
            totalAllAmount = totalAllAmount.subtract(amountAndTax.multiply(sign));
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("totalamount", totalAmount);
        map.put("totalallamount", totalAllAmount);
        map.put("totaltaxamount", totalTaxAmount);
        return map;
    }

    public static void changeTotalAmount(ChangeData data, IDataModel model, String headFieldName) {
        BigDecimal balance = AmountHelper.getBalance(data);
        BigDecimal origin = (BigDecimal)model.getValue(headFieldName);
        origin = origin.add(balance);
        model.setValue(headFieldName, (Object)origin);
    }

    public static BigDecimal getBalance(ChangeData changeData) {
        BigDecimal newAmount = BigDecimal.ZERO;
        BigDecimal oldAmount = BigDecimal.ZERO;
        if (changeData.getNewValue() != null) {
            newAmount = (BigDecimal)changeData.getNewValue();
        }
        if (changeData.getOldValue() != null) {
            oldAmount = (BigDecimal)changeData.getOldValue();
        }
        return newAmount.subtract(oldAmount);
    }

    public static Map<String, String> getProFiles() {
        HashMap<String, String> proFilesMap = new HashMap<String, String>();
        proFilesMap.put("entrynum", "payentry");
        proFilesMap.put("totalallamount", "totalallamount");
        proFilesMap.put("amount", "payamount");
        proFilesMap.put("rate", "payrate");
        proFilesMap.put("settlecurrency", "settlecurrency");
        proFilesMap.put("ispayrate", "ispayrate");
        proFilesMap.put("changetype", "payentrychangetype");
        return proFilesMap;
    }

    public static CommonContext getContext() {
        Map<String, String> proFilesMap = AmountHelper.getProFiles();
        CommonContext context = CommonContext.get();
        Map properytMapping = context.getProperytMapping();
        properytMapping.putAll(proFilesMap);
        return context;
    }

    public static void getAmountPlan(IFormView view) {
        CommonContext context = AmountHelper.getContext();
        AmountPlanHelper.calAmountPlanForView((CommonContext)context, (IFormView)view);
    }

    public static BigDecimal getCurAmountByRate(BigDecimal amount, BigDecimal exChangeRate, int currencyPrecision, String exChangeType) {
        BigDecimal curAmount = BigDecimal.ZERO;
        if (amount == null) {
            return curAmount;
        }
        if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
            return curAmount;
        }
        curAmount = exChangeType != null && ExChangeTypeEnum.INDIRECTRATE.getValue().equals(exChangeType) ? amount.divide(exChangeRate, currencyPrecision, RoundingMode.HALF_UP) : amount.multiply(exChangeRate).setScale(currencyPrecision, RoundingMode.HALF_UP);
        return curAmount;
    }

    public static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, String changeTypeField) {
        HashMap<String, String> fieldMapping = new HashMap<String, String>(8);
        fieldMapping.put("totalamount", "amount");
        fieldMapping.put("totaltaxamount", "taxamount");
        fieldMapping.put("totalallamount", "amountandtax");
        fieldMapping.put("curtotalamount", "curamount");
        fieldMapping.put("curtotalallamount", "curamountandtax");
        return AmountHelper.calcTotalAmount(bill, fieldMapping, changeTypeField);
    }

    private static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, Map<String, String> fieldMapping, String changeTypeField) {
        HashMap<String, BigDecimal> calcResult = new HashMap<String, BigDecimal>(8);
        DynamicObjectType billType = bill.getDynamicObjectType();
        Map<String, String> filteredMapping = AmountHelper.mappingFilter(billType, fieldMapping);
        if (filteredMapping.isEmpty()) {
            return calcResult;
        }
        for (String headField : filteredMapping.keySet()) {
            calcResult.put(headField, BigDecimal.ZERO);
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.isEmpty()) {
            return calcResult;
        }
        DynamicObjectType entryType = ((DynamicObject)entry.get(0)).getDynamicObjectType();
        Map<String, DynamicProperty> entryFieldProperties = AmountHelper.getEntryFieldProperties(entryType, filteredMapping);
        if (entryFieldProperties.isEmpty()) {
            return calcResult;
        }
        DynamicProperty changeTypeProp = entryType.getProperty(changeTypeField);
        for (DynamicObject row : entry) {
            if (changeTypeProp != null && ChangeTypeEnum.isCancel((String)((String)changeTypeProp.getValueFast((Object)row)))) continue;
            for (Map.Entry<String, DynamicProperty> propertyEntry : entryFieldProperties.entrySet()) {
                String headKey = propertyEntry.getKey();
                calcResult.put(headKey, ((BigDecimal)calcResult.get(headKey)).add(BigDecimalUtil.getNotNull((Object)propertyEntry.getValue().getValueFast((Object)row))));
            }
        }
        return calcResult;
    }

    private static Map<String, String> mappingFilter(DynamicObjectType billType, Map<String, String> fieldMapping) {
        HashMap<String, String> filteredMapping = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            String key = entry.getKey();
            if (billType.getProperty(key) == null) continue;
            filteredMapping.put(key, entry.getValue());
        }
        return filteredMapping;
    }

    private static Map<String, DynamicProperty> getEntryFieldProperties(DynamicObjectType entryType, Map<String, String> filteredMapping) {
        HashMap<String, DynamicProperty> entryFieldProperties = new HashMap<String, DynamicProperty>(8);
        for (Map.Entry<String, String> entry : filteredMapping.entrySet()) {
            DynamicProperty property = entryType.getProperty(entry.getValue());
            if (property == null) continue;
            entryFieldProperties.put(entry.getKey(), property);
        }
        return entryFieldProperties;
    }
}

