/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BizAppHelper {
    private static final Log logger = LogFactory.getLog(BizAppHelper.class);

    public static AppInfo getBizAppByFormId(String formId) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        if (formConfig == null || formConfig.getAppId() == null) {
            return null;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)formConfig.getAppId());
        return appInfo;
    }

    public static String getBizAppOrgFuncByFormId(String formId) {
        AppInfo appInfo = BizAppHelper.getBizAppByFormId(formId);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getOrgFunc();
    }

    public static boolean isDeployApp(String appNum) {
        if (StringUtils.isEmpty((CharSequence)appNum)) {
            return false;
        }
        String appSplit = System.getProperty("appSplit");
        logger.info(ResManager.loadKDString((String)("appSplit\u53c2\u6570\uff1a" + appSplit), (String)"", (String)"", (Object[])new Object[0]));
        if ("true".equals(appSplit)) {
            String registedAppIds = System.getProperty("registedAppIds");
            logger.info(ResManager.loadKDString((String)("registedAppIds\u53c2\u6570\uff1a" + registedAppIds), (String)"", (String)"", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((CharSequence)registedAppIds)) {
                String[] split;
                for (String appNumber : split = registedAppIds.split(",")) {
                    if (!appNum.equals(appNumber.trim())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

