/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.utils.MetadataUtils;

public class CustomerHelper {
    public static Long getLinkman(DynamicObject customer) {
        if (customer == null) {
            return null;
        }
        DynamicObject customerLinkMans = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)"bd_customer");
        DynamicObjectCollection linkmans = customerLinkMans.getDynamicObjectCollection("entry_linkman");
        Long customerLinkmanId = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return (Long)linkman.getPkValue();
            }
            if (customerLinkmanId != null || invalid) continue;
            customerLinkmanId = (Long)linkman.getPkValue();
        }
        return customerLinkmanId;
    }

    public static Set<Long> getAllLinkMans(DynamicObject customer) {
        HashSet<Long> ids = new HashSet<Long>(8);
        if (customer == null) {
            return ids;
        }
        if (!MetadataUtils.checkProperty((DynamicObject)customer, (String)"entry_linkman")) {
            customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)"bd_customer");
        }
        DynamicObjectCollection linkmans = customer.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject linkman : linkmans) {
            boolean invalid = linkman.getBoolean("invalid");
            if (invalid) continue;
            ids.add((Long)linkman.getPkValue());
        }
        return ids;
    }

    public static DynamicObject getLinkmanObject(DynamicObject customer) {
        if (customer == null) {
            return null;
        }
        DynamicObject customerLinkMans = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)"bd_customer");
        DynamicObjectCollection linkmans = customerLinkMans.getDynamicObjectCollection("entry_linkman");
        DynamicObject customerLinkmanId = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                customerLinkmanId = linkman;
                break;
            }
            if (customerLinkmanId != null || invalid) continue;
            customerLinkmanId = linkman;
        }
        DynamicObject linkmanObject = null;
        if (customerLinkmanId != null) {
            linkmanObject = BusinessDataServiceHelper.loadSingleFromCache((Object)customerLinkmanId.getPkValue(), (String)"bd_customerlinkman");
        }
        return linkmanObject;
    }

    public static DynamicObject getLinkmanDym(DynamicObject customer) {
        if (customer == null) {
            return null;
        }
        DynamicObjectCollection linkmans = customer.getDynamicObjectCollection("entry_linkman");
        DynamicObject customerLinkman = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return linkman;
            }
            if (customerLinkman != null || invalid) continue;
            customerLinkman = linkman;
        }
        return customerLinkman;
    }

    public static String getAddress(DynamicObject customer) {
        QFilter id2;
        if (customer == null) {
            return "";
        }
        QFilter id1 = new QFilter("customerid", "in", (Object)customer.getPkValue().toString());
        Map bd_address = BusinessDataServiceHelper.loadFromCache((String)"bd_address", (QFilter[])new QFilter[]{id1.and(id2 = new QFilter("invalid", "=", (Object)"0"))});
        if (bd_address.size() <= 0) {
            return "";
        }
        String validAddress = "";
        for (Map.Entry entry : bd_address.entrySet()) {
            DynamicObject add = (DynamicObject)entry.getValue();
            boolean isDefault = add.getBoolean("default");
            if (isDefault) {
                return add.getString("detailaddress");
            }
            if (!"".equalsIgnoreCase(validAddress)) continue;
            validAddress = add.getString("detailaddress");
        }
        return "".equalsIgnoreCase(validAddress) ? customer.getString("bizpartner_address") : validAddress;
    }

    public static DynamicObject getCustomerOriginal(DynamicObject customer, String otherCustomer) {
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        return dynamicObject;
    }

    public static DynamicObject getCustomerValue(DynamicObject customer, String otherCustomer) {
        String bizfunction;
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        if (dynamicObject != null) {
            QFilter id = new QFilter("id", "=", dynamicObject.getPkValue());
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            id = id.and(status.and(enable));
            switch (otherCustomer) {
                case "invoicecustomerid": {
                    QFilter invoicehold = new QFilter("invoicehold", "=", (Object)"0");
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%2%");
                    id = id.and(invoicehold).and(bizfunction2);
                    break;
                }
                case "delivercustomerid": {
                    QFilter purchasehold = new QFilter("blockedshipment", "=", (Object)"0");
                    QFilter bizfunction1 = new QFilter("bizfunction", "like", (Object)"%4%");
                    id = id.and(purchasehold).and(bizfunction1);
                    break;
                }
                case "paymentcustomerid": {
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%3%");
                    id = id.and(bizfunction2);
                }
            }
            DynamicObject otCustomer = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{id});
            if (otCustomer != null) {
                return otCustomer;
            }
            if (((Long)customer.getPkValue()).equals((Long)dynamicObject.getPkValue())) {
                return null;
            }
        }
        if (StringUtils.isBlank((String)(bizfunction = customer.getString("bizfunction")))) {
            return null;
        }
        switch (otherCustomer) {
            case "invoicecustomerid": {
                if (!customer.getBoolean("invoicehold") && bizfunction.contains("2")) break;
                return null;
            }
            case "delivercustomerid": {
                if (!customer.getBoolean("blockedshipment") && bizfunction.contains("4")) break;
                return null;
            }
            case "paymentcustomerid": {
                if (bizfunction.contains("3")) break;
                return null;
            }
        }
        return customer;
    }

    public static boolean checkBizFunction(DynamicObject customer, String function) {
        String bizFunction;
        if (customer == null) {
            return false;
        }
        if (!MetadataUtils.checkProperty((DynamicObject)customer, (String)"bizfunction")) {
            customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)"bd_customer");
        }
        if ((bizFunction = customer.getString("bizfunction")) == null) {
            return false;
        }
        return function != null && bizFunction.contains(function);
    }

    public static boolean isBlockedorder(DynamicObject customer) {
        if (!MetadataUtils.checkProperty((DynamicObject)customer, (String)"blockedorder")) {
            customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)"bd_customer");
        }
        return customer != null && customer.getBoolean("blockedorder");
    }
}

