/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class FileHelper {
    private static final Log logger = LogFactory.getLog(FileHelper.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream wordToPdf(String path, String filename) {
        if (StringUtils.isEmpty((String)filename)) return null;
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        String subfix = filename.substring(filename.lastIndexOf(46) + 1);
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream in = null;
        if (!"doc".equalsIgnoreCase(subfix)) {
            if (!"docx".equalsIgnoreCase(subfix)) return null;
        }
        try {
            Map preview = service.preview(filename, path, RequestContext.get().getUserAgent());
            String status = (String)preview.get(PreviewParams.STATUS.getEnumName());
            if (PreviewParams.ERROR.getEnumName().equals(status)) return in;
            if (PreviewParams.XLSX_SUCCESS.getEnumName().equals(status)) return in;
            if (PreviewParams.PDF_SUCCESS.getEnumName().equals(status)) return (InputStream)preview.get(PreviewParams.RESULT.getEnumName());
            if (!PreviewParams.NOT_NEED_CHANGE.getEnumName().equals(status)) return in;
            return (InputStream)preview.get(PreviewParams.RESULT.getEnumName());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static InputStream getInputStream(String path) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream doc = service.getInputStream(path);
        return doc;
    }

    public static void bindFile(String uid, String fileName, int size, String bindUrl, String formId, Object billId, String attachmentPanel) {
        ArrayList data = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", fileName);
        map.put("url", bindUrl);
        map.put("size", size);
        map.put("uid", uid);
        data.add(map);
        AttachmentServiceHelper.upload((String)formId, (Object)billId, (String)attachmentPanel, data);
    }

    public static String uploadFile(InputStream in, String fileName, String path) {
        FileItem fileItem = new FileItem(fileName, path, in);
        fileItem.setCreateNewFileWhenExists(false);
        FileService service = FileServiceFactory.getAttachmentFileService();
        service.delete(path);
        return service.upload(fileItem);
    }

    public static DynamicObjectCollection getAttachmentFile(DynamicObject bill, String attachmentPanel) {
        QFilter[] filters = new QFilter[]{new QFilter("finterid", "=", (Object)bill.getPkValue().toString()), new QFilter("fbilltype", "=", (Object)bill.getDataEntityType().getName()), new QFilter("fattachmentpanel", "=", (Object)attachmentPanel)};
        DynamicObjectCollection bos_attachment = QueryServiceHelper.query((String)"bos_attachment", (String)"id,fnumber,fattachmentname,ffileid", (QFilter[])filters);
        return bos_attachment;
    }
}

