/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.business.helper.InvoiceBiztypeHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.scmc.conm.business.helper.BillTplHelper;
import kd.scmc.conm.business.helper.CurrencyHelper;
import kd.scmc.conm.business.helper.SupplierHelper;
import kd.scmc.conm.enums.BizConfirmStatusEnum;
import kd.scmc.conm.enums.ChangeTypeEnum;
import kd.scmc.conm.enums.OperatorGrpTypeEnum;
import kd.scmc.conm.utils.CommonUtils;

public class PurContractBillHelper
extends BillTplHelper {
    public static Map<String, String> getPlanCommonFieldMapping() {
        HashMap<String, String> properytMapping = new HashMap<String, String>();
        properytMapping.put("appid", "04FF=O0EMI=4");
        properytMapping.put("viewtype", "02");
        properytMapping.put("plantype", "purconm");
        properytMapping.put("totalallamount", "totalallamount");
        properytMapping.put("settlecurrency", "settlecurrency");
        properytMapping.put("ispayrate", "ispayrate");
        properytMapping.put("biztime", "biztime");
        properytMapping.put("entrynum", "payentry");
        properytMapping.put("amount", "payamount");
        properytMapping.put("changetype", "payentrychangetype");
        properytMapping.put("rate", "payrate");
        properytMapping.put("itemname", "payname");
        properytMapping.put("isprepay", "isprepay");
        properytMapping.put("amountdate", "paydate");
        return properytMapping;
    }

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills) {
        BillTplHelper.completeBillInfo(bills);
        if (CommonUtils.isNull(bills)) {
            return bills;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(8);
        for (DynamicObject bill : bills) {
            DynamicObject org;
            if (bill == null || (org = bill.getDynamicObject("org")) == null) continue;
            PurContractBillHelper.setDefaultOperatorGroup(bill);
            PurContractBillHelper.setDefaultDept(bill);
            PurContractBillHelper.setSupplierInfo(bill);
            PurContractBillHelper.setDefaultFinanceInfo(bill);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                PurContractBillHelper.setDefaultEntryOrg(bill, entry, cacheMap);
            }
            PurContractBillHelper.setPayEntrys(bill);
        }
        return result;
    }

    private static void setPayEntrys(DynamicObject bill) {
        DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("payentry");
        DynamicObject type = bill.getDynamicObject("type");
        String pretimepoint = "";
        if (type != null) {
            pretimepoint = type.getString("pretimepoint");
        }
        for (DynamicObject entry : payEntrys) {
            entry.set("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
            Object isPreRec = entry.get("isprepay");
            if (isPreRec == null) {
                entry.set("isprepay", (Object)Boolean.FALSE);
            }
            if (CommonUtils.isNull((Object)entry.getString("timeunit"))) {
                entry.set("timeunit", (Object)"A");
            }
            if (CommonUtils.isNull((Object)entry.getDate("paydate"))) {
                entry.set("paydate", (Object)bill.getDate("biztime"));
            }
            if (isPreRec != null && !((Boolean)isPreRec).booleanValue()) {
                entry.set("pretimepoint", (Object)"");
                continue;
            }
            String entryPre = entry.getString("pretimepoint");
            if (!kd.bos.util.StringUtils.isEmpty((String)entryPre) || kd.bos.util.StringUtils.isEmpty((String)pretimepoint)) continue;
            entry.set("pretimepoint", (Object)pretimepoint);
        }
        AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)PurContractBillHelper.getPayPlanCommonText("conm_purcontract"), (DynamicObject)bill);
    }

    private static void setDefaultOperatorGroup(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        long userId = UserServiceHelper.getCurrentUserId();
        if (0L == userId) {
            return;
        }
        if (operator == null && org != null) {
            Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)((Long)org.getPkValue()), (Long)userId, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
            if (!operatorAndGroup.isEmpty()) {
                bill.set("operator", operatorAndGroup.get("operator"));
                if (operatorGroup == null) {
                    bill.set("operatorgroup", operatorAndGroup.get("operatorgroup"));
                }
            }
        } else if (operator != null && operatorGroup == null) {
            operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.get("operatorgrpid"), (String)"bd_operatorgroup");
            bill.set("operatorgroup", (Object)operatorGroup);
        }
    }

    private static void setDefaultDept(DynamicObject bill) {
        DynamicObject user;
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject operator = bill.getDynamicObject("operator");
        if (dept == null && operator != null && (user = operator.getDynamicObject("operatorid")) != null) {
            dept = OrgHelper.getDefaultDepartmentObject((Long)((Long)user.getPkValue()));
            bill.set("dept", (Object)dept);
        }
    }

    public static CommonContext getPayPlanCommonText(String entityId) {
        CommonContext commonContext = CommonContext.get();
        commonContext.setEntityId(entityId);
        Map propertyMapping = commonContext.getProperytMapping();
        propertyMapping.putAll(PurContractBillHelper.getPlanCommonFieldMapping());
        return commonContext;
    }

    private static void setDefaultFinanceInfo(DynamicObject bill) {
        if (CommonUtils.isNull((Object)bill.getDynamicObject("settletype"))) {
            DynamicObject supplier = bill.getDynamicObject("supplier");
            DynamicObject settletype = CurrencyHelper.getSettletype(supplier);
            bill.set("settletype", (Object)settletype);
        }
        if (bill.get("iscollaconsult") == null) {
            bill.set("iscollaconsult", (Object)Boolean.FALSE);
        }
        if (bill.get("iscollaconsult") != null && bill.getBoolean("iscollaconsult")) {
            bill.set("confirmstatus", null);
        } else {
            bill.set("confirmstatus", (Object)BizConfirmStatusEnum.INACTIVE.getValue());
        }
        if (BizConfirmStatusEnum.INACTIVE.getValue().equals(bill.getString("confirmstatus")) || BizConfirmStatusEnum.UNCONFIRM.getValue().equals(bill.getString("confirmstatus"))) {
            bill.set("confirmer", null);
            bill.set("confirmdate", null);
        }
    }

    private static void setDefaultEntryOrg(DynamicObject bill, DynamicObject entry, Map<String, Object> cacheMap) {
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        DynamicObject reqOrg = (DynamicObject)entry.get("entryreqorg");
        if (orgId != null && reqOrg == null) {
            String cacheKey = orgId + "entryreqorg";
            if (PurContractBillHelper.isCached(cacheMap, cacheKey)) {
                reqOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                reqOrg = OrgHelper.getOrgForFormDefObjValue((Long)orgId, (String)"", (String)"02", (String)"fromorg");
                cacheMap.put(cacheKey, reqOrg);
            }
            entry.set("entryreqorg", (Object)reqOrg);
        }
        DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
        if (orgId != null && settleOrg == null) {
            String settleCacheKey = orgId + "entrysettleorg";
            if (PurContractBillHelper.isCached(cacheMap, settleCacheKey)) {
                settleOrg = (DynamicObject)cacheMap.get(settleCacheKey);
            } else {
                settleOrg = OrgHelper.getOrgForFormDefObjValue((Long)orgId, (String)"02", (String)"10", (String)"toorg");
                cacheMap.put(settleCacheKey, settleOrg);
            }
            entry.set("entrysettleorg", (Object)settleOrg);
        }
        DynamicObject recOrg = (DynamicObject)entry.get("entryinvorg");
        if (orgId != null && recOrg == null) {
            String cacheKey = orgId + "entryinvorg";
            if (PurContractBillHelper.isCached(cacheMap, cacheKey)) {
                recOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                recOrg = OrgHelper.getOrgForFormDefObjValue((Long)orgId, (String)"02", (String)"05", (String)"toorg");
                cacheMap.put(cacheKey, recOrg);
            }
            entry.set("entryinvorg", (Object)recOrg);
        }
        if (entry.getDate("deliverdate") == null) {
            entry.set("deliverdate", (Object)bill.getDate("biztime"));
        }
    }

    private static void setSupplierInfo(DynamicObject bill) {
        DynamicObject invoicebiztype;
        DynamicObject contParties;
        DynamicObject supplier = bill.getDynamicObject("supplier");
        if (supplier == null) {
            return;
        }
        DynamicObject providerSupplier = bill.getDynamicObject("providersupplier");
        if (providerSupplier == null) {
            bill.set("providersupplier", (Object)SupplierHelper.getSupplierOriginal(supplier, "deliversupplierid"));
        }
        if ((providerSupplier = bill.getDynamicObject("providersupplier")) != null) {
            if (kd.bos.util.StringUtils.isEmpty((String)bill.getString("providerlinkman"))) {
                bill.set("providerlinkman", (Object)SupplierHelper.getLinkmanObject(providerSupplier));
            }
            if (kd.bos.util.StringUtils.isEmpty((String)bill.getString("provideraddress"))) {
                bill.set("provideraddress", (Object)SupplierHelper.getAddress(providerSupplier));
            }
        }
        if (bill.getDynamicObject("invoicesupplier") == null) {
            bill.set("invoicesupplier", (Object)SupplierHelper.getSupplierOriginal(supplier, "invoicesupplierid"));
        }
        if (bill.getDynamicObject("receivesupplier") == null) {
            bill.set("receivesupplier", (Object)SupplierHelper.getSupplierOriginal(supplier, "receivingsupplierid"));
        }
        if (bill.getString("party2nd") == null || kd.bos.util.StringUtils.isEmpty((String)bill.getString("party2nd"))) {
            String party2nd = supplier.getLocaleString("name").getLocaleValue();
            bill.set("party2nd", (Object)party2nd);
            if (bill.getString("contactperson2nd") == null || kd.bos.util.StringUtils.isEmpty((String)bill.getString("contactperson2nd"))) {
                String linkman = supplier.getLocaleString("linkman").getLocaleValue();
                bill.set("contactperson2nd", (Object)linkman);
            }
            if (bill.getString("phone2nd") == null || kd.bos.util.StringUtils.isEmpty((String)bill.getString("phone2nd"))) {
                String bizpartnerPhone = supplier.getString("bizpartner_phone");
                bill.set("phone2nd", (Object)bizpartnerPhone);
            }
        }
        if ((contParties = bill.getDynamicObject("contparties")) != null && (kd.bos.util.StringUtils.isEmpty((String)bill.getString("party1st")) || bill.getString("party1st") == null)) {
            String party1st = contParties.getLocaleString("name").getLocaleValue();
            bill.set("party1st", (Object)party1st);
            if (StringUtils.isEmpty((CharSequence)bill.getString("contactperson1st"))) {
                String contacts = contParties.getString("contacts");
                bill.set("contactperson1st", (Object)contacts);
            }
            if (StringUtils.isEmpty((CharSequence)bill.getString("phone1st"))) {
                String phone = contParties.getString("phone");
                bill.set("phone1st", (Object)phone);
            }
        }
        if ((invoicebiztype = bill.getDynamicObject("invoicebiztype")) == null) {
            DynamicObject invoicecategory = supplier.getDynamicObject("invoicecategory");
            Long invoicecategoryId = 0L;
            if (invoicecategory != null) {
                invoicecategoryId = (Long)invoicecategory.getPkValue();
            }
            if ((invoicebiztype = InvoiceBiztypeHelper.getInvoiceBizType((Long)invoicecategoryId, (String)"conm")) != null) {
                bill.set("invoicebiztype", (Object)invoicebiztype);
            }
        }
    }

    private static boolean isCached(Map<String, Object> map, String key) {
        return map.containsKey(key);
    }
}

