/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.conm.utils.CommonUtils;

public class RecordRuleHelper {
    private static final Log LOG = LogFactory.getLog(RecordRuleHelper.class);
    private static final DynamicObject NULL_DYNAMIC_OBJECT = new DynamicObject();

    private RecordRuleHelper() {
    }

    public static void recordScheme(DynamicObject[] bills, String option) {
        Map<String, Map<Long, Map<Long, DynamicObject>>> billMaps;
        if (bills == null || bills.length == 0) {
            LOG.info("Contract Perform Record\uff0cperform bill's number is zero");
            return;
        }
        List codeRuleInfos = new CodeRuleServiceHelper().getAllCodeRuleByEntity("conm_porecord");
        if (codeRuleInfos == null || codeRuleInfos.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5f00\u542f\u91c7\u8d2d\u8ba2\u5355\u767b\u8bb0\u5355\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u4e88\u767b\u8bb0\u3002", (String)"RecordRuleHelper_2", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
        HashMap<Long, DynamicObject> recordMap = new HashMap<Long, DynamicObject>();
        HashMap<Object, Integer> seqMap = new HashMap<Object, Integer>();
        String billName = bills[0].getDynamicObjectType().getName();
        if ("pm_xpurorderbill".equals(billName) || "pm_xspurorderbill".equals(billName)) {
            if (!"active".equals(option) && !"bizvalid".equals(option)) {
                return;
            }
            Object[] srcIds = "pm_xpurorderbill".equals(billName) ? Arrays.stream(bills).map(bill -> bill.getLong("sourceid")).toArray() : Arrays.stream(bills).map(bill -> bill.getLong("sourcebillid")).toArray();
            DynamicObject[] srcBills = BusinessDataServiceHelper.load((Object[])srcIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pm_purorderbill").getDynamicObjectType());
            billMaps = RecordRuleHelper.checkRecordScheme(srcBills, recordMap, seqMap, option, true);
        } else {
            billMaps = RecordRuleHelper.checkRecordScheme(bills, recordMap, seqMap, option, false);
        }
        try (TXHandle tx = TX.required();){
            try {
                billMaps.forEach((type, billMap) -> {
                    String[] typeArr = type.split("-");
                    if ("A".equals(typeArr[0])) {
                        RecordRuleHelper.deleteScheme(recordMap, billMap);
                        switch (typeArr[1]) {
                            case "A": {
                                RecordRuleHelper.addAndSubRecordScheme(recordMap, seqMap, billMap);
                                break;
                            }
                            case "B": {
                                RecordRuleHelper.subScheme(recordMap, seqMap, billMap);
                                break;
                            }
                            case "C": {
                                break;
                            }
                            case "D": {
                                break;
                            }
                        }
                    } else if ("B".equals(typeArr[0])) {
                        RecordRuleHelper.deleteScheme(recordMap, billMap);
                    }
                });
            }
            catch (Exception e) {
                tx.markRollback();
                LOG.error("Contract Perform Record\uff0csome thing wrong was happend :" + e.getMessage());
                throw e;
            }
        }
    }

    private static Map<String, Map<Long, Map<Long, DynamicObject>>> checkRecordScheme(DynamicObject[] bills, Map<Long, DynamicObject> recordMap, Map<Object, Integer> seqMap, String option, boolean isChangeBill) {
        HashMap<String, Map<Long, Map<Long, DynamicObject>>> billMap = new HashMap<String, Map<Long, Map<Long, DynamicObject>>>();
        HashMap typeSchemeMap = new HashMap();
        HashMap ruleMap = new HashMap();
        HashMap<Long, DynamicObject> contTypeMap = new HashMap<Long, DynamicObject>(16);
        HashMap contEntityMap = new HashMap(16);
        for (DynamicObject dynamicObject : bills) {
            DynamicObjectCollection poEntries = dynamicObject.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : poEntries) {
                String contEntity = RecordRuleHelper.checkConmEntity(entry);
                Long contID = entry.getLong("conbillid");
                if (contEntityMap == null || contEntityMap.get(contEntity) == null || ((Set)contEntityMap.get(contEntity)).size() == 0) {
                    HashSet<Long> contIDlst = new HashSet<Long>(1);
                    contIDlst.add(contID);
                    contEntityMap.put(contEntity, contIDlst);
                    continue;
                }
                ((Set)contEntityMap.get(contEntity)).add(contID);
            }
        }
        for (Map.Entry entry : contEntityMap.entrySet()) {
            DynamicObject[] contObjs;
            if (StringUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) continue;
            for (DynamicObject cont : contObjs = BusinessDataServiceHelper.load((String)((String)entry.getKey()), (String)"billno,type,id,billentry.lineno", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())})) {
                Long contId = cont.getLong("id");
                DynamicObject contType = cont.getDynamicObject("type");
                contTypeMap.put(contId, contType);
            }
        }
        for (DynamicObject dynamicObject : bills) {
            DynamicObjectCollection billEntries = dynamicObject.getDynamicObjectCollection("billentry");
            Map<Long, List<DynamicObject>> billEntryMap = billEntries.stream().filter(billEntry -> billEntry.getLong("conbillid") != 0L && billEntry.getLong("conbillentryid") != 0L).collect(Collectors.groupingBy(billEntry -> billEntry.getLong("conbillid")));
            billEntryMap.forEach((conBillId, entries) -> {
                String conmEntity = RecordRuleHelper.checkConmEntity((DynamicObject)entries.get(0));
                if (!CommonUtils.isNull((Object)conmEntity)) {
                    DynamicObject recordRule = (DynamicObject)recordMap.get(conBillId);
                    if (recordRule == null) {
                        DynamicObject type = (DynamicObject)contTypeMap.get(conBillId);
                        DynamicObject scheme = RecordRuleHelper.getScheme(conBillId, type, typeSchemeMap);
                        recordRule = RecordRuleHelper.getRecordRule(recordMap, ruleMap, dynamicObject.getDynamicObjectType().getName(), conBillId, type, scheme);
                    }
                    if (recordRule != null && recordRule.getDataEntityType() != null) {
                        if (isChangeBill) {
                            RecordRuleHelper.splitOrder(seqMap, billMap, dynamicObject, billEntries, conBillId, entries, "A", "A");
                        } else {
                            Optional.ofNullable(recordRule.getDynamicObjectCollection("optionentity")).flatMap(optionEntity -> optionEntity.stream().filter(op -> op.get("optionkey").equals(option)).findFirst()).ifPresent(op -> RecordRuleHelper.splitOrder(seqMap, billMap, dynamicObject, billEntries, conBillId, entries, op.getString("rectype"), op.getString("recmode")));
                        }
                    }
                }
            });
        }
        return billMap;
    }

    private static DynamicObject getScheme(Long conBillId, DynamicObject type, Map<Object, DynamicObject> typeSchemeMap) {
        DynamicObject scheme;
        try {
            if (typeSchemeMap.get(type.getPkValue()) == null) {
                scheme = type.getDynamicObject("scheme");
                scheme = (DynamicObject)BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{scheme.getPkValue()}, (String)scheme.getDynamicObjectType().getName()).get(scheme.getPkValue());
                typeSchemeMap.put(type.getPkValue(), scheme);
            } else {
                scheme = typeSchemeMap.get(type.getPkValue());
            }
        }
        catch (Exception e) {
            scheme = NULL_DYNAMIC_OBJECT;
            LOG.info(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u65e0\u65b9\u6848\u3002", (String)"RecordRuleHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]) + conBillId + e.getMessage());
        }
        return scheme;
    }

    private static DynamicObject getRecordRule(Map<Long, DynamicObject> recordMap, Map<Object, DynamicObject> ruleMap, String srcBillName, Long conBillId, DynamicObject type, DynamicObject scheme) {
        if (scheme.getDataEntityType() != null && scheme.getBoolean("enable")) {
            Optional.ofNullable(scheme.getDynamicObjectCollection("entryentity")).flatMap(entryEntity -> entryEntity.stream().filter(entry -> Boolean.TRUE.equals(entry.getBoolean("enabled")) && srcBillName.equals(entry.getDynamicObject("performbill").get("number"))).findFirst()).ifPresent(entry -> {
                DynamicObject recordRule = entry.getDynamicObject("recordrule");
                if (ruleMap.get(type.getPkValue().toString() + "-" + recordRule.getPkValue()) == null) {
                    recordRule = (DynamicObject)BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{recordRule.getPkValue()}, (String)recordRule.getDynamicObjectType().getName()).get(recordRule.getPkValue());
                    ruleMap.put(type.getPkValue().toString() + "-" + recordRule.getPkValue(), recordRule);
                } else {
                    recordRule = (DynamicObject)ruleMap.get(type.getPkValue().toString() + "-" + recordRule.getPkValue());
                }
                recordMap.put(conBillId, recordRule);
            });
        } else {
            recordMap.put(conBillId, NULL_DYNAMIC_OBJECT);
        }
        return recordMap.get(conBillId);
    }

    public static String checkConmEntity(DynamicObject billEntry) {
        String number;
        DynamicObject conmEntity = billEntry.getDynamicObject("conbillentity");
        if (conmEntity != null && !CommonUtils.isNull((Object)(number = conmEntity.getString("number")))) {
            if (number.startsWith("conm_salcontract")) {
                return "conm_salcontract";
            }
            if (number.startsWith("conm_purcontract")) {
                return "conm_purcontract";
            }
        }
        return null;
    }

    private static void splitOrder(Map<Object, Integer> seqMap, Map<String, Map<Long, Map<Long, DynamicObject>>> billMap, DynamicObject bill, DynamicObjectCollection billEntries, Long conBillId, List<DynamicObject> entries, String recType, String recMode) {
        DynamicObject targetBill = (DynamicObject)new CloneUtils(false, false).clone(bill.getDataEntityType(), (Object)bill);
        DynamicObjectCollection dynamicCollection = new DynamicObjectCollection();
        dynamicCollection.addAll(entries);
        entries.forEach(entry -> {
            AtomicInteger index = new AtomicInteger(0);
            billEntries.forEach(srcBillEntry -> {
                if (((Long)entry.getPkValue()).longValue() == ((Long)srcBillEntry.getPkValue()).longValue()) {
                    seqMap.put(bill.getPkValue() + "-" + entry.getPkValue(), index.incrementAndGet());
                } else {
                    index.incrementAndGet();
                }
            });
        });
        targetBill.set("billentry", (Object)dynamicCollection);
        HashMap<Long, DynamicObject> temp = new HashMap<Long, DynamicObject>();
        temp.put(conBillId, targetBill);
        Map map = billMap.computeIfAbsent(recType + "-" + recMode, func -> new HashMap());
        if (map.get(targetBill.getLong("id")) == null) {
            map.put(targetBill.getLong("id"), temp);
        } else {
            ((Map)map.get(targetBill.getLong("id"))).putAll(temp);
        }
    }

    private static void subScheme(Map<Long, DynamicObject> recordMap, Map<Object, Integer> seqMap, Map<Long, Map<Long, DynamicObject>> billMap) {
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>();
        billMap.forEach((pk, conmBillMaps) -> Optional.ofNullable(RecordRuleHelper.mergeRecordObject(recordMap, seqMap, conmBillMaps)).ifPresent(recordObject -> {
            RecordRuleHelper.orderEntryByConmNo(recordObject);
            AtomicInteger seq = new AtomicInteger(0);
            recordObject.getDynamicObjectCollection("entryentity").forEach(entry -> {
                entry.set("seq", (Object)seq.getAndIncrement());
                RecordRuleHelper.setEntryQtyAndAmount(entry);
            });
            addList.add((DynamicObject)recordObject);
        }));
        RecordRuleHelper.saveRecord(addList);
    }

    private static void setEntryQtyAndAmount(DynamicObject entry) {
        RecordRuleHelper.negateEntry(entry, entry);
    }

    private static void addAndSubRecordScheme(Map<Long, DynamicObject> recordMap, Map<Object, Integer> seqMap, Map<Long, Map<Long, DynamicObject>> billMap) {
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>();
        LOG.info("Contract Perform bill ids:" + StringUtils.join(billMap.keySet(), (String)" ; "));
        billMap.forEach((pk, conmBillMaps) -> {
            LOG.info("Contract Perform Record-ContractId:" + StringUtils.join(conmBillMaps.keySet(), (String)" ; "));
            DynamicObject recordObject = RecordRuleHelper.mergeRecordObject(recordMap, seqMap, conmBillMaps);
            if (recordObject != null) {
                Optional.ofNullable(recordObject).ifPresent(r -> {
                    RecordRuleHelper.orderEntryByConmNo(r);
                    AtomicInteger seq = new AtomicInteger(0);
                    r.getDynamicObjectCollection("entryentity").forEach(entry -> entry.set("seq", (Object)seq.getAndIncrement()));
                    addList.add((DynamicObject)r);
                });
            }
        });
        RecordRuleHelper.saveRecord(addList);
    }

    private static void saveRecord(List<DynamicObject> list) {
        if (!list.isEmpty()) {
            LOG.info("Contract Perform Record,record bill's number\uff1a" + list.size());
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObject mergeRecordObject(Map<Long, DynamicObject> recordMap, Map<Object, Integer> seqMap, Map<Long, DynamicObject> conmBillMaps) {
        Set<Map.Entry<Long, DynamicObject>> entries = conmBillMaps.entrySet();
        DynamicObject recordObject = null;
        for (Map.Entry<Long, DynamicObject> entry : entries) {
            DynamicObject bill = entry.getValue();
            DynamicObject tempRecordObject = RecordRuleHelper.generateRecordObject(recordMap.get(entry.getKey()), seqMap, bill, recordObject == null);
            if (recordObject == null) {
                recordObject = tempRecordObject;
                continue;
            }
            recordObject.getDynamicObjectCollection("entryentity").addAll((Collection)tempRecordObject.getDynamicObjectCollection("entryentity"));
        }
        return recordObject;
    }

    private static void orderEntryByConmNo(DynamicObject recordObject) {
        recordObject.getDynamicObjectCollection("entryentity").sort(Comparator.comparingInt(d -> Integer.parseInt(d.getString("srcbillentryseq"))));
    }

    private static void deleteScheme(Map<Long, DynamicObject> recordMap, Map<Long, Map<Long, DynamicObject>> billMap) {
        HashMap<String, List> deleteMap = new HashMap<String, List>();
        HashMap entityTypeMap = new HashMap();
        billMap.forEach((pk, values) -> values.forEach((conBillId, bill) -> {
            DynamicObject record = (DynamicObject)recordMap.get(conBillId);
            MainEntityType recordBillType = MetadataServiceHelper.getDataEntityType((String)record.getDynamicObject("recordbill").getString("number"));
            Optional.ofNullable(BusinessDataServiceHelper.load((String)recordBillType.getName(), (String)"", (QFilter[])new QFilter[]{new QFilter("entryentity.srcbillid", "=", pk)})).ifPresent(arg_0 -> RecordRuleHelper.lambda$null$22(deleteMap, entityTypeMap, (EntityType)recordBillType, arg_0));
        }));
        LOG.info("Contract Perform Record\uff0cdelete record bill\uff1a" + JSON.toJSONString(deleteMap));
        deleteMap.forEach((entityName, deleteBills) -> DeleteServiceHelper.delete((IDataEntityType)((IDataEntityType)entityTypeMap.get(entityName)), (Object[])deleteBills.toArray()));
    }

    private static void setDeleteRecordScheme(Map<String, List<Object>> deleteMap, Map<String, EntityType> entityTypeMap, EntityType recordBillType, List<Object> pks) {
        if (deleteMap.get(recordBillType.getName()) == null) {
            deleteMap.put(recordBillType.getName(), new ArrayList<Object>(pks));
            entityTypeMap.put(recordBillType.getName(), recordBillType);
        } else {
            deleteMap.get(recordBillType.getName()).addAll(pks);
        }
    }

    private static void negateEntry(DynamicObject entry, DynamicObject srcEntry) {
        entry.set("amount", (Object)srcEntry.getBigDecimal("amount").negate());
        entry.set("taxamount", (Object)srcEntry.getBigDecimal("taxamount").negate());
        entry.set("amountandtax", (Object)srcEntry.getBigDecimal("amountandtax").negate());
        entry.set("baseqty", (Object)srcEntry.getBigDecimal("baseqty").negate());
        entry.set("qty", (Object)srcEntry.getBigDecimal("qty").negate());
    }

    private static DynamicObject generateRecordObject(DynamicObject record, Map<Object, Integer> seqMap, DynamicObject bill, boolean isGenerate) {
        DynamicObject recordBill = record.getDynamicObject("recordbill");
        MainEntityType recordBillType = MetadataServiceHelper.getDataEntityType((String)recordBill.getString("number"));
        List<EntityType> recordBillEntryEntities = RecordRuleHelper.getChildEntities((IDataEntityType)recordBillType);
        DynamicObject target = new DynamicObject((DynamicObjectType)recordBillType);
        Optional.ofNullable(record.getDynamicObjectCollection("mappingentity")).ifPresent(mappingEntity -> mappingEntity.stream().filter(entity -> !CommonUtils.isNull((Object)entity.getString("performfield"))).forEach(entity -> {
            String[] recordField = entity.getString("recordfield").split("\\.");
            String[] recordFieldName = entity.getString("recordfieldname").split("\\.");
            String[] performField = entity.getString("performfield").split("\\.");
            if (ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"RecordRuleHelper_1", (String)"scmc-conm-business", (Object[])new Object[0]).equals(recordFieldName[0])) {
                if (isGenerate || "totalamount".equals(performField[0]) || "totaltaxamount".equals(performField[0]) || "totalallamount".equals(performField[0])) {
                    target.set(entity.getString("recordfield"), bill.get(performField[0]));
                }
            } else {
                recordBillEntryEntities.stream().filter(entry -> entry.getName().equals(recordField[0])).findFirst().ifPresent(entry -> {
                    if (entry.getClass() == EntryType.class) {
                        DynamicObjectCollection newEntry = target.getDynamicObjectCollection(entry.getName());
                        DynamicObjectCollection billEntries = bill.getDynamicObjectCollection("billentry");
                        if (newEntry.isEmpty()) {
                            billEntries.forEach(item -> {
                                DynamicObject dynamicObject = newEntry.addNew();
                                dynamicObject.set("contractnum", (Object)item.getString("conbillnumber"));
                                dynamicObject.set("contlineno", (Object)item.getString("conbillrownum"));
                                dynamicObject.set("contractid", (Object)item.getLong("conbillid"));
                                dynamicObject.set("contractentryid", (Object)item.getLong("conbillentryid"));
                                dynamicObject.set("srcbillentity", (Object)bill.getDataEntityType().getName());
                                dynamicObject.set("srcbillid", bill.getPkValue());
                                dynamicObject.set("srcbillnumber", (Object)bill.getString("billno"));
                                dynamicObject.set("srcbillentryid", item.getPkValue());
                                dynamicObject.set("srcbillentryseq", (Object)item.getString("seq"));
                            });
                        }
                        for (int i = 0; i < newEntry.size(); ++i) {
                            Object value;
                            DynamicObject dynamicObject = (DynamicObject)newEntry.get(i);
                            if (performField.length == 1) {
                                dynamicObject.set(recordField[recordField.length - 1], bill.get(performField[0]));
                                continue;
                            }
                            DynamicObject billEntry = (DynamicObject)billEntries.get(i);
                            if ("seq".equals(performField[performField.length - 1])) {
                                try {
                                    value = billEntry.get(performField[performField.length - 1]);
                                }
                                catch (Exception e) {
                                    value = seqMap.get(bill.getPkValue() + "-" + billEntry.getPkValue());
                                    LOG.error(e.getMessage());
                                }
                            } else {
                                value = billEntry.get(performField[performField.length - 1]);
                            }
                            dynamicObject.set(recordField[recordField.length - 1], value);
                        }
                    }
                });
            }
        }));
        if (isGenerate) {
            Date date = new Date();
            target.set("createtime", (Object)date);
            target.set("auditdate", (Object)date);
            target.set("modifytime", (Object)date);
            target.set("biztime", (Object)date);
            long currentUserId = UserServiceHelper.getCurrentUserId();
            target.set("creator", (Object)currentUserId);
            target.set("modifier", (Object)currentUserId);
            target.set("auditor", (Object)currentUserId);
            target.set("billstatus", (Object)BillStatus.C.name());
            target.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)recordBillType.getName(), (DynamicObject)target, (String)target.getDynamicObject("org").getPkValue().toString()));
        }
        return target;
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
            childEntities.addAll(RecordRuleHelper.getChildEntities((IDataEntityType)childEntity));
        }
        return childEntities;
    }

    private static /* synthetic */ void lambda$null$22(Map deleteMap, Map entityTypeMap, EntityType recordBillType, DynamicObject[] deleteBills) {
        if (deleteBills.length > 0) {
            List<Object> pks = Arrays.stream(deleteBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            RecordRuleHelper.setDeleteRecordScheme(deleteMap, entityTypeMap, recordBillType, pks);
        }
    }
}

