/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.conm.enums.ChangeTypeEnum;

public class RowNumHelper {
    private static final Log log = LogFactory.getLog(RowNumHelper.class);

    public static void generateRowNum(DynamicObject[] dataEntities, Boolean isOverWriteExist) {
        block7: for (DynamicObject dataEntity : dataEntities) {
            String entityName;
            switch (entityName = dataEntity.getDataEntityType().getName()) {
                case "conm_purcontract": 
                case "conm_salcontract": {
                    if (isOverWriteExist.booleanValue()) {
                        RowNumHelper.generateRowNumOverWrite(dataEntity);
                        continue block7;
                    }
                    RowNumHelper.generateRowNum(dataEntity);
                }
            }
        }
    }

    private static void generateRowNum(DynamicObject dataEntity) {
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("billentry");
        int rowNum = RowNumHelper.getMaxRowNum(entryColl) + 1;
        for (DynamicObject entry : entryColl) {
            String num = entry.getString("lineno");
            if (!StringUtils.isBlank((CharSequence)num)) continue;
            entry.set("lineno", (Object)rowNum++);
        }
    }

    private static void generateRowNumOverWrite(DynamicObject dataEntity) {
        int rowNum = 1;
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entryColl) {
            entry.set("lineno", (Object)rowNum++);
        }
    }

    private static void generateChangeBillRowNum(DynamicObject dataEntity) {
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("billentry");
        int rowNum = RowNumHelper.getChangeBillMaxRowNum(entryColl) + 1;
        for (DynamicObject entry : entryColl) {
            if (!ChangeTypeEnum.ADDNEW.getValue().equals(entry.getString("billentrychangetype"))) continue;
            entry.set("lineno", (Object)rowNum++);
        }
    }

    private static int getChangeBillMaxRowNum(DynamicObjectCollection entryColl) {
        int rowNum = 0;
        for (DynamicObject entry : entryColl) {
            if (ChangeTypeEnum.ADDNEW.getValue().equals(entry.getString("billentrychangetype"))) continue;
            String num = entry.getString("lineno");
            try {
                int numInt = Integer.parseInt(num);
                if (numInt <= rowNum) continue;
                rowNum = numInt;
            }
            catch (NumberFormatException e) {
                log.info(String.format(ResManager.loadKDString((String)"\u5408\u540c\u53d8\u66f4\u5355\u884c\u53f7\u201c%s\u201d\u5f02\u5e38\u3002", (String)"RowNumHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]), num) + e.getMessage());
            }
        }
        return rowNum;
    }

    private static int getMaxRowNum(DynamicObjectCollection entryColl) {
        int rowNum = 0;
        for (DynamicObject entry : entryColl) {
            String num = entry.getString("lineno");
            if (!StringUtils.isNotBlank((CharSequence)num)) continue;
            try {
                int numInt = Integer.parseInt(num);
                if (numInt <= rowNum) continue;
                rowNum = numInt;
            }
            catch (NumberFormatException e) {
                log.info(String.format(ResManager.loadKDString((String)"\u5408\u540c\u5f02\u5e38\u884c\u53f7\uff0c\u884c\u53f7\u4e3a:%s\u3002", (String)"RowNumHelper_1", (String)"scmc-conm-business", (Object[])new Object[0]), num) + e.getMessage());
            }
        }
        return rowNum;
    }
}

