/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.scmc.conm.business.helper.BillTplHelper;
import kd.scmc.conm.business.helper.CurrencyHelper;
import kd.scmc.conm.business.helper.CustomerHelper;
import kd.scmc.conm.enums.ChangeTypeEnum;
import kd.scmc.conm.enums.OperatorGrpTypeEnum;
import kd.scmc.conm.utils.CommonUtils;

public class SalContractBillHelper
extends BillTplHelper {
    public static Map<String, String> getPlanCommonFieldMapping() {
        HashMap<String, String> properytMapping = new HashMap<String, String>();
        properytMapping.put("appid", "04FF=O0EMI=4");
        properytMapping.put("viewtype", "15");
        properytMapping.put("plantype", "salconm");
        properytMapping.put("totalallamount", "totalallamount");
        properytMapping.put("settlecurrency", "settlecurrency");
        properytMapping.put("ispayrate", "ispayrate");
        properytMapping.put("biztime", "biztime");
        properytMapping.put("entrynum", "payentry");
        properytMapping.put("amount", "payamount");
        properytMapping.put("changetype", "payentrychangetype");
        properytMapping.put("rate", "payrate");
        properytMapping.put("itemname", "payname");
        properytMapping.put("isprepay", "isprepay");
        properytMapping.put("amountdate", "paydate");
        return properytMapping;
    }

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills) {
        BillTplHelper.completeBillInfo(bills);
        if (CommonUtils.isNull(bills)) {
            return bills;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(8);
        for (DynamicObject bill : bills) {
            DynamicObject org;
            if (bill == null || (org = bill.getDynamicObject("org")) == null) continue;
            SalContractBillHelper.setDefaultOperatorGroup(bill);
            SalContractBillHelper.setDefaultDept(bill);
            SalContractBillHelper.setCustomerInfo(bill);
            SalContractBillHelper.setDefaultFinanceInfo(bill);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                SalContractBillHelper.setDefaultEntryOrg(bill, entry, cacheMap);
            }
            SalContractBillHelper.setPayEntrys(bill);
        }
        return result;
    }

    private static void setPayEntrys(DynamicObject bill) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
        DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("payentry");
        DynamicObject entrysettleorg = null;
        if (!entries.isEmpty()) {
            entrysettleorg = ((DynamicObject)entries.get(0)).getDynamicObject("entrysettleorg");
        }
        for (DynamicObject entry : payEntrys) {
            entry.set("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
            Object isPreRec = entry.get("isprepay");
            if (isPreRec == null) {
                entry.set("isprepay", (Object)Boolean.FALSE);
            }
            if (CommonUtils.isNull((Object)entry.getString("timeunit"))) {
                entry.set("timeunit", (Object)"A");
            }
            if (CommonUtils.isNull((Object)entry.getDate("paydate"))) {
                entry.set("paydate", (Object)bill.getDate("biztime"));
            }
            if (entry.getDynamicObject("recentrysettleorg") != null) continue;
            entry.set("recentrysettleorg", (Object)entrysettleorg);
        }
        AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)SalContractBillHelper.getPayPlanCommonText("conm_salcontract"), (DynamicObject)bill);
    }

    private static void setCustomerInfo(DynamicObject bill) {
        DynamicObject contParties;
        DynamicObject customer = bill.getDynamicObject("customer");
        if (customer == null) {
            return;
        }
        DynamicObject reccustomer = bill.getDynamicObject("reccustomer");
        if (reccustomer == null) {
            bill.set("reccustomer", (Object)CustomerHelper.getCustomerOriginal(customer, "delivercustomerid"));
        }
        if ((reccustomer = bill.getDynamicObject("reccustomer")) != null) {
            if (kd.bos.util.StringUtils.isEmpty((String)bill.getString("reclinkman"))) {
                bill.set("reclinkman", (Object)CustomerHelper.getLinkmanObject(reccustomer));
            }
            if (kd.bos.util.StringUtils.isEmpty((String)bill.getString("receiveaddress"))) {
                bill.set("receiveaddress", (Object)CustomerHelper.getAddress(reccustomer));
            }
        }
        if (bill.getDynamicObject("payingcustomer") == null) {
            bill.set("payingcustomer", (Object)CustomerHelper.getCustomerOriginal(customer, "paymentcustomerid"));
        }
        if (bill.getDynamicObject("settlecustomer") == null) {
            bill.set("settlecustomer", (Object)CustomerHelper.getCustomerOriginal(customer, "invoicecustomerid"));
        }
        if (bill.getString("party1st") == null || kd.bos.util.StringUtils.isEmpty((String)bill.getString("party1st"))) {
            bill.set("party1st", (Object)customer.getLocaleString("name"));
            if (bill.getString("contactperson1st") == null || kd.bos.util.StringUtils.isEmpty((String)bill.getString("contactperson1st"))) {
                bill.set("contactperson1st", (Object)customer.getString("linkman"));
            }
            if (bill.getString("phone1st") == null || kd.bos.util.StringUtils.isEmpty((String)bill.getString("phone1st"))) {
                bill.set("phone1st", customer.get("bizpartner_phone"));
            }
        }
        if ((contParties = bill.getDynamicObject("contparties")) != null && (kd.bos.util.StringUtils.isEmpty((String)bill.getString("party2nd")) || bill.getString("party2nd") == null)) {
            String party1st = contParties.getLocaleString("name").getLocaleValue();
            bill.set("party2nd", (Object)party1st);
            if (StringUtils.isEmpty((CharSequence)bill.getString("contactperson2nd"))) {
                String contacts = contParties.getString("contacts");
                bill.set("contactperson2nd", (Object)contacts);
            }
            if (StringUtils.isEmpty((CharSequence)bill.getString("phone2nd"))) {
                String phone = contParties.getString("phone");
                bill.set("phone2nd", (Object)phone);
            }
        }
    }

    private static void setDefaultOperatorGroup(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        long userId = UserServiceHelper.getCurrentUserId();
        if (0L == userId) {
            return;
        }
        if (operator == null && org != null) {
            Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)((Long)org.getPkValue()), (Long)userId, (String)OperatorGrpTypeEnum.SALEGRP.getValue());
            if (!operatorAndGroup.isEmpty()) {
                bill.set("operator", operatorAndGroup.get("operator"));
                if (operatorGroup == null) {
                    bill.set("operatorgroup", operatorAndGroup.get("operatorgroup"));
                }
            }
        } else if (operator != null && operatorGroup == null) {
            operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.get("operatorgrpid"), (String)"bd_operatorgroup");
            bill.set("operatorgroup", (Object)operatorGroup);
        }
    }

    private static void setDefaultDept(DynamicObject bill) {
        DynamicObject user;
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject operator = bill.getDynamicObject("operator");
        if (dept == null && operator != null && (user = operator.getDynamicObject("operatorid")) != null) {
            dept = OrgHelper.getDefaultDepartmentObject((Long)((Long)user.getPkValue()));
            bill.set("dept", (Object)dept);
        }
    }

    public static CommonContext getPayPlanCommonText(String entityId) {
        CommonContext commonContext = CommonContext.get();
        commonContext.setEntityId(entityId);
        Map propertyMapping = commonContext.getProperytMapping();
        propertyMapping.putAll(SalContractBillHelper.getPlanCommonFieldMapping());
        return commonContext;
    }

    private static void setDefaultFinanceInfo(DynamicObject bill) {
        if (CommonUtils.isNull((Object)bill.getDynamicObject("settletype"))) {
            DynamicObject customer = bill.getDynamicObject("customer");
            DynamicObject settletype = CurrencyHelper.getSettletype(customer);
            bill.set("settletype", (Object)settletype);
        }
    }

    private static void setDefaultEntryOrg(DynamicObject bill, DynamicObject entry, Map<String, Object> cacheMap) {
        DynamicObject material;
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
        if (orgId != null && settleOrg == null) {
            String settleCacheKey = orgId + "entrysettleorg";
            if (SalContractBillHelper.isCached(cacheMap, settleCacheKey)) {
                settleOrg = (DynamicObject)cacheMap.get(settleCacheKey);
            } else {
                settleOrg = OrgHelper.getOrgForFormDefObjValue((Long)orgId, (String)"03", (String)"10", (String)"toorg");
                cacheMap.put(settleCacheKey, settleOrg);
            }
            entry.set("entrysettleorg", (Object)settleOrg);
        }
        DynamicObject recOrg = (DynamicObject)entry.get("entryinvorg");
        if (orgId != null && recOrg == null) {
            String cacheKey = orgId + "entryinvorg";
            if (SalContractBillHelper.isCached(cacheMap, cacheKey)) {
                recOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                recOrg = OrgHelper.getOrgForFormDefObjValue((Long)orgId, (String)"03", (String)"05", (String)"toorg");
                cacheMap.put(cacheKey, recOrg);
            }
            entry.set("entryinvorg", (Object)recOrg);
        }
        if (entry.getDate("deliverydate") == null) {
            entry.set("deliverydate", (Object)bill.getDate("biztime"));
        }
        if ((material = entry.getDynamicObject("material")) != null && material.getDynamicObject("masterid") != null) {
            DynamicObject masterid = material.getDynamicObject("masterid");
            if (entry.getDynamicObject("productline") == null) {
                DynamicObject productLine = masterid.getDynamicObject("productline");
                entry.set("productline", (Object)productLine);
            }
            if (!"2".equals(masterid.getString("configproperties"))) {
                entry.set("configuredcode", null);
            }
        }
    }

    private static boolean isCached(Map<String, Object> map, String key) {
        return map.containsKey(key);
    }
}

