/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class SupplierHelper {
    public static DynamicObject getLinkMan(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        DynamicObjectCollection entryLinkman = supplier.getDynamicObjectCollection("entry_linkman");
        DynamicObject linkman = null;
        for (DynamicObject rowLinkman : entryLinkman) {
            boolean isDefault = rowLinkman.getBoolean("isdefault_linkman");
            boolean invalid = rowLinkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return rowLinkman;
            }
            if (linkman != null || invalid) continue;
            linkman = rowLinkman;
        }
        return linkman;
    }

    public static DynamicObject getLinkmanObject(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        DynamicObject supplierLinkMans = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier");
        DynamicObjectCollection linkmans = supplierLinkMans.getDynamicObjectCollection("entry_linkman");
        DynamicObject supplierLinkmanId = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                supplierLinkmanId = linkman;
                break;
            }
            if (supplierLinkmanId != null || invalid) continue;
            supplierLinkmanId = linkman;
        }
        DynamicObject linkmanObject = null;
        if (supplierLinkmanId != null) {
            linkmanObject = BusinessDataServiceHelper.loadSingleFromCache((Object)supplierLinkmanId.getPkValue(), (String)"bd_supplierlinkman");
        }
        return linkmanObject;
    }

    public static String getAddress(DynamicObject supplier) {
        QFilter f2;
        if (supplier == null) {
            return null;
        }
        QFilter f1 = new QFilter("supplierid", "=", (Object)supplier.getPkValue().toString());
        Map bd_address = BusinessDataServiceHelper.loadFromCache((String)"bd_address", (QFilter[])new QFilter[]{f1, f2 = new QFilter("invalid", "=", (Object)Boolean.FALSE)});
        if (bd_address == null || bd_address.size() <= 0) {
            return StringUtils.getEmpty();
        }
        String validAddr = StringUtils.getEmpty();
        for (Map.Entry e : bd_address.entrySet()) {
            DynamicObject addr = (DynamicObject)bd_address.get(e.getKey());
            if (addr.getBoolean("default")) {
                return addr.getString("detailaddress");
            }
            if (!StringUtils.isEmpty((String)validAddr)) continue;
            validAddr = addr.getString("detailaddress");
        }
        return StringUtils.isEmpty((String)validAddr) ? supplier.getString("bizpartner_address") : validAddr;
    }

    public static DynamicObject getSupplierOriginal(DynamicObject supplier, String otherSupplier) {
        if (supplier == null) {
            return null;
        }
        DynamicObject dynamicObject = supplier.getDynamicObject(otherSupplier);
        return dynamicObject;
    }

    public static DynamicObject getSupplierValue(DynamicObject supplier, String otherSupplier) {
        String bizfunction;
        if (supplier == null) {
            return null;
        }
        DynamicObject dynamicObject = supplier.getDynamicObject(otherSupplier);
        if (dynamicObject != null) {
            QFilter id = new QFilter("id", "=", dynamicObject.getPkValue());
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            id = id.and(status.and(enable));
            switch (otherSupplier) {
                case "invoicesupplierid": {
                    QFilter invoicehold = new QFilter("invoicehold", "=", (Object)"0");
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%2%");
                    id = id.and(invoicehold).and(bizfunction2);
                    break;
                }
                case "deliversupplierid": {
                    QFilter purchasehold = new QFilter("purchasehold", "=", (Object)"0");
                    QFilter bizfunction1 = new QFilter("bizfunction", "like", (Object)"%4%");
                    id = id.and(purchasehold).and(bizfunction1);
                    break;
                }
                case "receivingsupplierid": {
                    QFilter payhold = new QFilter("payhold", "=", (Object)"0");
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%3%");
                    id = id.and(payhold).and(bizfunction2);
                }
            }
            DynamicObject otSupplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{id});
            if (otSupplier != null) {
                return otSupplier;
            }
            if (((Long)supplier.getPkValue()).equals((Long)dynamicObject.getPkValue())) {
                return null;
            }
        }
        if (StringUtils.isBlank((String)(bizfunction = supplier.getString("bizfunction")))) {
            return null;
        }
        switch (otherSupplier) {
            case "invoicesupplierid": {
                if (!supplier.getBoolean("invoicehold") && bizfunction.contains("2")) break;
                return null;
            }
            case "deliversupplierid": {
                if (!supplier.getBoolean("purchasehold") && bizfunction.contains("4")) break;
                return null;
            }
            case "receivingsupplierid": {
                if (!supplier.getBoolean("payhold") && bizfunction.contains("3")) break;
                return null;
            }
        }
        return supplier;
    }
}

