/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scmc.conm.enums.BizReviewStatusEnum;
import kd.scmc.conm.enums.BizSignStatusEnum;
import kd.scmc.conm.enums.BizValidStatusEnum;
import kd.scmc.conm.enums.StatusEnum;

public class TaskHelper {
    private static Log log = LogFactory.getLog(TaskHelper.class);

    private TaskHelper() {
    }

    public static void execOpAndSendErrorMsg(String entityName, String opKey, List<DynamicObject> bills) {
        if (bills == null || bills.isEmpty()) {
            return;
        }
        OperationResult res = null;
        try {
            Object[] ids = bills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()).toArray();
            log.info("\u5b9e\u4f53 : " + entityName + ", \u5408\u6cd5\u5355\u636e \uff1a " + Arrays.toString(ids));
            res = TaskHelper.executeOpIgnoreTip(opKey, entityName, ids);
            if (res != null) {
                log.info("\u5b9e\u4f53: " + entityName + " \u6267\u884c\u64cd\u4f5c\u7ed3\u679c : " + res.isSuccess() + ", " + res.getMessage());
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
            TaskHelper.sendSysMsg(bills, MessageFormat.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4efb\u52a1\u5931\u8d25\uff1a\u6267\u884c\u64cd\u4f5c {0}\uff0c{1}\u3002", (String)"TaskHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]), opKey, e.getMessage()), false);
        }
        if (res != null && !res.isSuccess()) {
            List sucessPKIds = res.getSuccessPkIds();
            List<DynamicObject> errorBills = bills.stream().filter(dym -> !sucessPKIds.contains(dym.getPkValue())).collect(Collectors.toList());
            TaskHelper.sendSysMsg(errorBills, MessageFormat.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4efb\u52a1\u5931\u8d25\uff1a\u6267\u884c\u64cd\u4f5c {0}\uff0c{1}\u3002", (String)"TaskHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]), opKey, res.getMessage()), false);
        }
    }

    public static List<QFilter> getValidQFilter() {
        QFilter qfilter1 = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter qfilter2 = new QFilter("validstatus", "=", (Object)BizValidStatusEnum.UNVALID.getValue());
        QFilter qfilter4 = new QFilter("signstatus", "=", (Object)BizSignStatusEnum.SIGN.getValue());
        qfilter4.or(new QFilter("signstatus", "=", (Object)BizSignStatusEnum.INACTIVE.getValue()));
        QFilter qfilter5 = new QFilter("reviewstatus", "=", (Object)BizReviewStatusEnum.PASS.getValue());
        qfilter5.or(new QFilter("reviewstatus", "=", (Object)BizReviewStatusEnum.INACTIVE.getValue()));
        return new ArrayList<QFilter>(Arrays.asList(qfilter1, qfilter2, qfilter4, qfilter5));
    }

    public static List<QFilter> getUnValidQFilter() {
        QFilter qfilter1 = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter qfilter2 = new QFilter("validstatus", "=", (Object)BizValidStatusEnum.VALID.getValue());
        QFilter qfilter4 = new QFilter("signstatus", "=", (Object)BizSignStatusEnum.SIGN.getValue());
        qfilter4.or(new QFilter("signstatus", "=", (Object)BizSignStatusEnum.INACTIVE.getValue()));
        QFilter qfilter5 = new QFilter("reviewstatus", "=", (Object)BizReviewStatusEnum.PASS.getValue());
        qfilter5.or(new QFilter("reviewstatus", "=", (Object)BizReviewStatusEnum.INACTIVE.getValue()));
        return new ArrayList<QFilter>(Arrays.asList(qfilter1, qfilter2, qfilter4, qfilter5));
    }

    public static OperationResult executeOpIgnoreTip(String opKey, String entityName, DynamicObject[] validBills) {
        if (validBills == null || validBills.length == 0) {
            return null;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("isshowmessage", "false");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("ignoreValidation", "true");
        option.setVariableValue("WF", String.valueOf(false));
        return OperationServiceHelper.executeOperate((String)opKey, (String)entityName, (DynamicObject[])validBills, (OperateOption)option);
    }

    public static OperationResult executeOpIgnoreTip(String opKey, String entityName, Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("isshowmessage", "false");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("ignoreValidation", "true");
        option.setVariableValue("WF", String.valueOf(false));
        return OperationServiceHelper.executeOperate((String)opKey, (String)entityName, (Object[])ids, (OperateOption)option);
    }

    public static void sendSysMsg(List<DynamicObject> bills, String message, boolean isSuccess) {
        if (bills == null || bills.isEmpty()) {
            return;
        }
        String sucStr = isSuccess ? ResManager.loadKDString((String)"\u4efb\u52a1\u6210\u529f", (String)"TaskHelper_1", (String)"scmc-conm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4efb\u52a1\u5931\u8d25", (String)"TaskHelper_2", (String)"scmc-conm-business", (Object[])new Object[0]);
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        LocaleString title = bills.get(0).getDataEntityType().getDisplayName();
        msgInfo.setEntityNumber(bills.get(0).getDataEntityType().getName());
        Map<Long, List<String>> map = TaskHelper.getUserBillInfo(bills);
        for (Map.Entry<Long, List<String>> e : map.entrySet()) {
            msgInfo.setUserIds(Collections.singletonList(e.getKey()));
            msgInfo.setTitle(title.getLocaleValue() + sucStr);
            msgInfo.setContent(e.getValue() + " " + message);
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
    }

    @Deprecated
    public static List<DynamicObject> filterBillBySysParm(List<DynamicObject> allBills, String parmKey, Object parmValue) {
        if (allBills == null || allBills.isEmpty() || parmValue == null) {
            return allBills;
        }
        return allBills.stream().filter(dym -> dym != null && dym.getDynamicObject("type") != null).filter(dym -> {
            DynamicObject type = dym.getDynamicObject("type");
            return type.get(parmKey).equals(parmValue);
        }).collect(Collectors.toList());
    }

    public static List<String> selectFields() {
        ArrayList<String> selectList = new ArrayList<String>(15);
        selectList.add("org");
        selectList.add("billno");
        selectList.add("billstatus");
        selectList.add("creator");
        selectList.add("auditor");
        selectList.add("type");
        return selectList;
    }

    private static Map<Long, List<String>> getUserBillInfo(List<DynamicObject> bills) {
        HashMap<Long, List<String>> map = new HashMap<Long, List<String>>(16);
        if (bills == null || bills.isEmpty()) {
            return map;
        }
        for (DynamicObject bill : bills) {
            DynamicObject creator = bill.getDynamicObject("creator");
            if (creator == null) continue;
            Long userId = (Long)creator.getPkValue();
            String billNo = bill.getString("billno");
            ArrayList<String> billNos = (ArrayList<String>)map.get(userId);
            if (billNos == null) {
                billNos = new ArrayList<String>();
                billNos.add(billNo);
            } else {
                billNos.add(billNo);
            }
            map.put(userId, billNos);
        }
        return map;
    }
}

