/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;

public class WebOfficeShowHelper {
    private static final Log logger = LogFactory.getLog(WebOfficeShowHelper.class);

    public static void showEditForm(IFormView view, WebOfficeBrowserParam param) {
        String customParams;
        Map params;
        StringBuilder formUrl = new StringBuilder();
        formUrl.append("?formId=").append(param.getFormId());
        if (StringUtils.isNotBlank((CharSequence)param.getBillFormId())) {
            formUrl.append("&billFormId=").append(param.getBillFormId());
        }
        StringBuilder dFormUrl = new StringBuilder();
        dFormUrl.append("#/dform?formId=").append(param.getFormId());
        if (StringUtils.isNotBlank((CharSequence)param.getBillFormId())) {
            dFormUrl.append("&billFormId=").append(param.getBillFormId());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPkId())) {
            dFormUrl.append("&pkId=").append(param.getPkId());
        }
        if (param.getStatus() != null) {
            dFormUrl.append("&Status=").append(param.getStatus().getValue());
        }
        if (null != (params = param.getParams()) && !params.isEmpty()) {
            customParams = "";
            try {
                customParams = URLEncoder.encode(URLEncoder.encode(SerializationUtils.toJsonString((Object)params), "utf-8"), "utf-8");
            }
            catch (UnsupportedEncodingException var9) {
                logger.error((Throwable)var9);
            }
            if (StringUtils.isNotBlank((CharSequence)customParams)) {
                dFormUrl.append("&customParams=").append(customParams);
            }
        }
        customParams = param.getProtocol();
        String domainUrl = UrlService.getDomainContextUrl();
        domainUrl = RevProxyUtil.addSlash((String)domainUrl);
        StringBuilder url = new StringBuilder();
        url.append(customParams).append(domainUrl).append((CharSequence)formUrl);
        try {
            String result = dFormUrl.insert(0, EncreptSessionUtils.encryptTokenLoinSession((String)url.toString())).toString();
            logger.info("weboffice\u5730\u5740\uff1a" + result);
            view.openUrl(result);
        }
        catch (UnsupportedEncodingException var8) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u94fe\u63a5\u5931\u8d25\u3002", (String)"WebOfficeShowHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
    }
}

