/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper.performctrl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.consts.ContractPerformConst;
import kd.scmc.conm.enums.BizCloseStatusEnum;
import kd.scmc.conm.enums.ExcuteControlEnum;
import kd.scmc.conm.utils.CommonUtils;

public class ContPerformCtrlHelper {
    private static final Log LOGGER = LogFactory.getLog(ContPerformCtrlHelper.class);

    private ContPerformCtrlHelper() {
    }

    public static boolean isCheck(String performFormId, String operateKey) {
        boolean isCheck = false;
        if (performFormId.equals("pm_purorderbill") && (operateKey.equals("submit") || operateKey.equals("audit"))) {
            isCheck = true;
        }
        if (performFormId.equals("pm_purrefundapplybill")) {
            isCheck = false;
        }
        if ((performFormId.equals("pm_xpurorderbill") || performFormId.equals("pm_xspurorderbill")) && (operateKey.equals("submit") || operateKey.equals("audit") || operateKey.equals("bizchange") || operateKey.equals("bizvalid") || operateKey.equals("active"))) {
            isCheck = true;
        }
        return isCheck;
    }

    public static boolean isWriteBack(String performFormId, String operateKey) {
        boolean isWB = false;
        if (performFormId.equals("pm_purorderbill") && (operateKey.equals("test-statusconvert") || operateKey.equals("test-unstatusconvert") || operateKey.equals("audit") || operateKey.equals("unaudit"))) {
            isWB = true;
        }
        if (performFormId.equals("pm_purrefundapplybill")) {
            isWB = false;
        }
        if ((performFormId.equals("pm_xpurorderbill") || performFormId.equals("pm_xspurorderbill")) && (operateKey.equals("bizchange") || operateKey.equals("bizvalid") || operateKey.equals("active"))) {
            isWB = true;
        }
        return isWB;
    }

    public static BigDecimal getDirection(String operateKey) {
        BigDecimal direction = new BigDecimal("1");
        if (operateKey.equals("submit") || operateKey.equals("test-statusconvert") || operateKey.equals("audit") || operateKey.equals("bizchange") || operateKey.equals("bizvalid") || operateKey.equals("active")) {
            direction = new BigDecimal("1");
        } else if (operateKey.equals("unsubmit") || operateKey.equals("test-unstatusconvert") || operateKey.equals("unaudit")) {
            direction = new BigDecimal("-1");
        }
        return direction;
    }

    public static List<DLock> getLocks(Set<Long> contKey, String performFormId) {
        Boolean tryLock;
        ArrayList<DLock> locks = new ArrayList<DLock>();
        if (performFormId.equals("pm_xpurorderbill") || performFormId.equals("pm_xspurorderbill")) {
            performFormId = "pm_purorderbill";
        }
        if (!(tryLock = ContPerformCtrlHelper.createLock(contKey, performFormId, locks)).booleanValue()) {
            ContPerformCtrlHelper.unLocks(locks);
            throw new KDBizException(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u53cd\u5199\u201c\u5408\u540c\u201d\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ContPerformCtrlHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Boolean createLock(Set<Long> contKey, String performFormId, List<DLock> locks) {
        boolean isSuccess = true;
        Iterator<Long> iterator = contKey.iterator();
        while (iterator.hasNext()) {
            Long contId = iterator.next();
            DLock lock = DLock.createReentrant((String)String.format("scmc/conm/%s/%s", performFormId, contId));
            Class<ContPerformCtrlHelper> clazz = ContPerformCtrlHelper.class;
            // MONITORENTER : kd.scmc.conm.business.helper.performctrl.ContPerformCtrlHelper.class
            if (!lock.tryLock(1000L)) {
                isSuccess = false;
                // MONITOREXIT : clazz
                return isSuccess;
            }
            locks.add(lock);
            // MONITOREXIT : clazz
        }
        return isSuccess;
    }

    public static void unLocks(List<DLock> locks) {
        for (DLock item : locks) {
            item.unlock();
        }
    }

    public static void contClose(DynamicObject contract, Set<Long> writeBackContEntry) {
        String ctrl = contract.getString("type.excutecontrol");
        if (ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(ctrl) || ExcuteControlEnum.AMOUNT_QTY.getValue().equals(ctrl) || ExcuteControlEnum.QTY.getValue().equals(ctrl)) {
            DynamicObjectCollection contEntrys = contract.getDynamicObjectCollection("billentry");
            boolean billclose = true;
            for (DynamicObject entry : contEntrys) {
                if (writeBackContEntry == null || !writeBackContEntry.contains(entry.getPkValue())) {
                    if (!BizCloseStatusEnum.UNCLOSE.getValue().equals(entry.getString("rowclosestatus"))) continue;
                    billclose = false;
                    continue;
                }
                if (entry.getBigDecimal("baseqty").compareTo(BigDecimal.ZERO) != 0 && entry.getBigDecimal("orderbaseqty").compareTo(entry.getBigDecimal("baseqty")) >= 0) {
                    entry.set("rowclosestatus", (Object)BizCloseStatusEnum.CLOSE.getValue());
                    continue;
                }
                entry.set("rowclosestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                billclose = false;
            }
            if (billclose) {
                contract.set("closestatus", (Object)BizCloseStatusEnum.CLOSE.getValue());
                contract.set("closer", (Object)ContractPerformConst.ADMINISTRATORID);
                contract.set("closedate", (Object)new Date());
            } else {
                contract.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                contract.set("closer", null);
                contract.set("closedate", null);
            }
        }
    }

    public static Map<Long, Map<Long, List<DynamicObject>>> groupBillsByConInfo(DynamicObject[] bills) {
        Map<Long, List<DynamicObject>> id_entrys = Arrays.stream(bills).flatMap(a -> a.getDynamicObjectCollection("billentry").stream()).collect(Collectors.groupingBy(a -> a.getLong("conbillid")));
        HashMap<Long, Map<Long, List<DynamicObject>>> billentryMap = new HashMap<Long, Map<Long, List<DynamicObject>>>(id_entrys.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : id_entrys.entrySet()) {
            Long contId = entry.getKey();
            List<DynamicObject> entryValue = entry.getValue();
            Map<Long, List<DynamicObject>> conentryid_entry = entryValue.stream().collect(Collectors.groupingBy(a -> a.getLong("conbillentryid")));
            billentryMap.put(contId, conentryid_entry);
        }
        return billentryMap;
    }

    public static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId == null || srcUnit == null || desUnit == null || srcQty == null) {
            desQty = BigDecimal.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            desQty = srcQty;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null) {
                int numerator = muConv.getInt("numerator");
                int denominator = muConv.getInt("denominator");
                if (denominator != 0) {
                    int unitPrecision = desUnit.getInt("precision");
                    int account = desUnit.getInt("precisionaccount");
                    int unitPrecisionType = 4;
                    if (account == 2) {
                        unitPrecisionType = 1;
                    } else if (account == 3) {
                        unitPrecisionType = 0;
                    }
                    desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
                }
            }
        }
        return desQty;
    }

    public static void reCalculateDifferenceData(DynamicObject bill, Map<Object, DynamicObject> srcBillEntrys) {
        long startTime = System.currentTimeMillis();
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        BigDecimal totalAmount = new BigDecimal(0);
        BigDecimal totalTaxAmount = new BigDecimal(0);
        BigDecimal totalAllAmount = new BigDecimal(0);
        String billName = bill.getDynamicObjectType().getName();
        String srcEntryid = "";
        if ("pm_xpurorderbill".equals(billName)) {
            srcEntryid = "sourceentryid";
        } else if ("pm_xspurorderbill".equals(billName)) {
            srcEntryid = "entrysrcid";
        }
        if (srcBillEntrys != null && !srcBillEntrys.isEmpty()) {
            for (DynamicObject entry : billEntry) {
                String entryChangeType = entry.getString("entrychangetype");
                Long srcEntryId = entry.getLong(srcEntryid);
                Long conBillEntryId = entry.getLong("conbillentryid");
                if (Long.compare(conBillEntryId, 0L) == 0 || Long.compare(srcEntryId, 0L) == 0) continue;
                switch (entryChangeType) {
                    case "B": 
                    case "C": {
                        ContPerformCtrlHelper.updateModifyEntry(entry, srcBillEntrys.get(srcEntryId), entryChangeType);
                        break;
                    }
                }
                totalAmount = totalAmount.add(entry.getBigDecimal("amount"));
                totalTaxAmount = totalTaxAmount.add(entry.getBigDecimal("taxamount"));
                totalAllAmount = totalAllAmount.add(entry.getBigDecimal("amountandtax"));
            }
        }
        bill.set("totalamount", (Object)totalAmount);
        bill.set("totaltaxamount", (Object)totalTaxAmount);
        bill.set("totalallamount", (Object)totalAllAmount);
        LOGGER.info(String.format(ResManager.loadKDString((String)"\u5408\u540c\u5c65\u884c-\u53d8\u66f4\u5355\u5dee\u91cf\u8ba1\u7b97\uff0c\u53d8\u66f4\u5355id:%s ,\u5355\u5934.\u91d1\u989d\uff1a%s ,\u5355\u5934.\u7a0e\u989d\uff1a%s ,\u5355\u5934.\u4ef7\u7a0e\u5408\u8ba1:%s", (String)"", (String)"", (Object[])new Object[0]), bill.getPkValue(), bill.getBigDecimal("totalamount").toPlainString(), bill.getBigDecimal("totaltaxamount").toPlainString(), bill.getBigDecimal("totalallamount").toPlainString()));
        long endTime = System.currentTimeMillis();
        LOGGER.info(ResManager.loadKDString((String)"\u5408\u540c\u5c65\u884c-\u53d8\u66f4\u5355\u5dee\u91cf\u8ba1\u7b97\uff0c\u8017\u65f6:", (String)"", (String)"", (Object[])new Object[0]) + (endTime - startTime) + "ms");
    }

    private static void updateModifyEntry(DynamicObject entry, DynamicObject srcEntry, String entryChangeType) {
        if (srcEntry == null) {
            return;
        }
        DynamicObject xbill = (DynamicObject)entry.getParent();
        entry.set("srcbillentity", (Object)srcEntry.getString("srcbillentity"));
        if ("C".equals(entryChangeType)) {
            entry.set("amount", (Object)srcEntry.getBigDecimal("amount").negate());
            entry.set("taxamount", (Object)srcEntry.getBigDecimal("taxamount").negate());
            entry.set("amountandtax", (Object)srcEntry.getBigDecimal("amountandtax").negate());
            entry.set("baseqty", (Object)srcEntry.getBigDecimal("baseqty").negate());
            entry.set("qty", (Object)srcEntry.getBigDecimal("qty").negate());
        } else {
            entry.set("amount", (Object)entry.getBigDecimal("amount").subtract(srcEntry.getBigDecimal("amount")));
            entry.set("taxamount", (Object)entry.getBigDecimal("taxamount").subtract(srcEntry.getBigDecimal("taxamount")));
            entry.set("amountandtax", (Object)entry.getBigDecimal("amountandtax").subtract(srcEntry.getBigDecimal("amountandtax")));
            entry.set("baseqty", (Object)entry.getBigDecimal("baseqty").subtract(srcEntry.getBigDecimal("baseqty")));
            entry.set("qty", (Object)entry.getBigDecimal("qty").subtract(srcEntry.getBigDecimal("qty")));
        }
    }

    public static Map<Long, DynamicObject> getEnableCtrlContract(Map<String, Set<Long>> contIdMap) {
        try (TraceSpan span = Tracer.create((String)"ContractPerformCtrlHelper", (String)"getEnableCtrlContract");){
            long startTime = System.currentTimeMillis();
            ArrayList conts = new ArrayList();
            ArrayList<Long> allOrgs = new ArrayList<Long>();
            contIdMap.forEach((conmEntity, conmIdSet) -> {
                DynamicObject[] contracts;
                for (DynamicObject contract : contracts = BusinessDataServiceHelper.load((String)conmEntity, (String)"billno,org, type.excutecontrol, totalamount, totaltaxamount, totalallamount, orderallamount,closer, closestatus,closedate,billentry.seq, billentry.material, billentry.unit, billentry.baseunit, billentry.qty, billentry.orderbaseqty, billentry.orderqty,billentry.joinorderbaseqty, billentry.joinorderqty, billentry.baseqty, billentry.priceandtax, billentry.lineno, billentry.rowclosestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", conmIdSet)})) {
                    conts.add(contract);
                    allOrgs.add((Long)contract.getDynamicObject("org").getPkValue());
                }
            });
            Set<Long> ctlOrgs = ContPerformCtrlHelper.getPerformCtlOrgs(allOrgs);
            Map<Long, DynamicObject> contMap = conts.stream().filter(a -> ctlOrgs.contains(a.getDynamicObject("org").getPkValue())).collect(Collectors.toMap(b -> (Long)b.getPkValue(), b -> b));
            long endTime = System.currentTimeMillis();
            LOGGER.info(ResManager.loadKDString((String)"\u5408\u540c\u5c65\u884c\uff0c\u67e5\u8be2\u5f00\u542f\u8ba2\u5355\u63a7\u5236\u7684\u8ba2\u5355\u5bf9\u5e94\u7684\u5408\u540c\uff0c\u8017\u65f6:", (String)"", (String)"", (Object[])new Object[0]) + (endTime - startTime) + "ms");
            Map<Long, DynamicObject> map = contMap;
            return map;
        }
    }

    public static Map<String, Set<Long>> getContractIds(DynamicObject[] bills) {
        List<DynamicObject> entryList = Arrays.stream(bills).map(bill -> bill.getDynamicObjectCollection("billentry")).flatMap(billEntry -> billEntry.stream().filter(entry -> !CommonUtils.isNull((Object)entry.getDynamicObject("conbillentity")))).collect(Collectors.toList());
        HashMap<String, Set<Long>> contIdMap = new HashMap<String, Set<Long>>(16);
        entryList.forEach(entry -> {
            String conmEntity = entry.getDynamicObject("conbillentity").getString("number");
            Long conmBillId = entry.getLong("conbillid");
            if (contIdMap.get(conmEntity) == null) {
                HashSet<Long> conmIdSet = new HashSet<Long>();
                conmIdSet.add(conmBillId);
                contIdMap.put(conmEntity, conmIdSet);
            } else {
                ((Set)contIdMap.get(conmEntity)).add(conmBillId);
            }
        });
        LOGGER.info(ResManager.loadKDString((String)("\u67e5\u8be2\u5408\u540cid\uff1a" + JSON.toJSONString(contIdMap)), (String)"", (String)"", (Object[])new Object[0]));
        return contIdMap;
    }

    public static Set<Long> getPerformCtlOrgs(List<Long> allOrg) {
        long startTime = System.currentTimeMillis();
        Map<String, Object> purControlMap = AppParameterHelper.batchGetAppParameter("conm", "15", allOrg, "fpurorderctrl");
        Set<Long> controlOrg = purControlMap.entrySet().stream().filter(e -> "true".equals(String.valueOf(e.getValue()))).map(org -> Long.valueOf((String)org.getKey())).collect(Collectors.toSet());
        LOGGER.info(ResManager.loadKDString((String)"\u5408\u540c\u5c65\u884c\uff0c\u5f00\u542f\u8ba2\u5355\u63a7\u5236\u7684\u7ec4\u7ec7 \uff1a", (String)"", (String)"", (Object[])new Object[0]) + JSON.toJSONString(controlOrg));
        long endTime = System.currentTimeMillis();
        LOGGER.info(ResManager.loadKDString((String)"\u5408\u540c\u5c65\u884c\uff0c\u67e5\u8be2\u5f00\u542f\u63a7\u5236\u7684\u7ec4\u7ec7\u8017\u65f6:", (String)"", (String)"", (Object[])new Object[0]) + (endTime - startTime) + "ms");
        return controlOrg;
    }

    public static Map<String, Date> getPerformOrgEnableTime(Collection<DynamicObject> bills) {
        List allOrg = bills.stream().map(v -> v.getLong("org.id")).collect(Collectors.toList());
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"conm");
        AppParam appParam = new AppParam();
        appParam.setActBookId(Long.valueOf(0L));
        appParam.setAppId(appId);
        appParam.setViewType("15");
        Map map = SystemParamServiceHelper.loadBatchAppParameterByOrg((AppParam)appParam, allOrg);
        HashMap<String, Date> enableDateMap = new HashMap<String, Date>();
        for (Map.Entry mapEntry : map.entrySet()) {
            String orgId = (String)mapEntry.getKey();
            Map param = (Map)mapEntry.getValue();
            String fpurOrderCtrl = String.valueOf(param.get("fpurorderctrl"));
            Date fenableTime = (Date)param.get("fenabletime");
            if (!"true".equals(fpurOrderCtrl)) continue;
            enableDateMap.put(orgId, fenableTime);
        }
        return enableDateMap;
    }
}

