/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.blockchain;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.conm.business.helper.BizAppHelper;

public class BlockChainEventServiceImpl
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(BlockChainEventServiceImpl.class);

    public Object handleEvent(KDBizEvent e) {
        logger.info("BlockChainEventServiceImpl :" + e.getEventNumber() + "eventId:" + e.getEventId());
        EntityEvent entityEvent = null;
        if (e instanceof EntityEvent) {
            entityEvent = (EntityEvent)e;
        }
        if (entityEvent == null) {
            logger.info("event = null");
            return e.getEventId();
        }
        if (!BizAppHelper.isDeployApp("bea")) {
            logger.info(ResManager.LoadKDString((String)"\u672a\u90e8\u7f72\u533a\u5757\u94fe\u5b58\u8bc1\u670d\u52a1", (String)""));
            return e.getEventId();
        }
        logger.info("begin scan....");
        List businessPkIds = entityEvent.getBusinesskeys();
        String bizOperation = entityEvent.getOperation();
        String bizEntityKey = entityEvent.getEntityNumber();
        if (businessPkIds != null && businessPkIds.size() > 0) {
            String taskId = "";
            String billNoField = "billno";
            ArrayList<Long> pks = new ArrayList<Long>(businessPkIds.size());
            for (String pkId : businessPkIds) {
                pks.add(Long.valueOf(pkId));
            }
            String queryFields = "billno";
            switch (bizEntityKey) {
                case "conm_purcontract": {
                    if (bizOperation.equals("bizvalid")) {
                        taskId = "20210908-983EE605";
                        break;
                    }
                    if (!bizOperation.equals("bizterminate")) break;
                    taskId = "20210908-D5E3E93D";
                    break;
                }
                case "conm_xpurcontract": {
                    if (!bizOperation.equals("bizvalid")) break;
                    taskId = "20210908-EFA72643";
                    break;
                }
                case "conm_purendagrt": {
                    if (!bizOperation.equals("bizvalid")) break;
                    taskId = "20210908-33848F55";
                    break;
                }
                case "conm_pursupagrt": {
                    if (!bizOperation.equals("bizvalid")) break;
                    taskId = "20210908-B74C9388";
                    break;
                }
                case "pm_purorderbill": {
                    if (bizOperation.equals("audit")) {
                        taskId = "20210908-39EB9633";
                        break;
                    }
                    if (!bizOperation.equals("unaudit")) break;
                    taskId = "20210908-51D7B5A2";
                    break;
                }
                case "pm_xpurorderbill": {
                    queryFields = queryFields + ",sourceno";
                    billNoField = "sourceno";
                    if (!bizOperation.equals("active")) break;
                    taskId = "20210908-AAF929E4";
                    break;
                }
                case "pm_xspurorderbill": {
                    if (!bizOperation.equals("bizvalid")) break;
                    taskId = "20210908-AAF929E4";
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)taskId)) {
                String finalBillNoField = billNoField;
                Set billNos = BusinessDataServiceHelper.loadFromCache((String)bizEntityKey, (String)queryFields, (QFilter[])new QFilter("id", "in", (Object)pks.toArray()).toArray()).values().stream().map(a -> a.getString(finalBillNoField)).collect(Collectors.toSet());
                for (String billNo : billNos) {
                    this.invokeService(bizOperation, bizEntityKey, taskId, billNo);
                }
            }
        }
        logger.info("end scan....");
        return e.getEventId();
    }

    private void invokeService(String bizOperation, String bizEntityKey, String taskId, String billNo) {
        Object o = DispatchServiceHelper.invokeBizService((String)"bsc", (String)"bea", (String)"StcTaskService", (String)"toChain", (Object[])new Object[]{taskId, billNo});
    }
}

