/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.cooperate.impl.core.subscriber;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.conm.business.service.cooperate.impl.core.router.IRouter;
import kd.scmc.conm.business.service.cooperate.impl.core.router.MicroServiceRouter;
import kd.scmc.conm.business.service.cooperate.impl.core.subscriber.BaseTopicSubscriber;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateRequest;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateResponse;

public class OperateTopicSubscriber
extends BaseTopicSubscriber {
    public OperateTopicSubscriber(String name, IRouter router) {
        this.name = name;
        this.router = router;
    }

    @Override
    public CooperateResponse invoke(CooperateRequest request) {
        CooperateResponse response = new CooperateResponse();
        if (this.router != null && this.router instanceof MicroServiceRouter) {
            Map result = (Map)this.router.dispatch(this.wrapperSyncRequestArgs(request));
            String status = (String)result.get("status");
            if (!"all".equals(status)) {
                response.setSuccess(Boolean.FALSE);
            }
            response.setMsg((String)result.get("errmsg"));
            response.setDetail((Map)result.get("errdata"));
        }
        return response;
    }

    private HashMap<String, Object> wrapperSyncRequestArgs(CooperateRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entity", request.getEntity());
        map.put("optype", request.getEvent());
        map.put("operator", request.getOperator());
        map.put("time", request.getTime());
        List<DynamicObject> bills = request.getBills();
        List billIds = bills.stream().map(con -> con.getLong("id")).collect(Collectors.toList());
        map.put("bills", billIds);
        return map;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

