/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.cooperate.impl.core.subscriber;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.BotpPushHelper;
import kd.scmc.conm.business.helper.OperateExecuteHelper;
import kd.scmc.conm.business.pojo.ReturnResultInfo;
import kd.scmc.conm.business.service.cooperate.impl.core.subscriber.BaseTopicSubscriber;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateRequest;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateResponse;

public class PushTopicSubscriber
extends BaseTopicSubscriber {
    private Log log = LogFactory.getLog(PushTopicSubscriber.class);
    private String trgEntity;

    public PushTopicSubscriber(String name, String trgEntity) {
        this.name = name;
        this.trgEntity = trgEntity;
    }

    @Override
    public List<DynamicObject> filter(List<DynamicObject> bills, String entity, String operate) {
        List<DynamicObject> superfilter = super.filter(bills, entity, operate);
        ArrayList<DynamicObject> filter = new ArrayList<DynamicObject>();
        if (superfilter != null && superfilter.size() > 0) {
            for (DynamicObject bill : superfilter) {
                if (bill.getBoolean("iscollaconsult")) continue;
                filter.add(bill);
            }
        }
        return filter;
    }

    @Override
    public CooperateResponse invoke(CooperateRequest request) {
        CooperateResponse response = new CooperateResponse();
        if (request != null) {
            List<DynamicObject> bills = request.getBills();
            if (bills != null && bills.size() > 0) {
                Map<String, Object> pushResult = BotpPushHelper.push(bills, request.getEntity(), this.trgEntity);
                Boolean success = (Boolean)pushResult.get("success");
                if (success.booleanValue()) {
                    response = this.audit(this.trgEntity, (List)pushResult.get("targetObjects"));
                } else {
                    Map errorMsg = (Map)pushResult.get("errorMsg");
                    this.log.error("\u4e0b\u63a8\u534f\u540c\u5355\u636e\u5931\u8d25\uff1a" + SerializationUtils.toJsonString((Object)errorMsg));
                    response.setDetail(errorMsg);
                    response.setSuccess(Boolean.FALSE);
                    String kdString = ResManager.loadKDString((String)"\u4e0b\u63a8\u534f\u540c\u5355\u636e\u5931\u8d25\u3002", (String)"PushTopicSubscriber_0", (String)"scmc-conm-business", (Object[])new Object[0]);
                    if (!errorMsg.isEmpty() && errorMsg.size() == 1) {
                        String detailMsg = "";
                        for (String msg : errorMsg.values()) {
                            if (!StringUtils.isNotEmpty((String)msg)) continue;
                            detailMsg = msg;
                            break;
                        }
                        response.setMsg(kdString + "\uff0c" + detailMsg);
                    } else {
                        response.setMsg(kdString);
                    }
                }
            } else {
                response.setSuccess(Boolean.TRUE);
            }
        }
        return response;
    }

    private CooperateResponse audit(String targetEntity, List<DynamicObject> targetBill) {
        CooperateResponse response = new CooperateResponse();
        ReturnResultInfo executeSave = OperateExecuteHelper.executeSave4Rollback(targetEntity, targetBill.toArray(new DynamicObject[targetBill.size()]), null, Boolean.TRUE);
        if (executeSave != null && executeSave.isSuccess() && executeSave.getSuccessList() != null) {
            List<Object> saveSuccessPkIds = executeSave.getSuccessList();
            ReturnResultInfo executeSubmit = OperateExecuteHelper.executeSubmit4Rollback(targetEntity, saveSuccessPkIds.toArray(), null, Boolean.TRUE);
            if (executeSubmit != null && executeSubmit.isSuccess() && executeSubmit.getSuccessList() != null) {
                List<Object> submitSuccessPkIds = executeSubmit.getSuccessList();
                ReturnResultInfo executeAudit = OperateExecuteHelper.executeAudit4Rollback(targetEntity, submitSuccessPkIds.toArray(), null, Boolean.TRUE);
                if (executeAudit == null || !executeAudit.isSuccess() || executeAudit.getSuccessList() == null) {
                    response.setSuccess(Boolean.FALSE);
                    if (executeAudit != null) {
                        response.setMsg(executeAudit.getMessage());
                    }
                }
            } else if (executeSubmit != null) {
                response.setSuccess(Boolean.FALSE);
                response.setMsg(executeSubmit.getMessage());
            }
        } else if (executeSave != null) {
            response.setSuccess(Boolean.FALSE);
            response.setMsg(executeSave.getMessage());
        }
        return response;
    }
}

