/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.cooperate.impl.core.subscriber.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scmc.conm.business.service.cooperate.impl.core.router.IRouter;
import kd.scmc.conm.business.service.cooperate.impl.core.router.MicroServiceRouter;
import kd.scmc.conm.business.service.cooperate.impl.core.subscriber.OperateTopicSubscriber;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateRequest;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateResponse;

public class ReviewApplyOperateTopicSubscriber
extends OperateTopicSubscriber {
    private Log log = LogFactory.getLog(ReviewApplyOperateTopicSubscriber.class);

    public ReviewApplyOperateTopicSubscriber(String name, IRouter router) {
        super(name, router);
    }

    @Override
    public List<DynamicObject> filter(List<DynamicObject> bills, String entity, String operate) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject bill : bills) {
            Long srcBillId;
            String srcBillEntity = bill.getString("srcbillentity");
            if (!this.isNeedSync(srcBillEntity, srcBillId = Long.valueOf(bill.getLong("srcbillid")))) continue;
            list.add(bill);
        }
        return list;
    }

    @Override
    public CooperateResponse invoke(CooperateRequest request) {
        CooperateResponse response = new CooperateResponse();
        String event = request.getEvent();
        List<DynamicObject> bills = request.getBills();
        if (bills != null && bills.size() > 0) {
            HashMap srcEntityMap = new HashMap();
            for (DynamicObject dynamicObject : bills) {
                Long srcBillId;
                String srcBillEntity = dynamicObject.getString("srcbillentity");
                ArrayList<Long> objectList = (ArrayList<Long>)srcEntityMap.get(srcBillEntity);
                if (objectList == null) {
                    objectList = new ArrayList<Long>();
                }
                if ((srcBillId = Long.valueOf(dynamicObject.getLong("srcbillid"))) != null) {
                    objectList.add(srcBillId);
                }
                srcEntityMap.put(srcBillEntity, objectList);
            }
            for (Map.Entry entry : srcEntityMap.entrySet()) {
                Map result;
                String status;
                DynamicObject[] srcBills;
                HashMap<String, Object> map;
                String srcEntity = (String)entry.getKey();
                List srcBillIds = (List)entry.getValue();
                if (this.router == null || !(this.router instanceof MicroServiceRouter) || (map = this.getDispatchData(request, event, srcBills = BusinessDataServiceHelper.load((String)srcEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcBillIds)}), srcEntity)) == null || "all".equals(status = (String)(result = (Map)this.router.dispatch(map)).get("status"))) continue;
                response.setSuccess(Boolean.FALSE);
                response.setMsg((String)result.get("errmsg"));
                response.setDetail((Map)result.get("errdata"));
                return response;
            }
        }
        return response;
    }

    private HashMap<String, Object> getDispatchData(CooperateRequest request, String event, DynamicObject[] srcBills, String srcEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("audit".equals(event)) {
            map.put("optype", "review_passed");
        } else if ("invalid".equals(event) || "bizcancel".equals(event)) {
            map.put("optype", "review_reject");
        } else {
            return null;
        }
        map.put("entity", srcEntity);
        map.put("operator", request.getOperator());
        map.put("time", request.getTime());
        List billIds = Arrays.stream(srcBills).map(con -> con.getLong("id")).collect(Collectors.toList());
        map.put("bills", billIds);
        return map;
    }

    private Object getSysParameter(Long orgId, String key) {
        Object value = null;
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setAppId("2AN7+R08B0/5");
        appParam.setOrgId(orgId);
        Map systemMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (systemMap != null) {
            value = systemMap.get(key);
        }
        return value;
    }

    private boolean isNeedSync(String entity, Long id) {
        Object sccSrm;
        boolean needSync = false;
        DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entity);
        if (srcBill != null && ("conm_purcontract".equals(entity) || "conm_purendagrt".equals(entity) || "conm_pursupagrt".equals(entity)) && srcBill.getBoolean("supplier.issuppcolla") && (sccSrm = this.getSysParameter(srcBill.getLong("org.id"), "sccsrm")) != null && ((Boolean)sccSrm).booleanValue()) {
            needSync = true;
        }
        return needSync;
    }
}

