/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.performctrl.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.performctrl.ContPerformCtrlHelper;
import kd.scmc.conm.business.pojo.performctrl.ContractEntryInfo;
import kd.scmc.conm.business.pojo.performctrl.ContractInfo;
import kd.scmc.conm.business.pojo.performctrl.PerformBillEntryInfo;
import kd.scmc.conm.business.service.performctrl.factory.PerformValidatorFactory;
import kd.scmc.conm.business.service.performctrl.impl.AbstractContractPerform;
import kd.scmc.conm.business.service.performctrl.validator.IPerformDataValidator;
import kd.scmc.conm.enums.StatusEnum;
import kd.scmc.conm.utils.CommonUtils;

public class ContractPerformImpl
extends AbstractContractPerform {
    private static final Log logger = LogFactory.getLog(ContractPerformImpl.class);

    @Override
    public List<String> onPreparePropertys(String formId) {
        return this.getFields(formId);
    }

    @Override
    public DynamicObject[] beforeValidate(DynamicObject[] bills, String operateKey) {
        if (bills == null || bills.length == 0 || StringUtils.isEmpty((String)operateKey)) {
            return bills;
        }
        DynamicObject[] filterBills = this.doFilter(bills, operateKey);
        DynamicObject[] diffData = this.reCalcDiffData(filterBills);
        return diffData;
    }

    @Override
    public Map<String, Object> validate(DynamicObject[] bills, String operateKey) {
        long start = System.currentTimeMillis();
        Map<String, Object> result = new HashMap<String, Object>();
        if (bills == null || bills.length == 0 || StringUtils.isEmpty((String)operateKey)) {
            return result;
        }
        try (TraceSpan span = Tracer.create((String)"ContractPerformImpl", (String)"validate");){
            String performFormId = bills[0].getDataEntityType().getName();
            if (ContPerformCtrlHelper.isCheck(performFormId, operateKey)) {
                IPerformDataValidator validator = PerformValidatorFactory.getValidatorByFormId(performFormId);
                List<ContractInfo> contractInfos = this.prepareValidateData(bills, operateKey);
                result = this.doValidate(contractInfos, validator, operateKey);
            }
            long end = System.currentTimeMillis();
            logger.info(ResManager.loadKDString((String)("\u603b\u6821\u9a8c\u8017\u65f6" + (end - start)), (String)"", (String)"", (Object[])new Object[0]));
            Map<String, Object> map = result;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeback(DynamicObject[] bills, String operateKey) {
        if (bills == null || bills.length == 0 || StringUtils.isEmpty((String)operateKey)) {
            return;
        }
        long start = System.currentTimeMillis();
        try (TraceSpan span = Tracer.create((String)"ContractPerformImpl", (String)"writeback");){
            String formId = bills[0].getDataEntityType().getName();
            if (ContPerformCtrlHelper.isWriteBack(formId, operateKey)) {
                DynamicObject[] diffData = this.reCalcDiffData(bills);
                BigDecimal direction = ContPerformCtrlHelper.getDirection(operateKey);
                Map<String, Set<Long>> contractIds = ContPerformCtrlHelper.getContractIds(diffData);
                long lo1 = System.currentTimeMillis();
                Map<Long, DynamicObject> contMap = ContPerformCtrlHelper.getEnableCtrlContract(contractIds);
                Set<Long> conmIdSet = contMap.values().stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
                List<DLock> locks = ContPerformCtrlHelper.getLocks(conmIdSet, formId);
                long lo2 = System.currentTimeMillis();
                if (!CommonUtils.isNull(locks)) {
                    logger.info(ResManager.loadKDString((String)("\u83b7\u53d6\u9501\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (lo2 - lo1)), (String)"", (String)"", (Object[])new Object[0]));
                    try {
                        if (!contMap.isEmpty()) {
                            logger.info(ResManager.loadKDString((String)"\u641c\u7d22\u5230\u7684\u5408\u540c\u6570\u636e\u4e0d\u4e3a\u7a7a", (String)"", (String)"", (Object[])new Object[0]));
                            this.doWriteBack(diffData, contMap, direction, operateKey);
                        }
                    }
                    finally {
                        ContPerformCtrlHelper.unLocks(locks);
                    }
                }
            }
            long end = System.currentTimeMillis();
            logger.info(ResManager.loadKDString((String)("\u53cd\u5199\u8017\u65f6:" + (end - start)), (String)"", (String)"", (Object[])new Object[0]));
        }
    }

    @Override
    public void record(DynamicObject[] bills, String operateKey) {
    }

    private DynamicObject[] doFilter(DynamicObject[] bills, String operateKey) {
        String allowStatus = "";
        switch (operateKey) {
            case "submit": {
                allowStatus = StatusEnum.SAVE.getValue();
                break;
            }
            case "audit": {
                allowStatus = StatusEnum.SUBMIT.getValue();
                break;
            }
            case "unaudit": 
            case "active": 
            case "bizvalid": {
                allowStatus = StatusEnum.AUDIT.getValue();
            }
        }
        String lamdaAllowStatus = allowStatus;
        bills = Arrays.stream(bills).filter(pbill -> lamdaAllowStatus.equals(pbill.get("billstatus").toString())).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        return bills;
    }

    private List<ContractInfo> prepareValidateData(DynamicObject[] bills, String operateKey) {
        try (TraceSpan span = Tracer.create((String)"ContractPerformImpl", (String)"prepareValidateData");){
            long start = System.currentTimeMillis();
            ArrayList<ContractInfo> list = new ArrayList<ContractInfo>();
            Map<Long, DynamicObject> contMap = ContPerformCtrlHelper.getEnableCtrlContract(ContPerformCtrlHelper.getContractIds(bills));
            if (contMap.isEmpty()) {
                ArrayList<ContractInfo> arrayList = list;
                return arrayList;
            }
            BigDecimal direction = ContPerformCtrlHelper.getDirection(operateKey);
            Map<Long, Map<Long, List<DynamicObject>>> billMap = ContPerformCtrlHelper.groupBillsByConInfo(bills);
            for (Map.Entry<Long, DynamicObject> conEntrySet : contMap.entrySet()) {
                Long conId = conEntrySet.getKey();
                Map<Long, List<DynamicObject>> entryMap = billMap.get(conId);
                if (entryMap == null || entryMap.isEmpty()) continue;
                DynamicObject contract = conEntrySet.getValue();
                ContractInfo contractInfo = this.getContractInfo(contract);
                DynamicObjectCollection conEntrys = contract.getDynamicObjectCollection("billentry");
                for (DynamicObject conEntry : conEntrys) {
                    Long conEntryId = (Long)conEntry.getPkValue();
                    List<DynamicObject> billEntrys = entryMap.get(conEntryId);
                    if (billEntrys == null || billEntrys.size() <= 0) continue;
                    ContractEntryInfo contractEntryInfo = this.getContractEntryInfo(conEntry);
                    for (DynamicObject billEntry : billEntrys) {
                        PerformBillEntryInfo orderEntryInfo = this.getPerformBillEntryInfo(direction, billEntry);
                        contractEntryInfo.addPerformBillInfo(orderEntryInfo);
                    }
                    contractInfo.addContractEntryInfo(contractEntryInfo);
                }
                list.add(contractInfo);
            }
            long end = System.currentTimeMillis();
            logger.info(ResManager.loadKDString((String)("\u6821\u9a8c\u6570\u636e\u5305" + JSON.toJSONString(list) + " ;\u6784\u9020\u8017\u65f6\uff1a" + (end - start)), (String)"", (String)"", (Object[])new Object[0]));
            ArrayList<ContractInfo> arrayList = list;
            return arrayList;
        }
    }

    private Map<String, Object> doValidate(List<ContractInfo> contractInfos, IPerformDataValidator validator, String operateKey) {
        try (TraceSpan span = Tracer.create((String)"ContractPerformImpl", (String)"doValidate");){
            long start = System.currentTimeMillis();
            HashMap<String, Object> result = new HashMap<String, Object>();
            ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
            for (ContractInfo contractInfo : contractInfos) {
                if (validator == null) continue;
                List<OperateErrorInfo> executeResult = validator.execute(contractInfo, operateKey, contractInfo.getDemension());
                errorInfos.addAll(executeResult);
            }
            if (errorInfos.size() > 0) {
                result.put("success", Boolean.FALSE);
                result.put("errorInfos", errorInfos);
            }
            long end = System.currentTimeMillis();
            logger.info(ResManager.loadKDString((String)("\u6821\u9a8c\u8017\u65f6\uff1a" + (end - start)), (String)"", (String)"", (Object[])new Object[0]));
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
    }

    private PerformBillEntryInfo getPerformBillEntryInfo(BigDecimal direction, DynamicObject billEntry) {
        Long orderId = (Long)((DynamicObject)billEntry.getParent()).getPkValue();
        Long orderEntryId = (Long)billEntry.getPkValue();
        int seq = billEntry.getInt("seq");
        BigDecimal amountAndtax = billEntry.getBigDecimal("amountandtax").multiply(direction);
        BigDecimal priceAndtax = billEntry.getBigDecimal("priceandtax");
        BigDecimal baseqty = billEntry.getBigDecimal("baseqty").multiply(direction);
        return new PerformBillEntryInfo(orderId, orderEntryId, seq, amountAndtax, priceAndtax, baseqty);
    }

    private ContractEntryInfo getContractEntryInfo(DynamicObject conEntry) {
        Long conEntryId = (Long)conEntry.getPkValue();
        int conSeq = conEntry.getInt("seq");
        BigDecimal priceAndTax = conEntry.getBigDecimal("priceandtax");
        BigDecimal baseQty = conEntry.getBigDecimal("baseqty");
        BigDecimal orderBaseQty = conEntry.getBigDecimal("orderbaseqty");
        return new ContractEntryInfo(conEntryId, conSeq, priceAndTax, baseQty, orderBaseQty);
    }

    private ContractInfo getContractInfo(DynamicObject contract) {
        String dimension = contract.getString("type.excutecontrol");
        BigDecimal orderAllAmount = contract.getBigDecimal("orderallamount");
        BigDecimal totalAllAmount = contract.getBigDecimal("totalallamount");
        Long contractId = (Long)contract.getPkValue();
        String billno = contract.getString("billno");
        return new ContractInfo(billno, contractId, totalAllAmount, orderAllAmount, dimension);
    }

    private void doWriteBack(DynamicObject[] bills, Map<Long, DynamicObject> contMap, BigDecimal direction, String operate) {
        try (TraceSpan span = Tracer.create((String)"ContractPerformImpl", (String)"doWriteBack");){
            DynamicObject[] array;
            long t1 = System.currentTimeMillis();
            HashSet<Long> writeBackContEntry = new HashSet<Long>(16);
            Map<Long, DynamicObject> conEntryMap = contMap.values().stream().flatMap(a -> a.getDynamicObjectCollection("billentry").stream()).collect(Collectors.toMap(b -> (Long)b.getPkValue(), b -> b));
            Map<String, Date> orgEnableTime = ContPerformCtrlHelper.getPerformOrgEnableTime(contMap.values());
            String formId = bills[0].getDataEntityType().getName();
            Map<Object, Object> auditDateMap = new HashMap();
            if ("pm_purorderbill".equals(formId) && "unaudit".equals(operate)) {
                auditDateMap = this.getAuditDate(bills, formId);
            }
            for (DynamicObject data : bills) {
                String billno = data.getString("billno");
                Date auditTime = (Date)auditDateMap.get(data.getPkValue());
                DynamicObjectCollection billentry = data.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : billentry) {
                    long conmbillid = entry.getLong("conbillid");
                    long conbillentryid = entry.getLong("conbillentryid");
                    String conbillrownum = entry.getString("conbillrownum");
                    String conbillnumber = entry.getString("conbillnumber");
                    String seq = entry.getString("seq");
                    Object endtryId = entry.getPkValue();
                    if (conbillentryid == 0L || conmbillid == 0L) continue;
                    writeBackContEntry.add(conbillentryid);
                    DynamicObject cont = contMap.get(conmbillid);
                    DynamicObject conbillentry = conEntryMap.get(conbillentryid);
                    if (cont == null || conbillentry == null) continue;
                    Date enableTime = orgEnableTime.get(String.valueOf(cont.getLong("org.id")));
                    boolean isWrite = true;
                    if (enableTime != null && auditTime != null && enableTime.compareTo(auditTime) >= 0) {
                        isWrite = false;
                    }
                    BigDecimal orderBaseQty = entry.getBigDecimal("baseqty");
                    BigDecimal amountandtax = entry.getBigDecimal("amountandtax");
                    BigDecimal initOrderBaseQty = (BigDecimal)conbillentry.get("orderbaseqty");
                    BigDecimal multiply = orderBaseQty.multiply(direction);
                    BigDecimal contOrderBaseQty = initOrderBaseQty.add(multiply);
                    if (isWrite) {
                        conbillentry.set("orderbaseqty", (Object)contOrderBaseQty);
                    }
                    BigDecimal initAmount = cont.getBigDecimal("orderallamount");
                    BigDecimal wbAmount = amountandtax.multiply(direction);
                    BigDecimal amt = initAmount.add(wbAmount);
                    if (isWrite) {
                        cont.set("orderallamount", (Object)amt);
                    }
                    Long materialId = 0L;
                    if (entry.getDynamicObject("material") != null) {
                        materialId = entry.getDynamicObject("material").getDynamicObject("masterid").getLong("id");
                    }
                    BigDecimal orderQty = ContPerformCtrlHelper.getDesQtyConv(materialId, conbillentry.getDynamicObject("baseunit"), contOrderBaseQty, conbillentry.getDynamicObject("unit"));
                    BigDecimal initOrderQty = conbillentry.getBigDecimal("orderqty");
                    if (isWrite) {
                        conbillentry.set("orderqty", (Object)orderQty);
                    }
                    if (!formId.equals("pm_xpurorderbill") && !formId.equals("pm_xspurorderbill") || !"conm_purcontract".equals(entry.getString("srcbillentity"))) continue;
                    BigDecimal initJoinOrderBaseQty = (BigDecimal)conbillentry.get("joinorderbaseqty");
                    BigDecimal joinOrderBaseQty = initJoinOrderBaseQty.add(multiply);
                    conbillentry.set("joinorderbaseqty", (Object)joinOrderBaseQty);
                    BigDecimal joinOrderQty = ContPerformCtrlHelper.getDesQtyConv(materialId, conbillentry.getDynamicObject("baseunit"), joinOrderBaseQty, conbillentry.getDynamicObject("unit"));
                    BigDecimal initJoinOrderQty = conbillentry.getBigDecimal("joinorderqty");
                    conbillentry.set("joinorderqty", (Object)joinOrderQty);
                }
            }
            for (DynamicObject cont : array = contMap.entrySet().stream().map(a -> (DynamicObject)a.getValue()).collect(Collectors.toList()).toArray(new DynamicObject[0])) {
                ContPerformCtrlHelper.contClose(cont, writeBackContEntry);
            }
            SaveServiceHelper.save((DynamicObject[])array);
            long t2 = System.currentTimeMillis();
            logger.info("\u53cd\u5199\u8017\u65f6\uff1a" + (t2 - t1));
        }
    }

    private Map<Object, Date> getAuditDate(DynamicObject[] bills, String formId) {
        HashMap<Object, Date> auditDateMap = new HashMap<Object, Date>();
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] orderBills;
            HashSet<Object> ids = new HashSet<Object>(bills.length);
            for (DynamicObject data : bills) {
                ids.add(data.getPkValue());
            }
            for (DynamicObject orderBill : orderBills = BusinessDataServiceHelper.load((String)formId, (String)"auditdate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                auditDateMap.put(orderBill.getPkValue(), orderBill.getDate("auditdate"));
            }
        }
        logger.info(JSON.toJSONString(auditDateMap));
        return auditDateMap;
    }

    /*
     * WARNING - void declaration
     */
    private DynamicObject[] reCalcDiffData(DynamicObject[] bills) {
        if (bills == null || bills.length == 0) {
            return bills;
        }
        String performFormId = bills[0].getDataEntityType().getName();
        if (performFormId.equals("pm_xpurorderbill") || performFormId.equals("pm_xspurorderbill")) {
            void var9_13;
            String sourceId = "";
            if ("pm_xpurorderbill".equals(performFormId)) {
                sourceId = "sourceid";
            } else if ("pm_xspurorderbill".equals(performFormId)) {
                sourceId = "sourcebillid";
            }
            HashSet<Long> srcbillids = new HashSet<Long>();
            for (DynamicObject bill : bills) {
                srcbillids.add(bill.getLong(sourceId));
            }
            String fields = String.join((CharSequence)",", this.getFields("pm_purorderbill"));
            Map srcBills = BusinessDataServiceHelper.loadFromCache((String)"pm_purorderbill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcbillids.toArray())});
            HashMap srcEntryMap = new HashMap();
            for (Map.Entry entry2 : srcBills.entrySet()) {
                Object key = entry2.getKey();
                DynamicObject bill = (DynamicObject)entry2.getValue();
                Map<Object, DynamicObject> billentry = bill.getDynamicObjectCollection("billentry").stream().filter(a -> a.getLong("conbillentryid") != 0L).collect(Collectors.toMap(DataEntityBase::getPkValue, entry -> entry));
                srcEntryMap.put(key, billentry);
            }
            DynamicObject[] cloneBills = new DynamicObject[bills.length];
            boolean bl = false;
            while (var9_13 < bills.length) {
                if (!srcBills.isEmpty()) {
                    DynamicObject bill = bills[var9_13];
                    DynamicObject cloneBill = (DynamicObject)new CloneUtils(false, false).clone(bill.getDataEntityType(), (Object)bill);
                    ContPerformCtrlHelper.reCalculateDifferenceData(cloneBill, (Map)srcEntryMap.get(bill.getLong(sourceId)));
                    cloneBills[var9_13] = cloneBill;
                }
                ++var9_13;
            }
            return cloneBills;
        }
        return bills;
    }

    private List<String> getFields(String entityKey) {
        ArrayList<String> selectors = new ArrayList<String>(16);
        if (entityKey.equals("pm_xpurorderbill") || entityKey.equals("pm_xspurorderbill")) {
            selectors.add("billentry.entrychangetype");
            selectors.add("version");
            if (entityKey.equals("pm_xpurorderbill")) {
                selectors.add("sourceid");
                selectors.add("billentry.sourceentryid");
            } else {
                selectors.add("sourcebillid");
                selectors.add("billentry.entrysrcid");
                selectors.add("changebillno");
            }
            entityKey = "pm_purorderbill";
        }
        Map cache = BusinessDataServiceHelper.loadFromCache((String)"conm_recordrule", (QFilter[])new QFilter[]{new QFilter("performbill.number", "=", (Object)entityKey)});
        for (DynamicObject recordrule : cache.values()) {
            DynamicObjectCollection mappingentity = recordrule.getDynamicObjectCollection("mappingentity");
            for (DynamicObject entry : mappingentity) {
                String performfield = entry.getString("performfield");
                if (!StringUtils.isNotEmpty((String)performfield)) continue;
                selectors.add(performfield);
            }
        }
        selectors.add("billentry.conbillnumber");
        selectors.add("billentry.conbillrownum");
        selectors.add("billentry.conbillid");
        selectors.add("billentry.conbillentryid");
        selectors.add("billstatus");
        selectors.add("billno");
        selectors.add("org");
        selectors.add("totalamount");
        selectors.add("totaltaxamount");
        selectors.add("totalallamount");
        selectors.add("billentry.material");
        selectors.add("billentry.conbillentity");
        selectors.add("billentry.srcbillentity");
        selectors.add("billentry.seq");
        selectors.add("billentry.amount");
        selectors.add("billentry.taxamount");
        selectors.add("billentry.amountandtax");
        selectors.add("billentry.baseqty");
        selectors.add("billentry.ispresent");
        selectors.add("billentry.priceandtax");
        return selectors;
    }
}

